/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/is.c 1.4 1995/05/02 06:05:16 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: is.c $
** Revision 1.4  1995/05/02 06:05:16  dpuryear
** *** empty log message ***
**
** Revision 1.3  1995/04/25 16:59:40  dpuryear
** Touch-ups for v2.0 release.
**
** Revision 1.2  1995/04/03 23:42:14  dpuryear
** sml_err was not being set to SML_SUCCESS, corrected this.
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

/*
** Contains functions to determine type of string
**
** sml_isalpha()
** sml_isalphanum()
** sml_isdigit()
** sml_iswhite()
** sml_is()
*/

/*
** sml_isalpha()        Is a string composed of all alpha-characters
**
** Input:
**      - str = string
**
** Output:
**      - !0 if all alpha-characters
**      - 0 otherwise
*/

extern int sml_isalpha(char *str)
{
      int bool = 1;

      sml_serr(SML_SUCCESS);

      while ( *str != NUL )
            if ( isalpha(*str) )
                  str++;
            else
                  bool = 0;

      return (bool);
}

/*
** sml_isalphanum()     Is a string composed of all alphanumerical or '_'
**
** Input:
**      - str = string
**
** Output:
**      - !0 if all alphanumerical or '_'
**      - 0 otherwise
*/

extern int sml_isalphanum(char *str)
{
      int bool = 1;

      sml_serr(SML_SUCCESS);

      while ( *str != NUL )
            if ( isalnum(*str) )
                  str++;
            else
                  bool = 0;

      return (bool);
}

/*
** sml_isdigit()          Is a string composed of all digits
**
** Input:
**      - str = string
**
** Output:
**      - !0 if all digits
**      - 0 otherwise
*/

extern int sml_isdigit(char *str)
{
      int bool = 1;

      sml_serr(SML_SUCCESS);

      while ( *str != NUL )
            if ( isdigit(*str) )
                  str++;
            else
                  bool = 0;

      return (bool);
}

/*
** sml_iswhite()        Is string all whitespace
**
** Input:
**      - str = string
**
** Output:
**      - !0 if all whitespace
**      - 0 otherwise
*/

extern int sml_iswhite(char *str)
{
      int bool = 1;

      sml_serr(SML_SUCCESS);

      while ( *str != NUL )
            if ( isspace(*str) )
                  str++;
            else
                  bool = 0;

      return (bool);
}

/*
** sml_is()             Generic is tester
**
** Input:
**      - str = string
**      - is() = function to evaluate string (ie., isprint(), isxdigit())
**
** Output:
**      - !0 if all whitespace
**      - 0 otherwise
*/

extern int sml_is(char *str, int (*is)(int c))
{
      int bool = 1;

      sml_serr(SML_SUCCESS);

      while ( *str != NUL )
            if ( is(*str) )
                  str++;
            else
                  bool = 0;

      return (bool);
}
