/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/justify.c 1.4 1995/05/02 06:05:16 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: justify.c $
** Revision 1.4  1995/05/02 06:05:16  dpuryear
** *** empty log message ***
**
** Revision 1.3  1995/04/26 21:40:44  dpuryear
** Touch-ups for v2.0 release.
**
** Revision 1.2  1995/04/07 00:48:18  dpuryear
** Beauty changes to sml_cjustify()
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

static void _isolate(char *str, size_t *bpos, size_t *epos, size_t *len);

/*
** Contains functions to justify a string.
**
** sml_jleft()
** sml_jright()
** sml_jcenter()
*/

/*
** sml_jleft()          Left justify string
**
** Input:
**      - str = string to be justified
**      - pad = character to pad right of string
**      - n = total memory available to string
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_jleft(char *str, char pad, size_t n)
{
      size_t bpos;
      size_t epos;
      size_t len;
      size_t end = n - 1;

      sml_serr(SML_SUCCESS);

      _isolate(str, &bpos, &epos, &len); /* isolate ss to justify */

      /* move string to left */
      memmove(str, str + bpos, len);

      /* pad right of string */
      sml_nfill(str + len, pad, 0, end - len);
      str[end] = NUL;

      return (str);
}

/*
** sml_jright()         Right justify string
**
** Input:
**      - str = string to be justified
**      - pad = character to pad left of string
**      - n = total memory available to string
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_jright(char *str, char pad, size_t n)
{
      size_t bpos;
      size_t epos;
      size_t len;
      size_t end = n - 1;

      sml_serr(SML_SUCCESS);

      _isolate(str, &bpos, &epos, &len); /* isolate ss to justify */

      /* Move string to right */
      memmove(str + (end - len), str + bpos, len);

      /* Pad left of string */
      sml_nfill(str, pad, 0, end - len);
      str[end] = NUL;

      return (str);
}

/*
** sml_jcenter()        Center justify string
**
** Input:
**      - str = string to be justified
**      - pad = character to pad left and right of string
**      - n = total memory available to string
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_jcenter(char *str, char pad, size_t n)
{
      size_t bpos;
      size_t epos;
      size_t len;
      size_t mmid;
      size_t smid;
      size_t end = n - 1;

      sml_serr(SML_SUCCESS);

      _isolate(str, &bpos, &epos, &len); /* isolate ss to justify */

      /* Get middle of memory and of string */
      mmid = end /2;
      smid = len /2;

      /* center string */
      memmove(str + (mmid - smid), str + bpos, len);

      /* Pad left and right. REALLY messy.. */
      sml_nfill(str, pad, 1, mmid - smid);
      sml_nfill(str, pad, (mmid - smid + len) + 1, end - (mmid - smid + len));
      str[end] = NUL;

      return (str);
}

/**************************
** static
*/

/*
** _isolate()           Return beginning and end of actual string
**
** Ignores trailing/leading whitespace
*/

static void _isolate(char *str, size_t *bpos, size_t *epos, size_t *len)
{
      /* Get beginning of string */
      for ( *bpos = 0; isspace(str[*bpos]); *bpos += 1 );

      /* Get end of string */
      for ( *epos = strlen(str) - 1; isspace(str[*epos]); *epos -= 1 );

      /* find length */
      *len = (*epos + 1) - *bpos;
}
