/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/nreturn.c 1.4 1995/05/02 06:05:16 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: nreturn.c $
** Revision 1.4  1995/05/02 06:05:16  dpuryear
** *** empty log message ***
**
** Revision 1.3  1995/04/26 21:46:25  dpuryear
** Touch-ups for v2.0 release
**
** Revision 1.2  1995/04/03 23:44:31  dpuryear
** began using memmove() instead of memcpy() for safety
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

/*
** Contains functions to return n characters from a string.
**
** sml_nmid()
** sml_nright()
** sml_nleft()
*/

/*
** sml_nmid()           Return n characters from some position ($MID)
**
** Input:
**      - str = string
**      - pos = position to start
**      - n = number of characters to return
**
** Output:
**      - pointer to new string or NULL if error
*/

extern char * sml_nmid(char *str, size_t pos, size_t n)
{
      size_t len = strlen(str);
      size_t size = SML_iMIN(n, len - pos);
      char *buf = sml_csize(size);

      if ( buf != NULL )
      {
            memmove(buf, str + pos, size);
            buf[size] = NUL;
      }

      /* sml_serr() set by sml_csize() */
      return (buf);
}

/*
** sml_nright()         Return n characters from right of string ($RIGHT)
**
** Input:
**      - str = string
**      - n = number of characters to return
**
** Output:
**      - pointer to new string or NULL error
*/

extern char * sml_nright(char *str, size_t n)
{
      size_t len = strlen(str);
      char *buf = sml_ccopy(str + len - SML_iMIN(n, len));

      /* sml_serr() set by sml_ccopy */
      return (buf);
}

/*
** sml_nleft()          Return n characters from left of string ($LEFT)
**
** Input:
**      - str = string
**      - n = number of characters to return
**
** Output:
**      - pointer to new string or NULL if error
*/

extern char * sml_nleft(char *str, size_t n)
{
      size_t len = strlen(str);
      size_t size = SML_iMIN(n, len);
      char *buf = sml_csize(size);

      if ( buf != NULL )
      {
            memmove(buf, str, size);
            buf[size] = NUL;
      }

      /* sml_serr() set by sml_csize() */
      return (buf);
}
