/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/place.c 1.3 1995/05/02 06:05:16 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: place.c $
** Revision 1.3  1995/05/02 06:05:16  dpuryear
** *** empty log message ***
**
** Revision 1.2  1995/04/28 00:23:18  dpuryear
** Removed sml_insert()'s use of a direct place of the NUL and just used
** a "+ 1" in the memmove() (for the hole) to make it faster.
** Plus, some touch-ups for v2.0 release.
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

/*
** Put a substring into a string:
**
** sml_insert()
** #sml_overlay()
*/

/*
** sml_insert()         Insert a substring into some position
**
** Input:
**      - str = string
**      - sub = string to be inserted
**      - pos = position to insert
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_insert(char *str, char *sub, size_t pos)
{
      size_t len = strlen(sub);

      sml_serr(SML_SUCCESS);

      /* punch hole into string: must use memmove() */
      memmove(str + pos + len, str + pos, strlen(str + pos) + 1);

      /* now, move sub into hole */
      memmove(str + pos, sub, len);

      return (str);
}
