/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/rotate.c 1.3 1995/05/02 06:05:16 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: rotate.c $
** Revision 1.3  1995/05/02 06:05:16  dpuryear
** *** empty log message ***
**
** Revision 1.2  1995/04/28 01:17:26  dpuryear
** Touch-ups for v2.0 release.
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

/*
** Rotate characters in a string:
**
** sml_nrrotate()
** sml_nlrotate()
*/

/*
** sml_nrrotate()       Rotate string right n times
**
** Input:
**      - str = string
**      - n = times to rotate characters
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_nrrotate(char *str, size_t n)
{
      size_t len = strlen(str);
      char *copy = sml_csize(len);
      size_t x;

      if ( copy == NULL )
            return (NULL);
      copy[len] = NUL;

      /* rotate it using old modulus trick */
      for ( x = 0; x < len; x++ )
            copy[((x % len) + n) % len] = str[x];

      strcpy(str, copy);
      sml_free(copy);

      return (str);
}

/*
** sml_nlrotate()       Rotate string left n times
**
** Input:
**      - str = string
**      - n = times to rotate characters
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_nlrotate(char *str, size_t n)
{
      size_t x;
      size_t len = strlen(str);
      size_t tn = len - n;
      char *copy = sml_csize(len);

      if ( copy == NULL )
            return (NULL);
      copy[len] = NUL;

      for ( x = 0; x < len; x++ )
            copy[((x % len) + tn) % len] = str[x];

      strcpy(str, copy);
      sml_free(copy);

      return (str);
}
