/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/xchg.c 1.3 1995/05/02 06:05:16 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: xchg.c $
** Revision 1.3  1995/05/02 06:05:16  dpuryear
** *** empty log message ***
**
** Revision 1.2  1995/04/25 17:04:26  dpuryear
** Touch-ups for v2.0 release.
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

/*
** sml_xchg()           String exchange
**
** Input:
**      - str1 = string to be swapped with str2
**      - str2 = string to be swapped with str1
**
** Output:
**      - pointer to passed string or NULL if error
**
** Notes:
**      - make sure string(s) do not overstep memory with swap
*/

extern char * sml_xchg(char *str1, char *str2)
{
      char *temp = sml_ccopy(str1);

      sml_serr(SML_SUCCESS);

      if ( temp == NULL )
            return (NULL);
      else
      {
            strcpy(str1, str2);
            strcpy(str2, temp);
            sml_free(temp);
      }

      return (str1);
}
