/* STEPH.H
   Stephen Morphet

   Include file for the Steph library.
   (c) 1993 - 1995 SDM

   You should #include this file in any source file that accesses the
   Steph system.

   *** WARNING ***

   This file incorporates constants, macros and functions prototypes
   that are needed by the Steph system.


   *** DO NOT EDIT THIS FILE. ***

   You CANNOT customise Steph by altering this file.  Doing so will cause
   Steph to become unstable and may cause a system crash.

   You CAN customise the behaviour of Steph as described in the manual.


   *** IMPORTANT ***

   The data structures described below are all available to code linked to
   the Steph library.   Many of the structure member variables are useful
   and are documented in the manual.  Those that are not documented are for
   internal use by the system and should not be changed.  No attempt has
   been made in this file to identify those variables.

*/
































#if !defined( WM_WM_HEADER )
#define WM_WM_HEADER

/* types */
typedef void(*vfnptr)();      /* pointer to a void function */
typedef unsigned char byte;


/* macros */


#if !defined( MK_FP )
#define MK_FP(seg, ofs) ((void far *) ((unsigned long) (seg)<<16|(ofs)))
#endif

/* macros to extract from _menu_spec.border[]   eg.  "Ŀ Ĵ" */
/*                                                    0123456789012  */
#define M_TOPLEFT    *_menu_spec.border
#define M_TOPRIGHT   *(_menu_spec.border + 2)
#define M_BOTLEFT    *(_menu_spec.border + 6)
#define M_BOTRIGHT   *(_menu_spec.border + 8)
#define M_TOP        *(_menu_spec.border + 1)
#define M_BOTTOM     *(_menu_spec.border + 7)
#define M_LEFT       *(_menu_spec.border + 3)
#define M_RIGHT      *(_menu_spec.border + 5)
#define M_CROSSLEFT  *(_menu_spec.border + 9)
#define M_CROSSRIGHT *(_menu_spec.border + 11)
#define M_CROSS      *(_menu_spec.border + 10)
#define M_BLANKGAP   *(_menu_spec.border + 4)
#define M_CHECK      *(_menu_spec.border + 12)

/* macros to extract from window borders */

#define W_TOPLEFT    *(_window_spec.border)
#define W_TOPRIGHT   *(_window_spec.border + 2)
#define W_BOTLEFT    *(_window_spec.border + 6)
#define W_BOTRIGHT   *(_window_spec.border + 8)
#define W_TOP        *(_window_spec.border + 1)
#define W_BOTTOM     *(_window_spec.border + 7)
#define W_LEFT       *(_window_spec.border + 3)
#define W_RIGHT      *(_window_spec.border + 5)
#define W_CTRLLEFT   *(_window_spec.border + 9)
#define W_CTRLRIGHT  *(_window_spec.border + 10)
#define W_MAX        *(_window_spec.border + 11)
#define W_MIN        *(_window_spec.border + 4)
#define W_CLOSE      *(_window_spec.border + 12)
#define W_TOPL2      *(_window_spec.border + 14)
#define W_TOPR2      *(_window_spec.border + 15)
#define W_SCROLL     *(_window_spec.border + 16)
#define W_SCRUP      *(_window_spec.border + 17)
#define W_SCRDOWN    *(_window_spec.border + 18)
#define W_SCRLEFT    *(_window_spec.border + 19)
#define W_SCRRIGHT   *(_window_spec.border + 20)
#define W_SCRBLIP    *(_window_spec.border + 21)

/* macros to extract dbox drawing characters */

#define _DB_TOPLEFT  *_dbox_spec.border
#define _DB_TOP      *(_dbox_spec.border + 1)
#define _DB_TOPRIGHT *(_dbox_spec.border + 2)
#define _DB_LEFT     *(_dbox_spec.border + 3)
#define _DB_PAGE     *(_dbox_spec.border + 4)
#define _DB_RIGHT    *(_dbox_spec.border + 5)
#define _DB_BOTLEFT  *(_dbox_spec.border + 6)
#define _DB_BOT      *(_dbox_spec.border + 7)
#define _DB_BOTRIGHT *(_dbox_spec.border + 8)
#define _DB_BUTTONL  *(_dbox_spec.border + 9)
#define _DB_BUTTONR  *(_dbox_spec.border + 10)
#define _DB_CHECKL   *(_dbox_spec.border + 11)
#define _DB_CHECK    *(_dbox_spec.border + 12)
#define _DB_UNCHECK  *(_dbox_spec.border + 13)
#define _DB_CHECKR   *(_dbox_spec.border + 14)
#define _DB_RADIOL   *(_dbox_spec.border + 15)
#define _DB_RADIO    *(_dbox_spec.border + 16)
#define _DB_RADIOR   *(_dbox_spec.border + 17)
#define _DB_TEXTL    *(_dbox_spec.border + 18)
#define _DB_TEXT     *(_dbox_spec.border + 19)
#define _DB_TEXTR    *(_dbox_spec.border + 20)
#define _DB_SCROLL   *(_dbox_spec.border + 21)
#define _DB_LSCROLL  *(_dbox_spec.border + 22)
#define _DB_RSCROLL  *(_dbox_spec.border + 23)
#define _DB_USCROLL  *(_dbox_spec.border + 24)
#define _DB_DSCROLL  *(_dbox_spec.border + 25)
#define _DB_SCRBLIP  *(_dbox_spec.border + 26)
#define _DB_BARL     *(_dbox_spec.border + 27)
#define _DB_BAR      *(_dbox_spec.border + 28)
#define _DB_BARR     *(_dbox_spec.border + 29)
#define _DB_COMBO    *(_dbox_spec.border + 30)

/* macros to extract speed bar boundary characters */

#define _SB_BUTTONL   *(_speed_spec.border);
#define _SB_SPACE    *(_speed_spec.border + 1);
#define _SB_BUTTONR   *(_speed_spec.border + 2);


#define WGNF _window_getnextfree()
#define WGLB _window_spec.lastbuilt

#define MGNF _menu_getnextfree()
#define MGLB _menu_spec.lastbuilt

/* Mouse buttons left/right/centre up or down.
   Suitable for testing data as returned by int33h fn03h regBX
   e.g. function _mouse_nowbutton() */

#define MBL_ISDOWN(sbyte)   (((sbyte)&&0x01) ? -1 :  0)
#define MBL_ISUP(sbyte)     (((sbyte)&&0x01) ?  0 : -1)
#define MBR_ISDOWN(sbyte)   (((sbyte)&&0x02) ? -1 :  0)
#define MBR_ISUP(sbyte)     (((sbyte)&&0x02) ?  0 : -1)
#define MBC_ISDOWN(sbyte)   (((sbyte)&&0x04) ? -1 :  0)
#define MBC_ISUP(sbyte)     (((sbyte)&&0x04) ?  0 : -1)

/* convert character lines to/from mouse coordinates in pixels */
/* Note: X and Y scalings are different, and dependant on video mode */

#define xch2pix(chars)      ((chars) * __gminfo.xchar)
#define xpix2ch(chars)      ((chars) / __gminfo.xchar)
#define ych2pix(chars)      ((chars) * __gminfo.ychar)
#define ypix2ch(chars)      ((chars) / __gminfo.ychar)


/* constants */

/* maxima */

#define __MAXWINDOWS    16   /* max number of windows allowed */
#define __WBMAXLINES  1024   /* max number of lines in a window buffer */
#define __MAXMENUS      16   /* number of menus allowed */
#define __MAXPOPMENUS    4   /* number of popup menus allowed */
#define __MENUITEMLEN   60   /* max number + 1 of chars in a menu entry */
#define __MAXDBOX       32   /* max number of simultaneous dboxes */
#define __MAXDBOXCTRL   16   /* number of controls allowed in a dbox */
#define __MAXBARLIST     4   /* number of horizontal bars allowed in a dbox */
#define __MAXTEXTCHAR 1024   /* max number of chars allowed in a text control */
#define __MAXDBOXDEP    16   /* max number of dependant dboxes */
#define __MAXMENUEDGE    5   /* hilite bar max overlap at edge of text */
#define __MAXTOOLBARS    4   /* number of tool bar lines allowed */
#define __MAXTOOLCONTROLS 16 /* number of tool bar controls */
#define __MAXSPEEDBUTTONS 16 /* number of speed bar buttons */

#define _COLOUR   -1
#define _K_MODE    0              /* internal use */
#define _MDAHERC    1              /* text screen mode types */
#define _NOTTEXT    2

/* constants used for overriding exit mode of dialogue controls   */
/* (more constants in PRIVATE.H, not available to programmers...) */

#define _CA_ESC    2
#define _CA_SET    3
#define _CA_NOEXIT 3         /* _CA_NOEXIT == _CA_SET */
#define _CA_EXIT   4

/* gmode values for use in _steph_initialise() calls */

#define M_GRAPHIC -1
#define M_TEXT     0

/* window types */

#define WP_NONE    0
#define WP_MAIN    1
#define WP_TOP     2
#define WP_BOT     3

/* constants for window control buttons */

#define WC_CLOSE       1
#define WC_MAX         2
#define WC_MIN         4
#define WC_HSCROLL     8
#define WC_VSCROLL    16

#define WC_SCRINHIB    32   /* for internal use */

/* window return action codes */

#define WR_NOACTION  255
#define WR_SELECT      0
#define WR_CLOSE       1
#define WR_MAX         2
#define WR_MIN         3
#define WR_SIZE        4
#define WR_VUP         5
#define WR_VDOWN       6
#define WR_VDRAG       7
#define WR_HUP         8
#define WR_HDOWN       9
#define WR_HDRAG      10
#define WR_VPUP       11
#define WR_VPDOWN     12
#define WR_HPUP       13
#define WR_HPDOWN     14

/* window draw mode codes */

#define WD_AUTO      0
#define WD_USER           1
#define WD_CLEAR        2
#define WD_COLOUR    3

#define _WD_CCODE 255          /* colour code for WD_COLOUR mode */

/* Null pointers for various purposes */

#define NOFN    (vfnptr)NULL   /* no attached function */
#define DFILTER (vfnptr)NULL   /* meaning default filter */
#define NOTEXT  (char *)NULL   /* no text */

/* Miscellaneous TRUE/FALSE type constants */

#define ON -1
#define OFF 0

#define EVENT 255
#define NOEVENT 0

#define FALSE 0
#define TRUE -1

#define GREY   -1
#define NOTGREY 0

#define TRUE -1
#define FALSE 0

#define OPEN  -1
#define CLOSED 0

#define LEFT -1
#define RIGHT 0

#define _UP  -1
#define _DOWN 0

#define ENABLED -1
#define DISABLED 0

/* Constants for checkable menu items. */
/* pass only ON, OFF, TOGGLE to the _menu_check function */

#define NOCHECK     1
#define CHECKON    -1
#define CHECKOFF    0
#define CHECKTOGGLE 2
#define CHECKERROR  3

/* Dialogue box buttons.  Exit mode flags. */

#define EXIT   1
#define NOEXIT 0
#define ESCAPE 2

/* Return codes from query boxes */

#define QB_FAIL   -2
#define QB_NONE   -1

/* Used to specify a horizontal bar in query_button_gap */

#define QB_BAR    -1

/* Dialogue box positions */

#define DB_CENSCR  0
#define DB_CENWIN  1
#define DB_ABSPOS  2

/* Toolbar control types */

#define TB_NONE      0
#define TB_COMBO     1
#define TB_BUTTON    2
#define TB_TOGGLE    3

/* list box scroll bars */
/* a list box can have none, one or the other, but not both */

#define DBL_HSCROLL  0
#define DBL_VSCROLL  1
#define DBL_NOSCROLL 2

/* Dialogue box dependancy and horizontal bars */

#define _NO_DEPENDANT -1
#define _NO_BAR        0


/* structure for window contents, line by line in a linked list */

struct winbuflist
{
   char *line;                /* Pointer to dynamic text string */
   int endcode;               /* User controlled data value */
   struct winbuflist *link;   /* next struct in list */
	struct winbuflist *prev;   /* previous struct in list */
};


/* structures for global variables set up by steph. */

/* global system information */

typedef struct
{
   char steph_running;  /* Is steph running yet?  Closed down?   */
	char mouse_installed;/* set TRUE if mouse installed, else FALSE */
   int mode;            /* text screen mode, ie. colour or b&w   */
   char gmode;          /* graphics or text screen mode */

   unsigned row, col;   /* screen size in characters */

   short launch_cursor; /* cursor shape on startup */
   int launch_insmode;  /* insert mode on startup */

   short cursor;
   short otcursor;      /* cursor shapes for insert and overtype modes */

   char cursor_vis;     /* current cursor visibility */
   short hidden_cursor; /* cursor shape currently hidden if any */
   char cursorr;
   char cursorc;        /* cursor row and column last set */

   char speak;          /* Speak mode. */
                        /* Reserved for future speech-synth extensions */

   vfnptr mem_handler;  /* function called when memory alloc error occurs */
   char mem_flag;       /* flag set TRUE in mem_handler to reattempt alloc */

   unsigned long mem_size;
                        /* amount of memory requested by last alloc
                           so that mem_handler can try to free that much */
                        /* in rare situations may return 0.  Either the system
                           failed to allocate a zero length block (possible) or
                           Steph was unable to determine the block size
                        */

	char _no_store;      /* disables background storing - used in critical
                           low memory situations */

   char *nomemlist;     /* pointer out of memory message list */

}__ss_tag;


/* individual menu description */

typedef struct
{
   unsigned itemcount;  /* number of items */
   unsigned longest;    /* longest item in menu body, excl. title */
   char *menuinfo;      /* store menu texts */
   char *hotkeys;       /* store position of hotkey in text */
   char *hotalpha;      /* store actual hotkey letter */
   char *enabled;       /* store grey out info */
   char *check;         /* store check marks info */
   vfnptr *funcp;       /* ptr to start of function pointer list */
   char **helptextp;    /* ptr to list of speed bar help items */
   char *behind;         /* pointer to whatever's behind the pull down */
   int onleft;          /* what is to the left of the menu? */
}__md_tag;


/* structure for individual window description */

typedef struct
{
   char type;     /* main, top or bottom */
   char numrows;  /* number of rows available inside the window */

	char *title;   /* pointer to the title string */
   char isopen;   /* window visibility */
   char wasopen;  /* used to determine whether to turn the bar off */

   char controls; /*   bits tell us which controls are active, 1=on   */
                  /*   bit0   close            1                      */
                  /*      1   max              2                      */
                  /*      2   min              4                      */
                  /*      3   vscroll          8                      */
                  /*      4   hscroll          16                     */
                  /*      5   scrollinhibit    32 (system use only)   */
                  /*      6                    64                     */
                  /*      7                   128                     */

   char haschanged;  /* has the window been changed? */

   char usetop;      /* usable region within window */
   char usebottom;

   char startrow;
   unsigned char oldstartrow;

   char vsblip;
   char hsblip;      /* position of the scroll bar blips in characters */
   char vsbold;
   char hsbold;      /* last position of scroll bar blips */

   short paper;      /* window contents colours */
   short ink;

   char fix_lines;   /* number of fixed lines at top of window */
   short fix_paper;
   short fix_ink;    /* colours for fixed lines */

   struct winbuflist buffer;  /* start of the window contents linked list */
   struct winbuflist *pwb;    /* working pointer to window buffer list */

   unsigned current_line;     /* the current line in the buffer */
   unsigned blines;           /* number of lines in the buffer,
                                 note they are numbered 0 to blines-1 */
   unsigned blong;

   unsigned lineo;            /* line offset, ie, line of buffer to show
                                 at top of window */
   unsigned charo;            /* character offset, ie, character to
                                 show at left of window */

   char drawmode;             /* eg WD_DEFAULT or WD_USER (re)draw mode */
   vfnptr drawfn;             /* user draw function */

   vfnptr filter;             /* keystroke filter for the window */
   vfnptr keyaction;          /* window keyboard action function */

   vfnptr close;
   vfnptr max;
   vfnptr min;
   vfnptr size;
   vfnptr vup;
   vfnptr vdown;
   vfnptr vdrag;
   vfnptr vpup;
   vfnptr vpdown;
   vfnptr hup;
   vfnptr hdown;
   vfnptr hdrag;
   vfnptr hpup;
	vfnptr hpdown;
   vfnptr unselect;
   vfnptr select;
   vfnptr activate;            /* window activity function hooks */

}__wd_tag;


/* global window information */

typedef struct
{
   unsigned active;     /* which window is active? */
   unsigned wasactive;  /* which window was active? */

   int maximise;        /* number of window that is maximised or -1 */
   char premaxrows;     /* size of the maxed window, before it was maxed */
   char hsbat;          /* posn of horiz scrollbar in last window, or -1 */

   int lastbuilt;       /* last window built */
   unsigned wincount;   /* number of windows built */

   unsigned ttop;       /* the toppest top window */
   unsigned btop;       /* the lowest top window */
   unsigned tbottom;    /* the toppest bottom window */
   unsigned bbottom;    /* the lowest bottom window */

   char control_gap;
   char title_gap;      /* spacing sizes */

   char sbinhib;        /* window size at which scrollbars are inhibited */

   short border_paper;
	short border_ink;
   short title_hilite;
   short title_ink;
   short title_paper;
   short scroll_paper;
   short scroll_ink;
   short drag_paper;
   short drag_ink;      /* window border colours */

   char border[23];     /* window border characters */

   byte mousecode;      /* button set to trigger window actions */
   byte mousecontrol;   /* buttons for window controls, must be a
                           subset of mousecode   */

   unsigned firstrow;   /* first row that we can put text on */
   unsigned lastrow;    /* last row on screen that we can use */

   char key1;           /* key passed to window by the filter */
   char key2;           /* key to pick up cursors etc when key1 == 0 */

   char syskeyflag;     /* set TRUE by filter if sys key is matched */

   unsigned last_action_window;   /* set by window action fn */
   byte last_action_code;         /* ditto */
   byte last_mouse_button;        /* the mouse button used */

   int scrinfo;         /* return data from scrollbar action */
   char selectx;
   char selecty;        /* window activity return codes */

   vfnptr sysfilter;    /* function to test if it is a sys key */
   vfnptr syskeyaction; /* function called when system key found */

}__ws_tag;


/* global menu information */

typedef struct
{
   vfnptr initialfunc;  /* system initialisation function */
   vfnptr loopfunc;     /* loop function pointer */

   vfnptr menuloopfunc; /* menu loop function pointer */
   vfnptr dboxloopfunc; /* dialogue box loop function pointer */

   unsigned lastbuilt;  /* last menu built */
   int lastmenuselect;
   int lastitemselect;  /* last selection made */

   unsigned lastpopbuilt;   /* last popup menu built */
   int lastpopmenuselect;
   int lastpopitemselect;   /* last popup selection made */

   char anyonright;     /* set TRUE is there are rhs windows */

   short bar_ink;
   short bar_paper;
   short bar_hotkey;
   short bar_disabled;  /* colours for menu bar at top of screen */

   short body_ink;
   short body_paper;
   short body_hotkey;
   short body_disabled; /* colours for menu body */

   char body_space;
   char body_offset;
   char bar_space;
   char bar_hilite_edge;     /* spacing data */

   int  bar_gothilite;
   int  body_menugothilite;
   int  body_itemgothilite;  /* highlight/cursor position info */

   char bar_hotkeyson;       /* (body hotkeys are always on) */

   char shadow_below;
   char shadow_right;
   char shadow_ink;
   char shadow_paper;        /* shadow sizes */

   char border[14];          /* menu drawing characters (incl. popups) */

   char mousetoopen;         /* activation button */

   char popmenu;             /* true when popup menus active */
   char popmenurow;          /* popup menu position of top left on screen */
   char popmenucol;
   char pop_left;            /* mouse popups hang on top-l corner if true */

   char user_activate;       /* who started the menus? - normally TRUE */

}__ms_tag;


/* dialogue box global info */

typedef struct
{
	unsigned active;            /* set while a dbox in on screen */

	char border[32];            /* drawing characters */

	char isopen[__MAXDBOX];     /* used to decide if a dialogue is open */
	char numopen;               /* number of open dboxes at any time */

	short ink;
	short hotkey;
	short paper;
	short shadow_ink;
	short shadow_paper;         /* colours for paper & border */

	short drag_ink;
	short drag_paper;           /* colour of drag outline */
	short grey;                 /* greyed out controls colour */

	char lift;                  /* window lift value */

	float scrollsecs;           /* number of secs to pause when scrolling */
	float dclick;               /* double click time delay secs */

	char shadow_right;
	char shadow_below;          /* size of shadows */
	char lbox_eofield;          /* list box field spacing */

	int cclose;                 /* set to the control number if combo */
										 /* is still open */

	char _ca_ret;               /* control activity return value */
	char _ca_activator;         /* mouse or kbd activation flag */
	char _ca_hotkey;            /* hotkey store */
	unsigned char filter_key;   /* key for pass to filter functions */
   unsigned char filter_key2;  /* another key for filtering */

   /* info for flash boxes */
   short flash_ink;
   short flash_paper;          /* colours */

   char flash_vgap;            /* space above & below text */
   char flash_hgap;            /* space to left and right of text */

   char *flash_behind;   /* store background for flash boxes */

   /* query boxes are just dboxes, so we use same colours etc... */

   char query_button_gap;      /* space between text & buttons */
   char query_button_space;    /* between buttons & chevrons */
   char query_button_spacing;  /* space between buttons */
   char query_bar_gap;         /* space above or below bars */

   char query_drags;           /* are querys draggable? */
   char dbox_drags;            /* default for draggable */
   char dbox_snap;             /* default for snapback */

   char _tb_control;           /* set TRUE when dbox system is managing
                                  toolbar combo box activity else FALSE */
   char _query_control;        /* ditto for query box */

   char bulkflag;              /* set TRUE when bulk control drawing */

   char *dback_t;         /* stores for background of outline during
                                  dbox drag */
}__ds_tag;


/* dialogue box control description */

typedef struct
{
   char type;                 /* the type of control */
   char grey;
   char info;                 /* info (usages depend on control type) */
   char inf2;                 /* more info */
   int  inf3;                 /* more info */
   char inf4;                 /* yet more info */
   char hotkey;               /* the position in title of hotkey */
   char alpha;                /* the hotkey letter */

   char oldblip;              /* store of where scroll blip used to be */

   char xpos;
   char ypos;                 /* position, 0-based on top left of dbox */
   char xsize;
   char ysize;

   char *behind;               /* needed for combo box pop down */

   int iret;                  /* integer return */
   int oldi;                  /* stores old iret value for esc returns */

   char *bret;                /* pointer to buffer for content/return */

   char *init;                /* pntr to init-buffer passed to control */

   vfnptr sfunc;              /* function called when control 'select'ed */
   vfnptr hfunc;              /* second user defined function */
                              /* (list/combo hilite change) */
}_dbctrl;


/* dialogue box descriptions */

typedef struct
{
   char position;             /* location/centering code */
   char xsize;
   char ysize;                /* size */

   char xpos;
   char ypos;                 /* position */

   char *title;               /* title on the dialogue's top edge */
   char *speedtext;           /* help text etc for the speedbar */

   char *behind;               /* pointer to store of what's behind */
   char barlist[__MAXBARLIST];/* where are the cross bars? */

   char ccount;               /* the number of controls on the box */
   _dbctrl *control;   /* pointer to start of list of controls */

   int dependant[__MAXDBOXDEP];
                              /* list of dependants */

   char *escstore;            /* pointer to buffer of ESC stored info */
   vfnptr global_key_filter;  /* filter for global keystrokes */
   vfnptr global_key_action;  /* function called when global key hit */

   char draggable;            /* TRUE if dbox can be positioned */
   char snapback;             /* TRUE = pops up next time in drag posn
                                 or FALSE, snaps back to start pos (dflt) */
}__dd_tag;


/* speed bar global info */

typedef struct
{
   short paper;
   short ink;           /* define colour of bar */

   char *bartext;       /* pointer to the bar text */
   vfnptr function;     /* user hook, called when speed bar redrawn */
   vfnptr clickfn;      /* user hook, called when sb is M_ANYPRESSed */
   char textindent;     /* indent text from _speed_text function */
   char isdef;          /* set TRUE when default bar is on screen */
   char maxlen;         /* number of characters to show */

   char border[4];      /* button border characters */

   char button_indent;  /* where do the buttons start */
   char button_space;   /* space between text & chevron   */
   char button_spacing; /* space between buttons */

}__ssb_tag;


/* speed bar buttons */

typedef struct
{
   char *text;          /* the button text */
   char chevron;        /* does the button have chevrons */

   short paper;
   short ink;           /* button colour */

   char start;
   char end;            /* position of button */

   vfnptr bclick;       /* hooked function to button click */

}__sbb_tag;


/* toolbar global info */

typedef struct
{
   short paper;       /* colour of toolbar */
   short ink;
   short grey;        /* colour of grey control */

   char nlines;       /* number of lines used */

   char *line[__MAXTOOLBARS];
                      /* pointers to text displayed on each line */

   vfnptr function;   /* draw function */
   vfnptr clickfn;    /* click function */

   char textindent;   /* how far to indent the text */

}__tb_tag;


/* toolbar control store */

typedef struct
{
   char type;        /* control type */

   char grey;        /* is it greyed out */

   char bar;         /* which line of the toolbar 0, 1, etc. */
   char position;    /* position on bar */

   char *text;       /* title or label */

   char cstart;      /* combo start position - like for dbox */

   char mstart;
   char mend;        /* mouse activation zone - set by draw function */

   char xsize;
   char ysize;       /* size of combo box */

   char *list;       /* pointer to list for combo control */
   int iret;         /* integer return value, combo or button toggle   */

   vfnptr hfunction; /* toggle on */
   vfnptr sfunction; /* combo select func, button function, toggle off */

}__tb_ctrl_tag;


/* global structure used to handle data for graphics mode
   user supplied functions */

typedef struct
{
   char _far *font_table;        /* pointer to font table */
   unsigned ftseg;
   unsigned ftoff;               /* seg and ofs for font table */

   byte *vbuf;                   /* screen mimic array pointer */

   unsigned gx, gy;              /* screen size in pixels */
   char xchar;
   char ychar;            /* character size in pixels */

   vfnptr screen_save;           /* user save restore pixels fns */
   vfnptr screen_restore;

}__gm_tag;


/* structure passes info about user screen save in graphics modes */

typedef struct
{
   /* Set on user-save function call */
   unsigned x1;      /* top left and bottom right corners to be saved */
   unsigned y1;
   unsigned x2;
   unsigned y2;

   /* Set by user on return */
   char *data; /* pointer to data store in memory */

}_pts_tag;


/* structure to return window size in pixels in graphics screen modes */

struct _window_pix
{
   unsigned xorigin;
   unsigned yorigin;

   unsigned xsize;
   unsigned ysize;
};


/* externs for global variables */
/* Don't extern these variables when compiling the library source GLOBALS.C */

#if !defined __S_INGLOBAL

extern __ds_tag _dbox_spec;
extern __ms_tag _menu_spec;
extern __ws_tag _window_spec;

extern __wd_tag _window[];
extern __md_tag _menu[], _popmenu[], __tempmenu;
extern __ss_tag _steph_spec;

extern __gm_tag _near __gminfo;
extern _pts_tag _pix_to_save;
extern __tb_ctrl_tag _tb_control[];

extern __tb_tag _tool_spec;
extern __sbb_tag _speed_button[];
extern __ssb_tag _speed_spec;

extern __dd_tag _dbox[], __tb_store;

#endif


/* function prototypes */

/* windowing functions */

int _window_build( unsigned win, unsigned posn, unsigned startrows,
      char *title, vfnptr filter, vfnptr keyaction, vfnptr mouseaction );

void _window_controls( unsigned win, unsigned char controls );
int _window_size( unsigned win, unsigned against, unsigned newrows );
void _window_set_draw( unsigned win, char drawmode, vfnptr drawfn );

void _window_draw( void );
void _window_title( unsigned win, char *newtitle );
int _window_getnextfree( void );

unsigned _window_above( unsigned win );
unsigned _window_below( unsigned win );

char _window_close( unsigned win );
void _window_maximise( unsigned win );
void _window_minimise( void );

unsigned _window_belowandopen( unsigned window );
unsigned _window_aboveandopen( unsigned window );

void _window_drawscrollblips( void );
char _window_set_vscroll_pc( unsigned win, int percent );
char _window_set_hscroll_pc( unsigned win, int percent );

int _wb_newline( unsigned win );
int _wb_gotoline( unsigned win, unsigned linenum );
int _wb_settext( unsigned win, char *thetext );
int _wb_delline( unsigned win );
int _wb_clearall( unsigned win );


int _wb_setend( unsigned win, int endcode );
int _wb_getend( unsigned win );

void _window_setfixed( unsigned win, char fixed );

void _window_refresh( unsigned win );
void _window_refresh_lines( unsigned win, unsigned start, unsigned end,
      char dofixed );
void _window_refresh_all( void );
void _window_clear( unsigned win );

int _window_open( unsigned win, char open );
int _window_make_active( unsigned win );
void _window_mouse_functions( unsigned win,
   vfnptr close, vfnptr max, vfnptr min,
   vfnptr size, vfnptr vup, vfnptr vdown,
   vfnptr vdrag, vfnptr vpup, vfnptr vpdown,
   vfnptr hup, vfnptr hdown, vfnptr hdrag,
   vfnptr hpup, vfnptr hpdown, vfnptr unselect,
   vfnptr select, vfnptr activate );

void _window_setsyskey( vfnptr filter, vfnptr action );

struct _window_pix _window_get_gsize( unsigned win );


void _wbcc_setcolour( unsigned win, unsigned sline, unsigned schar,
		unsigned eline, unsigned echar, short ink, short paper );
void _wbcc_uncolour( unsigned win, unsigned line );
void _wbcc_getcolour( unsigned win, unsigned line,
      unsigned qchar, short *inks, short *papers );


/* menuing functions */

int _menu_build( unsigned menu, char *menutext, ... );

char _menu_enable( unsigned menu, unsigned item, char enable );
void _menu_toggle( void );
char _menu_check( unsigned menu, unsigned item, char check );
char _menu_get_check( unsigned menu, unsigned item );

void _menu_helptext( unsigned menu, char *maintext, char *text, ... );
void _menu_functions( unsigned menu, void(*afunc)(), ... );

unsigned _menu_getnextfree( void );

void _menu_go( void );

void _loop_setfunction( vfnptr lfunc );
void _loop_menufunction( vfnptr lfunc );
void _loop_dboxfunction( vfnptr lfunc );
void _steph_initialfunction( vfnptr ifunc );


/* misc functions */

char _steph_initialise( char gmode );
void _steph_go( void );
void _steph_closedown( void );

void _steph_suspend( void );
void _steph_redraw( void );

void _steph_setupgraphic( unsigned xpix, unsigned ypix,
      vfnptr save, vfnptr restore );

void _s_settextposition( char row, char column );
short _s_gettextcursor( void );
void _s_settextcursor( short cursor );
void _s_displaycursor( int onoff );

int _s_insmode( int onoff );
char _s_key_for_me( void );

void _s_time_delay( float seconds );

char *_s_buildlist( char *liststring );
char *_s_buildradiolist( char *liststring );

byte _s_shift_key_read( void );
void _s_key_read( char *k1, char *k2 );
char _s_wait_for_key( void );
void _s_flush_keyboard( void );

void _steph_version( char *store );

/* mouse functions */

void _mouse_off( void );
void _mouse_vis( int vis );
int  _mouse_on(void);
byte _mouse_nowbutton( void );

/* dialogue box functions */

int _dbox_build( char dbox, char posn, char wide, char tall, char numctrl,
   char *title, char *helptext );
void _dbox_setabspos( unsigned dbox, char xpos, char ypos );

void _dbox_go( unsigned dbox );
void _dbox_remove_control( unsigned dbox, unsigned cnum );

void _dbox_c_label( unsigned dbox, unsigned cnum, char xpos, char ypos,
   char *text );

void _dbox_c_frame( unsigned dbox, unsigned cnum, char xpos, char ypos,
   char xsize, char ysize, char *title);
void _dbox_c_button( unsigned dbox, unsigned cnum, char xpos, char ypos,
   char size, char *text, char exitflag, vfnptr function );

void _dbox_c_check( unsigned dbox, unsigned cnum, char xpos, char ypos,
   char *text, int initval, vfnptr function );

void _dbox_c_radio( unsigned dbox, unsigned cnum, char *text,
   int initval, vfnptr function );

void _dbox_c_text( unsigned dbox, unsigned cnum, char xpos, char ypos,
   char xsize, char *title, char *text, vfnptr function, vfnptr filter );

void _dbox_c_list( unsigned dbox, unsigned cnum, char xpos, char ypos,
   char xsize, char ysize, char field, unsigned scrolls,
   char *title, char *list, char exitflag,
   vfnptr sfunction, vfnptr hfunction );

void _dbox_c_combo( unsigned dbox, unsigned cnum, char xpos, char ypos,
   char xsize, char ysize, int initial, char *title, char *list,
   char exitflag,
   vfnptr sfunction, vfnptr hfunction );

void _dbox_setbars( unsigned dbox, char bar1, ... );
void _dbox_setdependants( unsigned dbox, int dep_one, ... );

void _dbox_grey( unsigned dbox, unsigned cnum, unsigned radio, char grey );
void _dbox_draw_control( unsigned dbox, unsigned cnum );

void _dbox_dragdefault( char drag, char snap );
void _dbox_setdrag( unsigned dbox, char drag, char snap );
void _query_dragdefault( char drag );

void _dbox_set_global_keys( unsigned dbox, vfnptr filter, vfnptr action );

void _flash_remove( void );
int _flash_box( char position, char *list );
int _query_box( char position, char *textlist,
   char *buttonlist, char *helptext );


/* speed bar and toolbar functions */

void _speed_text( char *text );
void _speed_show( void );
void _speed_wipebar( void );

void _speed_setbar( char *text );
void _speed_drawfn( vfnptr func );
void _speed_clickfn( vfnptr func );
int  _speed_button_set( unsigned button, char *text, char chevron, vfnptr func );
void _speed_button_colour( unsigned button, short ink, short paper );
void _speed_button_remove( unsigned button );

int  _toolbar_reserve( char number );
void _toolbar_wipe( void );
int  _toolbar_set( char bar, char *text );
void _toolbar_draw( void );

void _toolbar_drawfn( vfnptr func );
void _toolbar_click( vfnptr func );

int _toolbar_set_button( char control, char bar, char pos, char *text,
      vfnptr func );
int _toolbar_set_toggle( char control, char bar, char pos, char *text,
      char initial, vfnptr onfunc, vfnptr offfunc );
int _toolbar_set_combo( char control, char bar, char pos, char xsize,
char ysize, char *text, char *list, char initial, vfnptr sfunc );

void _toolbar_draw_control( char control );
void _toolbar_grey( char control, char grey );
void _toolbar_remove_control( char control );


/* popup menu functions */

int _popmenu_build( unsigned menu, char *menutext, ... );
void _popmenu_go( unsigned menu, char row, char col );
void _popmenu_functions( unsigned menu, void(*afunc)(), ... );

void _popmenu_helptext( unsigned menu, char *text, ... );
char _popmenu_enable( unsigned menu, unsigned item, char enable );
void _popmenu_toggle( void );

char _popmenu_check( unsigned menu, unsigned item, char check );
char _popmenu_get_check( unsigned menu, unsigned item );
void _popmenu_atmouse( unsigned menu );


void *_s_realloc( void *buffer, unsigned siz );
void *_s_malloc( unsigned siz );
void *_s_strdup( char *text );

char *_s_buildemptylist( void );
char *_s_list_item( char *list, unsigned item );
unsigned _s_list_count( char *list );

char *_s_list_next( char *list );
void  _s_list_destroy( char *list );
char *_s_list_clear( char *list );
char *_s_list_delete( char *list, unsigned item );
char *_s_list_insert( char *list, char *item, unsigned at );
char *_s_list_sort( char *list );

#endif

/* END OF FILE */
