/*
 * menu.c - menu handling function
 *
 * V. Abell
 */

/*
 * Copyright 1994 Victor A. Abell, Lafayette, Indiana  47906.  All rights
 * reserved.
 *
 * Written by Victor A. Abell.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Victor A. Abell is not responsible for any consequences of the use of
 * this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to Victor A. Abell must
 *    appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#if	!defined(lint)

# if	defined(_BCC)
#pragma warn -use
# endif

static char copyright[] =
"@(#) Copyright 1994 Victor A. Abell.\nAll rights reserved.\n";
#endif

#include "touch2.h"
#include <ctype.h>

short Cursor;
short Mode = -1;
struct videoconfig Vc;
short Vmode = 0;			/* 0 = text; 1 = graphics */


/*
 * ClearRow() - clear a text row
 */

void
ClearRow(r, c)

#if	defined(UNIX)
	int r;				/* row */
	int c;				/* column */
#else
	short r;			/* row */
	short c;			/* column */
#endif

{
	while (c <= ((r == Vc.screenheight) ? Vc.screenwidth - 1
					    : Vc.screenwidth))
	{
		gotoxy(c++, r);
		(void) putch(' ');
	}
}


/*
 * DispMenu() - display a menu
 */

void
DispMenu(m, b)
	struct menu *m;			/* menu array */
	char *b;                        /* bottom line contents */
{
	int i;


	clrscr();
	for (i = 0; m[i].msg; i++) {
		gotoxy(m[i].col, m[i].row);
		(void) cputs(m[i].msg);
	}
	PromptMsg((b == NULL) ? "Press ESC to exit." : b);
}


/*
 * GetInp() - get input
 */

int
GetInp(r, c, p, def, ib, ibl)

#if	defined(UNIX)
	int r;				/* row */
	int c;				/* column */
#else
	short r;			/* row */
	short c;			/* column */
#endif
	char *p;			/* prompt */
	char *def;			/* default */
	char *ib;			/* input buffer */
	int ibl;			/* input buffer limit */
{
	short cc, sc;
	int ch[2];
	int eoi, i, j, n;

	PromptMsg("ESC - exit; RETURN - accept; CTRL-U - erase; BKSP, DELETE, arrow keys - edit.");
	ClearRow(r, 1);
	gotoxy(c, r);
	(void) cputs(p);
	sc = c + (short)strlen(p)  + 1;
	gotoxy(sc, r);
	if (def != NULL && *def != '\0') {
		i = n = strlen(def);
		if (n > (ibl - 1)) {
			(void) fprintf(stderr,
				"GetInp: default (\"%s\") too long", def);
			TouchExit(1);
		}
		if (def != ib)
			(void) strcpy(ib, def);
		cc = sc + n;
		(void) cputs(ib);
	} else {
		i = n = 0;
		ib[0] = '\0';
		cc = sc;
	}
	_setcursortype(_NORMALCURSOR);
/*
 * Get the input.
 */
	for (eoi = 0; !eoi;) {
		ch[1] = 0;
		if ( ! kbhit()) {
			AsynRstBf();
			continue;
		}
		if ((ch[0] = getch()) == 0) {
	/*
	 * Get and process function or cursor keystroke.
	 */
			ch[1] = getch();
			switch (ch[1]) {
		/*
		 * Delete the character under the cursor.
		 */
			case CHDEL:
				if (i >= n-1)
					ib[i] = '\0';
				else {
					for (j = i; j < n; j++) {
						ib[j] = ib[j+1];
					}
				}
				n--;
				ClearRow(r, cc);
				gotoxy(cc, r);
				(void) cputs(&ib[i]);
				gotoxy(cc, r);
				continue;
		/*
		 * Move the cursor left.
		 */
			case LARW:
				if (cc == sc)
					putch(BELL);
				else {
					cc--;
					i--;
					gotoxy(cc, r);
				}
				continue;
		/*
		 * Move the cursor right.
		 */
			case RARW:
				if (i == n)
					putch(BELL);
				else {
					cc++;
					i++;
					gotoxy(cc, r);
				}
				continue;
		/*
		 * Meaningless keystroke.
		 */
			default:
				putch(BELL);
			}
			continue;
		}
		if (isprint(ch[0])) {
	/*
	 * Display and store printable character.
	 */
			if (i >= n) {
				if (i >= ibl - 1) {
					putch(BELL);
					continue;
				}
				ib[i] = (char)ch[0];
				ib[i+1] = '\0';
				n = i+1;
			} else {
				if (n >= ibl - 1) {
					putch(BELL);
					continue;
				}
				for (j = ++n; j > i; j--)
					ib[j] = ib[j-1];
				ib[i] = (char)ch[0];
			}
			gotoxy(cc++, r);
			(void) cputs(&ib[i++]);
			gotoxy(cc, r);
			continue;
		}
		if (iscntrl(ch[0])) {
	/*
	 * Handle control characters.
	 */
			switch (ch[0]) {
		/*
		 * ESC - exit
		 */
		 	case ESC:
				eoi = 1;
				n = 0;
				continue;
		/*
		 * Backspace -- CTRL-H
		 */
			case BS:
				if (cc == sc)
					continue;
				i--;
				if (i >= n-1)
					ib[i] = '\0';
				else {
					for (j = i; j < n; j++) {
						ib[j] = ib[j+1];
					}
				}
				n--;
				cc--;
				ClearRow(r, cc);
				gotoxy(cc, r);
				(void) cputs(&ib[i]);
				gotoxy(cc, r);
				continue;
		/*
		 * RETURN -- end of input
		 */
			case CR:
				eoi = 1;
				continue;
		/*
		 * Line erase -- CTRL-U
		 */
			case DC4:
				cc = sc;
				i = n = 0;
				ib[0] = '\0';
				ClearRow(r, cc);
				gotoxy(cc, r);
				continue;
			}
		}
	/*
	 * Beep on an unknown.
	 */
		putch(BELL);
	}
	_setcursortype(_NOCURSOR);
	return(n);
}


/*
 * InitMenu() - initialize menu processing
 */

void
InitMenu()
{
	if (InitTextInfo.currmode != C80)
		textmode(C80);
	gettextinfo(&Vc);
	_setcursortype(_NOCURSOR);
}


/*
 * PromptMsg() - issue prompt message
 */

void
PromptMsg(m)
	char *m;			/* message text */
{
	if (Vmode) {
		moveto(0, Maxy - TxtHt - 1);
		setcolor((int)(PromptTxtClrx & 15));
		outtext(m);
		setcolor((int)(TxtClrx & 15));
		return;
	}
	gotoxy(1, Vc.screenheight);
	textattr(AttrPrompt);
	(void) cputs(m);
	textattr(AttrNorm);
}
