/*
 * touch2.h -- definitions for touch2
 *
 * V. Abell
 */

/*
 * Copyright 1993 Victor A. Abell, Lafayette, Indiana  47906.  All rights
 * reserved.
 *
 * Written by Victor A. Abell.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Victor A. Abell is not responsible for any consequences of the use of
 * this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to Victor A. Abell must
 *    appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#include <stdio.h>

#ifdef	_BCC
#include <conio.h>
#include <dos.h>
#include <graphics.h>
#include <string.h>
#endif

#ifdef	STDLIB
#include <stdlib.h>
#endif

#if	defined(UNIX)
struct videoconfig {
	unsigned char attribute;
	unsigned char currmode;
	int screenheight;
	int screenwidth;
};
#define	BLUE		1
#define	C80		0
#define DETECT		0
#define EGAVGA_driver	0
#define	_NOCURSOR	0
#define	_NORMALCURSOR	0
#define	RED		4
#define	strcmpi		strcasecmp
#define strnicmp	strncasecmp
#define	text_info	videoconfig
#define	VGA		0
#define	VGAMED		0
#define	WHITE		15
#define YELLOW		14
#endif

#if	defined(_BCC)
#define	videoconfig	text_info
#endif

#define	AFTEPSON	"\\f\\e@"		/* default after graph printer
						 * control string  for EPSON */
#define	AFTPCL4		"\\f\\eE\\04"		/* default after graph printer
						 * control string  for PCL4 */
#define	AFTPPDS		"\\f\\e[K\\01\\00\\06\\04"
						/* default after graph printer
						 * control string  for PPDS */
#define	BARCH		0xcd			/* bar graph character */
#define	BEFEPSON	"\\e0\\et1\\e7\\ex1"	/* default before graph printer
						 * control string  for EPSON */
#define	BEFPCL4		"\\e&l8D\\e(10U"	/* default before graph printer
						 * control string  for PCL4 */
#define	BEFPPDS		"\\e0"			/* default before graph printer
						 * control string  for PPDS */
#define	BELL		7			/* BELL */
#define	BS		8			/* BACKSPACE */
#define CHDEL           83                      /* delete character at cursor */
#define CR		13			/* RETURN */
#define	DARW		80			/* down arrow */
#define	DC4		21			/* CTRL-U */
#define	DEFBCX		BLUE			/* default background color
						 * index */
#define DEFQDMPF 	"touch2.csv"            /* default QuattroPro dump file
						 * name */
#define DEFRDMPF 	"touch2.dmp"            /* default raw dump file name */
#define DEFMGMAX	110.0			/* default mg/dl maximum */
#define DEFMGMIN        70.0			/* default mg/dl minimum */
#define DEFMMMAX	6.1			/* default mmol/l maximum */
#define DEFMMMIN        3.9			/* default mmol/l minimum */
#define	DEFGRAPHF	"touch2.grf"		/* default graph file name */
#define DEFPBCX		RED			/* default prompt background
						 * color index */
#define	DEFPTCX		WHITE			/* default prompt text color
						 * index */
#define DEFTCX		YELLOW			/* default text color index */
#define	DUMPFNL		64			/* dump file name length */
#define DUMPLL		256			/* dump line length */
#define DUMPNL		256			/* dump number of lines */
#define	ESC		27
#define GTTLLNL		66			/* graph title line limit */
#define	HDRLPP		10			/* header lines per page */
#define	INTCH		0xd8			/* bar and min/max intersection
						 * character */
#define LARW            75                      /* left arrow */
#define LF              10                      /* LINE FEED */
#define	LINECH		0xb3			/* min/max line character */
#define	LPP		81			/* lines per page */
#define	MAXTMRANGE	6			/* TmRange[] limit */
#define	NOCURSOR	0x2000			/* no cursor */
#define	PGDN		81			/* PgDn */
#define PGUP		73			/* PgUp */
#define	PRTRCTLLN	256			/* printer control string
						 * length */
#define RARW            77                      /* right arrow */
#define	RDREG		0			/* regular reading */
#define RDSOL		1			/* check solution reading */
#define	RDSTRIP		2			/* strip reading */
#define RDMTRERR	3			/* meter error -- "reading?" */
#define RDHIGH		4			/* " HIGH " reading */
#define	SKIPDTLN	9			/* graph date skip length */
#define	SKIPTMLN	12			/* graph time skip length */
#define UARW		72			/* up arrow */

struct menu {
	short	row;
	short	col;
	char	*msg;
};

struct parity {
	short val;
	char *nm;
};

struct range {
	char *tm;
	char *ttl;
	short bt;
	short et;
};


extern char *AftGraph;
extern int AsynBfLen;
extern int AttrNorm;
extern int AttrPrompt;
extern char BarCh[];
extern short Baud[];
extern short Baudx;
extern char *BefGraph;
extern short BkClrx;
extern short Ckdump;
extern short Cksum;
extern char *Colors[];
extern short ComOpen;
extern char Date[];
extern short Debug;
extern char Dow[];
extern short DSRwait;
extern char DumpfnQ[];
extern char DumpfnR[];
extern FILE *Dumpfs;
extern int DumpHs;
extern int DumpLc;
extern char DumpLine[];
extern char *DumpLp[];
extern char *EvtBuf[];
extern char Event;
extern char Eventfilt;
extern char Exttl[];
extern short Frame;
extern double Gmaxl;
extern double Gminl;
extern char Graphfn[];
extern FILE *Graphfs;
extern char Gttl[];
extern char GttlDumpf[];
extern char *GttlOrig;
extern unsigned char IgnEvt[];
extern unsigned char IgnEvtOrig[];
extern struct text_info InitTextInfo;
extern char IntCh[];
extern short Irq;
extern char LineCh[];
extern short Lineval;
extern short Lpp;
extern int Maxx;
extern int Maxy;
extern char Mdate[];
extern char Mmax[];
extern char Mmin[];
extern short Mode;
extern char Mtime[];
extern short Ndump;
extern short NTmRange;
extern struct parity Par[];
extern short Parx;
extern short PcDisp;
extern char *Pn;
extern short Port;
extern short PortAddr;
extern short PromptBkClrx;
extern short PromptTxtClrx;
extern short Qp;
extern short RangeInUse;
extern FILE *Rdumpfs;
extern short Rtype;
extern double Rval;
extern short SkipAft;
extern char SkipAftDt[];
extern char SkipAftTm[];
extern short SkipUnt;
extern char SkipUntDt[];
extern char SkipUntTm[];
extern short StSt;
extern short SupTtlIO;
extern char Time[];
extern struct range TmRange[];
extern char TtlErrMsg[];
extern char *TtlVar[];
extern short TtlVarX;
extern short TxtClrx;
extern int TxtHt;
extern int TxtWid;
extern struct videoconfig Vc;
extern short Vmode;
extern short Warn;

int Asm1Ch(char *s, char *r);
int CheckESC(void);

#if	defined(UNIX)
void ClearRow(int r, int c);
#else
void ClearRow(short r, short c);
#endif


int AsmHex(char *c);
void AsynClose(void);
void AsynInp(char *c, int *e);
void AsynOpen(int Cport, int irq, int portaddr, int baud, int parity,
	      int stopbits, int numbits, int *err_code);
void AsynRstBf(void);
void AsynSndStr(char *str,int *err_code);
int Atof(char *s, double *d, char *m, char *t);
void CloseCom(void);
void CloseDump(void);
void CommDisp(char *c);
int CvtTm(char **tm, char *msg);
int CvtPrtrStr(char *s, char *r, int n);
int CvtTmRange(char *tm, char *msg, short *bt, short *et);
void DateTime(void);
void DefCom(void);
void DrawGraph(int ty);
void DumpMtr(void);
void DispMenu(struct menu *m, char *b);
int EntPrtStr(char *a, char *b);
int ExpandTtl(void);
int GetDataLn(char *s, int n);

#if	defined(UNIX)
int GetInp(int r, int c, char *p, char *def, char *ib, int ibl);
#else
int GetInp(short r, short c, char *p, char *def, char *ib, int ibl);
#endif

int getopt(int argc, char **argv, char *opts);
void InitDump(void);
void InitMenu(void);
void InitStatus(void);
void OpenCom(void);
char *ParseField(char *p, char *b, int l);
int ParseHdr(void);

#if	defined(UNIX)
int ParseDumpLn(char *dl, int s);
#else
int ParseDumpLn(char *dl, short s);
#endif

void PromptMsg(char *m);
int ReadConf(void);
void SelEvent(void);
void SelIgnEvt(void);
void SelTmRange(void);
void SelSkipAft(void);
void SelSkipUnt(void);
int SetAftGraph(char *b, char *v);
int SetBarChar(char *b, char *v);
int SetBefGraph(char *b, char *v);
int SetGmaxLvl(char *b, char *v);
int SetGminLvl(char *b, char *v);
int SetGraphTtl(char *b, char *v);
int SetIntChar(char *b, char *v);
int SetLineChar(char *b, char *v);
int SetLpp(char *b, char *v);
int SetPrinter(char *b, char *v);
int SetTtlVar(char *b, char *v);
void StatusMtr(void);
int TestGlev(void);
void TouchExit(int xv);
int WaitAnyKey(void);

#if	defined(UNIX)
int WaitCmd(char *c, int e);
#else
int WaitCmd(char *c, char e);
#endif

int WaitRdy(void);

#if	defined(UNIX)
int WarnMsg(int r1, int c1, char *m1, int r2, int c2, char *m2, int f);
#else
int WarnMsg(short r1, short c1, char *m1, short r2, short c2, char *m2, short f);
#endif
