{}
{                                                       }
{      Virtual Pascal Runtime Library.  Version 1.0.    }
{      OS/2 Base & Text Mode Applications API interface }
{      }
{      Copyright (C) 1995 B&M&T Corporation             }
{      }
{      Written by Vitaly Miryanov                       }
{                                                       }
{}

unit Os2Base;

interface

uses Os2Def;

{$Far16+,AlignRec-,OrgName+}

{----[ KBDCALLS ]----}

const
  kr_KbdCharIn                  = $00000001;    { KbdRegister FnMask }
  kr_KbdPeek                    = $00000002;
  kr_KbdFlushBuffer             = $00000004;
  kr_KbdGetStatus               = $00000008;
  kr_KbdSetStatus               = $00000010;
  kr_KbdStringIn                = $00000020;
  kr_KbdOpen                    = $00000040;
  kr_KbdClose                   = $00000080;
  kr_KbdGetFocus                = $00000100;
  kr_KbdFreeFocus               = $00000200;
  kr_KbdGetCp                   = $00000400;
  kr_KbdSetCp                   = $00000800;
  kr_KbdXlate                   = $00001000;
  kr_KbdSetCustXt               = $00002000;

  io_Wait                       = 0;            { WaitFlag           }
  io_NoWait                     = 1;

  keyboard_Echo_On              = $0001;        { KBDINFO.fsMask     }
  keyboard_Echo_Off             = $0002;
  keyboard_Binary_Mode          = $0004;
  keyboard_Ascii_Mode           = $0008;
  keyboard_Modify_State         = $0010;
  keyboard_Modify_Interim       = $0020;
  keyboard_Modify_Turnaround    = $0040;
  keyboard_2B_Turnaround        = $0080;
  keyboard_Shift_Report         = $0100;

  kbdstf_RightShift             = $0001;        { KBDINFO.fsState    }
  kbdstf_LeftShift              = $0002;        { KBDKEYINFO.fsState }
  kbdstf_Control                = $0004;        { KBDTRANS.fsState   }
  kbdstf_Alt                    = $0008;
  kbdstf_ScrollLock_On          = $0010;
  kbdstf_NumLock_On             = $0020;
  kbdstf_Capslock_On            = $0040;
  kbdstf_Insert_On              = $0080;
  kbdstf_LeftControl            = $0100;
  kbdstf_LeftAlt                = $0200;
  kbdstf_RightControl           = $0400;
  kbdstf_RightAlt               = $0800;
  kbdstf_ScrollLock             = $1000;
  kbdstf_NumLock                = $2000;
  kbdstf_CapsLock               = $4000;
  kbdstf_SysReq                 = $8000;

  kbdtrf_Shift_Key_In           = $01;          { KBDTRANS.fbStatus  }
  kbdtrf_Conversion_Request     = $20;
  kbdtrf_Final_Char_In          = $40;
  kbdtrf_Interim_Char_In        = $80;

  keyboard_At_Compatable        = $0001;        { KbdHwId.IdKbd      }
  keyboard_Enhanced_101         = $AB41;
  keyboard_Enhanced_102         = $AB41;
  keyboard_Enhanced_122         = $AB85;
  keyboard_SpaceSaver           = $AB54;

type
  KbdKeyInfo = record           { Record for KbdCharIn and KbdPeek          }
    chChar:     Char;           { ASCII char (0 or $E0 = extended ASCII)    }
    chScan:     Byte;           { Scan code (or extended ASCII char)        }
    fbStatus:   Byte;           { Miscellaneous status; key recieved flag   }
    bNlsShift:  Byte;           { NLS Shift Status                          }
    fsState:    Word;           { State of shift keys                       }
    time:       ULong;          { TimeStamp (unique number of milliseconds) }
  end;

  StringInBuf = record          { Record for KbdStringIn                    }
    cb:         Word;           { Requested maximum number of characters    }
    cchIn:      Word;           { Expects: size of previous input(template) }
  end;                          { Returns: the actual number of characters  }

  KbdInfo = record              { record for KbdSet / GetStatus             }
    cb:           Word;         { Size of this record                       }
    fsMask:       Word;         { Mode of operation                         }
    chTurnAround: Word;         { usually $000D; i.e. Enter                 }
    fsInterim:    Word;         { NLS control bits                          }
    fsState:      Word;         { Shift key status                          }
  end;

  KbdHwId = record              { record for KbdGetHWID                     }
    cb:          Word;          { Size of this record                       }
    idKbd:       Word;          { Id number generated by keyboard hardware  }
    usReserved1: Word;          { Reserved                                  }
    usReserved2: Word;          { Reserved                                  }
  end;

  KbdTrans = record             { record for KbdXlate                       }
    chChar:     Char;           { Returns: ASCII Char(0 for X-ASCII)        }
    chScan:     Byte;           { Expects: Scan Code; Returns: 0 (or X-ASCII) }
    fbStatus:   Byte;           { Indicates return status                   }
    bNlsShift:  Byte;           { NLS shift status                          }
    fsState:    Word;           { Shift key status                          }
    time:       ULong;          { TimeStamp (unique number of milliseconds  }
    fsDD:       Word;           { Device driver returned flags              }
    fsXlate:    Word;           { Different flags (translation complete flag) }
    fsShift:    Word;           { Used in multi-key keystroke translation   }
    sZero:      Word;           { Reserved, must be zero                    }
  end;

function KbdCharIn(var Key: KbdKeyInfo; WaitFlag: Word; KbdHandle: Word): ApiRet16;
function KbdClose(KbdHandle: Word): ApiRet16;
function KbdDeRegister: ApiRet16;
function KbdFlushBuffer(KbdHandle: Word): ApiRet16;
function KbdFreeFocus(KbdHandle: Word): ApiRet16;
function KbdGetCp(Reserved: ULong; var CodePage: Word; KbdHandle: Word): ApiRet16;
function KbdGetFocus(WaitFlag: Word; KbdHandle: Word): ApiRet16;
function KbdGetHwId(var HwId: KbdHwId; KbdHandle: Word): ApiRet16;
function KbdGetStatus(var Status: KbdInfo; KbdHandle: Word): ApiRet16;
function KbdOpen(var KbdHandle: Word): ApiRet16;
function KbdPeek(var Key: KbdKeyInfo; KbdHandle: Word): ApiRet16;
function KbdRegister(ModuleName,ProcName: PChar; FnMask: ULong): ApiRet16;
function KbdSetCp(usReserved: Word; CodePage: Word; KbdHandle: Word): ApiRet16;
function KbdSetCustXt(XLateTbl: Pointer; KbdHandle: Word): ApiRet16;
function KbdSetFgnd: ApiRet16;
function KbdSetHwId(var HwId: KbdHwId; KbdHandle: Word): ApiRet16;
function KbdSetStatus(var Status: KbdInfo; KbdHandle: Word): ApiRet16;
function KbdStringIn(CharBuf: Pointer; var LenInOut: StringInBuf; WaitFlag: Word; KbdHandle: Word): ApiRet16;
function KbdSynch(WaitFlag: Word): ApiRet16;
function KbdXlate(var TransData: KbdTrans; KbdHandle: Word): ApiRet16;

{----[ MOUCALLS ]----}

const
  mr_MouGetNumButtons           = $00000001;    { MouRegsiter FnMask }
  mr_MouGetNumMickeys           = $00000002;
  mr_MouGetDevStatus            = $00000004;
  mr_MouGetNumQueEl             = $00000008;
  mr_MouReadEventQue            = $00000010;
  mr_MouGetScaleFact            = $00000020;
  mr_MouGetEventMask            = $00000040;
  mr_MouSetScaleFact            = $00000080;
  mr_MouSetEventMask            = $00000100;
  mr_MouOpen                    = $00000800;
  mr_MouClose                   = $00001000;
  mr_MouGetPtrShape             = $00002000;
  mr_MouSetPtrShape             = $00004000;
  mr_MouDrawPtr                 = $00008000;
  mr_MouRemovePtr               = $00010000;
  mr_MouGetPtrPos               = $00020000;
  mr_MouSetPtrPos               = $00040000;
  mr_MouInitReal                = $00080000;
  mr_MouSetDevStatus            = $00100000;

  mhk_Button1                   = $0001;        { MouGetHotKey / MouSetHotKey }
  mhk_Button2                   = $0002;        { Mouse Hot Key bits          }
  mhk_Button3                   = $0004;

  mouse_QueueBusy               = $0001;        { MouGetDevStatus /           }
  mouse_BlockRead               = $0002;        { MouSetDevStatus             }
  mouse_Flush                   = $0004;        { device status constants     }
  mouse_Unsupported_Mode        = $0008;
  mouse_Disabled                = $0100;
  mouse_Mickeys                 = $0200;

  mou_NoWait                    = $0000;        { WaitFlag                    }
  mou_Wait                      = $0001;

  mouse_Motion                  = $0001;        { MouGetEventMask /           }
  mouse_Motion_With_Bn1_Down    = $0002;        { MouSetEventMask events      }
  mouse_Bn1_Down                = $0004;
  mouse_Motion_With_Bn2_Down    = $0008;
  mouse_Bn2_Down                = $0010;
  mouse_Motion_With_Bn3_Down    = $0020;
  mouse_Bn3_Down                = $0040;

  mou_NoDraw                    = $0001;        { MouSetDevStatus Status      }
  mou_Draw                      = $0000;
  mou_Mickeys                   = $0002;
  mou_Pels                      = $0000;

type
  PtrLoc = record               { Record for MouGet / SetPtrPos               }
    Row:        Word;           { Current row (vertical coordinate)           }
    Col:        Word;           { Current column (horizontal coordinate)      }
  end;

  PtrShape = record             { Record for MouGetPtrShape / MouSetPtrShape  }
    cb:         Word;           { Length of image buffer in bytes             }
    Col:        Word;           { Pointer width in characters or pixels       }
    Row:        Word;           { Pointer height in characters or pixels      }
    ColHot:     Word;           { Hotspot offset from left side               }
    RowHot:     Word;           { Hotspot offset from top                     }
  end;

  MouEventInfo = record         { Record for MouReadEventQue                  }
    fs:         Word;           { Event bits                                  }
    Time:       ULong;          { Event timestamp (unique number of milliseconds)}
    Row:        Word;           { Pointer current row position                }
    Col:        Word;           { Pointer current column position             }
  end;

  MouQueInfo = record           { Record for MouGetNumQueEl                   }
    cEvents:    Word;           { Number of elements in event queue           }
    cMaxEvents: Word;           { Maximum queue size in elements              }
  end;

  ScaleFact = record            { Record for MouGetScaleFact / MouSetScaleFact}
    RowScale:   Word;           { Scaling factor of current row               }
    ColScale:   Word;           { Scaling factor of current column            }
  end;

  NoPtrRect = record            { Record for MouRemovePtr                     }
    Row:        Word;           { Row of top of the rectangle                 }
    Col:        Word;           { Column of left edge of the rectangle        }
    cRow:       Word;           { Row of bottom right edge of the rectangle   }
    cCol:       Word;           { Column of botton right edge of the rectangle}
  end;

  Threshold = record            { Record for MouGetThreshold / MouSetThreshold}
    Length:     Word;           { Length Field                                }
    Level1:     Word;           { First movement level                        }
    Lev1Mult:   Word;           { First level multiplier                      }
    Level2:     Word;           { Second movement level                       }
    Lev2Mult:   Word;           { Second level multiplier                     }
  end;

function MouClose(MouHandle: Word): ApiRet16;
function MouDeRegister: ApiRet16;
function MouDrawPtr(MouHandle: Word): ApiRet16;
function MouFlushQue(MouHandle: Word): ApiRet16;
function MouGetDevStatus(var Status: Word; MouHandle: Word): ApiRet16;
function MouGetEventMask(var EventMask: Word; MouHandle: Word): ApiRet16;
function MouGetHotKey(var ButtonBits: Word; MouHandle: Word): ApiRet16;
function MouGetNumButtons(var ButtonCount: Word; MouHandle: Word): ApiRet16;
function MouGetNumMickeys(var MickeyCnt: Word; MouHandle: Word): ApiRet16;
function MouGetNumQueEl(var MouseQInfo: MouQueInfo; MouHandle: Word): ApiRet16;
function MouGetPtrPos(var MouPtr: PtrLoc; MouHandle: Word): ApiRet16;
function MouGetPtrShape(ImageBuf: Pointer; var ImageInfo: PtrShape; MouHandle: Word): ApiRet16;
function MouGetScaleFact(var Scale: ScaleFact; MouHandle: Word): ApiRet16;
function MouGetThreshold(var MouThreshold: Threshold; MouHandle: Word): ApiRet16;
function MouInitReal(DriverName: PChar): ApiRet16;
function MouOpen(DriverName: PChar; var MouHandle: Word): ApiRet16;
function MouReadEventQue(var Event: MouEventInfo; var WaitFlag: Word; MouHandle: Word): ApiRet16;
function MouRegister(ModuleName,ProcName: PChar; FnMask: ULong): ApiRet16;
function MouRemovePtr(var ProtectArea: NoPtrRect; MouHandle: Word): ApiRet16;
function MouSetDevStatus(var Status: Word; MouHandle: Word): ApiRet16;
function MouSetEventMask (var EventMask: Word; MouHandle: Word): ApiRet16;
function MouSetHotKey(var ButtonBits: Word; MouHandle: Word): ApiRet16;
function MouSetPtrPos (var MouPtr: PtrLoc; MouHandle: Word): ApiRet16;
function MouSetPtrShape(ImageBuf: Pointer; var ImageInfo: PtrShape; MouHandle: Word): ApiRet16;
function MouSetScaleFact (var Scale: ScaleFact; MouHandle: Word): ApiRet16;
function MouSetThreshold(var MouThreshold: Threshold; MouHandle: Word): ApiRet16;
function MouSynch(WaitFlag: Word): ApiRet16;

{----[ VIOCALLS ]----}

const
  vr_VioGetCurPos               = $00000001;    { First parameter registration }
  vr_VioGetCurType              = $00000002;    { constants                    }
  vr_VioGetMode                 = $00000004;
  vr_VioGetBuf                  = $00000008;
  vr_VioGetPhysBuf              = $00000010;
  vr_VioSetCurPos               = $00000020;
  vr_VioSetCurType              = $00000040;
  vr_VioSetMode                 = $00000080;
  vr_VioShowBuf                 = $00000100;
  vr_VioReadCharStr             = $00000200;
  vr_VioReadCellStr             = $00000400;
  vr_VioWrtNChar                = $00000800;
  vr_VioWrtNAttr                = $00001000;
  vr_VioWrtNCell                = $00002000;
  vr_VioWrtTTy                  = $00004000;
  vr_VioWrtCharStr              = $00008000;
  vr_VioWrtCharStrAtt           = $00010000;
  vr_VioWrtCellStr              = $00020000;
  vr_VioScrollUp                = $00040000;
  vr_VioScrollDn                = $00080000;
  vr_VioScrollLf                = $00100000;
  vr_VioScrollRt                = $00200000;
  vr_VioSetAnsi                 = $00400000;
  vr_VioGetAnsi                 = $00800000;
  vr_VioPrtSc                   = $01000000;
  vr_VioScrLock                 = $02000000;
  vr_VioScrUnlock               = $04000000;
  vr_VioSavRedrawWait           = $08000000;
  vr_VioSavRedrawUndo           = $10000000;
  vr_VioPopup                   = $20000000;
  vr_VioEndPopup                = $40000000;
  vr_VioPrtScToggle             = $80000000;

  vr_VioModeWait                = $00000001;    { Second parameter registration}
  vr_VioModeUndo                = $00000002;    { constants                    }
  vr_VioGetFont                 = $00000004;
  vr_VioGetConfig               = $00000008;
  vr_VioSetCp                   = $00000010;
  vr_VioGetCp                   = $00000020;
  vr_VioSetFont                 = $00000040;
  vr_VioGetState                = $00000080;
  vr_VioSetState                = $00000100;

  colors_2                      = $0001;        { VioModeInfo.Color constants }
  colors_4                      = $0002;
  colors_16                     = $0004;
  colors_256                    = $0008;

  vgmt_Other                    = $01;          { VioModeInfo.fbType          }
  vgmt_Graphics                 = $02;
  vgmt_DisableBurst             = $04;

  vcc_SbCsChar                  = 0;            { VioCheckCharType.pType      }
  vcc_DbCsFullChar              = 1;
  vcc_DbCs1stHalf               = 2;
  vcc_DbCs2ndHalf               = 3;

  ansi_On                       = 1;            { VioGetAnsi / VioSetAnsi Mode}
  ansi_Off                      = 0;

  vsrwi_SaveAndRedraw           = 0;            { VioSavRedrawWait RequestType}
  vsrwi_Redraw                  = 1;
  vsrwn_Save                    = 0;            { VioSavRedrawWait NotifyType }
  vsrwn_Redraw                  = 1;

  undoi_GetOwner                = 0;            { VioSavRedrawUndo Ownership  }
  undoi_ReleaseOwner            = 1;
  undok_ErrorCode               = 0;            { VioSavRedrawUndo KillThread }
  undok_Terminate               = 1;

  vmwr_Popup                    = 0;            { VioModeWait RequestType     }
  vmwn_Popup                    = 0;            { VioModeWait NotifyType      }

  lockIO_NoWait                 = 0;            { VioScrLock WaitFlag         }
  lockIO_Wait                   = 1;
  lock_Success                  = 0;            { VioScrLock Status           }
  lock_Fail                     = 1;

  vp_NoWait                     = $0000;        { VioPopup OptionFlags        }
  vp_Wait                       = $0001;
  vp_Opaque                     = $0000;
  vp_Transparent                = $0002;

  vio_Config_Current            = 0;            { VioGetConfig.Configuration  }
  vio_Config_Primary            = 1;
  vio_Config_Secondary          = 2;

  display_Monochrome            = $0000;        { VioConfigInfo.Adapter       }
  display_CGA                   = $0001;
  display_EGA                   = $0002;
  display_VGA                   = $0003;
  display_8514a                 = $0007;

  monitor_Monochrome            = $0000;        { VioConfigInfo.Display       }
  monitor_Color                 = $0001;
  monitor_Enhanced              = $0002;
  monitor_8503                  = $0003;
  monitor_851x_Color            = $0004;
  monitor_8514                  = $0009;

  vgfi_GetCurFont               = 0;            { VioFontInfo.Type            }
  vgfi_GetROMFont               = 1;

type
  VioCursorInfo = record        { Record for VioSetCurType / VioGetCurType    }
    yStart:     Word;           { Cursor start scan line (0-based)            }
    cEnd:       Word;           { Cursor end scan line                        }
    cx:         Word;           { Cursor width (0=default width)              }
    Attr:       Word;           { Cursor color attribute (-1 = hidden)        }
  end;

  VioModeInfo = record          { Record for VioSetMode / VioGetMode          }
    cb:         Word;           { Size of this structure                      }
    fbType:     Byte;           { 8-bit mask identifying the mode             }
    Color:      Byte;           { Colors available. Power of 2 (1=2,2=4,4=16) }
    Col:        Word;           { Number of text character columns            }
    Row:        Word;           { Number of text character rows               }
    HRes:       Word;           { Display width in pixels                     }
    VRes:       Word;           { Display height in pixels                    }
    fmt_ID:     Byte;           { Format of the attributes                    }
    Attrib:     Byte;           { Number of attributes in the attribfmt field }
    Buf_Addr:   ULong;          { Address of the phisical display buffer      }
    Buf_Length: ULong;          { Length of the phisical display buffer       }
    Full_Length: ULong;         { Size of the buffer to save entire phis. buf.}
    Partial_Length: ULong;      { Size of the buffer to save part of the phis. buf. overwritten by VioPopup }
    Ext_Data_Addr: Pointer;     { Address of an extended-mode structure       }
  end;

  VioPhysBuf = record           { Record for VioGetPhysBuf                    }
    pBuf:       Pointer;        { Absolute screen address                     }
    cb:         ULong;          { Length of the buffer in bytes               }
    Sel:        Word;           { Receives selector for video access          }
  end;

  VioConfigInfo = record        { Record for VioGetConfig                     }
    cb:         Word;           { Size of this structure                      }
    Adapter:    Word;           { Adapter type                                }
    Display:    Word;           { Display type                                }
    cbMemory:   ULong;          { Amount of RAM in bytes on the adapter       }
    Configuration: Word;        { Configuration Id (Primary,Secondary,Current)}
    VDHVersion: Word;           { Reserved; must be zero                      }
    Flags:      Word;           { Flags: $0001 sets default power-on config   }
    HWBufferSize: ULong;        { Size of the buffer to save full adapter state(not including phis buf)}
    FullSaveSize: ULong;        { Size of the buffer to save entire adapter state}
    PartSaveSize: ULong;        { Size of the buffer to save part of the phis. buf. overwritten by VioPopup }
    EMAdaptersOFF: Word;        { Offset of the info that describes emulated adapter types}
    EMDisplaysOFF: Word;        { Offset of the info that describes emulated display types}
  end;

  VioFontInfo = record          { Record for VioGetFont / VioSetFont          }
    cb:         Word;           { Size of this structure                      }
    rType:      Word;           { Request type                                }
    cxCell:     Word;           { Column per cell                             }
    cyCell:     Word;           { Rows per cell                               }
    pbData:     Pointer;        { Address of caller's data area               }
    cbData:     Word;           { Size in bytes of the callers data area      }
  end;

  VioPalState = record          { Record for VioGetState / VioSetState        }
    cb:         Word;           { Size of this structure                      }
    rType:      Word;           { 0 = palette                                 }
    iFirst:     Word;           { Specifies the first register                }
    Acolor:     array [0..15] of Word; { Up to 16 register values             }
  end;

  VioOverScan = record          { Record for VioGetState / VioSetState        }
    cb:         Word;           { Size of this structure                      }
    rType:      Word;           { 1 = border color                            }
    Color:      Word;           { The color of the border area                }
  end;

  VioIntensity = record         { Record for VioGetState / VioSetState        }
    cb:         Word;           { Size of this structure                      }
    rType:      Word;           { 2 = Blink/bold settings                     }
    fs:         Word;           { The blink/bold background switch            }
  end;

  VioColorReg = record          { Record for VioGetState / VioSetState        }
    cb:         Word;           { Size of this structure                      }
    rType:      Word;           { 3 = Color registers                         }
    FirstColorReg: Word;        { Specifies the first color registers         }
    NumColorRegs: Word;         { Number of color registers                   }
    ColorRegAddr: Pointer;      { Pointer to array with color values          }
  end;

  VioSetULineLoc = record       { Record for VioGetState / VioSetState        }
    cb:         Word;           { Size of this structure                      }
    rType:      Word;           { 5 = Underline                               }
    ScanLine:   Word;           { Location of the underline (32=no underline) }
  end;

  VioSetTarget = record         { Record for VioGetState / VioSetState        }
    cb:         Word;           { Size of this structure                      }
    rType:      Word;           { 6 = Target for VioSetMode                   }
    DefaultAlgorithm: Word;     { $0000=default, $0001=Primary, $0002=Secondary}
  end;

function VioCheckCharType(var CharType: Word; Row,Column,VioHandle: Word): ApiRet16;
function VioDeRegister: ApiRet16;
function VioEndPopUp(VioHandle: Word): ApiRet16;
function VioGetAnsi(var Mode: Word; VioHandle: Word): ApiRet16;
function VioGetBuf(var LVBAddr: Pointer; var LVBLength: Word; VioHandle: Word): ApiRet16;
function VioGetConfig(ConfigId: Word; var VideoConfig: VioConfigInfo; VioHandle: Word): ApiRet16;
function VioGetCp(Reserved: Word; var CodePage: Word; VioHandle: Word): ApiRet16;
function VioGetCurPos(var Row,Col: Word; VioHandle: Word): ApiRet16;
function VioGetCurType(var CurData: VioCursorInfo; VioHandle: Word): ApiRet16;
function VioGetFont(var FontData: VioFontInfo; VioHandle: Word): ApiRet16;
function VioGetMode(var Mode: VioModeInfo; VioHandle: Word): ApiRet16;
function VioGetPhysBuf(var PBData: VioPhysBuf; Reserved: Word): ApiRet16;
function VioGetState(var State; VioHandle: Word): ApiRet16;
function VioModeUndo(OwnerShip,KillFlag,Reserved: Word): ApiRet16;
function VioModeWait(RequestType: Word; var NotifyType: Word; Reserved: Word): ApiRet16;
function VioPopUp(var OptionFlags: Word; VioHandle: Word): ApiRet16;
function VioPrtSc(VioHandle: Word): ApiRet16;
function VioPrtScToggle(VioHandle: Word): ApiRet16;
function VioReadCellStr(var Buf; var BufLen: Word; Row,Column,VioHandle: Word): ApiRet16;
function VioReadCharStr(var Buf; var BufLen: Word; Row,Column,VioHandle: Word): ApiRet16;
{ Stealth function: it's declared in the C header file, but it's not }
{ available in the VIOCALLS dynamic link library                     }
{function VioRedrawSize(var RedrawSize: ULong): ApiRet16;            }
function VioRegister(ModuleName,ProcName: PChar; FnMask1,FnMask2: ULong): ApiRet16;
function VioSavRedrawUndo(Ownership,KillThread,Reserved: Word): ApiRet16;
function VioSavRedrawWait(RequestType: Word; var NotifyType: Word; Reserved: Word): ApiRet16;
function VioScrLock(WaitFlag: Word; var Status: Word; VioHandle: Word): ApiRet16;
function VioScrUnLock(VioHandle: Word): ApiRet16;
function VioScrollDn(TopRow,LeftCol,BotRow,RightCol,Lines: Word; var Cell: Word; VioHandle: Word): ApiRet16;
function VioScrollLf(TopRow,LeftCol,BotRow,RightCol,cbCol: Word; var Cell: Word; VioHandle: Word): ApiRet16;
function VioScrollRt(TopRow,LeftCol,BotRow,RightCol,cbCol: Word; var Cell: Word; VioHandle: Word): ApiRet16;
function VioScrollUp(TopRow,LeftCol,BotRow,RightCol,Lines: Word; var Cell: Word; VioHandle: Word): ApiRet16;
function VioSetAnsi(Mode,VioHandle: Word): ApiRet16;
function VioSetCp(Reserved: Word; CodePage: Word; VioHandle: Word): ApiRet16;
function VioSetCurPos(Row,Column: Word; VioHandle: Word): ApiRet16;
function VioSetCurType(var CurData: VioCursorInfo; VioHandle: Word): ApiRet16;
function VioSetFont(var FontData: VioFontInfo; VioHandle: Word): ApiRet16;
function VioSetMode(var Mode: VioModeInfo; VioHandle: Word): ApiRet16;
function VioSetState(var State; VioHandle: Word): ApiRet16;
function VioShowBuf(BufOfs,Len,VioHandle: Word): ApiRet16;
function VioWrtCellStr(CellStr: Pointer; Len,Row,Column,VioHandle: Word): ApiRet16;
function VioWrtCharStr(CharStr: Pointer; Len,Row,Column,VioHandle: Word): ApiRet16;
function VioWrtCharStrAtt(CharStr: Pointer; Len,Row,Column: Word; var Attr: Byte; VioHandle: Word): ApiRet16;
function VioWrtNAttr(var Attr: Byte; Times,Row,Column,VioHandle: Word): ApiRet16;
function VioWrtNCell(var Cell: Word; Times,Row,Column,VioHandle: Word): ApiRet16;
function VioWrtNChar(var Char: Byte; Times,Row,Column,VioHandle: Word): ApiRet16;
function VioWrtTTY(CharStr: Pointer; Len,VioHandle: Word): ApiRet16;

{----[ MONCALLS ]----}

const
  monitor_Default               = $0000;        { DosMonReg PosCode           }
  monitor_Begin                 = $0001;
  monitor_End                   = $0002;

type
  MonIn = record                { Record for DosMonRead / DosMonReg           }
    cb:       Word;             { Size of this structure                      }
    Reserved: array [0..17] of Byte;    { Reserved                            }
    Buffer:   array [0..107] of Byte;   { Input buffer                        }
  end;

  MonOut = record               { Record for DosMonWrite / DosMonReg          }
    cb:       Word;             { Size of this structure                      }
    Reserved: array [0..17] of Byte;    { Reserved                            }
    Buffer:   array [0..107] of Byte;   { Output buffer                       }
  end;

function DosMonClose(MonHandle: Word): ApiRet16;
function DosMonOpen(DevName: PChar; var MonHandle: Word): ApiRet16;
function DosMonRead(InBuf: Pointer; WaitFlag: Word; DataBuf: Pointer; var BytesRead: Word): ApiRet16;
function DosMonReg(MonHandle: Word; InBuf,OutBuf: Pointer; PosCode,Index: Word): ApiRet16;
function DosMonWrite(OutBuf,DataBuf: Pointer; ByteCount: Word): ApiRet16;

{----[ BDCALLS ]----}

{ BidiHotKeys in BIDISTRUCT                                                }
{ The following defined value may be used to Enable/Disable the Bidi       }
{ keyboard hot keys.                                                       }
{ To enable a hot key, perform an 'OR' operation on the Bidi hot key flag  }
{ word in the KBVCBTYPE  structure with the required defined value.        }
{ To disable a hot key, perform an 'AND NOT' operation on the Bidi hot key }
{ flag word in the KBVCBTYPE  structure with the required defined value.   }
const
  bdhkflag_Push                 = $0004;
  bdhkflag_End_Push             = $0008;
  bdhkflag_Auto_Push            = $0010;
  bdhkflag_Field_Rev            = $0020;
  bdhkflag_Screen_Rev           = $0040;
  bdhkflag_Bidi_Popup           = $0200;
  bdhkflag_Automatic            = $0400;
  bdhkflag_Initial              = $0800;
  bdhkflag_Middle               = $1000;
  bdhkflag_Final                = $2000;
  bdhkflag_Isolated             = $4000;
{ Bidi Flags in BIDISTRUCT                                                 }
{ The following defined value may be used to Enable/Disable the Bidi       }
{ functions.                                                               }
{ To enable a Bidi function, perform an 'OR' operation on the Bidi flags   }
{ word in the BDKBVCB  structure with the required defined value.          }
{ To disable a Bidi fuction, perform an 'AND NOT' operation on the Bidi    }
{ flags word in the BDKBVCB  structure with the required defined value.    }
  bdflag_AutoPush_Rtl           = $0001;
  bdflag_AutoPush_Ltr           = $0002;
  bdflag_PushLevel              = $0004;
  bdflag_Layer                  = $0010;
  bdflag_Field_Rev              = $0020;
{ CSD in BIDIATT                                                           }
{ The following defined value may be used to select the specified          }
{ bit in the Bidi Attributes.                                              }
  bdcsd_Automatic               = $00000000;
  bdcsd_PassThru                = $00000001;
  bdcsd_Base                    = $00000010;
  bdcsd_Initial                 = $00000011;
  bdcsd_Middle                  = $00000012;
  bdcsd_Final                   = $00000013;
  bdcsd_Isolated                = $00000014;
  bdnum_Arabic                  = $00000000;
  bdnum_PassThru                = $00001000;
  bdnum_Hindu                   = $00002000;
  bdorient_Ltr                  = $00000000;
  bdorient_Rtl                  = $00010000;
  bd_Level                      = $30000000;
  bd_Support                    = $00000000;

{ The keyboard control block structure }
type
  BdKvCb = record
    BDLength:      Word;
    BDVersionId:   Word;
    BDAtts:        ULong;
    Reserved:      ULong;
    BDHotKeyFlags: Word;
    BDFlags:       Word;
    Reserved2:     array [0..63] of Byte;
  end;

{ The printer control block structure }
  BdPrCb = record
    PRLength: Word;
    PRAtts:   ULong;
    Reserved: array [0..13] of Byte;
  end;

{ The Character Shape Determination structure }

  PCSDRec = ^CSDRec;
  CSDRec = record
    RecLength:    ULong;
    Buffer:       Pointer;
    BufferLength: ULong;
    BufferIndex:  ULong;
  end;

  PRetInfo = Pointer;
  PSetInfo = Pointer;

function NlsQueryBidiAtt(Effect: Long; RetInfo: PRetInfo): ApiRet16;
function NlsSetBidiAtt(Effect: Long; SetInfo: PSetInfo): ApiRet16;
function NlsShapeBidiString(BidiAtts,Reserved: ULong; Src,Target: PChar; Length,Increment: ULong): ApiRet16;
function NlsEditShape(BidiAtts: ULong; Effect: Long; var Src,Target: CSDRec; var CSDState: ULong; Increment: ULong): ApiRet16;
function NlsInverseString(Src,Target: PChar; Length,Increment: ULong): ApiRet16;
function NlsConvertBidiNumerics(BidiAtts: ULong; Reserved: Long; Src,Tagret: PChar; Length,Increment: ULong): ApiRet16;
function NlsSetBidiPrint(BidiAtts,Length: ULong; FileHandle: Word): ApiRet16;
function NlsConvertBidiString(Src,Target: PChar; Length,Increment,SBidiAtts,TBidiAtts,Reserved: ULong): ApiRet16;

{----[ DOSCALLS ]----}

{$Cdecl+}

{ General services }
function DosBeep(Freq,Dur: Longint): ApiRet;

{ Process and Thread support }
function DosExit(Action,Result: Longint): ApiRet;

{ DosExit codes }
const
  exit_Thread                   = 0;
  exit_Process                  = 1;

type
  PFnThread = ^FnThread;
  FnThread  = function(P: ULong): ApiRet;

  PTib2 = ^Tib2;                        { Thread Information Block (TIB)      }
  Tib2  = record                        { System specific portion             }
    Tib2_ulTid:           ULong;        { Thread I.D.                         }
    Tib2_ulPri:           ULong;        { Thread priority                     }
    Tib2_Version:         ULong;        { Version number for this structure   }
    Tib2_usMCCount:       Word;         { Must Complete count                 }
    Tib2_fMCForceFlag:    Word;         { Must Complete force flag            }
  end;

  PTib = ^Tib;
  Tib  = record                         { TIB Thread Information Block        }
    Tib_PExchain:         Pointer;      { Head of exception handler chain     }
    Tib_PStack:           Pointer;      { Pointer to base of stack            }
    Tib_PStackLimit:      Pointer;      { Pointer to end of stack             }
    Tib_PTib2:            PTib2;        { Pointer to system specific TIB      }
    Tib_Version:          ULong;        { Version number for this TIB structure}
    Tib_Ordinal:          ULong;        { Thread ordinal number               }
  end;

  PPib = ^Pib;
  Pib  = record                         { Process Information Block (PIB)     }
    Pib_ulPid:            ULong;        { Process I.D.                        }
    Pib_ulPPid:           ULong;        { Parent process I.D.                 }
    Pib_hMte:             ULong;        { Program (.EXE) module handle        }
    Pib_pchCmd:           PChar;        { Command line pointer                }
    Pib_pchEnv:           PChar;        { Environment pointer                 }
    Pib_flStatus:         ULong;        { Process' status bits                }
    Pib_ulType:           ULong;        { Process' type code                  }
  end;

function DosCreateThread(var Tid: Tid; pFn: PFnThread; Param,Flag,cbStack: ULong): ApiRet;
function DosResumeThread(Tid: Tid): ApiRet;
function DosSuspendThread(Tid: Tid): ApiRet;
function DosGetInfoBlocks(var Tib: PTib; var TPib: PPib): ApiRet;
function DosKillThread(TTid: Tid): ApiRet;

{ Action code values }
const
  dcwa_Process                  = 0;
  dcwa_ProcessTree              = 1;

{ Wait option values }
  dcww_Wait                     = 0;
  dcww_NoWait                   = 1;

type
  PResultCodes = ^ResultCodes;
  ResultCodes = record
    codeTerminate: ULong;
    codeResult:    ULong;
  end;

function DosWaitChild(Action,Option: ULong; var Result: ResultCodes; var RetPID: Pid; Pid: Pid): ApiRet;
function DosWaitThread(var Tid: Tid; Option: ULong): ApiRet;
function DosSleep(MSec: ULong): ApiRet;

{ Buffer for DosDebug }
type
  PDebug_Buffer = ^Debug_Buffer;
  Debug_Buffer = record
   Pid:    Longint;     {  Debuggee Process ID        }
   Tid:    Longint;     {  Debuggee Thread ID         }
   Cmd:    Longint;     {  Command or Notification    }
   Value:  Longint;     {  Generic Data Value         }
   Addr:   Longint;     {  Debuggee Address           }
   Buffer: Longint;     {  Debugger Buffer Address    }
   Len:    Longint;     {  Length of Range            }
   Index:  Longint;     {  Generic Identifier Index   }
   MTE:    Longint;     {  Module Handle              }
   EAX:    Longint;     {  Register Set               }
   ECX:    Longint;
   EDX:    Longint;
   EBX:    Longint;
   ESP:    Longint;
   EBP:    Longint;
   ESI:    Longint;
   EDI:    Longint;
   EFlags: Longint;
   EIP:    Longint;
   CSLim:  Longint;     {  Byte Granular Limits }
   CSBase: Longint;     {  Byte Granular Base   }
   CSAcc:  Byte;        {  Access Rights        }
   CSAtr:  Byte;        {  Attributes           }
   CS:     Word;
   DSLim:  Longint;
   DSBase: Longint;
   DSAcc:  Byte;
   DSAtr:  Byte;
   DS:     Word;
   ESLim:  Longint;
   ESBase: Longint;
   ESAcc:  Byte;
   ESAtr:  Byte;
   ES:     Word;
   FSLim:  Longint;
   FSBase: Longint;
   FSAcc:  Byte;
   FSAtr:  Byte;
   FS:     Word;
   GSLim:  Longint;
   GSBase: Longint;
   GSAcc:  Byte;
   GSAtr:  Byte;
   GS:     Word;
   SSLim:  Longint;
   SSBase: Longint;
   SSAcc:  Byte;
   SSAtr:  Byte;
   SS:     Word;
  end;

{ DosDebug Commands }
const
  dbg_c_Null                    = 0;
  dbg_c_ReadMem                 = 1;
  dbg_c_ReadReg                 = 3;
  dbg_c_WriteMem                = 4;
  dbg_c_WriteReg                = 6;
  dbg_c_Go                      = 7;
  dbg_c_Term                    = 8;
  dbg_c_SStep                   = 9;
  dbg_c_Stop                    = 10;
  dbg_c_Freeze                  = 11;
  dbg_c_Resume                  = 12;
  dbg_c_NumToAddr               = 13;
  dbg_c_ReadCoRegs              = 14;
  dbg_c_WriteCoRegs             = 15;
  dbg_c_ThrdStat                = 17;
  dbg_c_MapROAlias              = 18;
  dbg_c_MapRWAlias              = 19;
  dbg_c_UnMapAlias              = 20;
  dbg_c_Connect                 = 21;
  dbg_c_ReadMemBuf              = 22;
  dbg_c_WriteMemBuf             = 23;
  dbg_c_SetWatch                = 24;
  dbg_c_ClearWatch              = 25;
  dbg_c_RangeStep               = 26;
  dbg_c_Continue                = 27;
  dbg_c_AddrToObject            = 28;
  dbg_c_XchngOpcode             = 29;
  dbg_c_LinToSel                = 30;
  dbg_c_SelToLin                = 31;

{ DosDebug Notifications }
  dbg_n_Success                 =  0;
  dbg_n_Error                   = -1;
  dbg_n_ProcTerm                = -6;
  dbg_n_Exception               = -7;
  dbg_n_ModuleLoad              = -8;
  dbg_n_CoError                 = -9;
  dbg_n_ThreadTerm              = -10;
  dbg_n_AsyncStop               = -11;
  dbg_n_NewProc                 = -12;
  dbg_n_AliasFree               = -13;
  dbg_n_Watchpoint              = -14;
  dbg_n_ThreadCreate            = -15;
  dbg_n_ModuleFree              = -16;
  dbg_n_RangeStep               = -17;
{ Object flags }
  dbg_o_ObjMte                  = $10000000;
{ Watchpoint Scopes }
  dbg_w_Global                  = $00000001;
  dbg_w_Local                   = $00000002;
{ Watchpoint types }
  dbg_w_Execute                 = $00010000;
  dbg_w_Write                   = $00020000;
  dbg_w_ReadWrite               = $00030000;
{ Thread debugging state }
  dbg_d_Thawed                  = 0;
  dbg_d_Frozen                  = 1;
{ Thread scheduling state }
  dbg_t_Runnable                = 0;
  dbg_t_Suspended               = 1;
  dbg_t_Blocked                 = 2;
  dbg_t_CritSec                 = 3;
{ DosDebug debugging level }
  dbg_l_386                     = 1;
{ Coprocessor type identifier }
  dbg_co_387                    = 1;

function DosDebug(var DbgBuf: Debug_Buffer): ApiRet;

{ codeTerminate values (also passed to ExitList routines) }
const
  tc_Exit                       = 0;
  tc_HardError                  = 1;
  tc_Trap                       = 2;
  tc_KillProcess                = 3;
  tc_Exception                  = 4;

type
  FnExitList = procedure(Parm: ULong);

function DosEnterCritSec: ApiRet;
function DosExitCritSec:  ApiRet;
function DosExitList(OrderCode: ULong; ExitFn: FnExitList): ApiRet;

{ DosExitList functions }
const
  exlst_Add                     = 1;
  exlst_Remove                  = 2;
  exlst_Exit                    = 3;

function DosExecPgm(ObjName: PChar; cbObjName: Long; ExecFlag: ULong;
  Arg,Env: PChar; var Result: ResultCodes; Name: PChar): ApiRet;

{ DosExecPgm functions }
const
  exec_Sync                     = 0;
  exec_Async                    = 1;
  exec_AsyncResult              = 2;
  exec_Trace                    = 3;
  exec_BackGround               = 4;
  exec_Load                     = 5;
  exec_AsyncResultDb            = 6;

function DosSetPriority(Scope,PrtyClass: ULong; Delta: Long; PorTid: ULong): ApiRet;

{ Priority scopes }
const
  prtys_Process                 = 0;
  prtys_ProcessTree             = 1;
  prtys_Thread                  = 2;

{ Priority classes }
  prtyc_NoChange                = 0;
  prtyc_IdleTime                = 1;
  prtyc_Regular                 = 2;
  prtyc_TimeCritical            = 3;
  prtyc_ForegroundServer        = 4;

{ Priority deltas }
  prtyd_Minimum                 = -31;
  prtyd_Maximum                 = +31;

function DosKillProcess(Action: ULong; Pid: Pid): ApiRet;

const
  dkp_ProcessTree               = 0;
  dkp_Process                   = 1;

{*** File manager ***}

{ DosSetFilePtr file position codes }
  file_Begin                    = $0000; { Move relative to beginning of = file }
  file_Current                  = $0001; { Move relative to current fptr = position }
  file_End                      = $0002; { Move relative to end of = file }

{ DosFindFirst/Next Directory handle types }
  hdir_System                   =  1;    { Use system handle (= 1)         }
  hdir_Create                   = -1;    { Allocate a new, unused = handle }

{ DosCopy control bits; may be or'ed together }
  dcpy_Existing                 = $0001; { Copy even if target = exists }
  dcpy_Append                   = $0002; { Append to existing file, do not = replace }
  dcpy_FailEas                  = $0004; { Fail if EAs not supported on = target }

{ DosOpen/DosQFHandState/DosQueryFileInfo et al file attributes; also }
{ known as Dos File Mode bits... }
  file_Normal                   = $0000;
  file_ReadOnly                 = $0001;
  file_Hidden                   = $0002;
  file_System                   = $0004;
  file_Directory                = $0010;
  file_Archived                 = $0020;
  file_Ignore                   = $10000;       { ignore file attribute = in }
                                                { DosSetPath/File Info if    }
                                                { this bit is set            }

  must_have_ReadOnly    = (file_ReadOnly  shl 8) or file_ReadOnly;
  must_have_Hidden      = (file_Hidden    shl 8) or file_Hidden;
  must_have_System      = (file_System    shl 8) or file_System;
  must_have_Directory   = (file_Directory shl 8) or file_Directory;
  must_have_Archived    = (file_Archived  shl 8) or file_Archived;

{ DosOpen actions }
  file_Existed                  = $0001;
  file_Created                  = $0002;
  file_Truncated                = $0003;

{ DosOpen open flags }
  file_Open                     = $0001;
  file_Truncate                 = $0002;
  file_Create                   = $0010;

{ This nibble applies if file already exists              xxxx }
  open_action_Fail_If_Exists    = $0000; { ---- ---- ---- 0000 }
  open_action_Open_If_Exists    = $0001; { ---- ---- ---- 0001 }
  open_action_Replace_If_Exists = $0002; { ---- ---- ---- 0010 }

{ This nibble applies if file does not exist         xxxx      }
  open_action_Fail_If_New       = $0000; { ---- ---- 0000 ---- }
  open_action_Create_If_New     = $0010; { ---- ---- 0001 ---- }

{ DosOpen/DosSetFHandState flags }
  open_access_ReadOnly          = $0000; { ---- ---- ---- -000 }
  open_access_WriteOnly         = $0001; { ---- ---- ---- -001 }
  open_access_ReadWrite         = $0002; { ---- ---- ---- -010 }
  open_share_DenyReadWrite      = $0010; { ---- ---- -001 ---- }
  open_share_DenyWrite          = $0020; { ---- ---- -010 ---- }
  open_share_DenyRead           = $0030; { ---- ---- -011 ---- }
  open_share_DenyNone           = $0040; { ---- ---- -100 ---- }
  open_flags_NoInherit          = $0080; { ---- ---- 1--- ---- }
  open_flags_No_Locality        = $0000; { ---- -000 ---- ---- }
  open_flags_Sequential         = $0100; { ---- -001 ---- ---- }
  open_flags_Random             = $0200; { ---- -010 ---- ---- }
  open_flags_RandomSequential   = $0300; { ---- -011 ---- ---- }
  open_flags_No_Cache           = $1000; { ---1 ---- ---- ---- }
  open_flags_Fail_On_Error      = $2000; { --1- ---- ---- ---- }
  open_flags_Write_Through      = $4000; { -1-- ---- ---- ---- }
  open_flags_Dasd               = $8000; { 1--- ---- ---- ---- }
  open_flags_NonSpooled         = $00040000;

  search_Path                   = $0000;
  search_Cur_Directory          = $0001;
  search_Environment            = $0002;
  search_IgnoreNetErrs          = $0004;

{
  EA Info Levels & Find First/Next
  API's: DosFindFirst, DosQueryFileInfo, DosQueryPathInfo, DosSetFileInfo,
          DosSetPathInfo
}

{ File info levels&gml All listed API's }
  fil_Standard                  = 1;    { Info level 1, standard file info }
  fil_QueryEaSize               = 2;    { Level 2, return Full EA size     }
  fil_QueryEasFromlLst          = 3;    { Level 3, return requested EA's   }

{ File info levels: Dos...PathInfo only }
  fil_QueryFullName             = 5;    { Level 5, return fully qualified name of file }
{ DosFsAttach: Attact or detach }
  fs_Attach                     = 0;    { Attach file server }
  fs_Detach                     = 1;    { Detach file server }
  fs_SpoolAttach                = 2;    { Register a spooler device }
  fs_SpoolDetach                = 3;    { De-register a spooler device }

{ DosFsCtl: Routing type }
  fsctl_Handle                  = 1;    { File Handle directs req routing }
  fsctl_PathName                = 2;    { Path Name directs req routing }
  fsctl_FsdName                 = 3;    { FSD Name directs req routing }

{ defined FSCTL functions }
  fsctl_Error_Info              = 1;    { return error info from FSD }
  fsctl_Max_EaSize              = 2;    { Max ea size for the FSD }

type
  PEaSizeBuf = ^EaSizeBuf;
  EaSizeBuf = record                    { Record for FSCTL fn 2 - max ea size }
    cbMaxEASize:     Word;              { max. size of one EA }
    cbMaxEAListSize: ULong;             { max size of the full EA List }
  end;

{ DosQueryFSAttach: Information level types (defines method of query) }
const
  fsail_QueryName               = 1;    { Return data for a Drive or Device }
  fsail_DevNumber               = 2;    { Return data for Ordinal Device # }
  fsail_DrvNumber               = 3;    { Return data for Ordinal Drive # }

{ Item types (from data structure item "iType") }
  fsat_CharDev                  = 1;    { Resident character device }
  fsat_PseudoDev                = 2;    { Pusedu-character device }
  fsat_LocalDrv                 = 3;    { Local drive }
  fsat_RemoteDrv                = 4;    { Remote drive attached to FSD }

type
  PFsqBuffer = ^FsqBuffer;
  FsqBuffer = record                    { fsqbuf Data structure for QFSAttach}
    iType:        Word;                 { Item type }
    cbName:       Word;                 { Length of item name, sans NULL }
    szName:    array [0..0] of Char;    { ASCIIZ item name }
    cbFSDName:    Word;                 { Length of FSD name, sans NULL }
    szFSDName: array [0..0] of Char;    { ASCIIZ FSD name }
    cbFSAData:    Word;                 { Length of FSD Attach data returned }
    rgFSAData: array [0..0] of Byte;    { FSD Attach data from FSD }
  end;

  PFsqBuffer2 = ^FsqBuffer2;            { fsqbuf Data structure for QFSAttach}
  FsqBuffer2 = record
    iType:        Word;
    cbName:       Word;
    cbFSDName:    Word;
    cbFSAData:    Word;
    szName:    array [0..0] of Char;
    szFSDName: array [0..0] of Char;
    rgFSAData: array [0..0] of Byte;
  end;

  PSpoolAttach = ^SpoolAttach;  { Data structure for spooler operations }
  SpoolAttach = record
    hNmPipe: Word;              { Named pipe handle }
    ulKey:   ULong;             { Attached key }
  end;

{ File System Drive Information&gml DosQueryFSInfo DosSetFSInfo }
{ FS Drive Info Levels }
const
  fsil_Alloc                    = 1;    { Drive allocation info (Query only) }
  fsil_VolSer                   = 2;    { Drive Volum/Serial info }

{ DosQueryFHType: Handle classes (low 8 bits of Handle Type) }
  fht_DiskFile                  = $0000;  { Disk file handle }
  fht_ChrDev                    = $0001;  { Character device handle }
  fht_Pipe                      = $0002;  { Pipe handle }

{ Handle bits (high 8 bits of Handle Type)}
  fhb_DskRemote                 = $8000;  { Remote disk }
  fhb_ChrDevRemote              = $8000;  { Remote character device }
  fhb_PipeRemote                = $8000;  { Remote pipe }

{ File time and date types }
(*
      typedef struct _FTIME
              {
              UINT   twosecs : 5;
              UINT   minutes : 6;
              UINT   hours   : 5;
              } FTIME;
*)

type
  PFTime = ^FTime;
  FTime = Word;

const
  mftTwoSecs                    = $001F;
  sftTwoSecs                    = 0;
  mftMinutes                    = $07E0;
  sftMinutes                    = 5;
  mftHours                      = $F800;
  sftHours                      = 11;

(*    typedef struct _FDATE
              {
              UINT   day     : 5;
              UINT   month   : 4;
              UINT   year    : 7;
              } FDATE;
*)

type
  PFDate = ^FDate;
  FDate = Word;

const
  mfdDay                        = $001F;
  sfdDay                        = 0;
  mfdMonth                      = $01E0;
  sfdMonth                      = 5;
  mfdYear                       = $FE00;
  sfdYear                       = 9;

type
  PVolumeLabel = ^VolumeLabel;
  VolumeLabel = String[12];

  PFsInfo = ^FsInfo;
  FsInfo = record
    fdateCreation:  FDate;
    ftimeCreation:  FTime;
    vol:            VolumeLabel;
  end;

{ HandType values }
const
  handtype_File                 = $0000;
  handtype_Device               = $0001;
  handtype_Pipe                 = $0002;
  handtype_Network              = $8000;

type
  PFileLock = ^FileLock;
  FileLock = record
    lOffset: Long;
    lRange:  Long;
  end;

  PHFile = ^HFile;
  HFile  = LHandle;
  PHEv   = ^HEv;
  HEv    = ULong;

function DosSetFileLocks(F: HFile; var UnLock,Lock: FileLock; TimeOut,Flags: ULong): ApiRet;
function DosCancelLockRequest(F: HFile; var Lock: FileLock): ApiRet;

type
  PFileFindBuf = ^FileFindBuf;
  FileFindBuf = record
    fdateCreation:   FDate;
    ftimeCreation:   FTime;
    fdateLastAccess: FDate;
    ftimeLastAccess: FTime;
    fdateLastWrite:  FDate;
    ftimeLastWrite:  FTime;
    cbFile:          ULong;
    cbFileAlloc:     ULong;
    attrFile:        Word;
    achName:         String[cchMaxPathComp-1];
  end;

  PFileFindBuf2 = ^FileFindBuf2;
  FileFindBuf2 = record
    fdateCreation:   FDate;
    ftimeCreation:   FTime;
    fdateLastAccess: FDate;
    ftimeLastAccess: FTime;
    fdateLastWrite:  FDate;
    ftimeLastWrite:  FTime;
    cbFile:          ULong;
    cbFileAlloc:     ULong;
    attrFile:        Word;
    cbList:          ULong;
    achName:         String[cchMaxPathComp-1];
  end;

  PFileFindBuf3 = ^FileFindBuf3;
  FileFindBuf3 = record
    oNextEntryOffset: ULong;    { new field }
    fdateCreation:    FDate;
    ftimeCreation:    FTime;
    fdateLastAccess:  FDate;
    ftimeLastAccess:  FTime;
    fdateLastWrite:   FDate;
    ftimeLastWrite:   FTime;
    cbFile:           ULong;
    cbFileAlloc:      ULong;
    attrFile:         ULong;    { widened field }
    achName:          String[cchMaxPathComp-1];
  end;

  PFileFindBuf4 = ^FileFindBuf4;
  FileFindBuf4 = record
    oNextEntryOffset: ULong;    { new field }
    fdateCreation:    FDate;
    ftimeCreation:    FTime;
    fdateLastAccess:  FDate;
    ftimeLastAccess:  FTime;
    fdateLastWrite:   FDate;
    ftimeLastWrite:   FTime;
    cbFile:           ULong;
    cbFileAlloc:      ULong;
    attrFile:         ULong;    { widened field }
    cbList:           ULong;
    achName:          String[cchMaxPathComp-1];
  end;

{ extended attribute structures }
  PGea  = ^Gea;
  Gea = record
    cbName: Byte;                 { name length not including NULL }
    szName: array [0..0] of Char; { attribute name }
  end;

  PGeaList = ^GeaList;
  GeaList = record
    cbList: ULong;              { total bytes of structure including full list }
    list: array[0..0] of Gea;   { variable length GEA structures }
  end;

  PFea = ^Fea;
  Fea = record
    fEA:     Byte;               { flags }
    cbName:  Byte;               { name length not including NULL }
    cbValue: Word;               { value length }
  end;

{ flags for _FEA.fEA }
const
  fea_NeedEA                    = $80;  { need EA bit }

type
  PFeaList = ^FeaList;
  FeaList = record
    cbList:  ULong;             { total bytes of structure including full list }
    list: array [0..0] of Fea;  { variable length FEA structures }
  end;

  PEaop = ^Eaop;
  Eaop = record
    fpGEAList: PGeaList;        { general EA list }
    fpFEAList: PGeaList;        { full EA list }
    oError:    ULong;
  end;

  PFea2 = ^Fea2;
  Fea2 = record
    oNextEntryOffset: ULong;    { new field }
    fEA:              Byte;
    cbName:           Byte;
    cbValue:          Word;
    szName:           Char;     { new field }
  end;

  PFea2List = ^Fea2List;
  Fea2List = record
    cbList:           ULong;
    list: array [0..0] of Fea2;
  end;

  PGea2 = ^Gea2;
  Gea2 = record
    oNextEntryOffset: ULong;      { new field }
    cbName:           Byte;
    szName: array [0..0] of Char;
  end;

  PGea2List = ^Gea2List;
  Gea2List = record
    cbList: ULong;
    list: array[0..0] of Gea2;
  end;

  PEaop2 = ^Eaop2;
  Eaop2 = record
    fpGEA2List: PGeaList;       { GEA set }
    fpFEA2List: PGeaList;       { FEA set }
    oError:    ULong;           { offset of FEA error }
  end;

{ Constants for the types of EAs that follow the convention that we have established
  Values $FFFE thru $8000 are reserved.
  Values $0000 thru $7FFF are user definable.
  Value  $FFFC is not used
}
const
  eat_Binary                    = $FFFE;     { length preceeded binary }
  eat_Ascii                     = $FFFD;     { length preceeded ASCII }
  eat_BitMap                    = $FFFB;     { length preceeded bitmap }
  eat_MetaFile                  = $FFFA;     { length preceeded metafile }
  eat_Icon                      = $FFF9;     { length preceeded icon }
  eat_Ea                        = $FFEE;     { length preceeded ASCII }
                                             { name of associated data }
  eat_Mvmt                      = $FFDF;     { multi-valued, multi-typed field }
  eat_Mvst                      = $FFDE;     { multi-valued, single-typed field }
  eat_Asn1                      = $FFDD;     { ASN.1 field }

function DosOpen(FileName: PChar; var F: HFile; var Action: ULong;
  cbFile,Attribute,OpenFlags,OpenMode: ULong; EAs: PEaop2): ApiRet;
function DosClose(F: HFile): ApiRet;
function DosRead(F: HFile; var Buffer; cbRead: ULong; var Actual: ULong): ApiRet;
function DosWrite(F: HFile; const Buffer; cbWrite: ULong; var Actual: ULong): ApiRet;

{ File time and date types }
type
  PFileStatus = ^FileStatus;
  FileStatus = record
    fdateCreation:   FDate;
    ftimeCreation:   FTime;
    fdateLastAccess: FDate;
    ftimeLastAccess: FTime;
    fdateLastWrite:  FDate;
    ftimeLastWrite:  FTime;
    cbFile:          ULong;
    cbFileAlloc:     ULong;
    attrFile:        Word;
  end;

  PFileStatus2 = ^FileStatus2;
  FileStatus2 = record
    fdateCreation:   FDate;
    ftimeCreation:   FTime;
    fdateLastAccess: FDate;
    ftimeLastAccess: FTime;
    fdateLastWrite:  FDate;
    ftimeLastWrite:  FTime;
    cbFile:          ULong;
    cbFileAlloc:     ULong;
    attrFile:        Word;
    cbList:          ULong;
  end;

  PFileStatus3 = ^FileStatus3;
  FileStatus3 = record
    fdateCreation:   FDate;
    ftimeCreation:   FTime;
    fdateLastAccess: FDate;
    ftimeLastAccess: FTime;
    fdateLastWrite:  FDate;
    ftimeLastWrite:  FTime;
    cbFile:          ULong;
    cbFileAlloc:     ULong;
    attrFile:        ULong;
  end;

  PFileStatus4 = ^FileStatus4;
  FileStatus4 = record
    fdateCreation:   FDate;
    ftimeCreation:   FTime;
    fdateLastAccess: FDate;
    ftimeLastAccess: FTime;
    fdateLastWrite:  FDate;
    ftimeLastWrite:  FTime;
    cbFile:          ULong;
    cbFileAlloc:     ULong;
    attrFile:        ULong;
    cbList:          ULong;
  end;

  PFsAllocate = ^FsAllocate;
  FsAllocate = record
    idFileSystem: ULong;
    cSectorUnit:  ULong;
    cUnit:        ULong;
    cUnitAvail:   ULong;
    cbSector:     Word;
  end;

  PHDir = ^HDir;
  HDir = LHandle;

function DosDelete(FName: PChar): ApiRet;
function DosForceDelete(FName: PChar): ApiRet;
function DosDupHandle(OldHandle: HFile; var NewHandle: HFile): ApiRet;
function DosQueryFHState(F: HFile; var Mode: ULong): ApiRet;
function DosSetFHState(F: HFile; Mode: ULong): ApiRet;
function DosQueryHType(F: HFile; var pType,pAttr: ULong): ApiRet;
function DosFindFirst(FileSpec: PChar; var Dir: HDir; Attribute: ULong;
  var FindBuf; BufSize: ULong; var SearchCount: ULong; InfoLevel: ULong): ApiRet;
function DosFindNext(Dir: HDir; var FindBuf; BufSize: ULong; var SearchCount: ULong): ApiRet;
function DosFindClose(Dir: HDir): ApiRet;
function DosFSAttach(Device,FileSystem: PChar; pDate: Pointer; cbData,Flag: ULong): ApiRet;
function DosQueryFSAttach(DeviceName: PChar; Ordinal,FSAInfoLevel: ULong;
  var fsqb: FsqBuffer2; var BufLen: ULong): ApiRet;
function DosFSCtl(pData: Pointer; cbData: ULong; var pcbData: PULong;
  pParms: Pointer; var cbParms: ULong; Func: ULong; Route: PChar; F: HFile;
  Method: ULong): ApiRet;
function DosSetFileSize(F: HFile; Size: ULong): ApiRet;
function DosResetBuffer(F: HFile): ApiRet;
function DosSetFilePtr(F: HFile; Distance: Long; Method: ULong; var Actual: ULong): ApiRet;
function DosMove(OldName,NewName: PChar): ApiRet;
function DosCopy(OldName,NewName: PChar; Option: ULong): ApiRet;
function DosEditName(MetaLevel: ULong; Source,Edit: PChar; Target: PChar; cbTarget: ULong): ApiRet;
function DosCreateDir(DirName: PChar; Eas: PEaop2): ApiRet;
function DosDeleteDir(Dir: PChar): ApiRet;
function DosSetDefaultDisk(DiskNum: ULong): ApiRet;
function DosQueryCurrentDisk(var DiskNum,Logical: ULong): ApiRet;
function DosSetCurrentDir(Dir: PChar): ApiRet;
function DosQueryCurrentDir(DiskNum: ULong; var Buf; var BufSize: ULong): ApiRet;
function DosQueryFSInfo(DiskNum,InfoLevel: ULong; var Buf; BufSize: ULong): ApiRet;
function DosSetFSInfo(DiskNum,InfoLevel: ULong; var Buf; BufSize: ULong): ApiRet;
function DosQueryVerify(var Flag: Bool): ApiRet;
function DosSetVerify(Flag: Bool): ApiRet;
function DosSetMaxFH(cFH: ULong): ApiRet;
function DosSetRelMaxFH(var cbReqCount,cbCurMaxFH: Long): ApiRet;
function DosQueryFileInfo(F: HFile; InfoLevel: ULong; var InfoBuf;
  cbInfoBuf: ULong): ApiRet;
function DosSetFileInfo(F: HFile; InfoLevel: ULong; var InfoBuf;
  cbInfoBuf: ULong): ApiRet;
function DosQueryPathInfo(PathName: PChar; InfoLevel: ULong; var InfoBuf;
  cbInfoBuf: ULong): ApiRet;
function DosSetPathInfo(PathName: PChar; InfoLevel: ULong; var InfoBuf;
  cbInfoBuf,Options: ULong): ApiRet;

{ Constant for DosSetPathInfo: pathinfo flag }
const
  dspi_WrtThru                  = $10;  { write through }

function DosShutdown(Reserved: ULong): ApiRet;
function DosEnumAttribute(RefType: ULong; pvFile: Pointer; Entry: ULong;
  var pvBuf; cbBuf: ULong; var Count: PULong; InfoLevel: ULong): ApiRet;

type
  PDena1 = ^Dena1;
  Dena1 = record        { dena1 level 1 info returned from DosEnumAttribute }
    reserved:   Byte;              { 0 }
    cbName:     Byte;              { length of name exculding NULL }
    cbValue:    Word;              { length of value }
    szName: array [0..0] of Char;  { variable length asciiz name }
  end;

{ Infolevels for DosEnumAttribute  }
const
  enumea_Level_No_Value         = 1;     { FEA without value }
{ Reference types for DosEnumAttribute }
  enumea_Reftype_FHandle        = 0;      { file handle }
  enumea_Reftype_Path           = 1;      { path name }
  enumea_Reftype_Max            = enumea_Reftype_Path;

{ Memory management }

function DosAllocMem(var Base: Pointer; MemSize,Flags: ULong): ApiRet;
function DosFreeMem(Base: Pointer): ApiRet;
function DosSetMem(Base: Pointer; MemSize,Flags: ULong): ApiRet;
function DosGiveSharedMem(Base: Pointer; Pid: Pid; Flags: ULong): ApiRet;
function DosGetSharedMem(Base: Pointer; Flags: ULong): ApiRet;
function DosGetNamedSharedMem(var Base: Pointer; Name: PChar; Flags: ULong): ApiRet;
function DosAllocSharedMem(var Base: Pointer; Name: PChar; MemSize,Flags: ULong): ApiRet;
function DosQueryMem(Base: Pointer; var MemSize,Flags: ULong): ApiRet;
function DosSubAllocMem(Base: Pointer; var SubBase: Pointer; MemSize: ULong): ApiRet;
function DosSubFreeMem(Base,SubBase: Pointer; MemSize: ULong): ApiRet;
function DosSubSetMem(Base: Pointer; Flag,MemSize: ULong): ApiRet;
function DosSubUnsetMem(Base: Pointer): ApiRet;

{*** Memory flags ***}
{ Access protection  }
const
  pag_Read                      = $00000001;    { read access              }
  pag_Write                     = $00000002;    { write access             }
  pag_Execute                   = $00000004;    { execute access           }
  pag_Guard                     = $00000008;    { guard protection         }
  pag_Default                   = $00000400;    { default (initial) access }
 { Commit }
  pag_Commit                    = $00000010;    { commit storage           }
  pag_Decommit                  = $00000020;    { decommit storage         }
 { Allocation attributes }
  obj_Tile                      = $00000040;    { tile object              }
  obj_Protected                 = $00000080;    { protect object;
                         NOTE: This flag is NOT available at the API level }
  obj_Gettable                  = $00000100;    { gettable by other processes}
  obj_Giveable                  = $00000200;    { giveable to other processes}
  fPerm                         = pag_Execute or pag_Read or pag_Write;
  fShare                        = obj_Gettable or obj_Giveable;
 { DosAllocMem flags }
  fAlloc                        = obj_Tile or pag_Commit or fPerm;
 { DosAllocSharedMem flags }
  fAllocShr                     = obj_Tile or pag_Commit or fShare or fPerm;
 { DosGetNamedSharedMem flags }
  fGetNmShr                     = fPerm;
 { DosGetSharedMem flags }
  fGetShr                       = fPerm;
 { DosGiveSharedMem flags }
  fGiveShr                      = fPerm;
 { DosSetMem flags }
  fSet                          = pag_Commit + pag_Decommit + pag_Default + fPerm;
 { DosSubSet flags }
  dossub_Init                   = $01;  { initialize memory object for suballocation }
  dossub_Grow                   = $02;  { increase size of memory pool for suballocation }
  dossub_Sparse_Obj             = $04;  { indicator for DosSub to manage the
                                          commitment of pages spanned by the memory pool }
  dossub_Serialize              = $08;  { indicates that access to the memory }
                                        { pool is to be serialized by DosSub  }
 { Allocation type (returned from DosQueryMem)                                }
  pag_Shared                    = $00002000;    { shared object        }
  pag_Free                      = $00004000;    { pages are free       }
  pag_Base                      = $00010000;    { first page in object }

{*** Semaphore Support ***}
{ Semaphore Attributes }

  dc_Sem_Shared                 = $01;  { DosCreateMutex, DosCreateEvent, and     }
                                        {   DosCreateMuxWait use it to indicate   }
                                        {   whether the semaphore is shared or    }
                                        {   private when the PSZ is null          }
  dcmw_Wait_Any                 = $02;  { DosCreateMuxWait option for wait on any }
                                        {   event/mutex to occur                  }
  dcmw_Wait_All                 = $04;  { DosCreateMuxWait option for wait on all }
                                        {   events/mutexs to occur                }

  sem_Indefinite_Wait           = -1;
  sem_Immediate_Return          =  0;

type
  PHSem = ^HSem;
  HSem = Pointer;

  PSemRecord = ^SemRecord;
  SemRecord = record
    hsemCur: HSem;
    ulUser:  ULong;
  end;

  PHMtx = ^HMtx;
  HMtx  = ULong;
  PHMux = ^HMux;
  HMux  = ULong;

function DosCreateEventSem(Name: PChar; var EvSem: HEv; Attr: ULong; State: Bool): ApiRet;
function DosOpenEventSem(Name: PChar; var EvSem: HEv): ApiRet;
function DosCloseEventSem(EvSem: HEv): ApiRet;
function DosResetEventSem(EvSem: HEv; var PostCount: ULong): ApiRet;
function DosPostEventSem(EvSem: HEv): ApiRet;
function DosWaitEventSem(EvSem: HEv; Timeout: ULong): ApiRet;
function DosQueryEventSem(EvSem: HEv; var PosCount: ULong): ApiRet;
function DosCreateMutexSem(Name: PChar; var Mtx: HMtx; Attr: ULong; State: Bool): ApiRet;
function DosOpenMutexSem(Name: PChar; var Mtx: HMtx): ApiRet;
function DosCloseMutexSem(Mtx: HMtx): ApiRet;
function DosRequestMutexSem(Mxt: HMtx; Timeout: ULong): ApiRet;
function DosReleaseMutexSem(Mtx: HMtx): ApiRet;
function DosQueryMutexSem(Mtx: HMtx; var Pid: Pid; var Tid: Tid; var Count: ULong): ApiRet;
function DosCreateMuxWaitSem(Name: PChar; var Mux: HMux; cSemRec: ULong; var SemRec: SemRecord; Attr: ULong): ApiRet;
function DosOpenMuxWaitSem(Name: PChar; var Mux: HMux): ApiRet;
function DosCloseMuxWaitSem(Mux: HMux): ApiRet;
function DosWaitMuxWaitSem(Mux: HMux; Timeout: ULong; var User: ULong): ApiRet;
function DosAddMuxWaitSem(Mux: HMux; var SemRec: SemRecord): ApiRet;
function DosDeleteMuxWaitSem(Mux: HMux; Sem: HSem): ApiRet;
function DosQueryMuxWaitSem(Mux: HMux; var cSemRec: ULong; SemRec: SemRecord; var Attr: ULong): ApiRet;

{ Time support }
type
  PDateTime = ^DateTime;
  DateTime = record
    hours:      Byte;
    minutes:    Byte;
    seconds:    Byte;
    hundredths: Byte;
    day:        Byte;
    month:      Byte;
    year:       Word;
    timezone:   Integer;
    weekday:    Byte;
  end;

function DosGetDateTime(var DT: DateTime): ApiRet;
function DosSetDateTime(var DT: DateTime): ApiRet;

type
  PHTimer = ^HTimer;
  HTimer = LHandle;

function DosAsyncTimer(MSec: ULong; Sem: HSem; var Timer: HTimer): ApiRet;
function DosStartTimer(MSec: ULong; Sem: HSem; var Timer: HTimer): ApiRet;
function DosStopTimer(Timer: HTimer): ApiRet;

{ Module manager }

function DosLoadModule(Name: PChar; cbName: ULong; ModName: PChar; var Module: HModule): ApiRet;
function DosFreeModule(Module: HModule): ApiRet;
function DosQueryProcAddr(Module: HModule; Ordinal: ULong; Name: PChar; var EntryAddr: Pointer): ApiRet;
function DosQueryModuleHandle(ModName: PChar; var Module: HModule): ApiRet;
function DosQueryModuleName(Module: HModule; cbName: ULong; Name: PChar): ApiRet;

const
  pt_16Bit                      = 0;
  pt_32Bit                      = 1;

function DosQueryProcType(Module: HModule; Ordinal: ULong; Name: PChar; var ProcType: ULong): ApiRet;

{ Resource support }
{ Predefined resource types }
const
  rt_Pointer                    = 1;  { mouse pointer shape }
  rt_Bitmap                     = 2;  { bitmap }
  rt_Menu                       = 3;  { menu template }
  rt_Dialog                     = 4;  { dialog template }
  rt_String                     = 5;  { string tables }
  rt_FontDir                    = 6;  { font directory }
  rt_Font                       = 7;  { font }
  rt_AccelTable                 = 8;  { accelerator tables }
  rt_RcData                     = 9;  { binary data }
  rt_Message                    = 10; { error msg tables }
  rt_DlgInclude                 = 11; { dialog include file name }
  rt_VKeyTbl                    = 12; { key to vkey tables }
  rt_KeyTbl                     = 13; { key to UGL tables }
  rt_CharTbl                    = 14; { glyph to character tables }
  rt_DisplayInfo                = 15; { screen display information }
  rt_FkaShort                   = 16; { function key area short form }
  rt_FkaLong                    = 17; { function key area Long form }
  rt_HelpTable                  = 18; { Help table for Cary Help manager }
  rt_HelpSubTable               = 19; { Help subtable for Cary Help manager }
  rt_FdDir                      = 20; { DBCS uniq/font driver directory }
  rt_Fd                         = 21; { DBCS uniq/font driver }
  rt_Max                        = 22; { 1st unused Resource Type }
  rf_OrdinalId                  = $80000000; { ordinal id flag in resource table }

function DosGetResource(Module: HModule; IdType,IdName: ULong; var ppb: Pointer): ApiRet;
function DosFreeResource(pb: Pointer): ApiRet;
function DosQueryResourceSize(Module: HModule; IdType,IdName: ULong; var Size: ULong): ApiRet;

{ NLS Support }
type
  PCountryCode = ^CountryCode;
  CountryCode = record
    country:  ULong;
    codepage: ULong;
  end;

  PCountryInfo = ^CountryInfo;
  CountryInfo = record
    country:              ULong;
    codepage:             ULong;
    fsDateFmt:            ULong;
    szCurrency:           array [0..4] of Char;
    szThousandsSeparator: array [0..1] of Char;
    szDecimal:            array [0..1] of Char;
    szDateSeparator:      array [0..1] of Char;
    szTimeSeparator:      array [0..1] of Char;
    fsCurrencyFmt:        Byte;
    cDecimalPlace:        Byte;
    fsTimeFmt:            Byte;
    abReserved1:          array [0..1] of Word;
    szDataSeparator:      array [0..1] of Char;
    abReserved2:          array [0..4] of Word;
  end;

function DosQueryCtryInfo(cb: ULong; var ccode: CountryCode; var pci: CountryInfo; var Actual: ULong): ApiRet;
function DosQueryDBCSEnv(cb: ULong; var ccode: CountryCode; Buf: PChar): ApiRet;
function DosMapCase(cb: ULong; var ccode: CountryCode; pch: PChar): ApiRet;
function DosQueryCollate(cb: ULong; var ccode: CountryCode; pch: PChar; var DataLen: ULong): ApiRet;
function DosQueryCp(cb: ULong; var arCP,pcCP: ULong): ApiRet;
function DosSetProcessCp(cp: ULong): ApiRet;

{ Signal support }
{ DosSetSignalExceptionFocus codes }
const
  sig_UnSetFocus                = 0;
  sig_SetFocus                  = 1;

{*** Exception Management ***}
{ User Exception Handler Return Codes: }
  xcpt_Continue_Search          = $00000000;     { exception not handled   }
  xcpt_Continue_Execution       = $FFFFFFFF;     { exception handled       }
  xcpt_Continue_Stop            = $00716668;     { exception handled by    }
                                                 { debugger (VIA DosDebug) }
{ fHandlerFlags values (see ExceptionReportRecord):
  The user may only set (but not clear) the eh_NonContinuable flag.
  All other flags are set by the system.
}

  eh_NonContinuable             = $01;          { Noncontinuable exception }
  eh_Unwinding                  = $02;          { Unwind is in progress }
  eh_Exit_Unwind                = $04;          { Exit unwind is in progress }
  eh_Stack_Invalid              = $08;          { Stack out of limits or unaligned }
  eh_Nested_Call                = $10;          { Nested exception handler call }

{ Unwind all exception handlers (see DosUnwindException API) }
  unwind_All                    = 0;
{ Exception values are 32 bit values layed out as follows:

  3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
  1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
  +---+-+-------------------------+-------------------------------+
  |Sev|C|       Facility          |               Code            |
  +---+-+-------------------------+-------------------------------+

  where

      Sev - is the severity code
          00 - Success
          01 - Informational
          10 - Warning
          11 - Error

      C - is the Customer code flag

      Facility - is the facility code

      Code - is the facility's status code

  Exceptions specific to OS/2 2.0 (e.g. xcpt_Signal) will be marked
  with a facility code of 1.

  System defined exceptions have a facility code of zero.

  Each exception may also have several pieces of additional information.
  These are stored in the ExceptionInfo fields of the
  ExceptionReportRecord. They are documented here with the exceptions
  only for ease of reference.
 }
  xcpt_Fatal_Exception          = $C0000000;
  xcpt_Severity_Code            = $C0000000;
  xcpt_Customer_Code            = $20000000;
  xcpt_Facility_Code            = $1FFF0000;
  xcpt_Exception_Code           = $0000FFFF;
{ Violation flags in ExceptionInfo }
  xcpt_Unknown_Access           = $00000000;     { Unknown access }
  xcpt_Read_Access              = $00000001;     { Read access    }
  xcpt_Write_Access             = $00000002;     { Write access   }
  xcpt_Execute_Access           = $00000004;     { Execute access }
  xcpt_Space_Access             = $00000008;     { Address space access }
  xcpt_Limit_Access             = $00000010;     { Address space limit violation }
  xcpt_Data_Unknown             = $FFFFFFFF;
{ Signal numbers for xcpt_Signal }
  xcpt_Signal_Intr              = 1;
  xcpt_Signal_KillProc          = 3;
  xcpt_Signal_Break             = 4;
{ Portable non-fatal software generated exceptions }
  xcpt_Guard_Page_Violation     = $80000001;
{ ExceptionInfo[ 0 ] - Access Code: xcpt_Read_Access
                                    xcpt_Write_Access }
{ ExceptionInfo[ 1 ] - FaultAddr }
  xcpt_Unable_To_Grow_Stack     = $80010001;
{ Portable fatal hardware generated exceptions }
  xcpt_DataType_Misalignment    = $C000009E;
{ ExceptionInfo[ 0 ] - Access Code: xcpt_Read_Access
                                    xcpt_Write_Access }
{ ExceptionInfo[ 1 ] - Alignment }
{ ExceptionInfo[ 2 ] - FaultAddr }
  xcpt_Breakpoint               = $C000009F;
  xcpt_Single_Step              = $C00000A0;
  xcpt_Access_Violation         = $C0000005;
{ ExceptionInfo[ 0 ] - Access Code: xcpt_Read_Access
                                    xcpt_Write_Access
                                    xcpt_Space_Access
                                    xcpt_Limit_Access
                                    xcpt_Unknown_Access }
{ ExceptionInfo[ 1 ] - FaultAddr (xcpt_Read_Access/xcpt_Write_Access)
                       Selector  (xcpt_Space_Access)
                         -1      (xcpt_Limit_Access) }
  xcpt_Illegal_Instruction      = $C000001C;
  xcpt_Float_Denormal_Operand   = $C0000094;
  xcpt_Float_Divide_By_Zero     = $C0000095;
  xcpt_Float_Inexact_Result     = $C0000096;
  xcpt_Float_Invalid_Operation  = $C0000097;
  xcpt_Float_Overflow           = $C0000098;
  xcpt_Float_Stack_Check        = $C0000099;
  xcpt_Float_Underflow          = $C000009A;
  xcpt_Integer_Divide_By_Zero   = $C000009B;
  xcpt_Integer_Overflow         = $C000009C;
  xcpt_Privileged_Instruction   = $C000009D;
{  Portable fatal software generated exceptions }
  xcpt_In_Page_Error            = $C0000006;
{ ExceptionInfo[ 0 ] - FaultAddr }
  xcpt_Process_Terminate        = $C0010001;
  xcpt_Async_Process_Terminate  = $C0010002;
{ ExceptionInfo[ 0 ] - TID of 'terminator' thread }
  xcpt_NonContinuable_Exception = $C0000024;
  xcpt_Invalid_Disposition      = $C0000025;
{ Non-portable fatal exceptions }
  xcpt_Invalid_Lock_Sequence    = $C000001D;
  xcpt_Array_Bounds_Exceeded    = $C0000093;
  xcpt_B1npx_Errata_02          = $C0010004;
{ Misc exceptions }
  xcpt_Unwind                   = $C0000026;
  xcpt_Bad_Stack                = $C0000027;
  xcpt_Invalid_Unwind_Target    = $C0000028;
{ Signal Exceptions }
  xcpt_Signal                   = $C0010003;
{ ExceptionInfo[ 0 ] - Signal Number }

{ ContextRecord
  This is the machine specific register contents for the thread
  at the time of the exception. Note that only the register sets
  specified by ContextFlags contain valid data. Conversely, only
  registers specified in ContextFlags will be restored if an exception
  is handled.

  The following flags control the contents of the CONTEXT structure.
}
  context_Control               = $00000001;    { SS:ESP, CS:EIP, EFLAGS, EBP  }
  context_Integer               = $00000002;    { EAX, EBX, ECX, EDX, ESI, EDI }
  context_Segments              = $00000004;    { DS, ES, FS, GS               }
  context_Floating_Point        = $00000008;    { numeric coprocessor state    }
  context_Full                  = context_Control  or context_Integer or
                                  context_Segments or context_Floating_Point;
{ Coprocessor stack register element }
type
  PFpReg = ^FpReg;
  FpReg = record
    losig:   ULong;
    hisig:   ULong;
    signexp: Word;
  end;

  PContextRecord = ^ContextRecord;
  ContextRecord = record
{ The flags values within this flag control the contents of
  a ContextRecord.
  If the ContextRecord is used as an input parameter, then
  for each portion of the ContextRecord controlled by a flag
  whose value is set, it is assumed that that portion of the
  ContextRecord contains valid context. If the ContextRecord
  is being used to modify a thread's context, then only that
  portion of the thread's context will be modified.

  If the ContextRecord is used as an Input/Output parameter to
  capture the context of a thread, then only those portions of the
  thread's context corresponding to set flags will be returned.
}
    ContextFlags: ULong;
{ This section is specified/returned if the ContextFlags
  contains the flag context_Floating_Point.
}
    ctx_env:   array [0..6] of ULong;    { coprocessor environment }
    ctx_stack: array [0..7] of FpReg;    { register set            }
{ This section is specified/returned if the ContextFlags
   contains the flag context_Segments.
}
    ctx_SegGs:  ULong;
    ctx_SegFs:  ULong;
    ctx_SegEs:  ULong;
    ctx_SegDs:  ULong;
{ This section is specified/returned if the ContextFlags
  contains the flag context_Integer.
}
    ctx_RegEdi: ULong;
    ctx_RegEsi: ULong;
    ctx_RegEax: ULong;
    ctx_RegEbx: ULong;
    ctx_RegEcx: ULong;
    ctx_RegEdx: ULong;
{ This section is specified/returned if the ContextFlags
  contains the flag context_Control.
}
    ctx_RegEbp: ULong;
    ctx_RegEip: ULong;
    ctx_SegCs:  ULong;
    ctx_EFlags: ULong;
    ctx_RegEsp: ULong;
    ctx_SegSs:  ULong;
  end;

{ ExceptionReportRecord
  This structure contains machine independant information about an
  exception/unwind. No system exception will ever have more than
  exception_Maximum_Parameters parameters. User exceptions are not
  bound to this limit.
 }
const
  exception_Maximum_Parameters  = 4;    { Enough for all system exceptions }
type
  PExceptionRegistrationRecord = ^ExceptionRegistrationRecord;
  PExceptionReportRecord = ^ExceptionReportRecord;
  ExceptionReportRecord = record
    ExceptionNum:     ULong;            { exception number }
    fHandlerFlags:    ULong;
    NestedExceptionReportRecord: PExceptionReportRecord;
    ExceptionAddress: Pointer;
    cParameters:      ULong;            { Size of Exception Specific Info }
    ExceptionInfo: array [0..exception_Maximum_Parameters-1] of ULong;
  end;                                  { Exception Specfic Info }

  Err = function(ExcpRep: PExceptionReportRecord;
                 ExcpReg: PExceptionRegistrationRecord;
                 Context: PContextRecord;
                 P:       Pointer): ULong;

{ ExceptionRegistrationRecord
  These are linked together to form a chain of exception handlers that
  will be dispatched to upon receipt of an exception.
}
  ExceptionRegistrationRecord = record
    Prev_Structure:   PExceptionRegistrationRecord;
    ExceptionHandler: Err;
  end;

{ End of exception chain marker }
const
  end_Of_Chain  = PExceptionRegistrationRecord(-1);

function DosSetExceptionHandler(var ERegRec: ExceptionRegistrationRecord): ApiRet;
function DosUnsetExceptionHandler(var ERegRec: ExceptionRegistrationRecord): ApiRet;
function DosRaiseException(var Except: ExceptionReportRecord): ApiRet;
function DosSendSignalException(Pid: Pid; Exception: ULong): ApiRet;
function DosUnwindException(var Handler: ExceptionRegistrationRecord; TargetIP: Pointer;
  var ERepRec: ExceptionReportRecord): ApiRet;
function DosSetSignalExceptionFocus(Flag: Bool; var Times: ULong): ApiRet;
function DosEnterMustComplete(var Nesting: ULong): ApiRet;
function DosExitMustComplete(var Nesting: ULong): ApiRet;
function DosAcknowledgeSignalException(SignalNum: ULong): ApiRet;

{*** Pipe and queue support ***}

type
  PHQueue = ^HQueue;
  HQueue  = LHandle;

  PRequestData = ^RequestData;
  RequestData = record
    Pid:  Pid;
    Data: ULong;
  end;

const
  que_Fifo                      = 0;
  que_Lifo                      = 1;
  que_Priority                  = 2;
  que_NoConvert_Address         = 0;
  que_Convert_Address           = 4;

function DosCreatePipe(var Read,Write: HFile; cb: ULong): ApiRet;
function DosCloseQueue(Queue: HQueue): ApiRet;
function DosCreateQueue(var Queue: HQueue; Priority: ULong; Name: PChar): ApiRet;
function DosOpenQueue(var Pid: Pid; var Queue: HQueue; Name: PChar): ApiRet;
function DosPeekQueue(Queue: HQueue; var Request: RequestData; var cbData: ULong;
  var Buf: Pointer; var Element: ULong; NoWait: Bool; var Priority: Byte; Sem: HEv): ApiRet;
function DosPurgeQueue(Queue: HQueue): ApiRet;
function DosQueryQueue(Queue: HQueue; var cbEntries: ULong): ApiRet;
function DosReadQueue(Queue: HQueue; var Request: RequestData;
  var cbData: ULong; var Buf: Pointer; Element: ULong; Wait: Bool; var Priority: Byte; Sem: HEv): ApiRet;
function DosWriteQueue(Queue: HQueue; Request: ULong; cbData: ULong; pbData: Pointer; Priority: ULong): ApiRet;

{ definitions for DosSearchPath control word }
const
  dsp_ImpliedCur                = 1;    { current dir will be searched first }
  dsp_PathRef                   = 2;    { from env.variable }
  dsp_IgnoreNetErr              = 4;    { ignore net errs & continue search }

{ indices for DosQuerySysInfo }
  qsv_Max_Path_Length           = 1;
  q_Max_Path_Length             = qsv_Max_Path_Length;
  qsv_Max_Text_Sessions         = 2;
  qsv_Max_Pm_Sessions           = 3;
  qsv_Max_Vdm_Sessions          = 4;
  qsv_Boot_Drive                = 5;      { 1=A, 2=B, etc. }
  qsv_Dyn_Pri_Variation         = 6;      { 0=Absolute, 1=Dynamic }
  qsv_Max_Wait                  = 7;      { seconds }
  qsv_Min_Slice                 = 8;      { milli seconds }
  qsv_Max_Slice                 = 9;      { milli seconds }
  qsv_Page_Size                 = 10;
  qsv_Version_Major             = 11;
  qsv_Version_Minor             = 12;
  qsv_Version_Revision          = 13;     { Revision letter }
  qsv_Ms_Count                  = 14;     { Free running millisecond counter }
  qsv_Time_Low                  = 15;     { Low dword of time in seconds }
  qsv_Time_High                 = 16;     { High dword of time in seconds }
  qsv_TotPhysMem                = 17;     { Physical memory on system }
  qsv_TotResMem                 = 18;     { Resident memory on system }
  qsv_TotAvailMem               = 19;     { Available memory for all processes }
  qsv_MaxPrMem                  = 20;     { Avail private mem for calling proc }
  qsv_MaxShMem                  = 21;     { Avail shared mem for calling proc }
  qsv_Timer_Interval            = 22;     { Timer interval in tenths of ms }
  qsv_Max_Comp_Length           = 23;     { max len of one component in a name }
  qsv_Max                       = qsv_Max_Comp_Length;
{ definitions for DosError - combine with OR }
  ferr_DisableHardErr           = $00000000;    { disable hard error popups }
  ferr_EnableHardErr            = $00000001;    { enable hard error popups  }
  ferr_EnableException          = $00000000;    { enable exception popups   }
  ferr_DisableException         = $00000002;    { disable exception popups  }
{ definitions for DosQueryRASInfo Index }
  sis_MmioAddr                  = 0;
  sis_Mec_Table                 = 1;
  sis_Sys_Log                   = 2;

function DosError(Error: ULong): ApiRet;
function DosGetMessage(var Table: PChar; cTable: ULong; Buf: PChar; cbBuf: ULong;
  MsgNumber: ULong; FileName: PChar; var cbMsg: ULong): ApiRet;
function DosErrClass(Code: ULong; var Class,Action,Locus: ULong): ApiRet;
function DosInsertMessage(var Table: PChar; cTable: ULong; Msg: PChar; cbMsg: ULong;
  Buf: PChar; cbBuf: ULong; var cbMsg: ULong): ApiRet;
function DosPutMessage(F: HFile; cbMsg: ULong; Buf: PChar): ApiRet;
function DosQuerySysInfo(Start,Last: ULong; var Buf; cbBuf: ULong): ApiRet;
function DosScanEnv(Name: PChar; var Value: PChar): ApiRet;
function DosSearchPath(Flag: ULong; PathOrName,FileName,Buf: PChar; cbBuf: ULong): ApiRet;
function DosQueryMessageCP(pb: PChar; cb: ULong; FileName: PChar; var Buf: ULong): ApiRet;
function DosQueryRASInfo(Index: ULong; var Addr: Pointer): ApiRet;

{ Session manager support }
type
  StartData = record
    Length:        Word;
    Related:       Word;
    FgBg:          Word;
    TraceOpt:      Word;
    PgmTitle:      PChar;
    PgmName:       PChar;
    PgmInputs:     PChar;
    TermQ:         PChar;
    Environment:   PChar;
    InheritOpt:    Word;
    SessionType:   Word;
    IconFile:      PChar;
    PgmHandle:     ULong;
    PgmControl:    Word;
    InitXPos:      Word;
    InitYPos:      Word;
    InitXSize:     Word;
    InitYSize:     Word;
    Reserved:      Word;
    ObjectBuffer:  PChar;
    ObjectBuffLen: ULong;
  end;

const
  ssf_Related_Independent       = 0;
  ssf_Related_Child             = 1;

  ssf_Fgbg_Fore                 = 0;
  ssf_Fgbg_Back                 = 1;

  ssf_TraceOpt_None             = 0;
  ssf_TraceOpt_Trace            = 1;
  ssf_TraceOpt_TraceAll         = 2;

  ssf_InhertOpt_Shell           = 0;
  ssf_InhertOpt_Parent          = 1;

{ note that these types are identical to those in PmShl unit for prog_* }
  ssf_Type_Default              = 0;
  ssf_Type_FullScreen           = 1;
  ssf_Type_WindowableVio        = 2;
  ssf_Type_Pm                   = 3;
  ssf_Type_Vdm                  = 4;
  ssf_Type_Group                = 5;
  ssf_Type_Dll                  = 6;
  ssf_Type_WindowedVdm          = 7;
  ssf_Type_Pdd                  = 8;
  ssf_Type_Vdd                  = 9;

{ note that these flags are identical to those in PmShl unit for she_* }
  ssf_Control_Visible           = $0000;
  ssf_Control_Invisible         = $0001;
  ssf_Control_Maximize          = $0002;
  ssf_Control_Minimize          = $0004;
  ssf_Control_NoAutoClose       = $0008;
  ssf_Control_SetPos            = $8000;

type
  PStatusData = ^StatusData;
  StatusData = record
    Length:    Word;
    SelectInd: Word;
    BondInd:   Word;
  end;

{ SelectInd and BondInd paramater values for DosSetSession }
const
  set_Session_Unchanged         = 0;
  set_Session_Selectable        = 1;
  set_Session_Non_Selectable    = 2;
  set_Session_Bond              = 1;
  set_Session_No_Bond           = 2;
{ TargetOption (scope) parameter values for DosStopSession }
  stop_Session_Specified        = 0;
  stop_Session_All              = 1;

function DosStartSession(var Sd: StartData; var IdSession: ULong; var Pid: Pid): ApiRet;
function DosSetSession(IdSession: ULong; var Sd: StatusData): ApiRet;
function DosSelectSession(IdSession: ULong): ApiRet;
function DosStopSession(Scope: ULong; IdSession: ULong): ApiRet;
function DosQueryAppType(Name: PChar; var Flags: ULong): ApiRet;

{ AppType returned in by DosQueryAppType in pFlags as follows }
const
  fapptyp_NotSpec               = $0000;
  fapptyp_NotWindowCompat       = $0001;
  fapptyp_WindowCompat          = $0002;
  fapptyp_WindowApi             = $0003;
  fapptyp_Bound                 = $0008;
  fapptyp_Dll                   = $0010;
  fapptyp_Dos                   = $0020;
  fapptyp_PhysDrv               = $0040; { physical device driver       }
  fapptyp_VirtDrv               = $0080; { virtual device driver        }
  fapptyp_ProtDll               = $0100; { 'protected memory' dll       }
  fapptyp_WindowsReal           = $0200; { Windows real mode app        }
  fapptyp_WindowsProt           = $0400; { Windows protect mode app     }
  fapptyp_32bit                 = $4000;
  fapptyp_ExeType               = fapptyp_WindowApi;

  fapptyp_Reserved              =
    not (fapptyp_WindowApi or fapptyp_Bound or fapptyp_Dll or fapptyp_Dos or
         fapptyp_PhysDrv or fapptyp_VirtDrv or fapptyp_ProtDll or fapptyp_32bit);

  eat_apptyp_PmApi              = $00;           { Uses PM API }
  eat_apptyp_Dos                = $01;           { DOS APP }
  eat_apptyp_PmW                = $02;           { Window compatible }
  eat_apptyp_NoPmW              = $03;           { Not Window compatible }
  eat_apptyp_ExeType            = $03;           { EXE type mask }
  eat_apptyp_Reserved           = not eat_apptyp_ExeType;

{ Device support }

function DosDevConfig(DevInfo: Pointer; Item: ULong): ApiRet;

const
  devinfo_Printer               = 0;      { Number of printers attached }
  devinfo_Rs232                 = 1;      { Number of RS232 ports }
  devinfo_Floppy                = 2;      { Number of diskette drives }
  devinfo_Coprocessor           = 3;      { Presence of math coprocessor }
  devinfo_SubModel              = 4;      { PC Submodel Type }
  devinfo_Model                 = 5;      { PC Model Type }
  devinfo_Adapter               = 6;      { Primary display adapter type }

function DosDevIOCtl(Device: HFile; Category,Func: ULong; Params: Pointer;
  cbParmLenMax: ULong; var cbParmLen: ULong; Data: Pointer; cbDataLenMax: ULong;
  var cbDataLen: ULong): ApiRet;

function DosPhysicalDisk(Func: ULong; var Buf; cbBuf: ULong; Params: Pointer;
  cbParams: ULong): ApiRet;

const
  info_Count_Partitionable_Disks = 1;   { # of partitionable disks }
  info_GetIoctlHandle            = 2;   { Obtain handle            }
  info_FreeIoctlHandle           = 3;   { Release handle           }

{ DosNamedPipes API Support }
{ Data structures used with named pipes }

type
  PHPipe = ^HPipe;
  HPipe  = LHandle;

  PAvailData = ^AvailData;
  AvailData = record
    cbpipe:    Word;                    { bytes left in the pipe }
    cbmessage: Word;                    { bytes left in the current message }
  end;

  PPipeInfo = ^PipeInfo;
  PipeInfo = record
    cbOut:     Word;               { length of outgoing I/O buffer }
    cbIn:      Word;               { length of incoming I/O buffer }
    cbMaxInst: Byte;               { maximum number of instances   }
    cbCurInst: Byte;               { current number of instances   }
    cbName:    Byte;               { length of pipe name           }
    szName: array [0..0] of Char;  { start of name                 }
  end;

  PPipeSemState = ^PipeSemState;
  PipeSemState = record
    fStatus: Byte;          { type of record, 0 = EOI, 1 = read ok, }
                            { 2 = write ok, 3 = pipe closed         }
    fFlag:   Byte;          { additional info, 01 = waiting thread  }
    usKey:   Word;          { user's key value                      }
    usAvail: Word;          { available data/space if status = 1/2  }
  end;

const
  np_Indefinite_Wait            = -1;
  np_Default_Wait               =  0;
{ DosPeekNmPipe pipe states }
  np_State_Disconnected         = $0001;
  np_State_Listening            = $0002;
  np_State_Connected            = $0003;
  np_State_Closing              = $0004;
{ DosCreateNPipe open modes }
  np_Access_InBound             = $0000;
  np_Access_OutBound            = $0001;
  np_Access_Duplex              = $0002;
  np_Inherit                    = $0000;
  np_NoInherit                  = $0080;
  np_WriteBehind                = $0000;
  np_NoWriteBehind              = $4000;
{ DosCreateNPipe and DosQueryNPHState state }
  np_ReadMode_Byte              = $0000;
  np_ReadMode_Message           = $0100;
  np_Type_Byte                  = $0000;
  np_Type_Message               = $0400;
  np_End_Client                 = $0000;
  np_End_Server                 = $4000;
  np_Wait                       = $0000;
  np_NoWait                     = $8000;
  np_UnLimited_Instances        = $00FF;

function DosCallNPipe(Name: PChar; var InBuf; cbIn: ULong; var OutBuf;
  cbOut: ULong; var cbActual: ULong; MSec: ULong): ApiRet;
function DosConnectNPipe(Pipe: HPipe): ApiRet;
function DosDisConnectNPipe(Pipe: HPipe): ApiRet;
function DosCreateNPipe(Name: PChar; var Pipe: HPipe; OpenMode,PipeMode,cbInBuf,cbOutbuf,MSec: ULong): ApiRet;
function DosPeekNPipe(Pipe: HPipe; var Buf; cbBuf: ULong; var cbActual: ULong;
  var Avail: AvailData; var State: ULong): ApiRet;
function DosQueryNPHState(Pipe: HPipe; var State: ULong): ApiRet;
function DosQueryNPipeInfo(Pipe: HPipe; InfoLevel: ULong; var Buf; cbBuf: ULong): ApiRet;
function DosQueryNPipeSemState(Sem: HSem; var NpSS: PipeSemState; cbBuf: ULong): ApiRet;
function DosRawReadNPipe(Name: PChar; cb: ULong; var Len: ULong; var Buf): ApiRet;
function DosRawWriteNPipe(Name: PChar; cb: ULong): ApiRet;
function DosSetNPHState(Pipe: HPipe; State: ULong): ApiRet;
function DosSetNPipeSem(Pipe: HPipe; Sem: HSem; Key: ULong): ApiRet;
function DosTransactNPipe(Pipe: HPipe; var OutBuf; cbOut: ULong; var InBuf;
  cbIn: ULong; cbRead: ULong): ApiRet;
function DosWaitNPipe(Name: PChar; MSec: ULong): ApiRet;

{ values in fStatus }
const
  npss_EOI                      = 0;    { End Of Information    }
  npss_RData                    = 1;    { read data available   }
  npss_WSpace                   = 2;    { write space available }
  npss_Close                    = 3;    { pipe in Closing state }

{ values in npss_flag }
  npss_Wait                     = $01;  { waiting thread on end of pipe }
{ defined bits in pipe mode }
  np_NBlk                       = $8000;{ non-blocking read/write }
  np_Server                     = $4000;{ set if server end       }
  np_WMesg                      = $0400;{ write messages          }
  np_RMesg                      = $0100;{ read as messages        }
  np_ICount                     = $00FF;{ instance count field    }
{ Named pipes may be in one of several states depending on the actions
  that have been taken on it by the server end and client end.  The
  following state/action table summarizes the valid state transitions:
  Current state           Action                  Next state

   <none>             server DosMakeNmPipe        DISCONNECTED
   DISCONNECTED       server connect              LISTENING
   LISTENING          client open                 CONNECTED
   CONNECTED          server disconn              DISCONNECTED
   CONNECTED          client close                CLOSING
   CLOSING            server disconn              DISCONNECTED
   CONNECTED          server close                CLOSING
   <any other>        server close                <pipe deallocated>

  If a server disconnects his end of the pipe, the client end will enter a
  special state in which any future operations (except close) on the file
  descriptor associated with the pipe will return an error.
}

{ Values for named pipe state }
  np_DisConnected               = 1;        { after pipe creation or Disconnect }
  np_Listening                  = 2;        { after DosNmPipeConnect            }
  np_Connected                  = 3;        { after Client open                 }
  np_Closing                    = 4;        { after Client or Server close      }
{ DosProfile API support }
{ Perfview API support   }
function DosTmrQueryFreq(var TmrFreq: ULong): ApiRet;
function DosTmrQueryTime(var TmrTime: QWord): ApiRet;
function DosRegisterPerfCtrs(DataBlk,TextBlk: Pointer; Flags: ULong): ApiRet;
{ DosProfile ordinal number }
const
  prof_Ordinal                  = 133;
{ DosProfile usType }
  prof_System                   = 0;
  prof_User                     = 1;
  prof_Usedd                    = 2;
  prof_Kernel                   = 4;
  prof_Verbose                  = 8;
  prof_Enable                   = 16;
{ DosProfile usFunc }
  prof_Alloc                    = 0;
  prof_Clear                    = 1;
  prof_On                       = 2;
  prof_Off                      = 3;
  prof_Dump                     = 4;
  prof_Free                     = 5;
{ DosProfile tic count granularity (DWORD) }
  prof_Shift                    = 2;
{ DosProfile module name string length }
  prof_Mod_Name_Size            = 10;
{ DosProfile error code for end of data }
  prof_End_Of_Data              = 13;
{ Virtual DOS Machine API support }
type
  PHVdd = ^HVdd;
  HVdd = LHandle;

function DosOpenVDD(VDD: PChar; var Vdd: HVdd): ApiRet;
function DosRequestVDD(VDD: HVdd; Sgid: Sgid; Cmd: ULong; cbInput: ULong;
  Input: Pointer; cbOutput: ULong; Output: Pointer): ApiRet;
function DosCloseVDD(Vdd: HVdd): ApiRet;
function DosQueryDOSProperty(Sgid: Sgid; Name: PChar; cb: ULong; pch: PChar): ApiRet;
function DosSetDOSProperty(gid: Sgid; Name: PChar; cb: ULong; pch: PChar): ApiRet;

{ Undocumented OS/2 routines that perform pointer conversion    }
{ NOTE: These routines can be called only from BASM code        }
{ EXPECTS:      eax     = Source pointer value                  }
{ RETURNS:      eax     = Converted pointer value               }
{ Instead of calling these routines directly, use System unit   }
{ procedures FlatToSel and SelToFlat, they will do it for you.  }

procedure DosFlatToSel;
procedure DosSelToFlat;

{ Error codes for Base OS/2 applications }

const
  no_Error                      = 0;    { No error occurred             }
  error_Invalid_Function        = 1;    { Invalid function number       }
  error_File_Not_Found          = 2;    { File not found                }
  error_Path_Not_Found          = 3;    { Path not found                }
  error_Too_Many_Open_Files     = 4;    { Too many open files (no handles left)}
  error_Access_Denied           = 5;    { Access denied                 }
  error_Invalid_Handle          = 6;    { Invalid handle                }
  error_Arena_Trashed           = 7;    { Memory control blocks destroyed }
  error_Not_Enough_Memory       = 8;    { Insufficient memory           }
  error_Invalid_Block           = 9;    { Invalid memory-block address  }
  error_Bad_Environment         = 10;   { Invalid environment           }
  error_Bad_Format              = 11;   { Invalid format                }
  error_Invalid_Access          = 12;   { Invalid access code           }
  error_Invalid_Data            = 13;   { Invalid data                  }
  error_Invalid_Drive           = 15;   { Invalid drive specified       }
  error_Current_Directory       = 16;   { Attempting to remove current directory }
  error_Not_Same_Device         = 17;   { Not same device               }
  error_No_More_Files           = 18;   { No more files                 }
  error_Write_Protect           = 19;   { Attempt to write on write-protected diskette }
  error_Bad_Unit                = 20;   { Unknown unit                  }
  error_Not_Ready               = 21;   { Drive not ready               }
  error_Bad_Command             = 22;   { Unknown command               }
  error_Crc                     = 23;   { Data error - cyclic redundancy check }
  error_Bad_Length              = 24;   { Invalid request structure length }
  error_Seek                    = 25;   { Seek error                    }
  error_Not_Dos_Disk            = 26;   { Unknown media type            }
  error_Sector_Not_Found        = 27;   { Sector not found              }
  error_Out_Of_Paper            = 28;   { Printer is out of paper       }
  error_Write_Fault             = 29;   { FAULT Write fault             }
  error_Read_Fault              = 30;   { Read fault                    }
  error_Gen_Failure             = 31;   { General failure               }
  error_Sharing_Violation       = 32;   { Sharing violation             }
  error_Lock_Violation          = 33;   { Lock violation                }
  error_Wrong_Disk              = 34;   { Invalid disk change           }
  error_Fcb_Unavailable         = 35;   { FCB unavailable               }
  error_Sharing_Buffer_Exceeded = 36;   { Sharing buffer overflow       }
  error_Code_Page_Mismatched    = 37;   { Code page does not match      }
  error_Handle_Eof              = 38;   { End of file reached           }
  error_Handle_Disk_Full        = 39;   { Disk is full                  }
  error_Not_Supported           = 50;   { Network request not supported }
  error_Rem_Not_List            = 51;   { Remote network node is not online }
  error_Dup_Name                = 52;   { Duplicate file name in network }
  error_Bad_Netpath             = 53;   { Network path not found        }
  error_Network_Busy            = 54;   { Network is busy               }
  error_Dev_Not_Exist           = 55;   { Device is not installed in network }
  error_Too_Many_Cmds           = 56;   { Network command limit reached }
  error_Adap_Hdw_Err            = 57;   { Network adapter hardware error }
  error_Bad_Net_Resp            = 58;   { Incorrect response in network }
  error_Unexp_Net_Err           = 59;   { Unexpected error in network   }
  error_Bad_Rem_Adap            = 60;   { Remote network adapter error  }
  error_Printq_Full             = 61;   { Network printer queue is full }
  error_No_Spool_Space          = 62;   { No space in print spool file  }
  error_Print_Cancelled         = 63;   { Print spool file deleted      }
  error_Netname_Deleted         = 64;   { Network name deleted          }
  error_Network_Access_Denied   = 65;   { Access to network denied      }
  error_Bad_Dev_Type            = 66;   { Device type invalid for network }
  error_Bad_Net_Name            = 67;   { Network name not found        }
  error_Too_Many_Names          = 68;   { Network name limit exceeded   }
  error_Too_Many_Sess           = 69;   { Network session limit exceeded }
  error_Sharing_Paused          = 70;   { Temporary pause in network    }
  error_Req_Not_Accep           = 71;   { Network request denied        }
  error_Redir_Paused            = 72;   { Pause in network print disk redirection }
  error_Sbcs_Att_Write_Prot     = 73;   { Attempted write on protected disk }
  error_Sbcs_General_Failure    = 74;   { General failure, single-byte character set }
  error_Xga_Out_Memory          = 75;
  error_File_Exists             = 80;   { File exists                   }
  error_Dup_Fcb                 = 81;   { Reserved                      }
  error_Cannot_Make             = 82;   { Cannot make directory entry   }
  error_Fail_I24                = 83;   { Failure on INT 24             }
  error_Out_Of_Structures       = 84;   { Too many redirections         }
  error_Already_Assigned        = 85;   { Duplicate redirection         }
  error_Invalid_Password        = 86;   { Invalid password              }
  error_Invalid_Parameter       = 87;   { Invalid parameter             }
  error_Net_Write_Fault         = 88;   { Network device fault          }
  error_No_Proc_Slots           = 89;   { No process slots available    }
  error_Not_Frozen              = 90;   { System error                  }
  err_Tstovfl                   = 91;   { Timer service table overflow  }
  err_Tstdup                    = 92;   { Timer service table duplicate }
  error_No_Items                = 93;   { No items to work on           }
  error_Interrupt               = 95;   { Interrupted system call       }
  error_Device_In_Use           = 99;   { Device in use                 }
  error_Too_Many_Semaphores     = 100;  { User/system open semaphore limit reached }
  error_Excl_Sem_Already_Owned  = 101;  { Exclusive semaphore already owned }
  error_Sem_Is_Set              = 102;  { DosCloseSem found semaphore set }
  error_Too_Many_Sem_Requests   = 103;  { Too many exclusive semaphore requests }
  error_Invalid_At_Interrupt_Time = 104; { Operation invalid at interrupt time }
  error_Sem_Owner_Died          = 105;  { Previous semaphore owner terminated without freeing semaphore }
  error_Sem_User_Limit          = 106;  { Semaphore limit exceeded      }
  error_Disk_Change             = 107;  { Insert drive B disk into drive A }
  error_Drive_Locked            = 108;  { Drive locked by another process }
  error_Broken_Pipe             = 109;  { Write on pipe with no reader }
  error_Open_Failed             = 110;  { Open/create failed due to explicit fail command }
  error_Buffer_Overflow         = 111;  { Buffer passed to system call too small to hold return data }
  error_Disk_Full               = 112;  { Not enough space on the disk }
  error_No_More_Search_Handles  = 113;  { Cannot allocate another search structure and handle }
  error_Invalid_Target_Handle   = 114;  { Target handle in DosDupHandle invalid }
  error_Protection_Violation    = 115;  { Invalid user virtual address }
  error_Viokbd_Request          = 116;  { Error on display write or keyboard read }
  error_Invalid_Category        = 117;  { Category for DevIOCtl not defined }
  error_Invalid_Verify_Switch   = 118;  { Invalid value passed for verify flag }
  error_Bad_Driver_Level        = 119;  { Level four driver not found   }
  error_Call_Not_Implemented    = 120;  { Invalid function called       }
  error_Sem_Timeout             = 121;  { Time-out occurred from semaphore API function }
  error_Insufficient_Buffer     = 122;  { Data buffer too small         }
  error_Invalid_Name            = 123;  { Illegal character or invalid file-system name }
  error_Invalid_Level           = 124;  { Non-implemented level for information retrieval or setting }
  error_No_Volume_Label         = 125;  { No volume label found with DosQueryFSInfo function }
  error_Mod_Not_Found           = 126;  { Module handle not found with DosQueryProcAddr, DosQueryModAddr }
  error_Proc_Not_Found          = 127;  { Procedure address not found with DosQueryProcAddr }
  error_Wait_No_Children        = 128;  { DosWaitChild finds no children }
  error_Child_Not_Complete      = 129;  { DosWaitChild children not terminated }
  error_Direct_Access_Handle    = 130;  { Handle operation invalid for direct disk-access handles }
  error_Negative_Seek           = 131;  { Attempting seek to negative offset }
  error_Seek_On_Device          = 132;  { Application trying to seek on device or pipe }
  error_Is_Join_Target          = 133;  { Drive has previously joined drives }
  error_Is_Joined               = 134;  { Drive is already joined }
  error_Is_Substed              = 135;  { Drive is already substituted }
  error_Not_Joined              = 136;  { Cannot delete drive that is not joined }
  error_Not_Substed             = 137;  { Cannot delete drive that is not substituted }
  error_Join_To_Join            = 138;  { Cannot join to a joined drive }
  error_Subst_To_Subst          = 139;  { Cannot substitute to a substituted drive }
  error_Join_To_Subst           = 140;  { Cannot join to a substituted drive }
  error_Subst_To_Join           = 141;  { Cannot substitute to a joined drive }
  error_Busy_Drive              = 142;  { Specified drive is busy }
  error_Same_Drive              = 143;  { Cannot join or substitute a drive to a directory on the same drive }
  error_Dir_Not_Root            = 144;  { Directory must be a subdirectory of the root }
  error_Dir_Not_Empty           = 145;  { Directory must be empty to use join command }
  error_Is_Subst_Path           = 146;  { Path specified is being used in a substitute }
  error_Is_Join_Path            = 147;  { Path specified is being used in a join }
  error_Path_Busy               = 148;  { Path specified is being used by another process }
  error_Is_Subst_Target         = 149;  { Cannot join or substitute a drive that
                                          has a directory that is the target of
                                          a previous substitute         }
  error_System_Trace            = 150;  { System trace error            }
  error_Invalid_Event_Count     = 151;  { DosWaitMuxWaitSem errors      }
  error_Too_Many_Muxwaiters     = 152;  { System limit of 100 entries reached }
  error_Invalid_List_Format     = 153;  { Invalid list format           }
  error_Label_Too_Long          = 154;  { Volume label too big          }
  error_Too_Many_Tcbs           = 155;  { Cannot create another TCB     }
  error_Signal_Refused          = 156;  { Signal refused                }
  error_Discarded               = 157;  { Segment is discarded          }
  error_Not_Locked              = 158;  { Segment is not locked         }
  error_Bad_Threadid_Addr       = 159;  { Invalid thread-identity address }
  error_Bad_Arguments           = 160;  { Invalid environment pointer   }
  error_Bad_Pathname            = 161;  { Invalid path name passed to exec }
  error_Signal_Pending          = 162;  { Signal already pending        }
  error_Uncertain_Media         = 163;  { Error with INT 24 mapping     }
  error_Max_Thrds_Reached       = 164;  { No more process slots         }
  error_Monitors_Not_Supported  = 165;  { Error with INT 24 mapping     }
  error_Unc_Driver_Not_Installed        = 166;  { Default redirection return code }
  error_Lock_Failed             = 167;  { Locking failed                }
  error_Swapio_Failed           = 168;  { Swap I/O failed               }
  error_Swapin_Failed           = 169;  { Swap in failed                }
  error_Busy                    = 170;  { Segment is busy               }
  error_Cancel_Violation        = 173;  { A lock request is not outstanding
                                          for the specified file range, or the
                                          range length is zero }
  error_Atomic_Lock_Not_Supported       = 174;  { The file-system driver (FSD)
                                          does not support atomic lock operations.
                                          Versions of OS/2 prior to version 2.00
                                          do not support atomic lock operations }
  error_Read_Locks_Not_Supported        = 175;  { The file system driver (FSD)
                                          does not support shared read locks }
  error_Invalid_Segment_Number  = 180;  { Invalid segment number        }
  error_Invalid_Callgate        = 181;  { Invalid call gate             }
  error_Invalid_Ordinal         = 182;  { Invalid ordinal               }
  error_Already_Exists          = 183;  { Shared segment already exists }
  error_No_Child_Process        = 184;  { No child process to wait for  }
  error_Child_Alive_Nowait      = 185;  { NoWait specified and child alive }
  error_Invalid_Flag_Number     = 186;  { Invalid flag number           }
  error_Sem_Not_Found           = 187;  { Semaphore does not exist      }
  error_Invalid_Starting_Codeseg = 188; { Invalid starting code segment, incorrect END (label) directive }
  error_Invalid_Stackseg        = 189;  { Invalid stack segment         }
  error_Invalid_Moduletype      = 190;  { Invalid module type - dynamic-link
                                          library file cannot be used as an
                                          application. Application cannot be
                                          used as a dynamic-link library }
  error_Invalid_Exe_Signature   = 191;  { Invalid EXE signature - file is
                                          a DOS mode program or an improper
                                          program }
  error_Exe_Marked_Invalid      = 192;  { EXE marked invalid - link detected
                                          errors when the application was created }
  error_Bad_Exe_Format          = 193;  { Invalid EXE format - file is a DOS mode
                                          program or an improper program }
  error_Iterated_Data_Exceeds_64k = 194; { Iterated data exceeds 64KB -
                                          there is more than 64KB of data in
                                          one of the segments of the file }
  error_Invalid_Minallocsize    = 195;  { Invalid minimum allocation size -
                                          the size is specified to be less
                                          than the size of the segment data
                                          in the file }
  error_Dynlink_From_Invalid_Ring = 196; { Dynamic link from invalid privilege
                                          level - privilege level 2 routine cannot
                                          link to dynamic-link libraries }
  error_Iopl_Not_Enabled        = 197;  { IOPL not enabled - IOPL set to NO in CONFIG SYS }
  error_Invalid_Segdpl          = 198;  { Invalid segment descriptor privilege
                                          level - can only have privilege levels
                                          of 2 and 3 }
  error_Autodataseg_Exceeds_64k = 199;  { Automatic data segment exceeds 64KB   }
  error_Ring2seg_Must_Be_Movable = 200; { Privilege level 2 segment must be movable }
  error_Reloc_Chain_Xeeds_Seglim = 201; { Relocation chain exceeds segment limit }
  error_Infloop_In_Reloc_Chain  = 202;  { Infinite loop in relocation chain segment }
  error_Envvar_Not_Found        = 203;  { Environment variable not found }
  error_Not_Current_Ctry        = 204;  { Not current country }
  error_No_Signal_Sent          = 205;  { No signal sent - no process in the command
                                          subtree has a signal handler }
  error_Filename_Exced_Range    = 206;  { File name or extension is greater than 8 3 characters }
  error_Ring2_Stack_In_Use      = 207;  { Privilege level 2 stack is in use }
  error_Meta_Expansion_Too_Long = 208;  { Meta (global) expansion is too long }
  error_Invalid_Signal_Number   = 209;  { Invalid signal number         }
  error_Thread_1_Inactive       = 210;  { Inactive thread               }
  error_Info_Not_Avail          = 211;  { File system information is not available for this file }
  error_Locked                  = 212;  { Locked error                  }
  error_Bad_Dynalink            = 213;  { Attempted to execute a non-family API in DOS mode }
  error_Too_Many_Modules        = 214;  { Too many modules              }
  error_Nesting_Not_Allowed     = 215;  { Nesting is not allowed        }
  error_Cannot_Shrink           = 216;  { The ring 2 stack is not allowed to shrink }
  error_Zombie_Process          = 217;  { Zombie process                }
  error_Stack_In_High_Memory    = 218;  { Stack is in high memory       }
  error_Invalid_Exitroutine_Ring = 219; { Invalid exit routine ring     }
  error_GetBuf_Failed           = 220;  { Get buffer failed             }
  error_FlushBuf_Failed         = 221;  { Flush buffer failed           }
  error_Transfer_Too_Long       = 222;  { Transfer is too long          }
  error_ForceNoSwap_Failed      = 223;
  error_Smg_No_Target_Window    = 224;  { The application window was created
                                          without the fcf_TaskList style, or the
                                          application window not yet been created
                                          or has already been destroyed }
  error_No_Children             = 228;  { No child process              }
  error_Invalid_Screen_Group    = 229;  { Invalid session               }
  error_Bad_Pipe                = 230;  { Non-existent pipe or invalid operation }
  error_Pipe_Busy               = 231;  { Pipe is busy                  }
  error_No_Data                 = 232;  { No data available on non-blocking read }
  error_Pipe_Not_Connected      = 233;  { Pipe was disconnected by server }
  error_More_Data               = 234;  { More data is available        }
  error_Vc_Disconnected         = 240;  { Session was dropped due to errors }
  error_Circularity_Requested   = 250;  { Renaming a directory that would cause a circularity problem }
  error_Directory_In_Cds        = 251;  { Renaming a directory that is in use }
  error_Invalid_Fsd_Name        = 252;  { Trying to access nonexistent FSD }
  error_Invalid_Path            = 253;  { Invalid pseudo device         }
  error_Invalid_Ea_Name         = 254;  { Invalid character in name, or invalid cbName }
  error_Ea_List_Inconsistent    = 255;  { List does not match its size, or there are invalid EAs in the list }
  error_Ea_List_Too_Long        = 256;  { FEAList is longer than 64K-1 bytes }
  error_No_Meta_Match           = 257;  { String does not match expression }
  error_FindNotify_Timeout      = 258;  { A timeout occured before the requested changes could be completed }
  error_No_More_Items           = 259;  { DosQueryFSAttach ordinal query }
  error_Search_Struc_Reused     = 260;  { DOS mode findfirst/next search structure reused }
  error_Char_Not_Found          = 261;  { Character not found           }
  error_Too_Much_Stack          = 262;  { Stack request exceeds system limit }
  error_Invalid_Attr            = 263;  { Invalid attribute             }
  error_Invalid_Starting_Ring   = 264;  { Invalid starting ring         }
  error_Invalid_Dll_Init_Ring   = 265;  { Invalid DLL INIT ring         }
  error_Cannot_Copy             = 266;  { Cannot copy                   }
  error_Directory               = 267;  { Used by DOSCOPY in doscall1   }
  error_Oplocked_File           = 268;  { Oplocked file                 }
  error_Oplock_Thread_Exists    = 269;  { Oplock thread exists          }
  error_Volume_Changed          = 270;  { Volume changed                }
  error_FindNotify_Handle_In_Use = 271;
  error_FindNotify_Handle_Closed = 272;
  error_Notify_Object_Removed   = 273;
  error_Already_Shutdown        = 274;  { System is already shut down   }
  error_Eas_Didnt_Fit           = 275;  { Buffer is not big enough to hold the EAs }
  error_Ea_File_Corrupt         = 276;  { EA file has been damaged      }
  error_Ea_Table_Full           = 277;  { EA table is full              }
  error_Invalid_Ea_Handle       = 278;  { EA handle is invalid          }
  error_No_Cluster              = 279;  { No cluster                    }
  error_Create_Ea_File          = 280;  { Cannot create the EA file     }
  error_Cannot_Open_Ea_File     = 281;  { Cannot open the EA file       }
  error_Eas_Not_Supported       = 282;  { Destination file system does not support EAs }
  error_Need_Eas_Found          = 283;  { Destination file system does not support EAs,
                                          and the source file's EAs contain a need EA }
  error_Duplicate_Handle        = 284;  { The handle already exists     }
  error_Duplicate_Name          = 285;  { The name already exists       }
  error_Empty_Muxwait           = 286;  { The list of semaphores in a muxwait semaphore is empty }
  error_Mutex_Owned             = 287;  { The calling thread owns one or more of the mutex semaphores in the list }
  error_Not_Owner               = 288;  { Caller does not own the semaphore }
  error_Param_Too_Small         = 289;  { Parameter is not large enough to
                                          contain all of the semaphore records
                                          in the muxwait semaphore }
  error_Too_Many_Handles        = 290;  { Limit reached for number of handles }
  error_Too_Many_Opens          = 291;  { There are too many files or semaphores open }
  error_Wrong_Type              = 292;  { Attempted to create wrong type of semaphore }
  error_Unused_Code             = 293;  { Code is not used              }
  error_Thread_Not_Terminated   = 294;  { Thread has not terminated     }
  error_Init_Routine_Failed     = 295;  { Initialization routine failed }
  error_Module_In_Use           = 296;  { Module is in use              }
  error_Not_Enough_Watchpoints  = 297;  { There are not enough watchpoints }
  error_Too_Many_Posts          = 298;  { Post count limit was reached for an event semaphore }
  error_Already_Posted          = 299;  { Event semaphore is already posted }
  error_Already_Reset           = 300;  { Event semaphore is already reset }
  error_Sem_Busy                = 301;  { Semaphore is busy             }

{ end of set 0 - 302 }

  error_User_Defined_Base       = $FF00;

  error_I24_Write_Protect       = 0;
  error_I24_Bad_Unit            = 1;
  error_I24_Not_Ready           = 2;
  error_I24_Bad_Command         = 3;
  error_I24_Crc                 = 4;
  error_I24_Bad_Length          = 5;
  error_I24_Seek                = 6;
  error_I24_Not_Dos_Disk        = 7;
  error_I24_Sector_Not_Found    = 8;
  error_I24_Out_Of_Paper        = 9;
  error_I24_Write_Fault         = 10;
  error_I24_Read_Fault          = 11;
  error_I24_Gen_Failure         = 12;
  error_I24_Disk_Change         = 13;
  error_I24_Wrong_Disk          = 15;
  error_I24_Uncertain_Media     = 16;
  error_I24_Char_Call_Interrupted = 17;
  error_I24_No_Monitor_Support  = 18;
  error_I24_Invalid_Parameter   = 19;
  error_I24_Device_In_Use       = 20;
  error_I24_Quiet_Init_Fail     = 21;

  allowed_Fail                  = $0001;
  allowed_Abort                 = $0002;
  allowed_Retry                 = $0004;
  allowed_Ignore                = $0008;
  allowed_Acknowledge           = $0010;
  allowed_Dispatch              = $8000;
  allowed_Regdump               = $0020;
  allowed_Detached              = allowed_Dispatch;
  allowed_Reserved              = not (allowed_Fail or allowed_Abort or
    allowed_Retry or allowed_Ignore or allowed_Acknowledge);

  i24_Operation                 = $01;
  i24_Area                      = $06;
  i24_Class                     = $80;

{ Values for error CLASS }
  errclass_Outres               = 1;    { Out of Resource               }
  errclass_Tempsit              = 2;    { Temporary Situation           }
  errclass_Auth                 = 3;    { Permission problem            }
  errclass_Intrn                = 4;    { Internal System Error         }
  errclass_Hrdfail              = 5;    { Hardware Failure              }
  errclass_Sysfail              = 6;    { System Failure                }
  errclass_Apperr               = 7;    { Application Error             }
  errclass_Notfnd               = 8;    { Not Found                     }
  errclass_Badfmt               = 9;    { Bad Format                    }
  errclass_Locked               = 10;   { Locked                        }
  errclass_Media                = 11;   { Media Failure                 }
  errclass_Already              = 12;   { Collision with Existing Item  }
  errclass_Unk                  = 13;   { Unknown/other                 }
  errclass_Cant                 = 14;
  errclass_Time                 = 15;

{ Values for error ACTION }
  erract_Retry                  = 1;    { Retry                          }
  erract_Dlyret                 = 2;    { Delay Retry, retry after pause }
  erract_User                   = 3;    { Ask user to regive information }
  erract_Abort                  = 4;    { abort with clean up            }
  erract_Panic                  = 5;    { abort immediately              }
  erract_Ignore                 = 6;    { ignore                         }
  erract_Intret                 = 7;    { Retry after User Intervention  }

{ Values for error LOCUS }
  errloc_Unk                    = 1;    { No appropriate value           }
  errloc_Disk                   = 2;    { Random Access Mass Storage     }
  errloc_Net                    = 3;    { Network                        }
  errloc_Serdev                 = 4;    { Serial Device                  }
  errloc_Mem                    = 5;    { Memory                         }

{ Abnormal termination codes }
  tc_Normal                     = 0;
  tc_Harderr                    = 1;
  tc_Gp_Trap                    = 2;
  tc_Signal                     = 3;
  tc_Xcpt                       = 4;

  error_Invalid_Procid          = 303;  { Invalid process identity      }
  error_Invalid_Pdelta          = 304;  { Invalid priority delta        }
  error_Not_Descendant          = 305;  { Not descendant                }
  error_Not_Session_Manager     = 306;  { Requestor not session manager }
  error_Invalid_Pclass          = 307;  { Invalid P class               }
  error_Invalid_Scope           = 308;  { Invalid scope                 }
  error_Invalid_Threadid        = 309;  { Invalid thread identity       }
  error_Dossub_Shrink           = 310;  { Cannot shrink segment - DosSubSetMem }
  error_Dossub_Nomem            = 311;  { No memory to satisfy request - DosSubAllocMem }
  error_Dossub_Overlap          = 312;  { Overlap of the specified block with a
                                          block of allocated memory - DosSubFreeMem }
  error_Dossub_Badsize          = 313;  { Invalid size parameter - DosSubAllocMem or DosSubFreeMem }
  error_Dossub_Badflag          = 314;  { Invalid flag parameter - DosSubSetMem }
  error_Dossub_Badselector      = 315;  { Invalid segment selector      }
  error_Mr_Msg_Too_Long         = 316;  { Message too long for buffer   }
  mgs_Mr_Msg_Too_Long           = 316;  { The message passed to the message retriever was truncated }
  error_Mr_Mid_Not_Found        = 317;  { Message identity number not found }
  error_Mr_Un_Acc_Msgf          = 318;  { Unable to access message file }
  error_Mr_Inv_Msgf_Format      = 319;  { Invalid message file format   }
  error_Mr_Inv_Ivcount          = 320;  { Invalid insertion variable count }
  error_Mr_Un_Perform           = 321;  { Unable to perform function    }
  error_Ts_Wakeup               = 322;  { Unable to wake up             }
  error_Ts_Semhandle            = 323;  { Invalid system semaphore      }
  error_Ts_Notimer              = 324;  { No timers available           }
  error_Ts_Handle               = 326;  { Invalid timer handle          }
  error_Ts_Datetime             = 327;  { Date or time invalid          }
  error_Sys_Internal            = 328;  { Internal system error         }
  error_Que_Current_Name        = 329;  { Current queue name does not exist }
  error_Que_Proc_Not_Owned      = 330;  { Current process does not own queue }
  error_Que_Proc_Owned          = 331;  { Current process owns queue    }
  error_Que_Duplicate           = 332;  { Duplicate queue name          }
  error_Que_Element_Not_Exist   = 333;  { Queue element does not exist  }
  error_Que_No_Memory           = 334;  { Inadequate queue memory       }
  error_Que_Invalid_Name        = 335;  { Invalid queue name            }
  error_Que_Invalid_Priority    = 336;  { Invalid queue priority parameter }
  error_Que_Invalid_Handle      = 337;  { Invalid queue handle          }
  error_Que_Link_Not_Found      = 338;  { Queue link not found          }
  error_Que_Memory_Error        = 339;  { Queue memory error            }
  error_Que_Prev_At_End         = 340;  { Previous queue element was at end of queue }
  error_Que_Proc_No_Access      = 341;  { Process does not have access to queues }
  error_Que_Empty               = 342;  { Queue is empty                }
  error_Que_Name_Not_Exist      = 343;  { Queue name does not exist     }
  error_Que_Not_Initialized     = 344;  { Queues not initialized        }
  error_Que_Unable_To_Access    = 345;  { Unable to access queues       }
  error_Que_Unable_To_Add       = 346;  { Unable to add new queue       }
  error_Que_Unable_To_Init      = 347;  { Unable to initialize queues   }
  error_Vio_Invalid_Mask        = 349;  { Invalid function replaced     }
  error_Vio_Ptr                 = 350;  { Invalid pointer to parameter  }
  error_Vio_Aptr                = 351;  { Invalid pointer to attribute  }
  error_Vio_Rptr                = 352;  { Invalid pointer to row        }
  error_Vio_Cptr                = 353;  { Invalid pointer to column     }
  error_Vio_Lptr                = 354;  { Invalid pointer to length     }
  error_Vio_Mode                = 355;  { Unsupported screen mode       }
  error_Vio_Width               = 356;  { Invalid cursor width value    }
  error_Vio_Attr                = 357;  { Invalid cursor attribute value }
  error_Vio_Row                 = 358;  { Invalid row value             }
  error_Vio_Col                 = 359;  { Invalid column value          }
  error_Vio_Toprow              = 360;  { Invalid TopRow value          }
  error_Vio_Botrow              = 361;  { Invalid BotRow value          }
  error_Vio_Rightcol            = 362;  { Invalid right column value    }
  error_Vio_Leftcol             = 363;  { Invalid left column value     }
  error_Scs_Call                = 364;  { Call issued by other than session manager }
  error_Scs_Value               = 365;  { Value is not for save or restore }
  error_Vio_Wait_Flag           = 366;  { Invalid wait flag setting     }
  error_Vio_Unlock              = 367;  { Screen not previously locked  }
  error_Sgs_Not_Session_Mgr     = 368;  { Caller not session manager    }
  error_Smg_Invalid_Sgid        = 369;  { Invalid session identity      }
  error_Smg_Invalid_Session_Id  = error_Smg_Invalid_Sgid; { Invalid session ID }
  error_Smg_Nosg                = 370;  { No sessions available         }
  error_Smg_No_Sessions         = 370;  { No sessions available         }
  error_Smg_Grp_Not_Found       = 371;  { Session not found             }
  error_Smg_Session_Not_Found   = error_Smg_Grp_Not_Found; { Session not found }
  error_Smg_Set_Title           = 372;  { Title sent by shell or parent cannot be changed }
  error_Kbd_Parameter           = 373;  { Invalid parameter to keyboard }
  error_Kbd_No_Device           = 374;  { No device                     }
  error_Kbd_Invalid_Iowait      = 375;  { Invalid I/O wait specified    }
  error_Kbd_Invalid_Length      = 376;  { Invalid length for keyboard   }
  error_Kbd_Invalid_Echo_Mask   = 377;  { Invalid echo mode mask        }
  error_Kbd_Invalid_Input_Mask  = 378;  { Invalid input mode mask       }
  error_Mon_Invalid_Parms       = 379;  { Invalid parameters to DosMon  }
  error_Mon_Invalid_Devname     = 380;  { Invalid device name string    }
  error_Mon_Invalid_Handle      = 381;  { Invalid device handle         }
  error_Mon_Buffer_Too_Small    = 382;  { Buffer too small              }
  error_Mon_Buffer_Empty        = 383;  { Buffer is empty               }
  error_Mon_Data_Too_Large      = 384;  { Data record is too large      }
  error_Mouse_No_Device         = 385;  { Mouse device closed (invalid device handle) }
  error_Mouse_Inv_Handle        = 386;  { Mouse device closed (invalid device handle) }
  error_Mouse_Inv_Parms         = 387;  { Parameters invalid for display mode }
  error_Mouse_Cant_Reset        = 388;  { Function assigned and cannot be reset }
  error_Mouse_Display_Parms     = 389;  { Parameters invalid for display mode }
  error_Mouse_Inv_Module        = 390;  { Module not valid              }
  error_Mouse_Inv_Entry_Pt      = 391;  { Entry point not valid         }
  error_Mouse_Inv_Mask          = 392;  { Function mask invalid         }
  NO_Error_Mouse_No_Data        = 393;  { No valid data                 }
  NO_Error_Mouse_Ptr_Drawn      = 394;  { Pointer drawn                 }
  error_Invalid_Frequency       = 395;  { Invalid frequency for beep    }
  error_Nls_No_Country_File     = 396;  { Cannot find COUNTRY SYS file  }
  error_Nls_Open_Failed         = 397;  { Cannot open COUNTRY SYS file  }
  error_Nls_No_Ctry_Code        = 398;  { Country code not found        }
  error_No_Country_Or_Codepage  = 398;  { Country code not found        }
  error_Nls_Table_Truncated     = 399;  { Table returned information truncated, buffer is too small }
  error_Nls_Bad_Type            = 400;  { Selected type does not exist  }
  error_Nls_Type_Not_Found      = 401;  { Selected type is not in file  }
  error_Vio_Smg_Only            = 402;  { Valid from session manager only }
  error_Vio_Invalid_Asciiz      = 403;  { Invalid ASCIIZ length         }
  error_Vio_Deregister          = 404;  { VioDeRegister not allowed     }
  error_Vio_No_Popup            = 405;  { Pop-up window not allocated   }
  error_Vio_Existing_Popup      = 406;  { Pop-up window on screen (NoWait) }
  error_Kbd_Smg_Only            = 407;  { Valid from session manager only }
  error_Kbd_Invalid_Asciiz      = 408;  { Invalid ASCIIZ length         }
  error_Kbd_Invalid_Mask        = 409;  { Invalid replacement mask      }
  error_Kbd_Register            = 410;  { KbdRegister not allowed       }
  error_Kbd_Deregister          = 411;  { KbdDeRegister not allowed     }
  error_Mouse_Smg_Only          = 412;  { Valid from session manager only }
  error_Mouse_Invalid_Asciiz    = 413;  { Invalid ASCIIZ length         }
  error_Mouse_Invalid_Mask      = 414;  { Invalid replacement mask      }
  error_Mouse_Register          = 415;  { Mouse register not allowed    }
  error_Mouse_Deregister        = 416;  { Mouse deregister not allowed  }
  error_Smg_Bad_Action          = 417;  { Invalid action specified      }
  error_Smg_Invalid_Call        = 418;  { INIT called more than once, or invalid session identity }
  error_Scs_Sg_Notfound         = 419;  { New session number            }
  error_Scs_Not_Shell           = 420;  { Caller is not shell           }
  error_Vio_Invalid_Parms       = 421;  { Invalid parameters passed     }
  error_Vio_Function_Owned      = 422;  { Save/restore already owned    }
  error_Vio_Return              = 423;  { Non-destruct return (undo)    }
  error_Scs_Invalid_Function    = 424;  { Caller invalid function       }
  error_Scs_Not_Session_Mgr     = 425;  { Caller not session manager    }
  error_Vio_Register            = 426;  { Vio register not allowed      }
  error_Vio_No_Mode_Thread      = 427;  { No mode restore thread in SG  }
  error_Vio_No_Save_Restore_Thd = 428;  { No save/restore thread in SG  }
  error_Vio_In_Bg               = 429;  { Function invalid in background }
  error_Vio_Illegal_During_Popup = 430; { Function not allowed during pop-up window }
  error_Smg_Not_Baseshell       = 431;  { Caller is not the base shell  }
  error_Smg_Bad_Statusreq       = 432;  { Invalid status requested      }
  error_Que_Invalid_Wait        = 433;  { NoWait parameter out of bounds }
  error_Vio_Lock                = 434;  { Error returned from Scroll Lock }
  error_Mouse_Invalid_Iowait    = 435;  { Invalid parameters for IOWait }
  error_Vio_Invalid_Handle      = 436;  { Invalid VIO handle            }
  error_Vio_Illegal_During_Lock = 437;  { Function not allowed during screen lock }
  error_Vio_Invalid_Length      = 438;  { Invalid VIO length            }
  error_Kbd_Invalid_Handle      = 439;  { Invalid KBD handle            }
  error_Kbd_No_More_Handle      = 440;  { Ran out of handles            }
  error_Kbd_Cannot_Create_Kcb   = 441;  { Unable to create kcb          }
  error_Kbd_Codepage_Load_Incompl = 442; { Unsuccessful code-page load  }
  error_Kbd_Invalid_Codepage_Id = 443;  { Invalid code-page identity    }
  error_Kbd_No_Codepage_Support = 444;  { No code page support          }
  error_Kbd_Focus_Required      = 445;  { Keyboard focus required       }
  error_Kbd_Focus_Already_Active = 446; { Calling thread has an outstanding focus }
  error_Kbd_Keyboard_Busy       = 447;  { Keyboard is busy              }
  error_Kbd_Invalid_Codepage    = 448;  { Invalid code page             }
  error_Kbd_Unable_To_Focus     = 449;  { Focus attempt failed          }
  error_Smg_Session_Non_Select  = 450;  { Session is not selectable     }
  error_Smg_Session_Not_Foregrnd = 451; { Parent/child session is not foreground }
  error_Smg_Session_Not_Parent  = 452;  { Not parent of requested child }
  error_Smg_Invalid_Start_Mode  = 453;  { Invalid session start mode    }
  error_Smg_Invalid_Related_Opt = 454;  { Invalid session start related option }
  error_Smg_Invalid_Bond_Option = 455;  { Invalid session bond option   }
  error_Smg_Invalid_Select_Opt  = 456;  { Invalid session select option }
  error_Smg_Start_In_Background = 457;  { Session started in background }
  error_Smg_Invalid_Stop_Option = 458;  { Invalid session stop option   }
  error_Smg_Bad_Reserve         = 459;  { Reserved parameters are not zero }
  error_Smg_Process_Not_Parent  = 460;  { Session parent process already exists }
  error_Smg_Invalid_Data_Length = 461;  { Invalid data length           }
  error_Smg_Not_Bound           = 462;  { Parent is not bound           }
  error_Smg_Retry_Sub_Alloc     = 463;  { Retry request block allocation }
  error_Kbd_Detached            = 464;  { This call is not allowed for a detached PID }
  error_Vio_Detached            = 465;  { This call is not allowed for a detached PID }
  error_Mou_Detached            = 466;  { This call is not allowed for a detached PID }
  error_Vio_Font                = 467;  { No font is available to support the mode }
  error_Vio_User_Font           = 468;  { User font is active           }
  error_Vio_Bad_Cp              = 469;  { Invalid code page specified   }
  error_Vio_No_Cp               = 470;  { System displays do not support code page }
  error_Vio_Na_Cp               = 471;  { Current display does not support code page }
  error_Invalid_Code_Page       = 472;  { Invalid code page             }
  error_CpList_Too_Small        = 473;  { Code page list is too small   }
  error_Cp_Not_Moved            = 474;  { Code page was not moved       }
  error_Mode_Switch_Init        = 475;  { Mode switch initialization error }
  error_Code_Page_Not_Found     = 476;  { Code page was not found       }
  error_Unexpected_Slot_Returned = 477; { Internal error                }
  error_Smg_Invalid_Trace_Option = 478; { Invalid start session trace indicator }
  error_Vio_Internal_Resource   = 479;  { VIO internal resource error   }
  error_Vio_Shell_Init          = 480;  { VIO shell initialization error }
  error_Smg_No_Hard_Errors      = 481;  { No session manager hard errors }
  error_Cp_Switch_Incomplete    = 482;  { DosSetProcessCp is unable to set a KBD or VIO code page }
  error_Vio_Transparent_Popup   = 483;  { Error during VIO pop-up window }
  error_CritSec_Overflow        = 484;  { Critical section overflow     }
  error_CritSec_Underflow       = 485;  { Critical section underflow    }
  error_Vio_Bad_Reserve         = 486;  { Reserved parameter is not zero }
  error_Invalid_Address         = 487;  { Invalid physical address      }
  error_Zero_Selectors_Requested = 488; { At least one selector must be requested }
  error_Not_Enough_Selectors_Ava = 489; { Not enough GDT selectors to satisfy request }
  error_Invalid_Selector        = 490;  { Not a GDT selector            }
  error_Smg_Invalid_Program_Type = 491; { Invalid program type          }
  error_Smg_Invalid_Pgm_Control = 492;  { Invalid program control       }
  error_Smg_Invalid_Inherit_Opt = 493;  { Invalid inherit option        }
  error_Vio_Extended_Sg         = 494;  { Vio function not allowed in PM window }
  error_Vio_Not_Pres_Mgr_Sg     = 495;  { Function not supported in non-PM screen group }
  error_Vio_Shield_Owned        = 496;  { Vio shield already owned      }
  error_Vio_No_More_Handles     = 497;  { Vio handles exhausted         }
  error_Vio_See_Error_Log       = 498;  { Vio error occurred, details sent to error log }
  error_Vio_Associated_Dc       = 499;  { Invalid display context       }
  error_Kbd_No_Console          = 500;  { Kbd input not available       }
  error_Mouse_No_Console        = 501;  { Mou input not available       }
  error_Mouse_Invalid_Handle    = 502;  { Invalid mouse handle          }
  error_Smg_Invalid_Debug_Parms = 503;  { Invalid debugging parameters  }
  error_Kbd_Extended_Sg         = 504;  { Kbd function not allowed in PM window }
  error_Mou_Extended_Sg         = 505;  { Mou function not allowed in PM window }
  error_Smg_Invalid_Icon_File   = 506;  { Invalid icon file             }
  error_Trc_Pid_Non_Existent    = 507;  { The specified process doesn't exist }
  error_Trc_Count_Active        = 508;  { RAS trace count is already active }
  error_Trc_Suspended_By_Count  = 509;  { RAS tracing has been suspended }
  error_Trc_Count_Inactive      = 510;  { RAS trace-until-error has not been requested }
  error_Trc_Count_Reached       = 511;  { RAS trace-error-count has reached its limit }
  error_No_Mc_Trace             = 512;  { Minor code RAS tracing is disallowed }
  error_Mc_Trace                = 513;  { The RAS minor or major code table contains an error }
  error_Trc_Count_Zero          = 514;  { The requested RAS trace-until-error is not allowed }
  error_Smg_Too_Many_Dds        = 515;  { Too many device drivers are registered with the Session Manager }
  error_Smg_Invalid_Notification = 516; { The session notification bit map is not correct }
  error_Lf_Invalid_Function     = 517;
  error_Lf_Not_Avail            = 518;
  error_Lf_Suspended            = 519;
  error_Lf_Buf_Too_Small        = 520;
  error_Lf_Buffer_Corrupted     = 521;
  error_Lf_Buffer_Full          = 521;
  error_Lf_Invalid_Daemon       = 522;
  error_Lf_Invalid_Record       = 522;
  error_Lf_Invalid_Templ        = 523;
  error_Lf_Invalid_Service      = 523;
  error_Lf_General_Failure      = 524;
  error_Lf_Invalid_Id           = 525;
  error_Lf_Invalid_Handle       = 526;
  error_Lf_No_Id_Avail          = 527;
  error_Lf_Template_Area_Full   = 528;
  error_Lf_Id_In_Use            = 529;
  error_Mou_Not_Initialized     = 530;
  error_Mouinitreal_Done        = 531;
  error_Dossub_Corrupted        = 532;
  error_Mouse_Caller_Not_Subsys = 533;
  error_Arithmetic_Overflow     = 534;
  error_Tmr_No_Device           = 535;
  error_Tmr_Invalid_Time        = 536;
  error_Pvw_Invalid_Entity      = 537;
  error_Pvw_Invalid_Entity_Type = 538;
  error_Pvw_Invalid_Spec        = 539;
  error_Pvw_Invalid_Range_Type  = 540;
  error_Pvw_Invalid_Counter_Blk = 541;
  error_Pvw_Invalid_Text_Blk    = 542;
  error_Prf_Not_Initialized     = 543;
  error_Prf_Already_Initialized = 544;
  error_Prf_Not_Started         = 545;
  error_Prf_Already_Started     = 546;
  error_Prf_Timer_Out_Of_Range  = 547;
  error_Prf_Timer_Reset         = 548;
  error_VDD_Lock_Useage_Denied  = 639;
  error_Timeout                 = 640;
  error_VDM_Down                = 641;
  error_VDM_Limit               = 642;
  error_VDD_Not_Found           = 643;
  error_Invalid_Caller          = 644;
  error_Pid_Mismatch            = 645;
  error_Invalid_Vdd_Handle      = 646;
  error_VLPT_No_Spooler         = 647;
  error_VCOM_Device_Busy        = 648;
  error_VLPT_Device_Busy        = 649;
  error_Nesting_Too_Deep        = 650;
  error_VDD_Missing             = 651;
  error_Bidi_Invalid_Length     = 671;
  error_Bidi_Invalid_Increment  = 672;
  error_Bidi_Invalid_Combination = 673;
  error_Bidi_Invalid_Reserved   = 674;
  error_Bidi_Invalid_Effect     = 675;
  error_Bidi_Invalid_Csdrec     = 676;
  error_Bidi_Invalid_Csdstate   = 677;
  error_Bidi_Invalid_Level      = 678;
  error_Bidi_Invalid_Type_Support = 679;
  error_Bidi_Invalid_Orientation  = 680;
  error_Bidi_Invalid_Num_Shape  = 681;
  error_Bidi_Invalid_Csd        = 682;
  error_Bidi_No_Support         = 683;
  no_Error_Bidi_Rw_Incomplete   = 684;
  error_Imp_Invalid_Parm        = 691;
  error_Imp_Invalid_Length      = 692;
  msg_HPFS_Disk_Error_Warn      = 693;
  error_Mon_Bad_Buffer          = 730;

  error_Module_Corrupted        = 731;

  error_Sm_OutOf_SwapFile       = 1477;

  error_Lf_Timeout              = 2055;
  error_Lf_Suspend_Success      = 2057;
  error_Lf_Resume_Success       = 2058;
  error_Lf_Redirect_Success     = 2059;
  error_Lf_Redirect_Failure     = 2060;


  error_Swapper_Not_Active      = 32768;
  error_Invalid_Swapid          = 32769;
  error_Ioerr_Swap_File         = 32770;
  error_Swap_Table_Full         = 32771;
  error_Swap_File_Full          = 32772;
  error_Cant_Init_Swapper       = 32773;
  error_Swapper_Already_Init    = 32774;
  error_Pmm_Insufficient_Memory = 32775;
  error_Pmm_Invalid_Flags       = 32776;
  error_Pmm_Invalid_Address     = 32777;
  error_Pmm_Lock_Failed         = 32778;
  error_Pmm_Unlock_Failed       = 32779;
  error_Pmm_Move_Incomplete     = 32780;
  error_Ucom_Drive_Renamed      = 32781;
  error_Ucom_Filename_Truncated = 32782;
  error_Ucom_Buffer_Length      = 32783;
  error_Mon_Chain_Handle        = 32784;
  error_Mon_Not_Registered      = 32785;
  error_Smg_Already_Top         = 32786;
  error_Pmm_Arena_Modified      = 32787;
  error_Smg_Printer_Open        = 32788;
  error_Pmm_Set_Flags_Failed    = 32789;
  error_Invalid_Dos_Dd          = 32790;
  error_Blocked                 = 32791;
  error_NoBlock                 = 32792;
  error_Instance_Shared         = 32793;
  error_No_Object               = 32794;
  error_Partial_Attach          = 32795;
  error_Incache                 = 32796;
  error_Swap_IO_Problems        = 32797;
  error_Crosses_Object_Boundary = 32798;
  error_LongLock                = 32799;
  error_ShortLock               = 32800;
  error_UVirtLock               = 32801;
  error_AliasLock               = 32802;
  error_Alias                   = 32803;
  error_No_More_Handles         = 32804;
  error_Scan_Terminated         = 32805;
  error_Terminator_Not_Found    = 32806;
  error_Not_Direct_Child        = 32807;
  error_Delay_Free              = 32808;
  error_Guardpage               = 32809;
  error_Swaperror               = 32900;
  error_Ldrerror                = 32901;
  error_Nomemory                = 32902;
  error_Noaccess                = 32903;
  error_No_Dll_Term             = 32904;
  error_Cpsio_Code_Page_Invalid = 65026;
  error_Cpsio_No_Spooler        = 65027;
  error_Cpsio_Font_Id_Invalid   = 65028;
  error_Cpsio_Internal_Error    = 65033;
  error_Cpsio_Invalid_Ptr_Name  = 65034;
  error_Cpsio_Not_Active        = 65037;
  error_Cpsio_Pid_Full          = 65039;
  error_Cpsio_Pid_Not_Found     = 65040;
  error_Cpsio_Read_Ctl_Seq      = 65043;
  error_Cpsio_Read_Fnt_Def      = 65045;
  error_Cpsio_Write_Error       = 65047;
  error_Cpsio_Write_Full_Error  = 65048;
  error_Cpsio_Write_Handle_Bad  = 65049;
  error_Cpsio_Swit_Load         = 65074;
  error_Cpsio_Inv_Command       = 65077;
  error_Cpsio_No_Font_Swit      = 65078;
  error_Entry_Is_CallGate       = 65079;

implementation

function DosAcknowledgeSignalException; external;
function DosAddMuxWaitSem;              external;
function DosAllocMem;                   external;
function DosAllocSharedMem;             external;
function DosAsyncTimer;                 external;
function DosBeep;                       external;
function DosCallNPipe;                  external;
function DosCancelLockRequest;          external;
function DosClose;                      external;
function DosCloseEventSem;              external;
function DosCloseMutexSem;              external;
function DosCloseMuxWaitSem;            external;
function DosCloseQueue;                 external;
function DosCloseVDD;                   external;
function DosConnectNPipe;               external;
function DosCopy;                       external;
function DosCreateDir;                  external;
function DosCreateEventSem;             external;
function DosCreateMutexSem;             external;
function DosCreateMuxWaitSem;           external;
function DosCreateNPipe;                external;
function DosCreatePipe;                 external;
function DosCreateQueue;                external;
function DosCreateThread;               external;
function DosDebug;                      external;
function DosDelete;                     external;
function DosDeleteDir;                  external;
function DosDeleteMuxWaitSem;           external;
function DosDevConfig;                  external;
function DosDevIOCtl;                   external;
function DosDisConnectNPipe;            external;
function DosDupHandle;                  external;
function DosEditName;                   external;
function DosEnterCritSec;               external;
function DosEnterMustComplete;          external;
function DosEnumAttribute;              external;
function DosErrClass;                   external;
function DosError;                      external;
function DosExecPgm;                    external;
function DosExit;                       external;
function DosExitCritSec;                external;
function DosExitList;                   external;
function DosExitMustComplete;           external;
function DosFSAttach;                   external;
function DosFSCtl;                      external;
function DosFindClose;                  external;
function DosFindFirst;                  external;
function DosFindNext;                   external;
function DosForceDelete;                external;
function DosFreeMem;                    external;
function DosFreeModule;                 external;
function DosFreeResource;               external;
function DosGetDateTime;                external;
function DosGetInfoBlocks;              external;
function DosGetMessage;                 external;
function DosGetNamedSharedMem;          external;
function DosGetResource;                external;
function DosGetSharedMem;               external;
function DosGiveSharedMem;              external;
function DosInsertMessage;              external;
function DosKillProcess;                external;
function DosKillThread;                 external;
function DosLoadModule;                 external;
function DosMapCase;                    external;
function DosMonClose;                   external;
function DosMonOpen;                    external;
function DosMonRead;                    external;
function DosMonReg;                     external;
function DosMonWrite;                   external;
function DosMove;                       external;
function DosOpen;                       external;
function DosOpenEventSem;               external;
function DosOpenMutexSem;               external;
function DosOpenMuxWaitSem;             external;
function DosOpenQueue;                  external;
function DosOpenVDD;                    external;
function DosPeekNPipe;                  external;
function DosPeekQueue;                  external;
function DosPhysicalDisk;               external;
function DosPostEventSem;               external;
function DosPurgeQueue;                 external;
function DosPutMessage;                 external;
function DosQueryAppType;               external;
function DosQueryCollate;               external;
function DosQueryCp;                    external;
function DosQueryCtryInfo;              external;
function DosQueryCurrentDir;            external;
function DosQueryCurrentDisk;           external;
function DosQueryDBCSEnv;               external;
function DosQueryDOSProperty;           external;
function DosQueryEventSem;              external;
function DosQueryFHState;               external;
function DosQueryFSAttach;              external;
function DosQueryFSInfo;                external;
function DosQueryFileInfo;              external;
function DosQueryHType;                 external;
function DosQueryMem;                   external;
function DosQueryMessageCP;             external;
function DosQueryModuleHandle;          external;
function DosQueryModuleName;            external;
function DosQueryMutexSem;              external;
function DosQueryMuxWaitSem;            external;
function DosQueryNPHState;              external;
function DosQueryNPipeInfo;             external;
function DosQueryNPipeSemState;         external;
function DosQueryPathInfo;              external;
function DosQueryProcAddr;              external;
function DosQueryProcType;              external;
function DosQueryQueue;                 external;
function DosQueryRASInfo;               external;
function DosQueryResourceSize;          external;
function DosQuerySysInfo;               external;
function DosQueryVerify;                external;
function DosRaiseException;             external;
function DosRawReadNPipe;               external;
function DosRawWriteNPipe;              external;
function DosRead;                       external;
function DosReadQueue;                  external;
function DosRegisterPerfCtrs;           external;
function DosReleaseMutexSem;            external;
function DosRequestMutexSem;            external;
function DosRequestVDD;                 external;
function DosResetBuffer;                external;
function DosResetEventSem;              external;
function DosResumeThread;               external;
function DosScanEnv;                    external;
function DosSearchPath;                 external;
function DosSelectSession;              external;
function DosSendSignalException;        external;
function DosSetCurrentDir;              external;
function DosSetDOSProperty;             external;
function DosSetDateTime;                external;
function DosSetDefaultDisk;             external;
function DosSetExceptionHandler;        external;
function DosSetFHState;                 external;
function DosSetFSInfo;                  external;
function DosSetFileInfo;                external;
function DosSetFileLocks;               external;
function DosSetFilePtr;                 external;
function DosSetFileSize;                external;
function DosSetMaxFH;                   external;
function DosSetMem;                     external;
function DosSetNPHState;                external;
function DosSetNPipeSem;                external;
function DosSetPathInfo;                external;
function DosSetPriority;                external;
function DosSetProcessCp;               external;
function DosSetRelMaxFH;                external;
function DosSetSession;                 external;
function DosSetSignalExceptionFocus;    external;
function DosSetVerify;                  external;
function DosShutdown;                   external;
function DosSleep;                      external;
function DosStartSession;               external;
function DosStartTimer;                 external;
function DosStopSession;                external;
function DosStopTimer;                  external;
function DosSubAllocMem;                external;
function DosSubFreeMem;                 external;
function DosSubSetMem;                  external;
function DosSubUnsetMem;                external;
function DosSuspendThread;              external;
function DosTmrQueryFreq;               external;
function DosTmrQueryTime;               external;
function DosTransactNPipe;              external;
function DosUnsetExceptionHandler;      external;
function DosUnwindException;            external;
function DosWaitChild;                  external;
function DosWaitEventSem;               external;
function DosWaitMuxWaitSem;             external;
function DosWaitNPipe;                  external;
function DosWaitThread;                 external;
function DosWrite;                      external;
function DosWriteQueue;                 external;
function KbdCharIn;                     external;
function KbdClose;                      external;
function KbdDeRegister;                 external;
function KbdFlushBuffer;                external;
function KbdFreeFocus;                  external;
function KbdGetCp;                      external;
function KbdGetFocus;                   external;
function KbdGetHwId;                    external;
function KbdGetStatus;                  external;
function KbdOpen;                       external;
function KbdPeek;                       external;
function KbdRegister;                   external;
function KbdSetCp;                      external;
function KbdSetCustXt;                  external;
function KbdSetFgnd;                    external;
function KbdSetHwId;                    external;
function KbdSetStatus;                  external;
function KbdStringIn;                   external;
function KbdSynch;                      external;
function KbdXlate;                      external;
function MouClose;                      external;
function MouDeRegister;                 external;
function MouDrawPtr;                    external;
function MouFlushQue;                   external;
function MouGetDevStatus;               external;
function MouGetEventMask;               external;
function MouGetHotKey;                  external;
function MouGetNumButtons;              external;
function MouGetNumMickeys;              external;
function MouGetNumQueEl;                external;
function MouGetPtrPos;                  external;
function MouGetPtrShape;                external;
function MouGetScaleFact;               external;
function MouGetThreshold;               external;
function MouInitReal;                   external;
function MouOpen;                       external;
function MouReadEventQue;               external;
function MouRegister;                   external;
function MouRemovePtr;                  external;
function MouSetDevStatus;               external;
function MouSetEventMask ;              external;
function MouSetHotKey;                  external;
function MouSetPtrPos ;                 external;
function MouSetPtrShape;                external;
function MouSetScaleFact ;              external;
function MouSetThreshold;               external;
function MouSynch;                      external;
function NlsConvertBidiNumerics;        external;
function NlsConvertBidiString;          external;
function NlsEditShape;                  external;
function NlsInverseString;              external;
function NlsQueryBidiAtt;               external;
function NlsSetBidiAtt;                 external;
function NlsSetBidiPrint;               external;
function NlsShapeBidiString;            external;
function VioCheckCharType;              external;
function VioDeRegister;                 external;
function VioEndPopUp;                   external;
function VioGetAnsi;                    external;
function VioGetBuf;                     external;
function VioGetConfig;                  external;
function VioGetCp;                      external;
function VioGetCurPos;                  external;
function VioGetCurType;                 external;
function VioGetFont;                    external;
function VioGetMode;                    external;
function VioGetPhysBuf;                 external;
function VioGetState;                   external;
function VioModeUndo;                   external;
function VioModeWait;                   external;
function VioPopUp;                      external;
function VioPrtSc;                      external;
function VioPrtScToggle;                external;
function VioReadCellStr;                external;
function VioReadCharStr;                external;
function VioRegister;                   external;
function VioSavRedrawUndo;              external;
function VioSavRedrawWait;              external;
function VioScrLock;                    external;
function VioScrUnLock;                  external;
function VioScrollDn;                   external;
function VioScrollLf;                   external;
function VioScrollRt;                   external;
function VioScrollUp;                   external;
function VioSetAnsi;                    external;
function VioSetCp;                      external;
function VioSetCurPos;                  external;
function VioSetCurType;                 external;
function VioSetFont;                    external;
function VioSetMode;                    external;
function VioSetState;                   external;
function VioShowBuf;                    external;
function VioWrtCellStr;                 external;
function VioWrtCharStr;                 external;
function VioWrtCharStrAtt;              external;
function VioWrtNAttr;                   external;
function VioWrtNCell;                   external;
function VioWrtNChar;                   external;
function VioWrtTTY;                     external;
procedure DosFlatToSel;                 external;
procedure DosSelToFlat;                 external;
{function VioRedrawSize;                 external;}

end.
