#include "stdafx.h"
#include "zedit.h"

IMPLEMENT_DYNAMIC (ZEdit, CEdit)


ZEdit::ZEdit (COLORREF cTextColor, COLORREF cBkColor) :
       m_cTextColor (cTextColor), m_cBkColor (cBkColor)
{
    m_hBkBrush = ::CreateSolidBrush (cBkColor);
    if (m_hBkBrush == NULL)
        TRACE0 ("ZEdit::ZEdit - CreateSolidBrush failed. "
                "Enhancements will not work.\n");
}

// ZEdit virtual destructor. Deletes the brush.
ZEdit::~ZEdit ()
{
    if (m_hBkBrush)
        DeleteObject (m_hBkBrush);
}

// GetSuperWndProcAddr. MFC Override. Has to be there in 
// MFC 2.5. This function is obsolete in MFC 3.0 and 
// therefore not required.

#if (_MFC_VER < 0x0300)        // Required only for MFC 2.5

WNDPROC* ZEdit::GetSuperWndProcAddr ()
{
    static WNDPROC pfnSuper;
    return &pfnSuper;
}
#endif      // MFC 2.5

void ZEdit::SetTextColor (COLORREF cColor, BOOL bRedraw)
{
    m_cTextColor = cColor;
    if (bRedraw)
        Redraw ();
}

// SetBkColor - delete the old brush and create a new one.
void ZEdit::SetBkColor (COLORREF cColor, BOOL bRedraw)
{
    if (m_hBkBrush) 
        DeleteObject (m_hBkBrush);
    m_cBkColor = cColor;
    m_hBkBrush = ::CreateSolidBrush (m_cBkColor);
    if (m_hBkBrush == NULL) {
        TRACE0 ("ZEdit::ZEdit - CreateSolidBrush failed. "
                " Enhancements will not work.\n");
    }
    if (bRedraw)
        Redraw ();
}

// OnChildNotify. Overriden virtual function.
// Parameters: Message, wParam, lParam, and a pointer to 
// the return value which you would have returned if you 
// trapped the message in a C WndProc.
// Returns: TRUE if the message is WM_CTLCOLOR to indicate 
// that this window has handled the message. For other 
// messages, call the base class version.

// This function is called by the framework, whenever the 
// edit control sends a message to the parent (i.e. the 
// dialog). The framework dialog procedure immediately 
// redirects this message to the control itself. 
// Returning FALSE would pass this message back to 
// the parent.
// If message is WM_CTLCOLOR, then call 
// DoCtlColorProcessing. 

// In Win32, WM_CTLCOLOR messages have been split into
// messages for individual controls.

BOOL ZEdit::OnChildNotify (UINT message, WPARAM wParam, 
        LPARAM lParam, LRESULT *pLResult)
{
#ifdef WIN32
    if (message == WM_CTLCOLOREDIT) {
#else
    if (message == WM_CTLCOLOR) {
#endif
        *pLResult = (LRESULT)DoCtlColorProcessing 
                                        (wParam, lParam);
        return TRUE;
    }
    else
        return CEdit::OnChildNotify (message, 
                    wParam, lParam, pLResult);
}

// Redraw.
// Forces a redraw of the control. Need not be called by 
// the user. Typically called by setting the redraw flag 
// ON in one of the Set property functions.
void ZEdit::Redraw (void)
{
    InvalidateRect (NULL);
    UpdateWindow ();
}

// DoCtlColorProcessing - protected helper function 
// handling the WM_CTLCOLOR message.
// Parameters: wParam, lParam.
// wParam - HDC of the control. lParam not used in this 
// function. In Win16 contains: HIWORD - type of control. 
// LOWORD - Handle of control. In Win32, lParam contains 
// HANDLE of the control.
// Returns: Background brush.
// Called from OnChildNotify.
// Set the mode to transparent to handle dithered colors.
// Note that passing a dithered color to a multiline edit
// control will cause repaint problems. For more details,
// refer to the MSDN article: PSS ID Number: Q698885
// "SetBkColor () does not support dithered colors"

HBRUSH ZEdit::DoCtlColorProcessing (WPARAM wParam, 
                                LPARAM lParam)
{
    HDC hDC = (HDC)wParam;
    ::SetBkColor (hDC, m_cBkColor);
    ::SetTextColor (hDC, m_cTextColor);
    return m_hBkBrush;
}

