/*
**  TEST.C
**    Test program demonstrating Windows 3.1 DeleteObject
**    bug.  CAUTION!! SAVE YOUR WORK AND CLOSE OTHER
**    APPLICATIONS BEFORE RUNNING THIS PROGRAM.
**
**    Created with Borland C++ 4.5
*/

#include <windows.h>
#include <string.h>

#define CM_CREATEFONTINDIRECT   101
#define CM_GLOBALCOMPACT        102
#define CM_DELETEOBJECT         103
#define CM_DELETEFONTOBJECT     104
#define CM_EXIT                 105

#define FONT_FACENAME           "Arial"
#define FONT_SIZE               12
#define FONT_WEIGHT             FW_BOLD

BOOL CALLBACK DlgProc(HWND, UINT, WPARAM, LPARAM);
void    UpdateMenu(HWND, HFONT);
void    DrawSomeText(HWND, HFONT, LONG);
HFONT   DoCreateFontIndirect(HWND);
BOOL    DoDeleteObject(HFONT);
BOOL    DeleteFontObject(HFONT);

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance,
        HINSTANCE hPrevInstance, LPSTR lpszCmdLine,
        int nCmdShow)
{
    if (DialogBox(hInstance, "#1000", NULL, DlgProc) < 0)
        OutputDebugString("WinMain: DialogBox failed\n\r");

    return(0);
}


BOOL CALLBACK _export DlgProc(HWND hDlg, UINT iMessage,
        WPARAM wParam, LPARAM lParam)
{
    static HFONT    hFont;

    switch(iMessage) {
        case WM_INITDIALOG:
            UpdateMenu(hDlg, NULL);
            break;
        case WM_LBUTTONDOWN:
            if (hFont != NULL)
                DrawSomeText(hDlg, hFont, lParam);
            break;
        case WM_COMMAND:
            switch(wParam) {
                case CM_CREATEFONTINDIRECT:
                    hFont = DoCreateFontIndirect(hDlg);
                    break;
                case CM_GLOBALCOMPACT:
                    GlobalCompact((DWORD)-1);
                    break;
                case CM_DELETEOBJECT:
                    DoDeleteObject(hFont);
                    hFont = NULL;
                    break;
                case CM_DELETEFONTOBJECT:
                    DeleteFontObject(hFont);
                    hFont = NULL;
                    break;
                case CM_EXIT:
                    PostMessage(hDlg, WM_CLOSE, 0, 0L);
                    break;
            }
            UpdateMenu(hDlg, hFont);
            return(TRUE);
        case WM_CLOSE:
            if (hFont != NULL)
                DeleteObject(hFont);
            hFont = NULL;
            EndDialog(hDlg, 0);
            return(TRUE);
    }
    return(FALSE);
}


void UpdateMenu(HWND hwnd, HFONT hFont)
{
    HMENU   hMenu;
    UINT    createFlags;
    UINT    deleteFlags;

    if (hFont != NULL) {
        createFlags = MF_DISABLED | MF_GRAYED;
        deleteFlags = MF_ENABLED;
    } else {
        createFlags = MF_ENABLED;
        deleteFlags = MF_DISABLED | MF_GRAYED;
    }

    hMenu = GetMenu(hwnd);
    if (hMenu != NULL) {
        EnableMenuItem(hMenu, CM_CREATEFONTINDIRECT,
                        createFlags);
        EnableMenuItem(hMenu, CM_DELETEOBJECT,
                        deleteFlags);
        EnableMenuItem(hMenu, CM_DELETEFONTOBJECT,
                        deleteFlags);
    }
}


void DrawSomeText(HWND hwnd, HFONT hFont, LONG lParam)
{
    RECT    r;
    HFONT   hOldFont;
    HDC     hdc;
    int     x, y;

    x = LOWORD(lParam);
    y = HIWORD(lParam);
    SetRect(&r, x, y, x + 200, y + 20);

    hdc = GetDC(hwnd);
    if (hdc != NULL) {
        hOldFont = SelectObject(hdc, hFont);
        DrawText(hdc, "DrawText Test", 13, &r, 0);
        if (hOldFont)
            SelectObject(hdc, hOldFont);
        ReleaseDC(hwnd, hdc);
    }
}


/*
**  DoCreateFontIndirect()
**      Creates a font based on the FONT_xxx defines at the
**      top of this file.  Returns a handle to the logical
**      font (HFONT).
*/
HFONT DoCreateFontIndirect(HWND hwnd)
{
    LOGFONT lf;
    HDC     hdc;
    HFONT   hFont;
    int     pelsPerInch;

    hFont   = NULL;
    hdc     = GetDC(hwnd);
    if (hdc != NULL) {
        pelsPerInch = GetDeviceCaps(hdc, LOGPIXELSY);
        ReleaseDC(hwnd, hdc);

        memset(&lf, 0, sizeof(LOGFONT));
        lf.lfHeight = -MulDiv(FONT_SIZE, pelsPerInch, 72);
        lf.lfWeight = FONT_WEIGHT;
        lstrcpy(lf.lfFaceName, FONT_FACENAME);
        hFont = CreateFontIndirect(&lf);
    }

    return(hFont);
}


/*
**  DoDeleteObject()
**      Deletes the given font after doing some sanity
**      checks.
*/
BOOL DoDeleteObject(HFONT hFont)
{
    if (hFont != NULL && IsGDIObject(hFont))
        return(DeleteObject(hFont));

    OutputDebugString("DoDeleteObject: Bad font!\n\r");
    return(FALSE);
}


/*
**  DoDeleteFontObject()
**      Deletes the given font safely avoiding the
**      DeleteObject bug.
*/
BOOL DeleteFontObject(HFONT hDeleteFont)
{
    HDC     hdc;
    HFONT   hOldFont;

    /*
    **  Selecting the font into a device context causes
    **  Windows to recreate global memory that may have
    **  been discarded.
    */
    hdc = GetDC(NULL);          /* get screen DC */
    if (hdc != NULL) {
        hOldFont = SelectObject(hdc, hDeleteFont);
        if (hOldFont)
            SelectObject(hdc, hOldFont);
        ReleaseDC(NULL, hdc);
    }

    /* Now it's safe to delete */
    return(DeleteObject(hDeleteFont));
}

