/* Resource decryption library, Written by A.Salvatucci, 1994 */

#include <windows.h>
#include <windowsx.h>
#include <io.h>
#include <fcntl.h>              
#include <string.h>
#include "encdec.h"

/*** Default decryption function prototype ***/
int CALLBACK crDefEncDecABuffer(BYTE FAR *buffer,WORD len);

/*** Our custom resource loader prototype ***/
HGLOBAL CALLBACK LoadResourceProc(HGLOBAL hglbmem,
                        HINSTANCE hinst, HRSRC hrscResInfo);

CRPROC        crDecryptABufferProc = crDefEncDecABuffer;

/* crDecryptON - Turn ON decryption for given res type. */
int crDecryptON ( HINSTANCE hAnInstance,LPCSTR lpResType )
{
    SetResourceHandler(    hAnInstance,lpResType,
                        (RSRCHDLRPROC)LoadResourceProc);
    return CR_SUCCESS;
}

/* crSetDecryptHandler -  Set a decryption function  */
int crSetDecryptHandler( CRPROC lpADecryptHandler )
{
    crDecryptABufferProc = lpADecryptHandler;
    return CR_SUCCESS;
}

/* LoadResourceProc - custom resource handler.
**    Returns NULL on error                     */
HGLOBAL CALLBACK _export LoadResourceProc(HGLOBAL hglbmem,
                         HINSTANCE hinst,HRSRC hrscResInfo)
{
NAMEINFO FAR *lpResInfo;
BYTE     FAR *lpResData,*lpModTable;
int         h,rc;
char        filename[128];
DWORD       dwOffset;
WORD        wAlignment = 9;
HMODULE     hmodule;

    /* Check if resource already in memory */
    if ( (hglbmem) && (GlobalLock(hglbmem)) )
    {
        GlobalUnlock(hglbmem);
        return hglbmem;
    }

    /* Get module file name */
    hmodule = GetInstanceModule(hinst);
    rc = GetModuleFileName(hmodule,
                            filename,sizeof(filename));
    if (!rc)
        return NULL;

    /* Get ptr to module table */
    lpModTable  = (BYTE FAR *)GlobalLock(hmodule);

    /* Get shift alignment */
    wAlignment = *( (WORD FAR *)(lpModTable +
                    *((WORD FAR *)(lpModTable+0x24))) );

    /* Get ptr to NAMEINFO struct */ 
    lpResInfo     = (NAMEINFO FAR *)(    lpModTable +
                                    (WORD)hrscResInfo);

    dwOffset = ((DWORD)lpResInfo->wOffset) << wAlignment;

    h = open(filename,O_RDONLY|O_BINARY);
    if (h<0)
    {
        GlobalUnlock(hmodule);
        return NULL;
    }

    /* Alloc space for resource data */
    if(!hglbmem)
        hglbmem = GlobalAlloc(GMEM_SHARE|GMEM_MOVEABLE|
            GMEM_DISCARDABLE, lpResInfo->wLength<<wAlignment);
    else
        hglbmem = GlobalReAlloc(hglbmem, lpResInfo->
            wLength<<wAlignment, GMEM_MODIFY);
    if (!hglbmem)
    {
        close(h);
        GlobalUnlock(hmodule);
        return NULL;
    }

    /* Save the resource data global handle */
    lpResInfo->hResSeg = (WORD)hglbmem;

    lpResData = (BYTE far *)GlobalLock(hglbmem);
    if (!lpResData)
    {
        GlobalFree(hglbmem);
        close(h);
        GlobalUnlock(hmodule);
        return NULL;
    }

    /* Load resource data from disk */
    lseek(h,dwOffset,SEEK_SET);
    rc = read(h,lpResData,
                (1<<wAlignment)*lpResInfo->wLength);

    /* Call Decryption function */
    crDecryptABufferProc(lpResData,rc);

    close(h);
    GlobalUnlock(hmodule);
    GlobalUnlock(hglbmem);
    return hglbmem;
}
