/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 10                        
                                                                            
Shows the difference between normal and xray putblock modes                 
and demonstrates the flipblock procedure.                                   
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <wgt4.h>

int i,x,y;
int oldmode;
color palette[256];
block part1;			/* part of the screen */

void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }
  oldmode=wgetmode();
  vga256();

  for (y = 40; y >= 4; y--)
  {
    wfill_circle(y + 40,y + 10,y);	/* draw a pattern */
    wsetcolor(y+20);
  }

  part1 = wnewblock(0,0,160,100);	/* get the circle in a block */
  wcls(0);

  for (x = 0; x < 320; x++)
  {
    wsetcolor(x);
    wline(x,0,x,199);
  }

  getch();
  wputblock(160,0,part1,0);		/* normal mode */
  wflipblock(part1, 0);

  getch();
  wputblock(160,100,part1,1);		/* XRAY mode */
  wflipblock(part1, 1);

  getch();
  wputblock(0,100,part1,0);		/* normal mode */
  wflipblock(part1, 0);

  getch();
  wputblock(0,0,part1,1);		/* XRAY mode */

  getch();
  wfreeblock(part1);
  wsetmode(oldmode);
}