{$A-,B-,D+,F-,G+,I-,K-,L+,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y+}
{$M 8192,8192}
{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Screen Saver Demo for Windows                }
{   Copyright (c) 1992 by Thomas Hvel           }
{   Requires 'The Lights Go Down'                }
{                                                }
{************************************************}

{ This file is bi-lingual: German and English
  Diese Datei ist zweisprachig: Deutsch und Englisch

  This file contains a sample LGD module.
  You'll find further information in API.HLP.
  Define ENGLISH to compile the English version.

  LGD searches all SS_*.LGD files in its own directory.
  Note: If you add an Debug=1 entry in the LGD section of WEEP.INI,
	LGD will search for SS_*.DLL instead of *.LGD. This is useful
	for TPW programmers!

  The DLL (which will be renamed to LGD in the retail version) contains
  4 function:
    ScreenSaverID      index 17
    ScreenSaverOptions index 18
    ScreenSaver        index 19
    ScreenSaverAbout   index 20

  ScreenSaverID identifies the screen saver. It reports name and description
    and functions supported by the saver.
  ScreenSaver is the function that actual draws. It registers a Window class,
    opens a windows and waits for WM_QUIT.
  ScreenSaverAbout may be empty. It gives the author a good chance to make
    his name known to the user.
  ScreenSaverOptions may be empty, too. Allows the user to change screen saver
    parameters which should be saved in an .INI-file.

  Die Parameter der einzelnen Funktionen werden weiter unten beschrieben.
  ************************************************************************

  Diese Datei zeigt das Grundgeruest eines LGD-Bildschirmschoners.
  Weitere Informationen finden Sie in API.HLP

  LGD sucht nach Dateien, die dem Schema SS_*.LGD entsprechen. Die .LGD-
  Dateien sind normale .DLLs, die lediglich umbenannt wurden.

  Tip fr TPW: In der Datei WEEP.INI kann im Abschnitt [LGD] der Eintrag
  Debug=1 eingefgt werden. Danach sucht LGD nach SS_*.DLL, d.h. zum Testen
  mu die DLL nicht mehr umbenannt werden.

  Grundsaetzlicher Aufbau:

  Die .DLL (spaeter SS_*.LGD genannt) stellt folgende vier Funktionen
  zur Verfgung:
    ScreenSaverID      index 17
    ScreenSaverOptions index 18
    ScreenSaver        index 19
    ScreenSaverAbout   index 20

  ScreenSaverID dient zur Identifikation. Sie bergibt Namen und Beschreibung
    des Schoners und zeigt an, welche Funktionen untersttzt werden.
  ScreenSaver ist der eigentliche Schoner. In der Regel wird diese Funktion
    eine Fensterklasse eintragen, ein Fenster oeffnen und auf WM_QUIT warten.
  ScreenSaverAbout ist eine optionale Funktion. Sie ermglicht dem Autor
    eines Schoner-Moduls eine angemessene Selbstdarstellung.
  ScreenSaverOptions erlaubt dem Benutzer, bestimmte Parameter des Schoners
    zu veraendern. Diese Parameter sollten in einer .INI-Datei gespeichert
    werden. Diese Funktion ist optional.

  Die Parameter der einzelnen Funktionen werden weiter unten beschrieben.

}

{$c preload}

{$define COL256}  { untersttzung fr farbpalette mit 256 farben }
		  { use color palettes with 256 colors }

{ $define RUN}   { RUN: standalone (.EXE), or .DLL }
{$ifndef RUN}
library ss_Crawl;
{$endif}


{$ifdef ENGLISH}
  {$d Crawler: LGD Screen Saver (c) 1993 Thomas Hvel}
  {$r se_crawl.res}
{$else}
  {$d Crawler: Bildschirmschoner (c) 1993 Thomas Hvel}
  {$r ss_crawl.res}
{$endif}

uses
{$ifdef COL256}
  ssCommon,            { definitionen fr farbpalette / definitions for color palette }
{$endif}
  WinTypes, WinProcs, lm_lgd, strings
{$ifdef USESOUNDS}
  , iSounds
{$endif}
  ;

const AppName = 'LGD_Crawler';
      Ini     = 'WEEP.INI';
{$ifdef ENGLISH}
      HELPTEXT : array[0..24]of char = 'Gummyworms'' Options'#0;
{$else}
      HELPTEXT : array[0..24]of char = 'Optionen von Crawler'#0;
{$endif}
      HELPFILE = 'LGD.HLP';

var
    lEndTime: LongInt;   { zeitdauer (fr Randomizer), period (for Randomizer) }
    lTime, lTmp: LongInt;
    fExit: LongInt;      { ende durch eingabe ?, ended by user action? }
{$ifdef COL256}
    pif: PInterFace;     { zeiger auf parameterstruktur (von LGD bergeben) }
			 { parameters received from LGD }
{$endif}
    cxClient, cyClient: integer;

const MAXTAIL = 100;
      MAXWORM = 50;
      __MAXTAIL:integer = 20;
      __MAXWORM:integer = 20;
      __TURBO: integer = 0;

type
     TPosition = record
       x, y: integer;
     end;
      
     TailType = record
       head, tail: integer;
       TailPos: array [1..MAXTAIL] of TPosition;
     end;

     CrawlerType = record
       xPos, yPos: integer;
       Dir: integer;
       l, m, d: TColorRef;
       Tail: TailType;
     end;

var Crawlers: array [1..MAXWORM] of CrawlerType;
{$ifdef USESOUNDS}
  cSoundTime:integer;
{$endif}



var fLocalHelp: boolean;

function Options(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export;
var trans: bool;
begin
  Options := True;
  case Message of
    wm_InitDialog:
      begin
	fLocalHelp := FALSE;
	SetDlgItemInt (Dialog, 103, __MAXWORM, FALSE);
	SetDlgItemInt (Dialog, 104, __MAXTAIL, FALSE);
	SetDlgItemInt (Dialog, 105, __TURBO, FALSE);
{$ifdef USESOUNDS}
	if THSndVersion > 0 then
	  ShowWindow (GetDlgItem (dialog, 199), sw_normal);
{$endif}
	Exit;
      end;
    wm_Command:
      if (WParam = 1) or (WParam = id_Cancel) then
	begin
	  if (wParam = 1) then
	    begin
	      __MAXWORM := GetDlgItemInt (Dialog, 103, @trans, FALSE);
	      __MAXTAIL := GetDlgItemInt (Dialog, 104, @trans, FALSE);
	      __TURBO   := GetDlgItemInt (Dialog, 105, @trans, FALSE);
	      if __MAXTAIL < 2 then
		__MAXTAIL := 2
	      else if __MAXTAIL > MAXTAIL then
		__MAXTAIL := MAXTAIL;
	      if __MAXWORM < 1 then
		__MAXWORM := 1
	      else if __MAXWORM > MAXWORM then
		__MAXWORM := MAXWORM;
	      if __TURBO < 0 then
		__TURBO := 0
	      else if __TURBO > 9999 then
		__TURBO := 9999;
	    end;
	  if fLocalHelp then
	    WinHelp (Dialog, HelpFile, help_Quit, 0);
	  EndDialog(Dialog, 1);
	  Exit;
	end
      else if (wParam = 102) then
	begin
	  WinHelp (dialog, HELPFILE, help_Key, LONGINT (@HELPTEXT));
	  fLocalHelp := TRUE;
	  exit;
	end
{$ifdef USESOUNDS}
      else if (wParam = 199) then
	begin
	  THSndOptions (AppName, dialog);
	end
{$endif}
	;
  end;
  Options := False;
end;





Procedure DrawSegment (dc:hdc; xPos, yPos: integer; l,m,d: TColorRef);
var x, y: integer;
    lb:TLogBrush;
    Brush: hBrush;
    Pen: hPen;
begin
  dec (xPos, 3);  { adresse des mittelpunkts bergeben }
  dec (yPos, 3);  { received address of center }

  lb.lbStyle := bs_Solid;
  lb.lbColor := m;
  lb.lbHatch := 0;
  Brush := CreateBrushIndirect (lb);

  Brush := SelectObject (dc, Brush);
  Pen := SelectObject (dc, GetStockObject (NULL_PEN));
  Rectangle (dc, xPos + 2, yPos + 2, xPos + 8, yPos + 8);
  DeleteObject (SelectObject (dc, Brush));
  Pen := SelectObject (dc, CreatePen (ps_Solid, 1, l));
  MoveTo (dc, xPos + 1, yPos + 6);
  LineTo (dc, xPos + 1, yPos + 1);
  LineTo (dc, xPos + 8, yPos + 1);
  MoveTo (dc, xPos, yPos + 2);
  LineTo (dc, xPos, yPos + 7);
  MoveTo (dc, xPos + 2, yPos);
  LineTo (dc, xPos + 7, yPos);
  DeleteObject (SelectObject (dc, Pen));
  Pen := SelectObject (dc, CreatePen (ps_Solid, 1, d));
  MoveTo (dc, xPos + 1, yPos + 7);
  LineTo (dc, xPos + 7, yPos + 7);
  LineTo (dc, xPos + 7, yPos + 1);
  MoveTo (dc, xPos + 2, yPos + 8);
  LineTo (dc, xPos + 7, yPos + 8);
  MoveTo (dc, xPos + 8, yPos + 2);
  LineTo (dc, xPos + 8, yPos + 7);
  DeleteObject (SelectObject (dc, Pen));
end;

Procedure InitCrawlers;
var i, j: integer;
begin
  for j := 1 to __MAXWORM do
    with Crawlers [j] do
      begin
	for i := 1 to __MAXTAIL do
	  begin
	    Tail.TailPos [i].x := -17;
	    Tail.TailPos [i].y := -17;
	  end;
	xPos := random (cxClient);
	yPos := random (cyClient);
	dir  := random (16 * 4);
	Tail.tail := 1;
	Tail.head := __MAXTAIL;
	if (pif <> nil) then
	  begin
	    i := random (7);
	    l := PaletteIndex (ColorIndexesColorScales [i * 8 + 7]);
	    m := PaletteIndex (ColorIndexesColorScales [i * 8 + 5]);
	    d := PaletteIndex (ColorIndexesColorScales [i * 8 + 3]);
	  end
	else
	  begin
	    i := random (7);
	    case i of
	      0: begin
		   l := RGB (255, 255, 255); { grau / grey}
		   m := RGB (192, 192, 192);
		   d := RGB (128, 128, 128);
		 end;
	      1: begin
		   l := RGB (255, 255, 0); { gelb / yellow }
		   m := RGB (192, 192, 0);
		   d := RGB (128, 128, 0);
		 end;
	      2: begin
		   l := RGB (0, 255, 255); { cyan }
		   m := RGB (0, 192, 192);
		   d := RGB (0, 128, 128);
		 end;
	      3: begin
		   l := RGB (0, 0, 255);   { blau / blue }
		   m := RGB (0, 0, 192);
		   d := RGB (0, 0, 128);
		 end;
	      4: begin
		   l := RGB (255, 0, 0);   { rot / red}
		   m := RGB (192, 0, 0);
		   d := RGB (128, 0, 0);
		 end;
	      5: begin
		   l := RGB (255, 0, 255);   { magenta }
		   m := RGB (192, 0, 192);
		   d := RGB (128, 0, 128);
		 end;
	      6: begin
		   l := RGB (0, 255, 0);   { grn / green }
		   m := RGB (0, 192, 0);
		   d := RGB (0, 128, 0);
		 end;
	    end;                           { german and english share the same roots ... }
	  end;
      end;
end;

Procedure MoveCrawlers (dc: hDC);
var i,j:integer;
begin
  for i := 1 to __MAXWORM do
    with Crawlers [i] do
      begin
	DrawSegment (dc, Tail.TailPos [Tail.Tail].x, Tail.TailPos [Tail.Tail].y, 0, 0, 0);
	DrawSegment (dc, xPos, yPos, l, m, d);
	Tail.TailPos [Tail.Head].x := xPos;
	Tail.TailPos [Tail.Head].y := yPos;
	inc (Tail.Head);
	if Tail.Head > __MAXTAIL then
	  Tail.Head := 1;
	inc (Tail.Tail);
	if Tail.Tail > __MAXTAIL then
	  Tail.Tail := 1;
	case Dir div 4 of
	  0: begin inc (xPos, 6); end;
	  1: begin inc (xPos, 4); inc (yPos, 2); end;
	  2: begin inc (xPos, 3); inc (yPos, 3); end;
	  3: begin inc (xPos, 2); inc (yPos, 4); end;
	  4: begin                inc (yPos, 6); end;
	  5: begin dec (xPos, 2); inc (yPos, 4); end;
	  6: begin dec (xPos, 3); inc (yPos, 3); end;
	  7: begin dec (xPos, 4); inc (yPos, 2); end;
	  8: begin dec (xPos, 6); end;
	  9: begin dec (xPos, 4); dec (yPos, 2); end;
	 10: begin dec (xPos, 3); dec (yPos, 3); end;
	 11: begin dec (xPos, 2); dec (yPos, 4); end;
	 12: begin                dec (yPos, 6); end;
	 13: begin inc (xPos, 2); dec (yPos, 4); end;
	 14: begin inc (xPos, 3); dec (yPos, 3); end;
	 15: begin inc (xPos, 4); dec (yPos, 2); end;
	end;
	j := integer (random (5)) - 2;
	dir := dir + j;
	if xPos >= cxClient then
	  begin
	    xPos := cxClient-1;
	    dir := 8 * 4;
	  end;
	if xPos < 0 then
	  begin
	    xPos := 0;
	    dir := 0;
	  end;
	if yPos >= cyClient then
	  begin
	    yPos := cyClient -1;
	    dir := 12 * 4;
	  end;
	if yPos < 0 then
	  begin
	    yPos := 0;
	    dir := 4 * 4;
	  end;
	dir := dir and 63;
      end;
end;

{ WindowProc des Bildschirmschoners }
{ In der Regel wird der Schoner ber WM_TIMER bzw. ber PeekMessage bestimmte
  Zeichenaktionen ausloesen.
}
{ Screen Saver's WindowProc }
{ Typically the screen saver will draw something on WM_TIMER messages or
  using PeekMessage.
}


function WindowProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint; export;
var
  hMen: hMenu;
  fFlag: Bool;
  w: Word;
  ps: TPaintStruct;
  dc: HDC;
  hOldPal: hPalette;
  lRet: LongInt;
begin
  WindowProc := 0;
  if (LgdDefProc (lRet, window, Message, wParam, lParam)) then
    begin
      WindowProc := lRet;
      exit;
    end;

  case Message of
    wm_Paint:
      begin
	dc := BeginPaint (window, ps);
{$ifdef COL256}
(*      keine aktion bei wm_Paint
	if pif <> nil then
	  begin
	    hOldPal := SelectPalette (dc, pif^.hPal, FALSE);
	    RealizePalette(dc);                    
	  end;
		  { hier: eigene zeichenroutinen einbauen }
		  { may add own drawing routines here }
	if pif <> nil then
	  SelectPalette (dc, hOldPal, FALSE);
*)
{$endif}
	EndPaint (window, ps);
	exit;
      end;

    wm_QUERYNEWPALETTE:
      begin
	if pif <> nil then
	  begin
	    dc := GetDC (window);
	    hOldPal := SelectPalette (dc, pif^.hPal, FALSE);
	    lRet := RealizePalette(dc);
	    SelectPalette (dc, hOldPal, FALSE);
(*          the screen is either black or not erased - so do nothing now
	    "normal" applications would invalidate to redraw the window *)
(*          bildschirm ist schwarz oder durchsichtig - eine applikation wrde jetzt neu zeichnen 
	    if lRet > 0 then
	      InvalidateRect (window, nil, FALSE);*)
	    ReleaseDC (window, dc);
	  end
	else
	  lRet := 0;
	WindowProc := lRet;
	exit;
      end;

    wm_PaletteChanged:
      begin
	if (pif <> nil) and (wParam <> Window) then
	  begin
	    dc := GetDC (window);
	    hOldPal := SelectPalette (dc, pif^.hPal, FALSE);
	    lRet := RealizePalette(dc);
	    SelectPalette (dc, hOldPal, FALSE);
(*          see note above *)
(*          bildschirm ist schwarz oder durchsichtig - eine applikation wrde jetzt neu zeichnen 
	    if lRet > 0 then
	      InvalidateRect (window, nil, FALSE);*)
	    ReleaseDC (window, dc);
	  end
	else
	  lRet := 0;
	WindowProc := lRet;
	exit;
      end;

    wm_Create:
      begin
      end;

    wm_EraseBkgnd:
      begin
	WindowProc := 1;
	exit;
      end;

   wm_Size:
      begin
	cxClient := LOWORD (lParam);
	cyClient := HIWORD (lParam);
	exit;
      end;

    wm_Timer:
      begin
	if GetCurrentTime >= lEndTime then
	  begin
	    fExit := 0;             { normal timeout - randomizer continues }
	    DestroyWindow (window);
	    exit;
	  end;
{$ifdef USESOUNDS}
	dec (cSoundTime);
	if cSoundTime < 0 then
	  begin
	    THSndRandom (AppName, FALSE);
	    cSoundTime := 10 + random (10);
	  end;
{$endif}
      end;

    wm_KillFocus:
      begin
	if fExit = -1 then
	  begin    { ende vorbereiten }
	    PostMessage (window, wm_Close, 0, 0);
	  end;
      end;


    wm_KeyDown,          { jeder tastendruck beendet den Saver }
    wm_Close,            { any key terminates screen saver }
    wm_lButtonDown,
    wm_mButtonDown,
    wm_rButtonDown:
      begin
	fExit := 1;   { randomizer mu zwischen timeout und abbruch unterscheiden knnen! }
		      { tells randomizer to exit (no timeout) }
	DestroyWindow (window);
	exit;
      end;

    wm_Destroy:
      begin
	KillTimer (window, 1000);
	PostQuitMessage(0);
	Exit;
      end;
  end;
  WindowProc := DefWindowProc(Window, Message, WParam, LParam);
end;



Procedure ReadProfile;
begin
  __MAXWORM := GetPrivateProfileInt (appname, 'Anzahl', 10, Ini);
  __MAXTAIL := GetPrivateProfileInt (appname, 'Lnge', 10, Ini);
  __TURBO := GetPrivateProfileInt (appname, 'lDelay', 20, Ini);
end;

Procedure WriteProfile;
var s:string;
begin
  str (__MAXWORM, s);
  s := s + #0;
  WritePrivateProfileString (AppName, 'Anzahl', @s[1], Ini);
  str (__MAXTAIL, s);
  s := s + #0;
  WritePrivateProfileString (AppName, 'Lnge', @s[1], Ini);
  str (__TURBO, s);
  s := s + #0;
  WritePrivateProfileString (AppName, 'lDelay', @s[1], Ini);
end;





{ ScreenSaver - duration: Laufzeit (in Sekunden), <= 0 -> unendlich
		Flags   : reserviert (pointer to interface structure)
}
{ ScreenSaver - duration: time to execute (in seconds), <= 0 -> endless
		Flags   : reserved (pointer to interface structure)
}

Function ScreenSaver (duration: LongInt; Flags:LongInt): LongInt;
{$ifndef RUN}
export;
{$endif}
var
  Window: HWnd;
  Message: TMsg;
  f:boolean;
  cCursor, i: integer;
  dc: hDC;
  hOldPal: hPalette;
const
  WindowClass: TWndClass = (
    style: cs_HREDRAW + cs_VREDRAW;
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: nil;
    lpszClassName: AppName);
begin
  Randomize;
  ReadProfile;
  fExit := -1;
{$ifdef COL256}
  pif := pointer (flags);
  if pif <> nil then
    if (pif^.lLevel <> 0) or
       (pif^.lMagic <> $12348765) then
      pif := nil;     { struktur nicht erkannt / unknown structure}
{$endif}

  if HPrevInst = 0 then
  begin
    WindowClass.hInstance := HInstance;
    WindowClass.hIcon := 0;
    WindowClass.hCursor := LoadCursor(0, idc_Cross);
    WindowClass.hbrBackground := GetStockObject(black_Brush);
    if not RegisterClass(WindowClass) then
	;
  end;
  if (pif <> nil) and (pif^.lCaller = 1) then  { von LGD gerufen / caller is LGD }
    begin
      Window := CreateWindow(
	AppName,
	AppName,
	ws_PopUp or ws_Border
	or ws_Visible,
	0,
	0,
	1,
	1,
	0,
	0,
	HInstance,
	nil);
      UpdateWindow(Window);
    end
  else
    begin                        { caller is randomizer }
      Window := CreateWindow(
	AppName,
	AppName,
	ws_PopUp or ws_border
	or ws_Visible or ws_maximize,
	0,
	0,
	1,
	1,
	0,
	0,
	HInstance,
	nil);
      UpdateWindow(Window);
    end;

{  SetWindowPos (Window, 0, -1, -1,
		GetSystemMetrics (sm_cxScreen)+2,
		GetSystemMetrics (sm_cyScreen)+2,
		swp_noZOrder);

  ShowWindow (window, sw_Normal);}

  cCursor := 0;
  repeat
    i := ShowCursor (false);
    inc (cCursor);
  until i < 0;

  if duration > 0 then
    lEndTime := GetCurrentTime + duration * 1000
  else
    lEndTime := $7fffffff;
  lTime := ThTickCount;

  cxClient := GetSystemMetrics (sm_cxScreen); 
  cyClient := GetSystemMetrics (sm_cyScreen);
  InitCrawlers;

{$ifdef USESOUNDS}
  cSoundTime := 0;
{$endif}
  SetTimer (window, 17, 1000, nil);

  f := TRUE;
  while f do
    begin
      if PeekMessage (Message, 0, 0, 0, pm_REMOVE) then
	begin
	  if Message.message = wm_Quit then
	    f := false
	  else
	    begin
	      TranslateMessage(Message);
	      DispatchMessage(Message);
	    end
	end
      else
	begin
	  if not IsZoomed (window) then
	    PostMessage (window, wm_syscommand, sc_zoom, 0)
	  else
	  if fExit = -1 then
	    begin
	      lTmp := ThTickCount;
	      if (lTmp >= lTime + __TURBO) then
		begin
		  lTime := lTmp;
		  dc := GetDC (window);
		  if pif <> nil then
		    begin
		      hOldPal := SelectPalette (dc, pif^.hPal, FALSE);
		      RealizePalette(dc);
		    end;
		  MoveCrawlers (dc);
		  if pif <> nil then
		    SelectPalette (dc, hOldPal, FALSE);
		  releaseDC (window, dc);
		end
	    end;
	end;
  end;


  while cCursor > 0 do
    begin
      ShowCursor (true);
      dec (cCursor);
    end;

  UnregisterClass (AppName, hInstance);
  ScreenSaver := fExit;
end;


{ ScreenSaverID - Identifikation des Schoners
    Parameter:
      wMagic    : mu bei der Rckkehr einen bestimmten Wert enthalten ($6874)
      fFunctions: Bit 0  About-Funktion wird untersttzt
		  Bit 1  Options-Funktion wird untersttzt
		  Bit 2  Bildschirm darf bei Aufruf nicht schwarz sein
		  Bit 3  Hinterlt einen schwarzen Bildschirm
      achName   : Name des Schoners - da erste Zeichen des Namens wird nicht
		  angezeigt, es legt blo die Sortierung fest.
      cchName   : Lnge des Puffers fr achName
      achDesc   : Beschreibung des Schoners, bis max. ca. 8 Zeilen a 30 Zeichen
		  Beschreibung kann #10 (\n) (Zeilenvorschub) enthalten
      cchDesc   : Lnge des Puffers fr Beschreibung
}
{ ScreenSaverID - identifies the screen saver
    Parameters:
      wMagic    : set to magic ID number ($6874)
      fFunctions: Bit 0  has an About function
		  Bit 1  has an Options function
		  Bit 2  requires non-blank screen on start
		  Bit 3  leaves blank screen on termination
      achName   : saver name - first character is not shown, used for sorting only
      cchName   : length of achName buffer
      achDesc   : description of the saver, max. 8 lines with 30 chars. each (approx.)
		  may contain #10 (\n) line feed characters
      cchDesc   : length of achDesc buffer
}


Procedure ScreenSaverID (var wMagic:integer;
			 var fFunctions:LongInt;
			     achName:pchar;
			     cchName:integer;
			     achDesc:pchar;
			     cchDesc:integer);
export;
begin
  wMagic := $6874;
  fFunctions := 16+4+2+1;  { 1: about, 2:options, 3:both }
		      { 4: non-blank (nicht-leerer bildschirm erforderlich }
		      { 8: hinterlt leeren bildschirm }
		      { 4: non-blank (requires non-blank screen }
		      { 8: leaves screen blank }
		      {16: help in lgd.hlp available (not for 3rd party savers }
  { das erste zeichen des namens wird nicht angezeigt, es legt
    lediglich die sortierung fest. }
  { first char is used for sorting only - it's not displayed
    should be identical with the first visible character }
{$ifdef ENGLISH}
  StrLCopy (achName, 'GGummyworms', cchName - 1);
  StrLCopy (achDesc, 'Gummyworms:'#10#10'Screen saver with support for 256 colours.'#10#10+
		     'The full program will list from the SDK\PAS sub directory!'#10,
	    cchDesc - 1);
{$else}
  StrLCopy (achName, 'CCrawler', cchName - 1);
  StrLCopy (achDesc, 'Crawler:'#10#10'Bildschirmschoner mit 256-Farben-Untersttzung'#10#10'Quelltext (Pascal) liegt bei!'#10,
	    cchDesc - 1);
{$endif}
end;

{ ScreenSaverOptions - der uebergebene Fensterhandle sollte als ParentWindow
    fr die Dialogbox benutzt werden 
		     - the window handle should be used as parent window }
Procedure ScreenSaverOptions (window: hWND);
export;
var Proc: TFarProc;
begin
  ReadProfile;
  Proc := MakeProcInstance(@Options, HInstance);
  DialogBox(HInstance, 'OPTIONBOX', Window, Proc);
  FreeProcInstance(Proc);
  WriteProfile;
end;


{ ScreenSaverAbout - Parameter wie bei ScreenSaverOptions
		   - refer to ScreenSaverOptions for parameters }
Procedure ScreenSaverAbout (window: hWND);
export;
begin
{$ifdef ENGLISH}
  {$ifdef SHARE}
  LgdAboutBox (window, 0,
                       'Gummyworms',
                       '1992-95 Thomas Hvel Software'#10+
                       'Saturnstr. 45, 53842 Troisdorf, Germany'#10+
                       'All Rights reserved!',
                       FALSE, 3);
  {$else}
  LgdAboutBox (window, 0,
                       'Gummyworms',
                       '1992-95 Thomas Hvel Software'#10+
                       'Saturnstr. 45, 53842 Troisdorf, Germany'#10+
                       'All Rights reserved!',
                       TRUE, 3);
  {$endif}
{$else}
  {$ifdef SHARE}
  LgdAboutBox (window, 0,
                       'Crawler',
                       '1993-95 Thomas Hvel Software'#10+
                       'Saturnstrae 45, 53842 Troisdorf, Deutschland'#10+
                       'Alle Rechte vorbehalten!',
                       FALSE, 3);
  {$else}
  LgdAboutBox (window, 0,
                       'Crawler',
                       '1993-95 Thomas Hvel Software'#10+
                       'Saturnstrae 45, 53842 Troisdorf, Deutschland'#10+
                       'Alle Rechte vorbehalten!',
                       TRUE, 3);
  {$endif}
{$endif}
(*
{$ifdef ENGLISH}
  messagebox (window, 'Saver module for ''The Lights Go Down'''#10'(C) 1993 Leo Minor', 'Gummyworms', mb_Ok or mb_ApplModal);
{$else}
  messagebox (window, 'Beispiel zu ''The Lights Go Down'''#10'(C) 1993 Leo Minor', 'Crawler', mb_Ok or mb_ApplModal);
{$endif}
*)
end;

{$ifndef RUN}
exports
  ScreenSaverID      index 17,
  ScreenSaverOptions index 18,
  ScreenSaver        index 19,
  ScreenSaverAbout   index 20;
{$endif}

begin
{$ifdef RUN}
  ScreenSaver (20, 0);  { demo fr ca. 20 sekunden / run for 20 seconds }
{$endif}
end.
