/*
 * The author of this software is William Dorsey.
 * Copyright (c) 1993, 1994, 1995 by William Dorsey.  All rights reserved.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, THE AUTHOR DOES NOT MAKE ANY CLAIM OR
 * WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR
 * ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*  nautilus.h
 *
 * REVISION HISTORY
 *
 * DATE      RESPONSIBLE PARTY  DESCRIPTION
 * -------------------------------------------------------------------------
 * 93/12/31  B. Dosrey          Module created
 */

#include "machine.h"

/* Debug level */
#define DEBUG       0

/* Program definitions */
#define NCODERS         2
#define VERSION_MAJOR   0
#define VERSION_MINOR	9
#define VERSION_STRING	"Beta 0.9.1"
#define LOGON_FILE	"logon.v"

/* Miscellaneous parameters */
#define MAX_SKEY_LEN		80

/* MS-DOS stuff */
enum soundcards { SOUNDBLASTER };

/* Flags */
#define SUCCESS         0
#define FAIL            ~SUCCESS
#define FALSE           0
#define TRUE            ~FALSE

/* Default operating parameters */
#define DEFAULT_DTE_SPEED       19200
#define DEFAULT_DCE_SPEED       14400
#define DEFAULT_PORT            "COM1"
#define DEFAULT_MODEM_INIT      "V1"
#define DEFAULT_CODER_INDEX     0

/* Turnaround beep parameters */
#define BEEP_MS		80
#define BEEP_AMPLITUDE	25000
#define BEEP_FREQ	750.0

/* Configuration types */
enum config_types { STR, NUM, U16 };

/* Operating modes */
enum modes { ANSWER, AUTO_ANSWER, ORIGINATE };
enum flow { RECEIVE, TRANSMIT };

/* Packet types */
enum pkt_type { DATA, EOT, XMIT, RECV, ACK, NAK, MAX_PACKET_TYPE};

/* Error types */
enum err_type { MSG_WARNING, MSG_ERROR, MSG_FATAL };

/* Special packet characters */
#define FRAME   0x7E
#define ESCAPE  0x7D

/* Coder types */
enum coder_type { APSD, DMSP };

/* Encryption types */
enum crypto_type { NONE, BLOWFISH, IDEA, DES3 };

/* Function macros */
#define AddByte(buf, idx, byte) {       \
    switch (byte) {                     \
    case FRAME:                         \
    case ESCAPE:                        \
	buf[idx++] = ESCAPE;            \
	buf[idx++] = (byte) ^ 0x20;     \
	break;                          \
    default:                            \
	buf[idx++] = (byte);            \
	break;                          \
    }                                   \
}

#define PAUSE(ms)			\
    Timer(1);				\
    while (Timer(0) < ms)		\
        ;

#define MAX_PKT_DATA    256             /* max size of data field */
struct packet_t {
    UINT8       type;                   /* packet type */
    UINT16      length;                 /* length of data in bytes */
    UINT8       data[MAX_PKT_DATA];     /* packet data */
    UINT16      crc;                    /* crc of data */
};

struct coder_t {
    void        (*init) (void);
    void        (*encode) (INT16 *samples, UINT8 *bits);
    void        (*decode) (UINT8 *bits, INT16 *samples);
    int         sample_rate;	/* sample rate of coder */
    int         frame_size;     /* bytes per frame of input */
    int         output_size;    /* bytes per frame of output */
    int         frames_per_pkt; /* # frames per packet */
    int         bandwidth;	/* coder bandwidth (incl. overhead) */
    char        *name;          /* name of coder */
    char        *desc;          /* description of coder */
};

typedef struct {
    UINT32	left;
    UINT32	right;
} BLOCK;

typedef struct cfbctx_t {
    int         bufleft;	/* chars remaining in shift register */
    BLOCK       iv;		/* cfb initial vector */
    struct key_t {
        int     type;		/* type of encryption */
        int     key_len;	/* length of key schedule in bytes */
        void    *key;		/* key schedule */
    } *key;
} CFBCTX;

struct param_t {
    int         mode;           /* startup mode */
    char        telno[64];      /* phone # to dial */
    int         verbose;        /* verbose flag */
    struct port_t {
	int     speed;          /* DTE speed */
	char    name[64];       /* name of port */
    } port;
    struct modem_t {
	unsigned speed;         /* modem connect speed */
	char     init[64];      /* modem initialization string */
    } modem;
    struct coder_p {
	int     index;          /* index of selected coder */
    } coder;
    struct msdos_t {
	INT16   snd_iobase;     /* i/o base address of soundcard */
	INT16   snd_irq;        /* irq # of soundcard */
	INT16   snd_dma;        /* dma channel of soundcard */
	INT16   snd_type;       /* type of soundcard */
    } msdos;
    struct crypto_t {
        struct key_t key;	/* cipher info */
       	CFBCTX  sess_ctx;	/* crypt context for session key exchange */
       	CFBCTX  xmit_ctx;	/* crypt context for transmitting data */
       	CFBCTX  recv_ctx;	/* crypt context for receiving data */
       	int     skey_len;	/* length of session key */
       	UINT8   skey[MAX_SKEY_LEN]; 	/* session key */
    } crypto;
};

struct config_t {
    char        name[64];	/* config parameter name */
    int         type;		/* config parameter type */
    void        *value;		/* config parameter value */
};

struct negotiate_t {
    UINT8	major;		/* major version number */
    UINT8	minor;		/* minor version number */
    UINT8	encode[2];	/* "encode" capability bitfield */
    UINT8	decode[2];	/* "decode" capability bitfield */
    UINT8	coder;		/* specified coder (255=unspecified) */
    UINT8	encrypt_type;	/* type of encryption */
    UINT8	modem_speed[2];	/* modem speed (0=unknown, LSB first) */
};

/*
 * key exchange structure.  Note that the BLOCK type variables must
 * come first in this structure to force word alignment at the
 * beginning of the structure rather than in the middle where it
 * would introduce alignment problems on different platforms.
 */
struct keyexch_t {
    BLOCK	sess_iv;	/* iv for session key */
    BLOCK	xmit_iv;	/* xmit iv for receiver */
    BLOCK	recv_iv;	/* recv iv for receiver */
    UINT8	skey[MAX_SKEY_LEN]; /* encrypted session key */
};

/* nautilus function prototypes */
void    init(void);
void	InitBeep(int sample_rate);
void    title(void);
void	credits(void);
void    help(void);
void    usage(void);
int     FindCoder(char *arg);
int     FindCipher(char *arg);
void    ListCoders(void);
void	ListCiphers(void);
int     Connect(char *phone, char *modem_init);
int     AnswerMode(int flag);
void    Talk(int mode);
int     ReadPkt(struct packet_t * pkt);
void    SendPkt(int type, UINT8 * data, int len);
void    SyncPkt(void);
int     GetByte(void);
int     XChange(int mode);
char    *GetPort(char *arg);
int     InitPort(char *arg, UINT16 speed);
int     IncomingPort(void);
int     ReadPort(int timeout);
int     UngetPort(UINT8 c);
int     WritePort(UINT8 * buf, int n);
int     InitAudio(int sample_rate, int frame_size);
int     ReadAudio(UINT8 * buf, int n);
int     WriteAudio(UINT8 * buf, int n);
int     AudioFlow(int flag);
void	DrainAudio(void);
void    CloseAudio(void);
void    Raw2Std(UINT8 * data, INT16 *samples, INT16 len);
void    Std2Raw(INT16 *samples, UINT8 * data, INT16 len);
int     ptt(void);
int     quit(void);
UINT16  ComputeCRC(UINT8 type, UINT8 * data, int len);
int     SysInit(void);
int     WaitFor(char *, int, int);
long    Clock(void);
void    sleep(unsigned);
void    ShowMode(int mode);
void    error(int type, char *s);
void    debug_puts(char *s);
void    debug_puts_nr(char *s);
void    debug_putc(char c);
int     ReadConfigFile(char *fname);
void	VoiceLogon(char *voice_fname);
INT32	Timer(int init);
int	AudioOverflow(void);
int	AudioUnderflow(void);
int	GetPassPhrase(char *pw, int maxlen, char *msg);

#if defined(__MSDOS__) || defined(MSDOS)
int     getopt(int, char *[], char*);
#endif

/* coder function declarations */
void    apsd_init(void);
void	dmsp_init(void);
void    apsd_encode(INT16 *samples, UINT8 *bits);
void	dmsp_encode(INT16 *samples, UINT8 *bits);
void    apsd_decode(UINT8 *bits, INT16 *samples);
void	dmsp_decode(UINT8 *bits, INT16 *samples);

/* encryption function declarations */
void	cfb_init(CFBCTX *context, struct key_t *key, BLOCK *iv);
void	cfb_encrypt(CFBCTX *context, UINT8 *data, int len);
void	cfb_decrypt(CFBCTX *context, UINT8 *data, int len);
int	keyinit(struct key_t *k, char *passphrase, int len);
void	keydestroy(struct key_t *k);
void	ecb_encrypt(struct key_t *k, BLOCK *data);
void	ecb_decrypt(struct key_t *k, BLOCK *data);
void	random_init(UINT8 *data, int len);
void	random_bytes(UINT8 *data, int len);
