ORIGIN = PWB
ORIGIN_VER = 2.1.49
PROJ = NAUTILUS
PROJFILE = NAUTILUS.MAK
DEBUG = 1

CC  = cl
CFLAGS_G  = /W2 /DORDER_DCBA /BATCH
CFLAGS_D  = /f /Od /Zi
CFLAGS_R  = /f- /Ot /Ol /Og /Oe /Oi /Gs
CXX  = cl
CXXFLAGS_G  = /W2 /BATCH
CXXFLAGS_D  = /f /Od /Zi
CXXFLAGS_R  = /f- /Ot /Ol /Og /Oe /Oi /Gs
MAPFILE_D  = NUL
MAPFILE_R  = $(PROJ).map
LFLAGS_G  = /NOI /STACK:4096 /BATCH /ONERROR:NOEXE
LFLAGS_D  = /CO /FAR /PACKC
LFLAGS_R  = /MAP /EXE /FAR /PACKC
LINKER	= link
ILINK  = ilink
LRF  = echo > NUL
ILFLAGS  = /a /e
CVFLAGS  = /50
RUNFLAGS  = -A -p com2 -s 38400 -e idea

FILES  = CLI.C COMM.C CONFIG.C CRC.C IDMSP.C GETOPT.C IAPSD.C INIT.C\
	PC-AUDIO.C PC-COMM.C TALK.C UTIL.C ZLIB.OBJ CRYPT.C NAUT_BF.C IDEA.C\
	DES3.C
OBJS_EXT  = ZLIB.OBJ
OBJS  = CLI.obj COMM.obj CONFIG.obj CRC.obj IDMSP.obj GETOPT.obj IAPSD.obj\
	INIT.obj PC-AUDIO.obj PC-COMM.obj TALK.obj UTIL.obj CRYPT.obj\
	NAUT_BF.obj IDEA.obj DES3.obj $(OBJS_EXT)

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES: .obj .c
.SUFFIXES: .obj .c

CLI.obj : CLI.C nautilus.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoCLI.obj CLI.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoCLI.obj CLI.C
<<
!ENDIF

COMM.obj : COMM.C nautilus.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoCOMM.obj COMM.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoCOMM.obj COMM.C
<<
!ENDIF

CONFIG.obj : CONFIG.C nautilus.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoCONFIG.obj CONFIG.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoCONFIG.obj CONFIG.C
<<
!ENDIF

CRC.obj : CRC.C machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoCRC.obj CRC.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoCRC.obj CRC.C
<<
!ENDIF

IDMSP.obj : IDMSP.C machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoIDMSP.obj IDMSP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoIDMSP.obj IDMSP.C
<<
!ENDIF

GETOPT.obj : GETOPT.C
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoGETOPT.obj GETOPT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoGETOPT.obj GETOPT.C
<<
!ENDIF

IAPSD.obj : IAPSD.C machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoIAPSD.obj IAPSD.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoIAPSD.obj IAPSD.C
<<
!ENDIF

INIT.obj : INIT.C nautilus.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoINIT.obj INIT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoINIT.obj INIT.C
<<
!ENDIF

PC-AUDIO.obj : PC-AUDIO.C nautilus.h pc-audio.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoPC-AUDIO.obj PC-AUDIO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoPC-AUDIO.obj PC-AUDIO.C
<<
!ENDIF

PC-COMM.obj : PC-COMM.C nautilus.h pc-comm.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoPC-COMM.obj PC-COMM.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoPC-COMM.obj PC-COMM.C
<<
!ENDIF

TALK.obj : TALK.C nautilus.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoTALK.obj TALK.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoTALK.obj TALK.C
<<
!ENDIF

UTIL.obj : UTIL.C nautilus.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoUTIL.obj UTIL.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoUTIL.obj UTIL.C
<<
!ENDIF

CRYPT.obj : CRYPT.C nautilus.h blowfish.h des3.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoCRYPT.obj CRYPT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoCRYPT.obj CRYPT.C
<<
!ENDIF

NAUT_BF.obj : NAUT_BF.C nautilus.h blowfish.h naut_bf.h machine.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoNAUT_BF.obj NAUT_BF.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoNAUT_BF.obj NAUT_BF.C
<<
!ENDIF

IDEA.obj : IDEA.C
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoIDEA.obj IDEA.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoIDEA.obj IDEA.C
<<
!ENDIF

DES3.obj : DES3.C des3.h
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoDES3.obj DES3.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoDES3.obj DES3.C
<<
!ENDIF


$(PROJ).exe : $(OBJS)
!IF $(DEBUG)
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LIBS: = +^
) +
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LIBS: = +^
) +
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
	$(LINKER) @$(PROJ).lrf


.c.obj :
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /Fo$@ $<
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /Fo$@ $<
<<
!ENDIF


run: $(PROJ).exe
	$(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
	CV $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
