unit Rvtest;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Ddrvcnst, StdCtrls, ExtCtrls;

type
  Tfddrv = class(TForm)
    btnTest: TButton;
    btnDone: TButton;
    GroupBox1: TGroupBox;
    oState1: TRadioButton;
    oState2: TRadioButton;
    oState3: TRadioButton;
    GroupBox2: TGroupBox;
    chkControl: TCheckBox;
    chkButtons: TCheckBox;
    chkViewFirst: TCheckBox;
    GroupBox3: TGroupBox;
    oLand: TRadioButton;
    oPort: TRadioButton;
    Panel1: TPanel;
    procedure btnDoneClick(Sender: TObject);
    procedure btnTestClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fddrv: Tfddrv;

implementation

{$R *.DFM}

procedure Tfddrv.btnDoneClick(Sender: TObject);
begin
     Application.Terminate;
end;

procedure Tfddrv.btnTestClick(Sender: TObject);

var
   Title, GraphicFile          :String;
   DisplayCtlBox, MinMaxOrLeft :Integer;
   PortOrLand, ViewOrPrint, a  :Integer;
   AString                     :String;

begin

{ -- Set the title - notice the null termination -- }
   Title := 'Test of DDRV.DLL' + #0;

{ -- Setup the page orientation -- }
   if oPort.Checked = True then
      PortOrLand := rv_portrait
      else
         PortOrLand := rv_landscape;

{ -- Do we want to view or print ? --}
   if chkViewFirst.Checked = True then
      ViewOrPrint := rv_viewfirst
      else
         ViewOrPrint := rv_justprint;


{ -- Initialize the viewer -- }
   a := rvInit(fddrv.Handle, @Title[1], ViewOrPrint, rv_inch, PortOrLand);

{ -- Set the name, style, and size of the font
     This should be done right after calling
     rvInit to insure the font is initialized
     properly. -- }

   AString := 'Arial' + #0;
   rvFontName(@AString[1]);
   rvFontSize(12);
   rvFontStyle(rv_fontbold + rv_fontitalic);

{ -- Should we show the control box ? -- }
   if chkControl.Checked = True then
      DisplayCtlBox := rv_ctlbox
      else
         DisplayCtlBox := rv_noctlbox;

{ -- If we want the screen maximized or
     minimized we indicate this by
     passing rv_maximize or rv_minimize
     in the X parameter of rvViewerPos -- }

   if oState1.Checked = True then              {Minimized}
      MinMaxOrLeft := rv_minimize
      else
         if oState2.Checked = True then        {Normal}
            MinMaxOrLeft := 10
            else
               MinMaxOrLeft := rv_maximize;    {Maximized}

{ -- Set the viewer's initial position -- }
   rvViewerPos(MinMaxOrLeft, 10, 600, 450, DisplayCtlBox);

{ -- Set some alternate button captions if requested -- }
   If chkButtons.Checked = True then
     begin
       AString := ExtractFilePath(Application.ExeName);
       AString := AString + 'alt_tool.bmp' + #0;
       rvButtons(84, 10, @AString[1]);
       AString := 'Alt Exit Hint' + #0;
       rvButtonCaption(rv_btn_exit, @Astring[1]);
       AString := 'Alt Prev Hint' + #0;
       rvButtonCaption(rv_btn_prev, @Astring[1]);
       AString := 'Alt Next Hint' + #0;
       rvButtonCaption(rv_btn_next, @Astring[1]);
       AString := 'Alt Print Hint' + #0;
       rvButtonCaption(rv_btn_print, @Astring[1]);
       AString := 'Alt Printer Hint' + #0;
       rvButtonCaption(rv_btn_chooseprinter, @Astring[1]);
     end;

{ -- Place a graphic file on the screen -- }
   GraphicFile := ExtractFilePath(Application.ExeName);
   GraphicFile := GraphicFile + 'ddrv.bmp' + #0;
   rvGraphic(@GraphicFile[1], 1.25, 1.5, 7.25, 4.5);

{ -- Call a new page -- }
   rvNewPage;

{ -- Print some text -- }
   AString := 'Text can be printed in any position and alignment' + #0;
   rvText(4.25, 0.5, rv_center, @AString[1]);

{ -- Change the font size and print some
     text using various alignments. -- }

   rvFontSize(12);
   rvFontStyle(rv_fontnormal);
   AString := '0,0.0) is this position' + #0;
   rvText(0.0,0.0,rv_left,@AString[1]);
   AString := '(8.5,0) is this position' + #0;
   rvText(8.5,0,rv_right,@AString[1]);
   AString := '(0,10.5) is this position' + #0;
   rvText(0.0,10.5,rv_left,@AString[1]);
   AString := '(8.5,10.5) is this position' + #0;
   rvText(8.5,10.5,rv_right,@AString[1]);
   AString := '(11,0) is this position' + #0;
   rvText(11,0.0,rv_right,@AString[1]);
   AString := '(11,8) is this position' + #0;
   rvText(11,8,rv_right,@AString[1]);

{ -- Change the font size and style -- }
   rvFontSize(10);
   rvFontStyle(rv_fontbold);

{ -- Show different alignments --}
   AString := 'Left Text - 4 inches' + #0;
   rvText(4, 3, rv_left, @AString[1]);
   AString := 'Right Text - 4 inches' + #0;
   rvText(4, 3.2, rv_right, @AString[1]);
   AString := 'Centered Text - 4 inches' + #0;
   rvText(4, 3.4, rv_center, @AString[1]);
   AString := 'Decimal (4 inches) $90.00' + #0;
   rvText(4, 3.6, rv_decimal, @AString[1]);

{ -- Draw a fine line (horizontal) -- }
   rvLine(1, 3, 7, 3, 0);

{ -- Draw a 1 point line (vertical) -- }
   rvLine(4,1,4,6,1);

{ -- Start another new page -- }
   rvNewPage;

{ -- Change font specs -- }
   rvFontStyle(rv_fontnormal);
   rvFontSize(24);

{ -- Print some text -- }
   AString := 'Some Bitmaps' + #0;
   rvText(4.25, 0.5, rv_center, @AString[1]);

{ -- Draw a rectangle -- }
   rvRect(0.5, 6.5, 4.5, 8.5, 2, rv_clearback);

{ -- Draw a bunch of bitmaps with some stretching -- }
   GraphicFile := ExtractFilePath(Application.ExeName) + 'test.bmp' + #0;
   rvGraphic(@GraphicFile[1],0.5,0.5,1,1);
   rvGraphic(@GraphicFile[1],1,2,4,5);
   rvGraphic(@GraphicFile[1],7,7,8,9);
   rvGraphic(@GraphicFile[1],1,7,4,8);
   rvGraphic(@GraphicFile[1],6,1,7,5);
   rvRect(6, 1, 7, 5, 2, rv_clearback);

{ -- End the document --}
   rvEndDoc;

end;

end.
