/****************************************************************************/
/*                                                                          */
/*                             COMMCTRL.H                                   */
/*                                                                          */
/*  Implementation of Win95-like common controls for the Win16 API.         */
/*                                                                          */
/*                                                                          */
/*  Written by Marc Adler, Magma Systems (201)-912-0192                     */
/*                                                                          */
/*  History :                                                               */
/*                                                                          */
/*      4/14/95 (maa)  Initial stab at tabbed dialogs!                      */
/*                                                                          */
/****************************************************************************/

#if !defined(__COMMCTRL_H)
#define _COMMCTRL_H

/*
  Function declarations
*/
VOID WINAPI InitPropertySheet(void);
#if !defined(_WIN32)
#define InitCommonControls  InitPropertySheet
#endif


/****************************************************************************/
/*                                                                          */
/*                         TABBED FOLDER INFO                               */
/*                                                                          */
/****************************************************************************/

/*
  MS Windows SDK declarations of the TAB Control
*/
typedef struct tagTC_ITEM
{
  UINT    mask;                /* name of item to get or set */
    #define TCIF_TEXT  0x0001     /* pszText and ccTextMax are valid */
    #define TCIF_IMAGE 0x0002     /* iImage is valid */
    #define TCIF_PARAM 0x0004     /* lParam is valid */
    #define TCIF_STATE 0x0008     /* state is valid  */
  UINT    state;
    #define TCIS_FOCUSED     0x0001  /* Tab has the input focus */
    #define TCIS_SELECTED    0x0002  /* Tab is selected         */
    #define TCIS_DROPHILITED 0x0004  /* Tab is the drop highlight target */
    #define TCIS_DISABLED    0x0008  /* Tab is disabled         */
    #define TCIS_HIDDEN      0x0010  /* Tab is hidden           */
  UINT    stateMask;
  LPSTR   pszText;
  int     cchTextMax;
  int     iImage;
  LPARAM  lParam;
} TC_ITEM, FAR *LPTC_ITEM;

typedef struct tagTC_ITEMHEADER
{
  UINT    mask;
  UINT    state;
  UINT    stateMask;
  LPSTR   pszText;
  int     cchTextMax;
  int     iImage;
} TC_ITEMHEADER, FAR *LPTC_ITEMHEADER;

/*
  Tabbed dialog Styles passed to CreateWindow(Ex)
*/
#define TCS_BUTTONS                         0x0001
#define TCS_FIXEDWIDTH                      0x0002
#define TCS_FOCUSONBUTTONDOWN               0x0004
#define TCS_MULTILINE                       0x0008
#define TCS_OWNERDRAWFIXED                  0x0010
#define TCS_RAGGEDRIGHT                     0x0020
#define TCS_RIGHTJUSTIFY                    0x0040
#define TCS_SHAREIMAGELISTS                 0x0080
#define TCS_SINGLELINE                      0x0100
#define TCS_SORTASCENDING                   0x0200
#define TCS_SORTDESCENDING                  0x0400
#define TCS_SORTNONE                        0x0800
#define TCS_TABS                            0x1000
#define TCS_TOOLTIPS                        0x2000
#define TCS_ISPROPSHEET                     0x4000  /* internal use... */

#define TCS_DEFAULTSTYLE                    (TCS_TABS | TCS_SINGLELINE)

/*
  Class name used for CreateWindow(Ex)
*/
#define WC_TABCONTROL                       ((LPCSTR) "MagmaTabbedDlg")

/*
  Tab Control messages
*/
#define TCM_BASE           (WM_USER + 123)
#define TCM_ADJUSTRECT     (TCM_BASE + 0)
#define TCM_DELETEALLITEMS (TCM_BASE + 1)
#define TCM_DELETEITEM     (TCM_BASE + 2)
#define TCM_GETBKCOLOR     (TCM_BASE + 3)
#define TCM_GETCURSEL      (TCM_BASE + 4)
#define TCM_GETIMAGELIST   (TCM_BASE + 5)
#define TCM_GETITEM        (TCM_BASE + 6)
#define TCM_GETITEMCOUNT   (TCM_BASE + 7)
#define TCM_GETITEMRECT    (TCM_BASE + 8)
#define TCM_GETROWCOUNT    (TCM_BASE + 9)
#define TCM_GETTEXTBKCOLOR (TCM_BASE + 10)
#define TCM_GETTEXTCOLOR   (TCM_BASE + 11)
#define TCM_GETTOOLTIPS    (TCM_BASE + 12)
#define TCM_HITTEST        (TCM_BASE + 13)
#define TCM_INSERTITEM     (TCM_BASE + 14)
#define TCM_REMOVEIMAGE    (TCM_BASE + 15)
#define TCM_SETBKCOLOR     (TCM_BASE + 16)
#define TCM_SETCURSEL      (TCM_BASE + 17)
#define TCM_SETIMAGELIST   (TCM_BASE + 18)
#define TCM_SETITEM        (TCM_BASE + 19)
#define TCM_SETITEMEXTRA   (TCM_BASE + 20)
#define TCM_SETITEMSIZE    (TCM_BASE + 21)
#define TCM_SETPADDING     (TCM_BASE + 22)
#define TCM_SSTTEXTBKCOLOR (TCM_BASE + 23)
#define TCM_SETTEXTCOLOR   (TCM_BASE + 24)
#define TCM_SETTOOLTIPS    (TCM_BASE + 25)

/*
  Notification codes
*/
#define TCN_SELCHANGING    (TCM_BASE + 30)
#define TCN_SELCHANGE      (TCM_BASE + 31)


typedef struct tagTCHitTestInfo
{
  POINT pt;
  int   idxTab;
  UINT  flags;
    #define TCHT_NOWHERE     0x01
    #define TCHT_ONITEMICON  0x02
    #define TCHT_ONITEMLABEL 0x04
    #define TCHT_ONITEM      (TCHT_ONITEMICON | TCHT_ONITEMLABEL)
} TC_HITTESTINFO, FAR *LPTC_HITTESTINFO;



/****************************************************************************/
/*                                                                          */
/*                         PROPERTY PAGE/SHEET INFO                         */
/*                                                                          */
/****************************************************************************/

/*
  Typedef for the release callback
*/
typedef VOID (CALLBACK *LPFNRELEASEPROPSHEETPAGE)(struct _PROPSHEET FAR *lpPage);


/*
  Microsoft Windows compatible dialog template
*/
#pragma pack(1)
typedef struct tagDlgTemplate
{
  long dtStyle;
  BYTE dtItemCount;
  int  dtX;
  int  dtY;
  int  dtCX;
  int  dtCY;
  /*
    NULL-terminated strings
  char dtMenuName[];
  char dtClassName[];
  char dtCaptionText[];
  */
} DLGTEMPLATE, FAR *LPDLGTEMPLATE;
typedef const DLGTEMPLATE FAR *LPCDLGTEMPLATE;
#pragma pack()



/*
  Property Sheet Page structure
*/
typedef struct _PROPSHEETPAGE
{
  DWORD dwSize;
  DWORD dwFlags;         /* PSP_* bits (see below) */
  HINSTANCE hInstance;
  union
  {
    LPCSTR pszTemplate;
    LPCDLGTEMPLATE pResource;
  };
  union
  {
    HICON hIcon;
    LPCSTR pszIcon;
  };
  LPCSTR  pszTitle;
  WNDPROC pfnDlgProc;
  LPARAM  lParam;
  LPFNRELEASEPROPSHEETPAGE pfnRelease;
  UINT FAR *pcRefParent;
} PROPSHEETPAGE, FAR *LPPROPSHEETPAGE;
typedef const PROPSHEETPAGE FAR *LPCPROPSHEETPAGE;
DECLARE_HANDLE32(HPROPSHEETPAGE);


/*
  Bits for PROPSHEETPAGE.dwFlags
*/
#define PSP_DEFAULT          0x0001
#define PSP_DLGINDIRECT      0x0002
#define PSP_USEHICON         0x0004
#define PSP_USEICONID        0x0008
#define PSP_USETITLE         0x0010
#define PSP_USERELEASEFUNC   0x0020
#define PSP_USEREFPARENT     0x0040




/*
  Property Sheet Header structure
*/
typedef struct _PROPSHEETHEADER
{
  DWORD  dwSize;
  DWORD  dwFlags;   /* PSH_* bits */
  HWND   hwndParent;
  HINSTANCE hInstance;
  union
  {
    HICON hIcon;
    LPCSTR pszIcon;
  };
  LPCSTR pszCaption;
  UINT   nPages;
  UINT   nStartPage;
  union
  {
    LPCPROPSHEETPAGE ppsp;
    HPROPSHEETPAGE FAR *phpage;
  };
} PROPSHEETHEADER, FAR *LPPROPSHEETHEADER;
typedef const PROPSHEETHEADER FAR *LPCPROPSHEETHEADER;
DECLARE_HANDLE32(HPROPSHEETHEADER);

/*
  Bits for PROPSHEETHEADER.dwFlags
*/
#define PSH_DEFAULT          0x0001
#define PSH_PROPTITLE        0x0002
#define PSH_USEHICON         0x0004
#define PSH_USEICONID        0x0008
#define PSH_PROPSHEETPAGE    0x0010


/*
  Property Sheet Public APIs
*/
int            WINAPI PropertySheet(LPCPROPSHEETHEADER lpSheetHdr);
HPROPSHEETPAGE WINAPI CreatePropertySheetPage(LPCPROPSHEETPAGE lpPage);
BOOL           WINAPI DestroyPropertySheetPage(HPROPSHEETPAGE hPage);


/*
  Property Sheet messages and notification codes
*/
#define PSM_BASE           (WM_USER + 234)
#define PSM_ADDPAGE        (PSM_BASE + 0)
#define PSM_APPLY          (PSM_BASE + 1)
#define PSM_CANCELTOCLOSE  (PSM_BASE + 2)
#define PSM_CHANGED        (PSM_BASE + 3)
#define PSM_GETPAGE        (PSM_BASE + 4)
#define PSM_PRESSBUTTON    (PSM_BASE + 5)
#define PSM_QUERYSIBLINGS  (PSM_BASE + 6)
#define PSM_REBOOTSYSTEM   (PSM_BASE + 7)
#define PSM_REMOVEPAGE     (PSM_BASE + 8)
#define PSM_RESTARTWINDOWS (PSM_BASE + 9)
#define PSM_SETCURSEL      (PSM_BASE + 10)
#define PSM_SETTITLE       (PSM_BASE + 11)
#define PSM_SETWIZBUTTONS  (PSM_BASE + 12)
#define PSM_UNCHANGED      (PSM_BASE + 13)

#define PSN_APPLY          (PSM_BASE + 20)
#define PSN_HASHELP        (PSM_BASE + 21)
#define PSN_HELP           (PSM_BASE + 22)
#define PSN_KILLACTIVE     (PSM_BASE + 23)
#define PSN_QUERYCANCEL    (PSM_BASE + 24)
#define PSN_RESET          (PSM_BASE + 25)
#define PSN_SETACTIVE      (PSM_BASE + 26)
#define PSN_WIZBACK        (PSM_BASE + 27)
#define PSN_WIZFINISH      (PSM_BASE + 28)
#define PSN_WIZNEXT        (PSM_BASE + 29)


/*
  WM_NOTIFY header
*/
#define WM_NOTIFY          (PSM_BASE + 50)

typedef struct tagNotifyHeader
{
  int code;
} NMHDR, FAR *LPNMHDR;


#define PropSheet_AddPage(hWndSheet, hPage)                 \
  SendMessage(hWndSheet, PSM_ADDPAGE, 0, (LPARAM) (hPage))
#define PropSheet_Changed(hWndSheet, hDlg)                  \
  SendMessage(hWndSheet, PSM_CHANGED, 0, (LPARAM) 0)
#define PropSheet_QuerySiblings(hWndSheet, wParam,  lParam) \
  SendMessage(hWndSheet, PSM_QUERYSIBLINGS, (WPARAM)(wParam), (LPARAM)(lParam))
#define PropSheet_SetCurSel(hWndSheet, wParam, lParam)      \
  SendMessage(hWndSheet, PSM_SETCURSEL, (WPARAM)(wParam), (LPARAM)(lParam))

#endif /* _COMMCTRL_H */

