/***********************************************************
 * dlgicon.c - Make icon display correctly when dialog
 *             is main window.  See Bonneau's column in
 *             the November 1993 W/DDJ
 **********************************************************/
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include <string.h>

typedef struct
    {
    DWORD           ulwStyle;
    BYTE            citm;
    unsigned short  x, y, dx, dy;
    char            szMenuName[1];
    } DLT;          /* DiaLog Template. */

static
HGLOBAL HgblSetDlgIcon(LPCSTR lpszDlt, char * pszClass,
  HICON hicn, HINSTANCE hins);

BOOL    DialogIcon(HICON Icon, HINSTANCE Instance,
           LPSTR DialogName, HWND Owner, DLGPROC DialogProc)
    {
    HGLOBAL     hgbl;
    char        szClass[MAX_CLASSNAME];

    szClass[0] = 0;
    if (Icon != NULL)
        {
        if ((hgbl = HgblSetDlgIcon(DialogName, szClass,
          Icon, Instance)) != NULL)
            {
            DialogBoxIndirect(Instance, hgbl, Owner,
              DialogProc);
            FreeResource(hgbl);
            }
        if (szClass[0] != 0)
            UnregisterClass(szClass, Instance);
        }

    return 0;
    }

HGLOBAL
HgblSetDlgIcon(LPCSTR lpszDlt, char * pszClass,
  HICON hicn, HINSTANCE hins)
/*****************************************************/
/* -- Create a new private dialog class with given   */
/*    icon.  Load the dialog template, and change    */
/*    its class to the new name.  Return the         */
/*    modified dialog template and new class name.   */
/*****************************************************/
    {
    WNDCLASS    wcs;    /* Cloned class. */
    HRSRC       hrsrc;  /* Dialog template resource. */
    HGLOBAL     hgblNew; /* New dialog template. */
    HGLOBAL     hgbl        = NULL; /* Old template. */
    int         fOk         = FALSE;
    DLT far *   lpdlt;  /* New template pointer. */
    char far *  lpszClass; /* Unique class name. */
    UINT        bClass; /* Offset to class name. */
    int         cbClassOld, cbClassNew, cbOld;
    static long cact;   /* Number of times called. */

    /* Get the dialog class and clone it. */
    if(!GetClassInfo(NULL, MAKEINTRESOURCE(32770), &wcs))
        {
        MessageBox(NULL, "Can't happen: Could not "
            "do GetClassInfo() on #32770", "HgblSetDlgIcon", MB_ICONSTOP);
        return NULL;
        }
    wsprintf(pszClass, "MyDialog%lx", ++cact);
	wcs.lpszClassName = pszClass;
    wcs.lpszMenuName = NULL;
    wcs.hIcon = hicn;
    wcs.hInstance = hins;

    /* Register the cloned class. */
    if (!RegisterClass(&wcs))
        {
        MessageBox(NULL, "Can't happen: Could not create class",
                                                pszClass, MB_OK);
        pszClass[0] = 0;
        return NULL;
        }

    /* Get the dialog template. */
    if ((hrsrc = FindResource(hins, lpszDlt,
      RT_DIALOG)) == NULL ||
      (hgbl = LoadResource(hins, hrsrc)) == NULL ||
      (lpdlt = (DLT *)LockResource(hgbl)) == NULL)
        goto LCleanup;

    /* Find class name member. */
    bClass = (lpdlt->szMenuName[0] == '\xff' ?
        3 : lstrlen(lpdlt->szMenuName) + 1);
    lpszClass = lpdlt->szMenuName + bClass;

    /* Resize dialog template resource if necessary */
    /* to hold new class name. */
    cbClassOld = lstrlen(lpszClass) + 1;
    cbClassNew = lstrlen(pszClass) + 1;
    cbOld = (int)GlobalSize(hgbl);
    if (cbClassNew > cbClassOld)
        {
        UnlockResource(hgbl);
        lpdlt = NULL;
        if ((hgblNew = GlobalReAlloc(hgbl, cbOld +
            cbClassNew - cbClassOld, GMEM_MOVEABLE)) ==
          NULL)
            goto LCleanup;
        hgbl = hgblNew;
        if ((lpdlt = (DLT *)LockResource(hgbl)) == NULL)
            goto LCleanup;
        lpszClass = lpdlt->szMenuName + bClass;
        }

    /* Make room for new class name. */
    _fmemmove(lpszClass + cbClassNew,
      lpszClass + cbClassOld, cbOld -
      (lpszClass - (char far *)lpdlt) - cbClassOld);

    /* Copy new class name into dialog template */
    /* resource. */
    lstrcpy(lpszClass, pszClass);
    fOk = TRUE;

LCleanup:
    if (lpdlt != NULL)
        UnlockResource(hgbl);
    if (!fOk && hgbl != NULL)
        {
        FreeResource(hgbl);
        hgbl = NULL;
        }

    return hgbl;
    }

