/* taskcln.c "Clean" a running task using TerminateApp.
 *       List all tasks in a list box,
 *       and allow user to select by button or double click.
 * by Jason M. Rinn 10/24/94
 * NOTE: This code was written assuming smart callbacks,
 *       -DSTRICT, and large memory model.
 */
#include <windows.h>
#include <toolhelp.h> /*For TaskFirst,TaskNext,TerminateApp*/
#include <stdlib.h>    /*For malloc*/
#include "taskcln.h"  /*For Dialog Box constants*/

#ifdef __WATCOMC__
    #pragma off (unreferenced);
#endif

/*Name of Dialog box resource*/
#define DIALOGNAME "TaskClean"

HTASK hTaskList[256]; /* Array of handles of running tasks.*/

/*Lists module names of
 *currently running tasks in listbox ID_TASKLIST*/
void RefreshList(HWND hDlg)
{
   TASKENTRY te;
   int iCount=0;

   SendDlgItemMessage(hDlg, ID_TASKLIST,
                      LB_RESETCONTENT, 0, 0);
   te.dwSize=sizeof(TASKENTRY);
   if (TaskFirst(&te))
   {
      do
      {
         hTaskList[iCount++]=te.hTask;
         SendDlgItemMessage(hDlg, ID_TASKLIST, LB_ADDSTRING,
                        0, (DWORD)(LPSTR)&te.szModule);
      } while (TaskNext(&te));
   }
}

/* End task selected in list box ID_TASKLIST using
 * TerminateApp. Then, relist task modules. */
void KillTask(HWND hDlg)
{
   DWORD dwCurSel, dwTextLen;
   LPSTR lpszCurSel;

   dwCurSel = SendDlgItemMessage(hDlg, ID_TASKLIST,
                                 LB_GETCURSEL, 0, 0);
   dwTextLen = SendDlgItemMessage(hDlg, ID_TASKLIST,
                                 LB_GETTEXTLEN, 0, 0);

   /*Allocate string for safety (+1 for terminating NULL*/
   lpszCurSel = (LPSTR) malloc((size_t)dwTextLen+1);

   /*And check return value.*/
   if (lpszCurSel!=NULL)
      if (IsTask(hTaskList[dwCurSel]))
         TerminateApp(hTaskList[dwCurSel], NO_UAE_BOX);
   RefreshList(hDlg);
}

/*Dialog Box Procedure.*/
BOOL CALLBACK CleanProc(HWND hDlg, UINT wMsg, WPARAM wParam,
                      LPARAM lParam)
{
   switch(wMsg)
   {
      case WM_INITDIALOG:
         RefreshList(hDlg);
         break;
      case WM_CLOSE:
         EndDialog(hDlg, TRUE);
         break;
      case WM_COMMAND:
         switch(wParam)
         {
            case ID_REFRESH:
               RefreshList(hDlg);
               break;
            case ID_KILLTASK:
               KillTask(hDlg);
               break;
            case ID_TASKLIST:
               if (HIWORD(lParam)==LBN_DBLCLK)
                  KillTask(hDlg);
               break;
            case IDCANCEL:
            case IDOK:
               EndDialog(hDlg, TRUE);
               break;
         }
         break;
      default:
         return FALSE; /*If not handled in switch. */
   }

   return TRUE; /*If handled in switch*/
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance,
    HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
   return DialogBox(hInstance, DIALOGNAME, NULL,
                                       (DLGPROC) CleanProc);
}

