#include <windows.h>
#include <windowsx.h>
#include "bmppal.h"

#ifdef __WATCOMC__
    #pragma off (unreferenced);
#endif

HINSTANCE   hInst;

LRESULT CALLBACK MainWindowProc(HWND hwnd, UINT message,
                               WPARAM wParam, LPARAM lParam)
{
   HBITMAP      hBitmap, hOldBitmap;
   HDC         hdc, hdcBitmap;
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_PAINT:
         hdc = BeginPaint(hwnd, &ps);
         SetBkMode(hdc, TRANSPARENT);
         hdcBitmap = CreateCompatibleDC(hdc);

         TextOut(hdc, 20, 20, "Unchanged bitmap", 16);
         hBitmap = LoadBitmap(hInst,
                               MAKEINTRESOURCE(IDB_BITMAP));
         hOldBitmap = SelectBitmap(hdcBitmap, hBitmap);
         BitBlt(hdc, 20, 40, 32, 32,
                hdcBitmap, 0, 0, SRCCOPY);
         SelectBitmap(hdcBitmap, hOldBitmap);
         DeleteBitmap(hBitmap);

         TextOut(hdc, 20, 80, "System color bitmap", 19);
         hBitmap = LoadSystemColorBitmap(hInst,
                               MAKEINTRESOURCE(IDB_BITMAP));
         hOldBitmap = SelectBitmap(hdcBitmap, hBitmap);
         BitBlt(hdc, 20, 100, 32, 32,
                hdcBitmap, 0, 0, SRCCOPY);
         SelectBitmap(hdcBitmap, hOldBitmap);
         DeleteBitmap(hBitmap);

         TextOut(hdc, 20, 140, "Disabled bitmap", 15);
         hBitmap = LoadDisabledBitmap(hInst,
                               MAKEINTRESOURCE(IDB_BITMAP));
         hOldBitmap = SelectBitmap(hdcBitmap, hBitmap);
         BitBlt(hdc, 20, 160, 32, 32,
                hdcBitmap, 0, 0, SRCCOPY);
         SelectBitmap(hdcBitmap, hOldBitmap);
         DeleteBitmap(hBitmap);

         DeleteDC(hdcBitmap);
         EndPaint(hwnd, &ps);
         break;

      case WM_DESTROY:
         PostQuitMessage(0);
         break;

      default:
         return DefWindowProc(hwnd, message,
                              wParam, lParam);
   }

   return 0;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance, LPSTR lpCmdLine,
                   int nCmdShow)
{
   MSG      message;
   WNDCLASS wc;
   HWND     hwndMain;

   if (!hPrevInstance)
   {
      wc.style         = 0;
      wc.lpfnWndProc   = (WNDPROC) MainWindowProc;
      wc.cbClsExtra    = 0;
      wc.cbWndExtra    = 0;
      wc.hInstance     = hInstance;
      wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
      wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
      wc.hbrBackground = (HBRUSH) (COLOR_BTNFACE + 1);
      wc.lpszMenuName  = NULL;
      wc.lpszClassName = "BitmapPaletteTest";

      RegisterClass(&wc);
   }

   hInst = hInstance;

   hwndMain = CreateWindow("BitmapPaletteTest",
                           "Bitmap Palette Test",
                           WS_OVERLAPPEDWINDOW,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           NULL, NULL, hInstance, NULL);

   ShowWindow(hwndMain, nCmdShow);
   UpdateWindow(hwndMain);

   while ( GetMessage(&message, NULL, 0, 0) )
   {
      TranslateMessage(&message);
      DispatchMessage(&message);
   }

   return message.wParam;
}

