#include <windows.h>
#include <windowsx.h>
#include <string.h>

/* Background color of the bitmap */
static COLORREF MASK_COLOR = RGB(0, 255, 255);

static COLORREF WHITE = RGB(255,255,255);
static COLORREF GRAY  = RGB(128,128,128);

/* Background color of the window */
#define BACKGROUND_COLOR   GetSysColor(COLOR_BTNFACE)

int ColorEq(RGBQUAD a, COLORREF b)
    {
    return a.rgbRed   == GetRValue(b)
        && a.rgbGreen == GetGValue(b)
        && a.rgbBlue  == GetBValue(b);
    } 
void    SetColor(RGBQUAD *Quad, COLORREF Color)
    {
    Quad->rgbRed    = GetRValue(Color);
    Quad->rgbGreen  = GetGValue(Color);
    Quad->rgbBlue   = GetBValue(Color);
    }

typedef struct TDibInfo
    {
    HGLOBAL         hBitmapResource;
    WORD            wNumColors, wPaletteSize;
    LPSTR           lpPalette, lpBits;
    } TDibInfo;

/* utility function for loading DIBs */
static LPBITMAPINFO LoadDib(HINSTANCE hBitmapInstance,
                   LPCSTR lpszBitmap, struct TDibInfo *Info)
    {
    HRSRC           hrsrcBitmap;
    LPBITMAPINFO    lpbmInfo;

    hrsrcBitmap = FindResource(hBitmapInstance, lpszBitmap,
                              RT_BITMAP);
    Info->hBitmapResource = LoadResource(hBitmapInstance,
                                  hrsrcBitmap);
    lpbmInfo = (LPBITMAPINFO)
                        LockResource(Info->hBitmapResource);
    if ( lpbmInfo == NULL )
        {
        #ifndef WIN32
            FreeResource(Info->hBitmapResource);
        #endif
        return NULL;
        }
    switch (lpbmInfo->bmiHeader.biBitCount)
        {
        case 1 : Info->wNumColors   = 2;    break;
        case 4 : Info->wNumColors   = 16;   break;
        case 8 : Info->wNumColors   = 256;  break;
        default: Info->wNumColors   = 0;
        }
    Info->wPaletteSize = Info->wNumColors * sizeof(RGBQUAD);
    Info->lpBits = (LPSTR)(lpbmInfo) +
        sizeof(BITMAPINFOHEADER) + Info->wPaletteSize;
    /* Make copy of palette */
    Info->lpPalette = (LPSTR)GlobalAllocPtr(GHND,
        Info->wPaletteSize);
    if ( Info->lpPalette == NULL )
        {
        #ifndef WIN32
            UnlockResource(Info->hBitmapResource);
            FreeResource(Info->hBitmapResource);
        #endif
        return NULL;
        }
    memcpy(Info->lpPalette, (LPSTR)lpbmInfo
        + sizeof(BITMAPINFOHEADER), Info->wPaletteSize);
    return lpbmInfo;
    }

/***********************************************************
* This function loads a bitmap resource, changes           *
* MASK_COLOR to BACKGROUND_COLOR, and returns the image in *
* the form of an HBITMAP.                                  *
***********************************************************/
HBITMAP LoadSystemColorBitmap(HINSTANCE hBitmapInstance,
                              LPCSTR lpszBitmap)
{
    struct TDibInfo Info;
    LPBITMAPINFO    lpbmInfo;
    HDC             hdcMemory;
    WORD            i;
    HBITMAP         hBitmap;

    lpbmInfo    = LoadDib(hBitmapInstance, lpszBitmap, &Info);
    if(lpbmInfo == NULL)
        return NULL;
    for (i = 0; i < Info.wNumColors; i++)
        if ( ColorEq( lpbmInfo->bmiColors[i], MASK_COLOR ) )
            SetColor(&lpbmInfo->bmiColors[i], BACKGROUND_COLOR);
    hdcMemory = GetDC(NULL);
    hBitmap   = CreateDIBitmap(hdcMemory, &lpbmInfo->bmiHeader,
                CBM_INIT, Info.lpBits, lpbmInfo, DIB_RGB_COLORS);
    memcpy((LPSTR)lpbmInfo + sizeof(BITMAPINFOHEADER),
              Info.lpPalette, Info.wPaletteSize);
    GlobalFreePtr(Info.lpPalette);
    ReleaseDC(NULL, hdcMemory);

    #ifndef WIN32
        UnlockResource(Info.hBitmapResource);
        FreeResource(Info.hBitmapResource);
    #endif

    return hBitmap;
}

/***********************************************************
* This function loads a bitmap resource, creates a         *
* disabled version of the image, and returns it as an      *
* HBITMAP.                                                 *
***********************************************************/
HBITMAP LoadDisabledBitmap(HINSTANCE hBitmapInstance,
                           LPCSTR lpszBitmap)
{
    struct TDibInfo Info;
    LPBITMAPINFO lpbmInfo;
    HDC          hdcMemory, hdcBitmap, hdcCanvas;
    WORD         i;
    HBITMAP      hBitmap, hTempBitmap, hOldBitmap;
    HBRUSH       hBackgroundBrush;

    lpbmInfo    = LoadDib(hBitmapInstance, lpszBitmap, &Info);
    if(lpbmInfo == NULL)
        return NULL;
    /* Create memory bitmap */
    hdcMemory = GetDC(NULL);
    hdcBitmap = CreateCompatibleDC(hdcMemory);
    hdcCanvas = CreateCompatibleDC(hdcMemory);
    hBitmap   = CreateCompatibleBitmap(hdcMemory,
                         (int)lpbmInfo->bmiHeader.biWidth,
                         (int)lpbmInfo->bmiHeader.biHeight);
    SelectBitmap(hdcCanvas, hBitmap);
    hBackgroundBrush = CreateSolidBrush( BACKGROUND_COLOR );
    SelectBrush(hdcCanvas, hBackgroundBrush);
    Rectangle(hdcCanvas, -1, -1,
        (int)(lpbmInfo->bmiHeader.biWidth + 1),
        (int)(lpbmInfo->bmiHeader.biHeight + 1));
    SelectBrush(hdcCanvas, GetStockBrush(NULL_BRUSH));
    DeleteBrush(hBackgroundBrush);

    for (i = 0; i < Info.wNumColors; i++)
        if ( ColorEq( lpbmInfo->bmiColors[i], MASK_COLOR ) ||
             ColorEq( lpbmInfo->bmiColors[i], RGB(255, 255, 255) ) ||
             ColorEq( lpbmInfo->bmiColors[i], RGB(192, 192, 192) ) )
            SetColor(&lpbmInfo->bmiColors[i], BACKGROUND_COLOR);
        else
            SetColor(&lpbmInfo->bmiColors[i], WHITE);

    hTempBitmap = CreateDIBitmap(hdcMemory, &lpbmInfo->
        bmiHeader, CBM_INIT, Info.lpBits,
        lpbmInfo, DIB_RGB_COLORS);

    hOldBitmap = SelectBitmap(hdcBitmap, hTempBitmap);
    BitBlt(hdcCanvas, 1, 1, (int)lpbmInfo->bmiHeader.biWidth,
        (int)lpbmInfo->bmiHeader.biHeight, hdcBitmap,
        0, 0, SRCCOPY);
    SelectBitmap(hdcBitmap, hOldBitmap);
    DeleteBitmap(hTempBitmap);

    memcpy((LPSTR)lpbmInfo + sizeof(BITMAPINFOHEADER),
              Info.lpPalette, Info.wPaletteSize);

    for (i = 0; i < Info.wNumColors; i++)
        if ( ColorEq( lpbmInfo->bmiColors[i], MASK_COLOR ) ||
             ColorEq( lpbmInfo->bmiColors[i], RGB(255, 255, 255) ) ||
             ColorEq( lpbmInfo->bmiColors[i], RGB(192, 192, 192) ) )
            SetColor(&lpbmInfo->bmiColors[i], WHITE);
        else
            SetColor(&lpbmInfo->bmiColors[i], RGB(0,0,0));
    hTempBitmap = CreateDIBitmap(hdcMemory,
        &lpbmInfo->bmiHeader, CBM_INIT, Info.lpBits,
        lpbmInfo, DIB_RGB_COLORS);

    hOldBitmap = SelectBitmap(hdcBitmap, hTempBitmap);
    BitBlt(hdcCanvas, 0, 0, (int)lpbmInfo->bmiHeader.biWidth,
        (int)lpbmInfo->bmiHeader.biHeight, hdcBitmap, 0, 0,
        SRCAND);
    SelectBitmap(hdcBitmap, hOldBitmap);
    DeleteBitmap(hTempBitmap);

    memcpy((LPSTR)lpbmInfo + sizeof(BITMAPINFOHEADER),
        Info.lpPalette, Info.wPaletteSize);

    for (i = 0; i < Info.wNumColors; i++)
        if ( ColorEq( lpbmInfo->bmiColors[i], MASK_COLOR ) ||
             ColorEq( lpbmInfo->bmiColors[i], RGB(255, 255, 255) ) ||
             ColorEq( lpbmInfo->bmiColors[i], RGB(192, 192, 192) ) )
            SetColor(&lpbmInfo->bmiColors[i], RGB(0,0,0));
        else
            SetColor(&lpbmInfo->bmiColors[i], GRAY);
    hTempBitmap = CreateDIBitmap(hdcMemory,
        &lpbmInfo->bmiHeader, CBM_INIT, Info.lpBits,
        lpbmInfo, DIB_RGB_COLORS);

    hOldBitmap = SelectBitmap(hdcBitmap, hTempBitmap);
    BitBlt(hdcCanvas, 0, 0, (int)lpbmInfo->bmiHeader.biWidth,
        (int)lpbmInfo->bmiHeader.biHeight, hdcBitmap, 0, 0,
        SRCPAINT);
    SelectBitmap(hdcBitmap, hOldBitmap);
    DeleteBitmap(hTempBitmap);
    memcpy((LPSTR)lpbmInfo + sizeof(BITMAPINFOHEADER),
        Info.lpPalette, Info.wPaletteSize);
    DeleteDC(hdcCanvas);
    DeleteDC(hdcBitmap);
    ReleaseDC(NULL, hdcMemory);
    GlobalFreePtr(Info.lpPalette);

    #ifndef WIN32
        UnlockResource(Info.hBitmapResource);
        FreeResource(Info.hBitmapResource);
    #endif

    return hBitmap;
}
