#define E_NFILE   1 // cannot open executable file
#define E_NMODULE 2 // cannot find module
#define E_NMAGIC  3 // not an executable
#define E_OLDAPP  4 // not a Windows executable
#define E_CORRUPT 5 // corrupt executable image

typedef struct tagMODULE {
    char szName[9];     // module name
    char szFile[128];   // module file name
    BOOL fImported;     // module is imported
    struct tagMODULE *pNext;
} MODULE;

typedef MODULE FAR *LPMODULE;
typedef int (CALLBACK* MODENUMPROC)(LPMODULE, LPARAM);
typedef void (CALLBACK* MODERRPROC)(int, LPSTR);

BOOL    GetImportModules(LPMODULE *, LPSTR, MODERRPROC);
VOID    FreeModuleList(LPMODULE);


