unit Calcintf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TCalcForm = class(TForm)
    Seven: TButton;
    Eight: TButton;
    Nine: TButton;
    Plus: TButton;
    Clear: TButton;
    Four: TButton;
    Five: TButton;
    Six: TButton;
    Minus: TButton;
    AllClear: TButton;
    One: TButton;
    Two: TButton;
    Multiply: TButton;
    Three: TButton;
    Zero: TButton;
    equal: TButton;
    Divide: TButton;
    modulo: TButton;
    Entry: TEdit;
    procedure ZeroClick(Sender: TObject);
    procedure OneClick(Sender: TObject);
    procedure TwoClick(Sender: TObject);
    procedure ThreeClick(Sender: TObject);
    procedure FourClick(Sender: TObject);
    procedure FiveClick(Sender: TObject);
    procedure SixClick(Sender: TObject);
    procedure SevenClick(Sender: TObject);
    procedure EightClick(Sender: TObject);
    procedure NineClick(Sender: TObject);
    procedure PlusClick(Sender: TObject);
    procedure MinusClick(Sender: TObject);
    procedure MultiplyClick(Sender: TObject);
    procedure DivideClick(Sender: TObject);
    procedure ClearClick(Sender: TObject);
    procedure AllClearClick(Sender: TObject);
    procedure EntryChange(Sender: TObject);
    procedure equalClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CalcForm: TCalcForm;
  Total   : Longint;
  Complete: Boolean;
  Operator: Char;

implementation

{$R *.DFM}

function ValFn(S: String): Longint;
var Code: Integer;
    L   : Longint;
begin
   Val(S, L, Code);
   ValFn := L;
   end;

function StrFn(L: Longint): String;
var S: String;
begin
   Str(L, S);
   StrFn := S;
   end;

procedure Calculate(Number: Longint; NextOp: Char);
begin
   If not Complete or (Total=0) then
   case Operator of
      '+': Total := Total + Number;
      '-': Total := Total - Number;
      'x': Total := Total * Number;
      '': Total := Total div Number;
      'm': Total := Total mod Number;
      end;
   Operator := NextOp;
   Complete := True;
   end;

procedure TCalcForm.ZeroClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '0';
   end;

procedure TCalcForm.OneClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '1';
end;

procedure TCalcForm.TwoClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '2';
end;

procedure TCalcForm.ThreeClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '3';
end;

procedure TCalcForm.FourClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '4';
end;

procedure TCalcForm.FiveClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '5';
end;

procedure TCalcForm.SixClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '6';
end;

procedure TCalcForm.SevenClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '7';
end;

procedure TCalcForm.EightClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '8';
end;

procedure TCalcForm.NineClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '9';
end;

procedure TCalcForm.PlusClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), '+');
   Entry.Text := StrFn(Total);
   end;

procedure TCalcForm.MinusClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), '-');
   Entry.Text := StrFn(Total);
   end;

procedure TCalcForm.MultiplyClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), 'x');
   Entry.Text := StrFn(Total);
   end;

procedure TCalcForm.DivideClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), '');
   Entry.Text := StrFn(Total);
   end;

procedure TCalcForm.ClearClick(Sender: TObject);
begin
  Entry.Text := '0';
  Complete := True;
end;

procedure TCalcForm.AllClearClick(Sender: TObject);
begin
   Entry.Text := '0';
   Complete := True;
   Total := 0;
   Operator := '+';
   Complete := True;
   end;

procedure TCalcForm.EntryChange(Sender: TObject);
begin
   If Entry.Text = '' then Complete := False;
   end;

procedure TCalcForm.equalClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), '+');
   Entry.Text := StrFn(Total);
   Complete := True;
   Total := 0;
end;

end.