unit Deckcard;

interface

type
   Suits = (Clubs, Diamonds, Hearts, Spades);
   Ranks = (Back, Ace, Two, Three, Four, Five, Six,
            Seven, Eight, Nine, Ten, Jack, Queen, King);

   cards = record
      Suit: Suits;
      Rank: Ranks;
      end;

   TCardDeck = class
         Dealt         : byte;
         Deck          : array[1..52] of cards;
      constructor Create;
      function    CardName(R: Ranks; S: Suits): String;
      function    Deal: Cards;
      function    RankOfLastDealt(Depth: Byte): Ranks;
      procedure   Shuffle;
      function    SuitOfLastDealt(Depth: Byte): Suits;
      end;

implementation

constructor TCardDeck.Create;
var I    : Integer;
    Rank : Ranks;
    Suit : Suits;
begin
   I := 1;
   For Suit := Clubs to Spades do
      For Rank := Ace to King do
   begin
      Deck[I].Suit    := Suit;
      Deck[I].Rank    := Rank;
      inc(I);
      end;
   end;

function   TCardDeck.CardName(R: Ranks; S: Suits): String;
var Q, K: String;
begin
   case Suit of
      Clubs   : K := 'Clubs';
      Diamonds: K := 'Diamonds';
      Hearts  : K := 'Hearts';
      Spades  : K := 'Spades';
      end;

   case Rank of
      Back    : Q := 'Back';
      Ace     : Q := 'Ace';
      Two     : Q := 'Two';
      Three   : Q := 'Three';
      Four    : Q := 'Four';
      Five    : Q := 'Five';
      Six     : Q := 'Six';
      Seven   : Q := 'Seven';
      Eight   : Q := 'Eight';
      Nine    : Q := 'Nine';
      Ten     : Q := 'Ten';
      Jack    : Q := 'Jack';
      Queen   : Q := 'Queen';
      King    : Q := 'King';
      end;
   CardNames[Rank, Suit] := R + ' of ' + K;
   end;

function    TCardDeck.Deal: Cards;
begin
   Inc(Dealt);
   Deal := Deck[Dealt];
   end;

function    TCardDeck.RankOfLastDealt(Depth: Byte): Ranks;
begin
   RankOfLastDealt := Deck[Dealt-Depth].Rank;
   end;

procedure   TCardDeck.Shuffle;
var Hold: Cards;
    I,J : Integer;
begin
   for I := 1 to 52 do
   begin
      Hold := Deck[I];
      J := Random(52)+1;
      Deck[I] := Deck[J];
      Deck[J] := Hold;
      end;
   end;

function  TCardDeck.SuitOfLastDealt(Depth: Byte): Suits;
begin
   SuitOfLastDealt := Deck[Dealt-Depth].Suit;
   end;

begin
   Randomize;
   end.
