unit Remmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, RemEng;

type
  TReminderList = class(TForm)
    ReminderListBox: TListBox;
    Edit: TButton;
    New: TButton;
    Remove: TButton;
    Remind: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure EditClick(Sender: TObject);
    procedure ReminderListBoxClick(Sender: TObject);
    procedure NewClick(Sender: TObject);
    procedure RemoveClick(Sender: TObject);
    procedure RemindClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  protected
     ReminderFile: TReminderReader;
  end;

var
  ReminderList: TReminderList;

implementation

{$R *.DFM}

uses RemEdit, Reminder;

procedure TReminderList.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   ReminderFile.Destroy;
end;

{This code counts on the fact that Edit is only
enabled and therfore "clickable" when the user
has made a valid selection in the list box.}
procedure TReminderList.EditClick(Sender: TObject);
var R: TReminder;
    M, D,
    Year: Word;  {Year not used in this version}
begin
   {The listbox is zero based but the reminders
    are numbered from one to n.}
   R := ReminderFile.GetReminder(ReminderListBox.ItemIndex+1);
   {DecodeDate from SysUtils}
   DecodeDate(R.Data.Date, Year, M, D);
   with ReminderEdit do
   begin
      {The month combo-box is zero-based but Decode date
       returns 1-31 and 1-12 for day and month.}
      Month.ItemIndex := M-1;
      Day.Value := D;
      Window.Value := R.Data.Window;
      Message.Text := R.Data.Message;
      Nag.Checked := R.Data.Nag;
      Cleared.Checked := R.Data.Cleared;
      ReminderNumber := ReminderListBox.ItemIndex+1;
      end;
   ReminderEdit.ReminderFile := ReminderFile;
   R.Destroy;
   If ReminderEdit.ShowModal = mrOk then
   begin
      R := ReminderFile.GetReminder(ReminderListBox.ItemIndex+1);
      ReminderListBox.Items[ReminderListBox.ItemIndex] := R.Describe;
      R.Destroy;
      end;
   Edit.Enabled := false;
   Remove.Enabled := false;
   end;

procedure TReminderList.ReminderListBoxClick(Sender: TObject);
begin
   Edit.Enabled := true;
   Remove.Enabled := true;
   end;

procedure TReminderList.NewClick(Sender: TObject);
var R: TReminder;
begin
   With ReminderEdit do
   begin
      Message.Text := 'New Reminder';
      {A ReminderNumber of Zero tells ReminderEdit
       to add a new reminder.}
      ReminderNumber := 0;
      end;
   ReminderEdit.ReminderFile := ReminderFile;
   If ReminderEdit.ShowModal = mrOK then
   begin
      R := ReminderFile.GetReminder(ReminderFile.NumberOfReminders);
      ReminderListBox.Items.Add(R.Describe);
      R.Destroy;
      end;
   end;

{RemoveClick counts on ReminderListBox having a valid
 selection in it.}
procedure TReminderList.RemoveClick(Sender: TObject);
begin
   {ReminderListbox is zero based,
    ReminderFile is one based.}
   ReminderFile.RemoveReminder(ReminderListBox.ItemIndex+1);
   ReminderListBox.Items.Delete(ReminderListBox.ItemIndex);
   Edit.Enabled := False;
   Remove.Enabled := False;
   end;

procedure TReminderList.RemindClick(Sender: TObject);
var I: Integer;
    R: TReminder;
begin
   For I := 1 to ReminderFile.NumberOfReminders do
   begin
      If ReminderFile.SinceLastChecked(I) then
      begin
         R := ReminderFile.GetReminder(I);
         with Remember do
         begin
            Message.Caption := R.Data.Message;
   {DateToStr from SysUtils}
            ReminderDate.Caption := DateToStr(R.Data.Date);
   {Cleared.Check shoudl always be false.}
            Cleared.Checked := R.Data.Cleared;
            ReminderNumber := I;
            R.Destroy;
            end;
         Remember.ReminderFile := ReminderFile;
         Remember.ShowModal;
         end;
      end;
   end;

procedure TReminderList.FormActivate(Sender: TObject);
const FirstTime : Boolean = true;
var   I: Longint;
      R: TReminder;
begin

   {This code can't be put in FormCreate because it
    requires that the reminder form already be
    created.}
   If FirstTime then
   begin
      {Note for next version of program:
         Allow user to specify the name of reminder file.
         Maybe allow user top open more than one file.}
      ReminderFile := TReminderReader.Create('Reminder.Lst');

   {Click the Reminder button for the user.}
      RemindClick(Remind);
      FirstTime := False;

      For I := 1 to ReminderFile.NumberOfReminders do
      begin
         R := ReminderFile.GetReminder(I);
         ReminderListBox.Items.Add(R.Describe);
         R.Destroy;
         end;
      end;
   end;

end.
