program Testprj;

uses
  Forms,
  Messages, {added}
  ShellAPI, {added}
  WinProcs, {added}
  WinTypes, {added}
  Test in 'TEST.PAS' {Form1},
  Test2 in 'TEST2.PAS' {Form2};

{$R *.RES}

type
    TMyApplication = class(TApplication)
       procedure OnMsgProc(var Msg: TMsg; var Handled: Boolean);
       end;

procedure TMyApplication.OnMsgProc;
begin
   {Catch the WM_DROPFILES message.  I also
    check to make sure that the message is headed
    for the iconized application, leaving other
    windows to fend for themselves.}
   If (Msg.Message = WM_DROPFILES) and
      (Msg.HWND = Handle) then
   begin
   {My handling here is to send the form a message so that
    it doesn't have to know where the WM_DROPFILES message
    came from.}
      SendMessage(Form1.Handle, Msg.Message, Msg.WParam, Msg.LParam);
      Handled := true;
      end;
   end;

begin
  {An Application is automatically created, so
   we must free it and replace it with our own
   sub-class.}
  Application.Free;
  Application := TMyApplication.Create(nil);
  {Application.ShowHint is set by the InitControls
   procedure when it creates the default application,
   so we set it again here to ensure compatibility.}
  Application.ShowHint := True;
  {Assign our method to the OnMessageEvent}
  Application.OnMessage := TMyApplication(Application).OnMsgProc;
  Application.CreateForm(TForm1, Form1);
  Application.CreateForm(TForm2, Form2);
  {Form2 simply shows how any form other than the
   main form will accept a dropped file in regular
   or minimized state.}
  Form2.Show;
  {This DragAcceptFiles handles dropping on a
   minimized application.handle.}
  DragAcceptFiles(Application.handle,TRUE);
  Application.Run;
end.
