unit Mainu;
{Version 0.2
  better error handling of invalid files
    Initial IsPE test doesn'g gag on bad file now
    Renamed or disappeard file doesn't freeze after save

WORK ON Ctrl+M and Ctrl+P

}
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus,
  ExtractU;
const
  UtterMax = 900;
type
  IdxString = String[9];
  TMainForm = class(TForm)
    ListBox1: TListBox;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SaveDialog2: TSaveDialog;
    SaveDialog3: TSaveDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    ReadIcons1: TMenuItem;
    SaveIcon1: TMenuItem;
    SaveAsDLL1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Icon1: TMenuItem;
    Clear1: TMenuItem;
    Delete1: TMenuItem;
    N1: TMenuItem;
    Mark1: TMenuItem;
    Place1: TMenuItem;
    Options1: TMenuItem;
    IconSpacing1: TMenuItem;
    MarkICOfiles1: TMenuItem;
    MarkPEfiles1: TMenuItem;
    N4: TMenuItem;
    DefaulttoICO1: TMenuItem;
    DefaulttoEXE1: TMenuItem;
    DefaulttoDLL1: TMenuItem;
    Defaulttoallthree1: TMenuItem;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    SearchforHelpOn1: TMenuItem;
    HowtoUseHelp1: TMenuItem;
    N3: TMenuItem;
    AboutIconJack1: TMenuItem;
    Panel1: TPanel;
    Quiet1: TMenuItem;
    procedure FormResize(Sender: TObject);
    procedure ListBox1DrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ReadIcons1Click(Sender: TObject);
    procedure SaveIcon1Click(Sender: TObject);
    procedure SaveAsDLL1Click(Sender: TObject);
    procedure IconSpacing1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Icon1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ListBox1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListBox1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Mark1Click(Sender: TObject);
    procedure Place1Click(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure SearchforHelpOn1Click(Sender: TObject);
    procedure HowtoUseHelp1Click(Sender: TObject);
    procedure AboutIconJack1Click(Sender: TObject);
    procedure MarkICOfiles1Click(Sender: TObject);
    procedure Defaulttoallthree1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Options1Click(Sender: TObject);
    procedure Quiet1Click(Sender: TObject);
  private
    { Private declarations }
    FileNames : TStringList; {contains a list of the names of all files
                              from which icons are currently displayed}
    Marked    : Integer;     {number of icon marked for moving, or -1
                              if no icon is marked}
    Busy      : Boolean;     {True when program is busy in a loop}
    procedure AppOnHint(Sender: TObject);
    FUNCTION ProcessFile(Filename : String) : Boolean;
    PROCEDURE TooBusy(Status : String);
    PROCEDURE NotBusy;
    PROCEDURE FilIcoFromString(S : idxString; VAR FNum, IcoNum : Word);
    FUNCTION FileTypeFromString(S: idxString) : TFileDataType;
    FUNCTION NameAndNum(Ndx : Integer) : String;
    PROCEDURE SetStatusText(S : String);
    procedure DeleteAnItem(N : Integer; Report : Boolean);
    PROCEDURE DeleteIconsFrom(TheNum : Word);
    procedure WMDropFiles(VAR Msg: TWMDropFiles); message WM_DROPFILES;
    procedure AppOnMessage(VAR Msg: TMsg; VAR Handled : Boolean);
    procedure WMNcRButtonDblClk(VAR Msg: TWMNCRButtonDblClk);
      message WM_NCRBUTTONDBLCLK;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation
uses ShellApi, IniFiles, IcoSpace, IcoTypes, AboutBox;
{$R *.DFM}
{ICONJACX.RES contains the special hand cursor used when
 dragging icons to new location in the display }
{$R ICONJACX.RES}

procedure TMainForm.SetStatusText(S : String);
{Necessary because the ampersand & is a legitimate
 filename character; must double the ampersand in
 panel's caption to get a single ampersand to show}
VAR N : Word;
BEGIN
  IF Pos('&', S) > 0 THEN
    FOR N := Length(S) DOWNTO 1 DO
      IF S[N] = '&' THEN
        System.Insert('&', S, N);
 Panel1.Caption := ' ' + S;
END;

PROCEDURE TMainForm.FilIcoFromString(S : IdxString; VAR FNum, IcoNum : Word);
{Retrieve the filename index and icon number from the
 list box item string}
BEGIN
  FNum   := StrToInt(Copy(S,1,4));
  IcoNum := StrToInt(Copy(S,5,4));
END;

FUNCTION TMainForm.FileTypeFromString(S: idxString) : TFileDataType;
VAR FNum : Word;
BEGIN
  FNum := StrToInt(Copy(S,1,4));
  IF Filenames.Objects[fNum] IS TFileData THEN
    WITH TFIleData(Filenames.Objects[fNum]) DO
      Result := FileDataType
  ELSE Result := fdtUnknown;
END;


function TMainForm.NameAndNum(Ndx : Integer) : String;
{Take the index of the highlighted icon and create
 a descriptive string for the status bar}
VAR Num, FNum : Word;
begin
  WITH ListBox1 DO
    BEGIN
      FilIcoFromString(Items[Ndx], FNum, Num);
      Result := ExtractFileName(Filenames[FNum]);
      CASE FileTypeFromString(Items[Ndx]) OF
        fdtNormal  : Result := Result + ' #' + IntToStr(Num);
        fdtICO     : Result := Result + ' (ICON)';
        fdtPE      : Result := Result + ' #' + IntToStr(Num)+ ' (PE)';
      END;
    END;
end;

procedure TMainForm.AppOnHint(Sender: TObject);
BEGIN
  IF Busy THEN Exit;
  SetStatusText(Application.Hint);
END;

procedure TMainForm.AppOnMessage(VAR Msg: TMsg;
  VAR Handled : Boolean);
VAR WMD : TWMDropFiles;
BEGIN
  IF Msg.message = WM_DROPFILES then
    BEGIN
      WMD.Msg    := Msg.message;
      WMD.Drop   := Msg.wParam;
      WMD.Unused := Msg.lParam;
      WMD.Result := 0;
      WMDropFiles(WMD);
      Handled := TRUE;
    END;
END;

procedure TMainForm.FormResize(Sender: TObject);
VAR Cols : Word;
CONST WasWidth : Integer = 0;
begin
  {Desired column width is stored in ListBox1.Tag}
  Cols := ClientWidth DIV ListBox1.Tag;
  IF Cols = 0 THEN Cols := 1;
  ListBox1.Columns := Cols;
  {If window is being sized wider, "round up" to
   next whole column. If Narrower, round down}
  IF ClientWidth <> Cols*ListBox1.Tag+2 THEN
    BEGIN
      IF WasWidth > ClientWidth THEN
        ClientWidth := Cols*ListBox1.Tag+2
      ELSE IF WasWidth < ClientWidth THEN
        ClientWidth := (Cols+1)*ListBox1.Tag+2;
    END;
  WasWidth := Width;
end;

FUNCTION TMainForm.ProcessFile(Filename : String) : Boolean;
VAR
  pName   : ARRAY[0..255] OF Char;
                    {PChar for use with ExtractIcon API function}
  NameNum,          {index of filename in Filenames list}
  IconIndex,        {index of icon in file}
  Ndx     : Word;   {index of icon in list box}
  IcoH    : hIcon;  {icon handle of extracted icon}
BEGIN
  Filename := UpperCase(Filename);
  StrPCopy(pName, Filename);
  NameNum := Filenames.Add(Filename);
  Filenames.Objects[NameNum] := TFileData.Create(Filename);
  WITH FileNames.Objects[NameNum] AS TFileData DO
    IF FileDataType = fdtUnknown THEN
      BEGIN
       Filenames.Delete(NameNum);
       Exit;
      END;
  IconIndex := 0;
  WITH ListBox1 DO
    REPEAT
      IcoH := ExtractIcon(hInstance, pName, IconIndex);
      Application.ProcessMessages;
      IF IcoH <= 1 THEN Break;
      {The non-displayed string for each item in the list
       box is an 8 character code. First four digits are
       an index into the Filenames list, second four
       digits are the icon number in that file}
      Ndx := Items.Add(Format('%.4d%.4d', [NameNum, IconIndex]));
      Items.Objects[Ndx] := TIcon.Create;
      WITH Items.Objects[Ndx] AS TIcon DO
        Handle := IcoH;
      IconIndex := IconIndex + 1;
      IF Ndx = UtterMax-1 THEN Break;
    UNTIL False;
  IF IconIndex = 0 THEN
    Filenames.Delete(NameNum);
  IF Ndx = UtterMax-1 THEN
    BEGIN
      IF NOT Quiet1.Checked THEN
        MessageBeep(MB_ICONSTOP);
      MessageDlg('IconJack can hold ' + IntToStr(UtterMax) +
       ' icons. It is now full.', mtWarning,
       [mbOk, mbHelp], 22);
      Result := False;
    END
  ELSE Result := True;
END;

procedure TMainForm.ListBox1DrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
VAR
  X, Y : Integer;
  R : TRect;
begin
  WITH ListBox1.Canvas, Rect DO
    BEGIN
      FillRect(Rect);
      X := (Right + Left - 32) DIV 2;
      Y := (Bottom + Top - 32) DIV 2;
      R := Classes.Rect(X-8, Y-8, X, Y);
      IF IntersectRect(R, R, Rect) > 0 THEN
        CASE FileTypeFromString(ListBox1.Items[Index]) OF
          fdtICO : IF MarkICOFiles1.Checked THEN
                      TextOut(R.Left, R.Top, 'I');
          fdtPE  : IF MarkPEFiles1.Checked THEN
                      TextOut(R.Left, R.Top, 'P');
        END;
      Draw(X, Y, TIcon(ListBox1.Items.Objects[Index]));
      IF Index = Marked THEN
        DrawFocusRect(Bounds(X-1,Y-1,34,34));
    END;
end;

PROCEDURE TMainForm.TooBusy(Status : String);
BEGIN
  ListBox1.HelpContext := 25;
  DragAcceptFiles(Handle, False);
  DragAcceptFiles(Application.Handle, False);
  SetStatusText(Status);
  Screen.Cursor := crHourglass;
  Application.ProcessMessages;
  Busy := True;
  LockWindowUpdate(Self.Handle);
END;

PROCEDURE TMainForm.NotBusy;
BEGIN
  LockWindowUpdate(0);
  Busy := False;
  Screen.Cursor := crDefault;
  Self.Refresh;
  (*SetStatusText('');*)
  DragAcceptFiles(Handle, True);
  DragAcceptFiles(Application.Handle, True);
  ListBox1.HelpContext := 1;
  IF NOT Quiet1.Checked THEN
    MessageBeep(MB_ICONEXCLAMATION);
  {Get the menu items enabled/disabled so
   the accelerator keys work right}
  File1Click(Self);
  Icon1Click(Self);
  Options1Click(Self);
END;

procedure TMainForm.ReadIcons1Click(Sender: TObject);
VAR
  ofNum : Word; {index into file list from OpenDialog}
begin
  IF ListBox1.Items.Count >= UtterMax THEN
    BEGIN
      IF NOT Quiet1.Checked THEN
        MessageBeep(MB_ICONSTOP);
      MessageDlg('IconJack is already holding '+
        IntToStr(UtterMax) + ' icons. You cannot add '+
        'any more.', mtWarning, [mbOk, mbHelp], 22);
      Exit;
    END;
  WITH OpenDialog1 DO
    IF Execute THEN
      BEGIN
        TooBusy('READING ICONS...');
        try
          try
            FOR ofNum := 0 TO Files.Count-1 DO
              IF NOT ProcessFile(Files[ofNum]) THEN Break;
          except
            ON EOutOfResources DO
              BEGIN
                IF NOT Quiet1.Checked THEN
                  MessageBeep(MB_ICONSTOP);
                MessageDlg('Not enough memory to add more icons',
                  mtWarning, [mbOK, mbHelp], 22);
              END;
          end;
        finally
          NotBusy;
          SetStatusText('');
          Caption := 'IconJack - ' + IntToStr(ListBox1.Items.Count)
            + ' icons';
        end;
      END;
end;

procedure TMainForm.WMDropFiles(VAR Msg: TWMDropFiles);
VAR
  N : Word;
  buffer : ARRAY[0..80] OF Char;
BEGIN
  try
    IF ListBox1.Items.Count >= UtterMax THEN
      BEGIN
        IF NOT Quiet1.Checked THEN
          MessageBeep(MB_ICONSTOP);
        MessageDlg('IconJack is already holding '+
          IntToStr(UtterMax) + ' icons. You cannot add '+
          'any more.', mtWarning, [mbOk, mbHelp], 22);
      END
    ELSE
      BEGIN
        TooBusy('ACCEPTING DROPPED ICONS...');
        try
          WITH Msg DO
            FOR N := 0 TO DragQueryFile(Drop, $FFFF, buffer, 80)-1 DO
              BEGIN
                DragQueryFile(Drop, N, Buffer, 80);
                IF NOT ProcessFile(StrPas(Buffer)) THEN Break;
              END;
        except
          ON EOutOfResources DO
            BEGIN
              IF NOT Quiet1.Checked THEN
                MessageBeep(MB_ICONSTOP);
              MessageDlg('Not enough memory to add more icons',
                mtInformation, [mbOK, mbHelp], 22);
            END;
        end;
      END;
  finally
    DragFinish(Msg.Drop);
    NotBusy;
    SetStatusText('');
    Caption := 'IconJack - ' + IntToStr(ListBox1.Items.Count)
      + ' icons';
  end;
END;

PROCEDURE TMainForm.DeleteIconsFrom(TheNum : Word);
VAR
  N : Word;
  dFnum, dInum : Word;
BEGIN
  WITH ListBox1 DO
    BEGIN
      FOR N := Items.Count-1 DOWNTO 0 DO
        BEGIN
          FilIcoFromString(Items[N],dFNum, dINum);
          IF dFNum = TheNum THEN
            DeleteAnItem(N, False);
        END;
      SetStatusText('');
      IF Items.Count = 0 THEN FileNames.Clear;
      Caption := 'IconJack - ' + IntToStr(Items.Count) + ' icons';
    END;
END;

procedure TMainForm.SaveIcon1Click(Sender: TObject);
VAR
  FNum, INum : Word;
  Rslt       : Integer;
  PEIcon     : TIcon;
  PEInfo     : ^TCursorIconInfo;
  BitsPix    : Byte;
begin
  IF ListBox1.ItemIndex < 0 THEN Exit;
  WITH SaveDialog1 DO
    IF Execute THEN
      BEGIN
        WITH ListBox1 DO
          BEGIN
            FilIcoFromString(Items[ItemIndex],FNum, INum);
            WITH Filenames.Objects[fNum] AS TFileData DO
              CASE FileDataType OF
                fdtNormal :
                  BEGIN
                    Rslt := ExtractIconFromExe(Filename, INum);
                    IF Rslt <> EXU_OK THEN
                      IF MessageDlg('Error processing ' + Filenames[fNum] +
                        ': ' + ErrorString(Rslt) +
                        '. Delete this file''s icons from display?',
                         mtError,
                        [mbYes, mbNo, mbHelp], 13) = IDYES THEN
                        DeleteIconsFrom(FNum);
                  END;
                {If it's a portable executable, just save a single
                 image using built-in SaveToFile}
                fdtPE : BEGIN
                  PEIcon := ListBox1.Items.Objects[ItemIndex] AS TIcon;
                  PEInfo := GlobalLock(PEIcon.Handle);
                  BitsPix := PEInfo^.BitsPix;
                  GlobalUnlock(PEIcon.Handle);
                  IF BitsPix = 1 THEN
                    BEGIN
                      IF MessageDlg('This is a 2-color icon from a PE file. '+
                        'IconJack cannot handle this type of icon. Delete ' +
                        'from display?', mtInformation, [mbYes, mbNo, mbHelp],
                        27) = IDYES THEN
                        Delete1Click(Self);
                    END
                  ELSE PEIcon.SaveToFile(Filename);
                END;
                fdtICO : ; {menu is disabled if file type is .ICO!}
                fdtUnknown : ; (*!*)
              END;
          END;
      END;
end;

procedure TMainForm.SaveAsDLL1Click(Sender: TObject);
{Build a complete Windows DLL from scratch, using MORICONS.DLL
 as a model. }
VAR
  NumIcons, NumImages : Word;
  TotalSize   : LongInt;
  ResoName,
  NonResName,
  FinalName,
  TempName    : String;
  ImageCounts : PByteArray;
  rscAlignShift,
  AlignFactor   : Word;
  CurFile     : Integer;     {Name of current file being processed}
  CurIcon     : Integer;     {number of icon being processed}

  function RoundUpToAlign(L : LongInt) : LongInt;
  BEGIN
    Result := L DIV AlignFactor;
    IF L MOD AlignFactor > 0 THEN
      Result := Result + 1;
  END;

  FUNCTION WriteFile(DllName : String) : Boolean;
  VAR
    F                 : File;
    NEH               : TNEHeader;
    ResourceTableSize : Word;
    EndOfFile,
    HoldFilePos       : LongInt;
  CONST Zero : LongInt = 0;

    PROCEDURE WriteDosHead;
    CONST
      Buff : ARRAY[0..$7F] OF Byte =
      ($4D,$5A,$FA,$00,$01,$00,$00,$00,
       $04,$00,$00,$00,$FF,$FF,$00,$00,
       $B8,$00,$00,$00,$00,$00,$00,$00,
       $40,$00,$00,$00,$00,$00,$00,$00,
       $00,$00,$00,$00,$00,$00,$00,$00,
       $00,$00,$00,$00,$00,$00,$00,$00,
       $00,$00,$00,$00,$00,$00,$00,$00,
       $00,$00,$00,$00,$80,$00,$00,$00,
       $0E,$1F,$BA,$0E,$00,$B4,$09,$CD,
       $21,$B8,$01,$4C,$CD,$21,$54,$68,
       $69,$73,$20,$70,$72,$6F,$67,$72,
       $61,$6D,$20,$63,$61,$6E,$6E,$6F,
       $74,$20,$62,$65,$20,$72,$75,$6E,
       $20,$69,$6E,$20,$44,$4F,$53,$20,
       $6D,$6F,$64,$65,$2E,$0D,$0A,$24,
       $00,$00,$00,$00,$00,$00,$00,$00);
    BEGIN
      BlockWrite(F, Buff, SizeOf(Buff));
    END;

    PROCEDURE InitializeNEHeader;
    {Not all of the data fields can be filled in at
     the start. Those that need to be filled in later
     are included as comments in this procedure, e.g.
     EntryTableRelOffset}
    BEGIN
      WITH NEH DO
        BEGIN
          Signature                      := $454E;
          LinkerVersion                  := 5;
          LinkerRevision                 := 1;
          {EntryTableRelOffset}
          EntryTableLength               := 2;
          Reserved                       := $8F6D224D;
          Flags                          := $8301;
          AutomaticDSegNumber            := 1;
          LocalHeapSize                  := 0;
          StackSize                      := 0;
          CSIP                           := NIL;
          SSSP                           := NIL;
          SegmentTableNumEntries         := 0;
          ModuleReferenceTableNumEntries := 0;
          NonresidentNameTableSize       := Length(NonResName) + 4;
          SegmentTableRelOffset          := 64;
          ResourceTableRelOffset         := 64;
          {ResidentNameTableRelOffset}
          {ModuleReferenceTableRelOffset} {same as EntryTableRelOffset}
          {ImportedNameTableRelOffset}    {same as previous}
          {NonresidentNameTableOffset}
          NumberOfMovableEntryPoints     := 0;
          ShiftCount                     := rscAlignShift;
          NumberOfResourceSegments       := 0;
          TargetOS                       := 2; {Windows}
          AdditionalInfo                 := 0;
          FastLoadAreaOffset             := 0;
          FastLoadAreaSectors            := 0;
          Reserved2                      := 0;
          ExpectedWindowsVersion         := $030A;
        END;
      BlockWrite(F, NEH, SizeOf(NEH));
    END;

    PROCEDURE WriteEntryTable;
    BEGIN
      ResourceTableSize := RoundUpToAlign(6 {fixed items} +
        2*SizeOf(ResTypeInfo) +
        NumIcons*SizeOf(NameInfo) +
        NumImages*SizeOf(NameInfo) +
        Length(ResoName))*AlignFactor;
      WITH NEH DO
        BEGIN
          EntryTableRelOffset := ResourceTableRelOffset +
            ResourceTableSize;
          ModuleReferenceTableRelOffset :=
            EntryTableRelOffset;
          ImportedNameTableRelOffset :=
            EntryTableRelOffset;
          Seek(F, EntryTableRelOffset + $80);
          BlockWrite(F, Zero, 1);
          BlockWrite(F, Zero, 1);
          NonResidentNameTableOffset := FilePos(F);
        END;
    END;

    PROCEDURE WriteNonResidentNameTable;
    BEGIN
      Seek(F, NEH.NonResidentNameTableOffset);
      BlockWrite(F, NonResName, Length(NonResName)+1);
      BlockWrite(F, Zero, 1);
      BlockWrite(F, Zero, 1);
      BlockWrite(F, Zero, 1);
      EndOfFile := FilePos(F);
      WHILE EndOfFile MOD AlignFactor <> 0 DO
        BEGIN
          BlockWrite(F, Zero, 1);
          Inc(EndOfFile);
        END;
    END;

    PROCEDURE WriteIconGroupResources;
    VAR
      RTI      : ResTypeInfo;
      NI       : NameInfo;
      N, M,
      ImNum,
      FNum,
      INum     : Word;
      HoldPos  : LongInt;
      NextID   : Word;
      Buffer   : DataBuffer;
      IcoHead  : IconDirExe ABSOLUTE Buffer;
      BuffLen  : Word;
      TFD      : TFileData;
      WasPE    : Boolean;
      PEIcon   : TIcon;
      PEInfo   : ^TCursorIconInfo;
      BitsPix  : Byte;
    BEGIN
      Seek(F, NEH.ResourceTableRelOffset + $80);
      BlockWrite(F, rscAlignShift, 2);
      RTI.rtTypeId := $8000 + LongInt(RT_GROUP_ICON);
      RTI.rtResourceCount := NumIcons;
      RTI.rtReserved := 0;
      BlockWrite(F, RTI, SizeOf(RTI));
      NextID := 1;
      FOR N := 0 TO NumIcons-1 DO
        BEGIN
          CurIcon := N;
          Application.ProcessMessages;
          WITH NI DO
            BEGIN
              niOffset := EndOfFile DIV AlignFactor;
              niLength := RoundUpToAlign(6 + 14 * ImageCounts^[N]);
              niFlags  := $1C30;
              niID     := $8001 + N;
              niHandle := 0;
              niUsage  := 0;
            END;
          BlockWrite(F, NI, SizeOf(NI));
          FilIcoFromString(ListBox1.Items[N], FNum, INum);
          CurFile := fNum;
          TFD := Filenames.Objects[fNum] AS TFileData;
          IF TFD.FileDataType = fdtPE THEN
            BEGIN
              PEIcon := ListBox1.Items.Objects[N] AS TIcon;
              PEInfo := GlobalLock(PEIcon.Handle);
              BitsPix := PEInfo^.BitsPix;
              GlobalUnlock(PEIcon.Handle);
              IF BitsPix = 1 THEN
                BEGIN
                  Raise Exception.Create('Cannot save monochrome icons ' +
                    'from PE file.');
                END;
              {problem when bitspix=1}
              WITH PEIcon DO
                SaveToFile('\TEMP$$$$.ICO');
              TFD := TFileData.Create('\TEMP$$$$.ICO');
              WasPE := True;
            END
          ELSE WasPE := False;
          BuffLen := TFD.GetIconDirectory(INum, Buffer);
          FOR ImNum := 0 TO IcoHead.idCount-1 DO
            BEGIN
              IcoHead.idEntries[ImNum].wId := NextId;
              NextID := NextID + 1;
            END;
          CurFile := -1;
          HoldPos := FilePos(F);
          Seek(F, EndOfFile);
          BlockWrite(F, Buffer, BuffLen);
          EndOfFile := FilePos(F);
          WHILE EndOfFile MOD AlignFactor <> 0 DO
            BEGIN
              BlockWrite(F, Zero, 1);
              Inc(EndOfFile);
            END;
          Seek(F, HoldPos);
          IF WasPE THEN TFD.Free;
        END;
      RTI.rtTypeId := $8000 + LongInt(RT_ICON);
      RTI.rtResourceCount := NumImages;
      RTI.rtReserved := 0;
      BlockWrite(F, RTI, SizeOf(RTI));
      NextID := $8001;
      FOR N := 0 TO NumIcons-1 DO
        BEGIN
          CurIcon := N;
          Application.ProcessMessages;
          FilIcoFromString(ListBox1.Items[N], FNum, INum);
          CurFile := fNum;
          TFD := Filenames.Objects[fNum] AS TFileData;
          IF TFD.FileDataType = fdtPE THEN
            BEGIN
              WITH ListBox1.Items.Objects[N] AS TIcon DO
                SaveToFile('\TEMP$$$$.ICO');
              TFD := TFileData.Create('\TEMP$$$$.ICO');
              WasPE := True;
            END
          ELSE WasPE := False;
          FOR M := 0 TO ImageCounts^[N]-1 DO
            BEGIN
              BuffLen := TFD.GetIconImage(INum, M, Buffer);
              WITH NI DO
                BEGIN
                  niOffset := EndOfFile DIV AlignFactor;
                  niLength := RoundUpToAlign(BuffLen);
                  niFlags  := $1C10;
                  niID     := NextID;
                  niHandle := 0;
                  niUsage  := 0;
                END;
              BlockWrite(F, NI, SizeOf(NI));
              HoldPos := FilePos(F);
              Seek(F, EndOfFile);
              BlockWrite(F, Buffer, BuffLen);
              EndOfFile := FilePos(F);
              WHILE EndOfFile MOD AlignFactor <> 0 DO
                BEGIN
                  BlockWrite(F, Zero, 1);
                  Inc(EndOfFile);
                END;
              Seek(F, HoldPos);
              NextID := NextID + 1;
              IF WasPE THEN TFD.Free;
            END;
          CurFile := -1;
        END;
      {Write rscEndTypes}
      BlockWrite(F, Zero,1);
      BlockWrite(F, Zero,1);
      NEH.ResidentNameTableRelOffset := FilePos(F)-$80;
      BlockWrite(F, ResoName, length(ResoName)+1);
      HoldPos := FilePos(F);
      WHILE HoldPos < NEH.EntryTableRelOffset+$80 DO
        BEGIN
          BlockWrite(F, Zero, 1);
          Inc(HoldPos);
        END;
    END;

  BEGIN
    Result := False;
    AssignFile(F, DllName);
    CurFile := -1;
    try try
      Rewrite(F, 1);
      WriteDOSHead;
      InitializeNEHeader;
      WriteEntryTable;
      WriteNonresidentNameTable;
      WriteIconGroupResources;
      Seek(F, $80);
      BlockWrite(F, NEH, SizeOf(NEH));
    finally
      CloseFile(F);
    end;
    except
      On E: EInOutError DO
        BEGIN
          Screen.Cursor := crDefault;
          IF CurFile = -1 THEN
            MessageDlg('Error processing ' + FinalName +
              ':  ' + E.Message, mtError,
              [mbOk, mbHelp], 13)
          ELSE IF MessageDlg('Error processing ' + FileNames[CurFile] +
              ':  ' + E.Message + '. Delete this file''s icons '+
              'from display?', mtError,
              [mbYes, mbNo, mbHelp], 26) = IDYES THEN
            DeleteIconsFrom(CurFile);
        END;
      On E: Exception DO
        BEGIN
          Screen.Cursor := crDefault;
          ListBox1.ItemIndex := CurIcon;
          IF MessageDlg('Error processing ' + FileNames[CurFile] +
              ':  ' + E.Message + '. Delete this icon from display?',
              mtError, [mbYes, mbNo, mbHelp], 26) = IDYES THEN
            DeleteAnItem(CurIcon, True);
        END;
    end;
    Result := True;
  END;

  FUNCTION CalcSizes : Boolean;
  {Its necessary that we know how many images are going
   to be written to the .DLL before we start writing any
   resource data. This routine counts them. It also makes
   an estimate of the final size of the icon data, and
   verifies that all the necessary files are still present}
  VAR
    NFilenames,
    NListBox,
    NFile, NImage,
    NIcon        : Word;
    Rslt,
    IcSiz, ImSiz : Integer;

    PROCEDURE ErrorOut(ErrCode : Integer; ErrMsg : String);
    BEGIN
      Screen.Cursor := crDefault;
      IF MessageDlg('Error processing ' + FileNames[NFile] +
          ':  ' + ErrMsg + '. Delete this file''s icons '+
          'from display?', mtError,
          [mbYes, mbNo, mbHelp], 13) = IDYES THEN
        DeleteIconsFrom(NFile);
    END;

  BEGIN
    NumImages := 0;
    TotalSize := 0;
    {for each file in the filenames list...}
    FOR NFilenames := 0 TO Filenames.Count-1 DO
      WITH Filenames.Objects[NFileNames] AS TFileData DO
        BEGIN
          Rslt := Verify;
          IF Rslt <> EXU_OK THEN
            BEGIN
              ErrorOut(Rslt, ErrorString(Rslt));
              Result := False;
              Exit;
            END
          ELSE Application.ProcessMessages;
        END;
    FOR NListBox := 0 TO ListBox1.Items.Count-1 DO
      BEGIN
        FilIcoFromString(ListBox1.Items[NListBox], NFile, NIcon);
        WITH Filenames.Objects[NFile] AS TFileData DO
          BEGIN
            ImageCounts^[NListBox] := NumImgs[NIcon];
            NumImages := NumImages + ImageCounts^[NListBox];
            IcSiz := SizIco[NIcon];
            IF IcSiz < 0 THEN
              BEGIN
                ErrorOut(IcSiz, ErrorString(IcSiz));
                Result := False;
                Exit;
              END;
            ImSiz := SizImgs[nIcon];
            IF ImSiz < 0 THEN
              BEGIN
                ErrorOut(ImSiz, ErrorString(ImSiz));
                Result := False;
                Exit;
              END;
            TotalSize := TotalSize + IcSiz + ImSiz;
          END;
      END;
  END;

begin
  WITH SaveDialog3 DO
    IF Execute THEN
      BEGIN
        TooBusy('Writing DLL...');
        ResoName := 'ICONJACK';
        NonResName := 'Icons collected by IconJack (IconJack copyright '+
          '(c) 1995 by Ziff-Davis Publishing Company)';
        GetMem(ImageCounts, ListBox1.Items.Count);
        NumIcons := ListBox1.Items.Count;
        IF NOT CalcSizes THEN
          BEGIN
            NotBusy;
            SetStatusText(Filename + ' NOT created');
            Exit;
          END;
        TotalSize := TotalSize + $80 {DOS header} +
          SizeOf(TNEHeader) + 10 {fixed items} +
          2*SizeOf(ResTypeInfo) +
          LongInt(NumIcons)*SizeOf(NameInfo) +
          LongInt(NumImages)*SizeOf(NameInfo) +
          Length(ResoName) +
          Length(NonResName);
        rscAlignShift := 0;
        AlignFactor := 1;
        {Set rscAlignShift and AlignFactor so that all of the
         offsets can be expressed as a word value multiplied
         by the Align factor.}
        WHILE TotalSize > 65000 DO
          BEGIN
            TotalSize := TotalSize DIV 2;
            rscAlignShift := rscAlignShift + 1;
            AlignFactor := AlignFactor * 2;
          END;
        FinalName := Filename;
        TempName := ExtractFilePath(Filename) + '$ICOJAK$.$$$';
        try try
          IF WriteFile(TempName) THEN
            BEGIN
              DeleteFile(Filename);
              RenameFile(TempName, Filename);
              SetStatusText(Filename + ' created');
            END
          ELSE
            BEGIN
              DeleteFile(TempName);
              SetStatusText(Filename + ' NOT created');
            END;
        finally
          NotBusy;
          FreeMem(ImageCounts, ListBox1.Items.Count);
        end;
        except
          On Exception DO
            ShowMessage('WriteFile failed');
        end;
      END;
end;

procedure TMainForm.IconSpacing1Click(Sender: TObject);
begin
  IconSpacingForm := TIconSpacingForm.Create(Self);
  WITH IconSpacingForm DO
    try
      VertSpinEdit.Value := ListBox1.ItemHeight;
      HorzSpinEdit.Value := ListBox1.Tag;
      IF ShowModal = mrOK THEN
        BEGIN
          ListBox1.ItemHeight := VertSpinEdit.Value;
          ListBox1.Tag := HorzSpinEdit.Value;
          FormResize(Self);
        END;
    finally
      Free;
    end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Busy := False;
  Screen.Cursors[1] := LoadCursor(hInstance, 'XXDragIcon');
  Application.OnHint := AppOnHint;
  Filenames := TStringList.Create;
  Filenames.Duplicates := dupError;
  Marked := -1;
  {Read lots of INI file information}
  WITH TIniFile.Create(ChangeFileExt(
    Application.ExeName,'.INI')) DO
    try
      Left := ReadInteger('Main', 'Left', 40);
      Top := ReadInteger('Main', 'Top', 40);
      Width := ReadInteger('Main', 'Width', 400);
      Height := ReadInteger('Main', 'Height', 400);
      ListBox1.ItemHeight := ReadInteger('Spacing','Vertical',38);
      ListBox1.Tag := ReadInteger('Spacing','Horizontal',38);
      MarkICOFiles1.Checked := ReadBool('Options', 'Mark ICO', False);
      MarkPEFiles1.Checked := ReadBool('Options', 'Mark PE', False);
      Quiet1.Checked := ReadBool('Options', 'Quiet', False);
      OpenDialog1.FilterIndex := ReadInteger('Options', 'Default file type', 1);
      CASE OpenDialog1.FilterIndex OF
        1 : DefaultToIco1.Checked := True;
        2 : DefaultToExe1.Checked := True;
        3 : DefaultToDLL1.Checked := True;
        4 : DefaultToAllThree1.Checked := True;
      END;
    finally
      Free;
    end;
  DragAcceptFiles(Handle, True);
  DragAcceptFiles(Application.Handle, True);
  Application.OnMessage := AppOnMessage;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  {write INI file information}
  WITH TIniFile.Create(ChangeFileExt(
    Application.ExeName,'.INI')) DO
    try
      IF WindowState = wsNormal THEN
        BEGIN
          WriteInteger('Main', 'Left', Left);
          WriteInteger('Main', 'Top', Top);
          WriteInteger('Main', 'Width', Width);
          WriteInteger('Main', 'Height', Height);
        END;
      WriteInteger('Spacing','Vertical',ListBox1.ItemHeight);
      WriteInteger('Spacing','Horizontal',ListBox1.Tag);
      WriteBool('Options', 'Mark ICO', MarkICOFiles1.Checked);
      WriteBool('Options', 'Mark PE', MarkPEFiles1.Checked);
      WriteBool('Options', 'Quiet', Quiet1.Checked);
      WriteInteger('Options', 'Default file type', OpenDialog1.FilterIndex);
    finally
      Free;
    end;
end;

procedure TMainForm.ListBox1Click(Sender: TObject);
begin
  IF Busy THEN Exit;
  SetStatusText(NameAndNum(ListBox1.ItemIndex));
  Mark1.Enabled := ListBox1.ItemIndex >= 0;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.Icon1Click(Sender: TObject);
{Enable/disable items in the Icon submenu}
begin
  WITH ListBox1 DO
    BEGIN
      Clear1.Enabled  := (NOT Busy) AND (Items.Count > 0);
      Delete1.Enabled := (NOT Busy) AND (Items.Count > 0);
      Mark1.Enabled   := (NOT Busy) AND (ItemIndex >= 0);
      Place1.Enabled  := (NOT Busy) AND (Marked >= 0);
    END;
end;

procedure TMainForm.Clear1Click(Sender: TObject);
{clear the list box completely}
VAR N : Word;
begin
  IF ListBox1.Items.Count > 0 THEN
    FOR N := 0 TO ListBox1.Items.Count-1 DO
      try
        WITH ListBox1.Items.Objects[N] AS TIcon DO
          Free;
      except
        ON Exception DO;
      end;
  ListBox1.Clear;
  FileNames.Clear;
  SetStatusText('');
  Marked := -1;
  Caption := 'IconJack - 0 icons';
end;

procedure TMainForm.DeleteAnItem(N : Integer; Report : Boolean);
{delete the Nth item; keep the highlight
 in the same location if possible}
VAR WasIndex : Integer;
begin
  WITH ListBox1 DO
    BEGIN
      IF N < 0 THEN Exit;
      IF Marked = N THEN
        Marked := -1
      ELSE IF Marked > N THEN
        Marked := Marked - 1;
      WasIndex := ItemIndex;
      try
        WITH Items.Objects[N] AS TIcon DO Free;
      except
        ON Exception DO;
      end;
      Items.Delete(N);
      IF WasIndex >= Items.Count THEN Dec(WasIndex);
      IF WasIndex >= 0 THEN ItemIndex := WasIndex;
      IF Report THEN
        BEGIN
          SetStatusText('');
          IF Items.Count = 0 THEN
            FileNames.Clear;
          Caption := 'IconJack - ' + IntToStr(Items.Count) + ' icons';
        END;
    END;
end;

procedure TMainForm.Delete1Click(Sender: TObject);
{delete the highlighted item; keep the highlight
 in the same location if possible}
begin
  DeleteAnItem(ListBox1.ItemIndex, True);
end;

procedure TMainForm.ListBox1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  IF Busy THEN Exit;
  ListBox1.BeginDrag(False);
end;

procedure TMainForm.ListBox1DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := (Source = ListBox1) AND
    (ListBox1.Items.Count > 0);
end;

procedure TMainForm.ListBox1DragDrop(Sender, Source: TObject; X,
  Y: Integer);
VAR NewIndex : Integer;
begin
  WITH ListBox1, Items DO
    BEGIN
      NewIndex := ItemAtPos(Point(X,Y), False);
      IF NewIndex >= Count THEN
        NewIndex := Count-1;
      Move(ItemIndex, NewIndex);
      ItemIndex := NewIndex;
    END;
end;

procedure TMainForm.Mark1Click(Sender: TObject);
begin
  IF ListBox1.ItemIndex < 0 THEN Exit;
  Marked := ListBox1.ItemIndex;
  ListBox1.RePaint;
end;

procedure TMainForm.Place1Click(Sender: TObject);
VAR WasIndex : Integer;
begin
  IF ListBox1.ItemIndex < 0 THEN Exit;
  WITH ListBox1 DO
    BEGIN
      WasIndex := ItemIndex;
      Items.Move(Marked, ItemIndex);
      ItemIndex := WasIndex;
      Marked := -1;
    END;
end;

procedure TMainForm.File1Click(Sender: TObject);
{Disable the "save as .ICO" menu choice if the item
 came from an .ICO file already}
begin
  WITH ListBox1 DO
    BEGIN
      ReadIcons1.Enabled := NOT Busy;
      SaveIcon1.Enabled  := (NOT Busy) AND
        (ItemIndex >= 0) AND
        (FileTypeFromString(Items[ItemIndex]) <> fdtICO);
      SaveAsDLL1.Enabled := (NOT Busy) AND
        (Items.Count > 0);
      Exit1.Enabled := NOT Busy;
    END;
end;

procedure TMainForm.Contents1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.SearchforHelpOn1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_PARTIALKEY, 0);
end;

procedure TMainForm.HowtoUseHelp1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TMainForm.AboutIconJack1Click(Sender: TObject);
begin
  AboutForm := TAboutForm.Create(Application);
  try
    AboutForm.ShowModal;
  finally
    AboutForm.Free;
  end;
end;

procedure TMainForm.MarkICOfiles1Click(Sender: TObject);
begin
  WITH Sender AS TMenuItem DO
    Checked := NOT Checked;
  ListBox1.Refresh;
end;

procedure TMainForm.Defaulttoallthree1Click(Sender: TObject);
begin
  DefaultToIco1.Checked := False;
  DefaultToExe1.Checked := False;
  DefaultToDLL1.Checked := False;
  DefaultToAllThree1.Checked := False;
  WITH Sender AS TMenuItem DO
    BEGIN
      Checked := True;
      OpenDialog1.FilterIndex := Tag;
    END;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := NOT Busy;
end;

procedure TMainForm.Options1Click(Sender: TObject);
begin
  IconSpacing1.Enabled       := NOT Busy;
  MarkICOfiles1.Enabled      := NOT Busy;
  MarkPEfiles1.Enabled       := NOT Busy;
  DefaulttoICO1.Enabled      := NOT Busy;
  DefaulttoEXE1.Enabled      := NOT Busy;
  DefaulttoDLL1.Enabled      := NOT Busy;;
  Defaulttoallthree1.Enabled := NOT Busy;
end;

procedure TMainForm.WMNcRButtonDblClk(VAR Msg: TWMNCRButtonDblClk);
{IconJack should never become stuck in the "busy" state, but
 "never" is such an extreme word. In the event that IconJack truly
 does get stuck, a right-double-click on the minimize button will
 unstick it. }
BEGIN
  Inherited;
  IF Msg.HitTest = HTMINBUTTON THEN NotBusy;
END;

procedure TMainForm.Quiet1Click(Sender: TObject);
begin
  Quiet1.Checked := NOT Quiet1.Checked;
end;

end.
