PROGRAM Is_Today_The_Last_Weekday_Of_The_Current_Month;
USES DOS;

FUNCTION IsLeapYear (yr: WORD): BOOLEAN;
BEGIN
  IsLeapYear := ((yr MOD 4 = 0) AND (yr MOD 100 <> 0)) OR (yr MOD 400 = 0)
END;

FUNCTION DaysInMonth (y, m : WORD): BYTE;
BEGIN
  CASE m OF
    1,3,5,7,8,10,12 : DaysInMonth := 31;
    4,6,9,11        : DaysInMonth := 30;
    2               : DaysInMonth := 28 + Ord (IsLeapYear (y));
  END;
END; { DaysInMonth }

VAR
  Year, Month, Date, DOW : WORD;
  LastDayOfMonth : BYTE;
  IsLastWeekDay : BOOLEAN;

BEGIN
  IsLastWeekDay := FALSE;
  GetDate (Year, Month, Date, DOW);
  LastDayOfMonth := DaysInMonth (Year, Month);

  IF DOW in [1..5]   { 0 = Sunday and 6 = Saturday }
  THEN
    IF (Date = LastDayOfMonth) OR
       ((DOW = 5) AND ((LastDayOfMonth - Date) <= 2))
    THEN IsLastWeekDay := TRUE;

  IF IsLastWeekDay
  THEN Halt (1)  { TRUE }
  ELSE Halt (0); { FALSE }
END.
