// expr.prg
// demonstration of expressions and functions

string_expr:
// concatenate strings
($val = 'abc'+'123');
// display the value
(disp = nl + $val + nl);

// character interval
($val = 'a' .. 'd');
// display the value
(disp = nl + $val + nl);

// bitwise AND
($val = 'abcd' & x'5f5f5f5f');
// display the value
(disp = nl + $val + nl);

// bitwise XOR
($val = 'aBcD' ^ x'20202020');
// display the value
(disp = nl + $val + nl);

// bitwise OR
($val = 'ABCD' | x'20202020');
// display the value
(disp = nl + $val + nl);

// duplication
($val = 'abc' * 3);
// display the value
(disp = nl + $val + nl);

string_fct:
// print a numerical value
($val = $num(123));
// display the value
(disp = nl + $val + nl);

// print a numerical value as hexadecimal string
($val = $hex(0x123, 4));
// display the value
(disp = nl + $val + nl);

// convert max. 4 bytes of a numerical value to a string
($val = $mem(0x616263, 2));
// display the value
(disp = nl + $val + nl);

// print a substring
($val = $substr('abcdef', 2, 3));
// display the value
(disp = nl + $val + nl);

// accept a string from the keyboard
($val = $input('new value for $val '));
// display the value
(disp = nl + $val + nl);

// convert a string to lower case
($val = $lower('AbCDef'));
// display the value
(disp = nl + $val + nl);

// convert a string to upper case
($val = $upper('AbCDef'));
// display the value
(disp = nl + $val + nl);

// print the name of the current file
($val = $file(0));
// display the value
(disp = nl + $val + nl);

num_fct:
// length of a string
(#val = #len('abc'));
// display the value
(disp = nl + $num(#val) + nl);

set_search_pos:
// please set a breakpoint at the label get_search_pos
// (press 's' then 'b' then type get_search_pos then press <enter>)
// then choose the go option
// search a string for later use
'copyright' : t get_search_pos;
:<+1 byte>; :f s; : set_search_pos;

get_search_pos:
// current search position, i.e. the offset
// from the beginning of the current file
// to the character, that will be checked next
// to find a matching string
// note: this is past the previously found matching string!!

(#val = #byte());
// display the value
(disp = nl + $num(#val) + ' = 0x' + $hex(#val,4) + nl);

// number of the line, that contains the search position
(#val = #line());
// display the value
(disp = nl + $num(#val) + ' = 0x' + $hex(#val,4) + nl);

// number of the column, that corresponds to the search position
(#val = #column());
// display the value
(disp = nl + $num(#val) + ' = 0x' + $hex(#val,4) + nl);

// integer value of a printable number 
(#val = #num('123'));
// display the value
(disp = nl + $num(#val) + ' = 0x' + $hex(#val,4) + nl);

// integer value of a hexadecimal string
(#val = #hex('1f2'));
// display the value
(disp = nl + $num(#val) + ' = 0x' + $hex(#val,4) + nl);

// at most 4 bytes from the string as an integer value
(#val = #mem(x'010203', 2));
// display the value
(disp = nl + $num(#val) + ' = 0x' + $hex(#val,4) + nl);

// do not confirm the statistic message 
(#options ('p:-cs'));

:s;

