// LIST1.PRG
// display nothing but the data
// use the option /l:list.out to copy the data to a file

// inhibit any other output to the log file
(#options ('p:-l:+lo'));

begin:
find_headline:
// skip empty line
*(ws)l(0..) + nl : t find_headline;
// find the first headline; stop on error
<1> ' salesman ':f s;
skip_line:
// skip this line
* + nl;
// check for dashed line; skip dashed line
<1> ' ------' + * + nl :f skip_line;

check_line:
// check for end of page (empty line)
*(ws)l(0..) + nl : t find_headline;
// skip leading spaces
*(ws);
// display name
*(-ws) > display;

check_number:
// skip column separator
*(ws)l(0..) + '|' + *(ws)l(0..);
// check for end of line
nl > display :t check_line;
// display a TAB character
(display = '\t');
// display sign
'-' > display;

disp_digits:
*(digit) > display;
// skip comma
',':t disp_digits;
// display fractional part
'.' > display + *(digit) > display;
// search next number
:check_number;
// end of LIST1.PRG


