###################################
#
#  Modem and Host Scripts V2.4.2
#   Modified by John Mudge [jmudge@wln.com]
#
#   Changes in 2.4:
#   Added script for SupraFAXModem 144LC
#
#   Changes in 2.4.1:
#   Added script for USR Courier V32.bis 
#
#   Changes in 2.4.2:
#   Modified script for USR Courier V32.bis to run Supra 14400
#
###################################
#
#   Modem scripts
#
#  For each modem type xxx, supply script:
#
#      Modem.xxx.Dial         Dials the phone, waits for connection
#      Modem.xxx.Hangup       Gets the modem to hang up the phone
#      Modem.xxx.Status       Returns the modem's status (-1,0,1=?,no cd,cd)
#
###################################
#
#
Procedure     Modem.Supra.Dial
Message   "Initializing ...."
Send   'ATZ<'
TimeOut   10            'Your modem is not responding, try turning it off, then on.'
Reject    'ERROR'       'Your modem said "Error" to the initialization string.'
Expect    'OK'          'Your modem did not say "OK".'
Wait 2
Message   "Dialing ...."
Send    'ATDT %n<'
TimeOut 60              'No connection after 1 minute.'
Reject  'NO DIALTONE'   'Your modem can't get a dial tone, check phone line to modem.'
Reject  'BUSY'          'The server is fully occupied.'
Reject  'NO CARRIER'    'The server modem is not responding.  Try again.'
Expect  'CONNECT'       'Did not get the CONNECT response.'
Message        "Connected ...."
EndProcedure   Modem.Supra.Dial
#
Procedure Modem.Supra.HangUp
Flush
Message        "Disconnecting ...."
Wait 1
Send '+++'
Wait 2
Flush
Send 'ATH<'
DTR Off
Message        "Disconnected ...."
EndProcedure Modem.Supra.HangUp
#
###############################################
#
#
##############################################
#
#        Host Scripts
#
#    For each host hhh, supply two scripts:
#
#
#      Host.hhh.Login          Logs in and goes into SLIP mode
#
#      Host.hhh.LogOut         Does any logout chores (often empty)
#
#
Procedure    Host.WLN.Login
TimeOut 60      'The SLIP server is not responding.'
Message         'Waiting for SLIP server to respond.'
Quiet ON
#Expect   'Verification'
#TimeOut 5
Message         'SLIP server is responding.'
Message         'Sending your user name and password.'
Quiet OFF
Expect   'Login:'
Send '%u<'
Expect   'Password:'
Private
Send '%p<'
Reject    'Access denied'   'Your user name or password was not accepted.'
TimeOut 30    'SLIP server did not respond to your validation request.'
Expect    '==>'
TimeOut 10    'SLIP server did not respond to SLIP command.'
Send 'slip<'
Grab MYIP
Expect 'Your address is'
Message 'Login to SLIP server successful.'
EndProcedure   Host.WLN.Login
#
#
#
Procedure      Host.WLN.LogOut
EndProcedure   Host.WLN.LogOut
#
#   End of Script file
#
