//
//  CryptXOR.C
//  Runtime Loadable Encryptor Extension for Pegasus Mail for Windows.
//  Copyright (c) 1995, David Harris, All Rights Reserved.
//
//  The author grants explicit permission for this source code to be
//  used or modified as required, subject only to the conditions that
//  the copyright notices above are preserved and that by using this
//  code you agree that the code is provided without warranty of any
//  kind, either explicit or implied, and you use it at your own
//  risk.
//
//  This module implements a simple encryptor module to demonstrate
//  the general format and layout such an extension should take.
//
//  *** WARNING!! The encryption method this module uses barely even
//  *** warrants the title "encryptor"; it is a very simple algorithm
//  *** that should be quite easy to break for anyone wishing to invest
//  *** some time in standard cryptanalytical techniques.
//  ***
//  *** UNDER NO CIRCUMSTANCES SHOULD YOU REGARD THIS AS A WORKING
//  *** ENCRYPTOR OFFERING ANY KIND OF SECURITY. IT IS INTENDED PURELY
//  *** AS TUTORIAL CODE SHOWING IMPLEMENTATIONAL DETAIL.
//

#define STRICT
#include <windows.h>
#include <bwcc.h>
#include <stdio.h>
#include <string.h>
#include "..\wpmforms.h"

HINSTANCE  hLibInstance;            // set in LibMain, used throughout the DLL
HWND last_focus;

#pragma warn -par

//
//  FORMINIT: Runtime Loadable Encryptors are simply a specialised form of
//  WinPMail Extension. As such, they must follow the standard rules for
//  such Extensions, including having an .FFF file to describe their char-
//  acteristics to the Extensions Manager, and a routine called FORMINIT
//  that is called when the module is loaded. For more information on
//  Extensions, examine the files WPMFORMS.TXT and WPMFORMS.TXT supplied in
//  the "FORMS" subdirectory of the WinPMail install directory. Note that
//  an encryptor module can use the entire family of Extension Manager
//  interface calls except those specific to READER Extensions.
//
//  In short, FORMINIT must take the following form:
//
//  WORD FAR PASCAL _export FORMINIT (WORD version, int variant, HWND hParent,
//      char *data, HWND *hDialog, char *callback_name);
//
//  "version" is passed in with the version of the WinPMail forms
//     manager which is running.
//  "variant" indicates what type of form is required - the following
//     values are currently defined:
//       0: Create a form for composing a message
//       1: Create a form for reading a message
//  "hParent" contains the handle of the WinPMail MDI child window
//     which is to contain the form. For encryptor modules this window
//     will almost always be hidden.
//  "data" contains any string defined as being required for the
//     form in the menu interface.
//  "hDialog" should be filled in with the window handle of the
//     modeless dialog created within the MDI child window.
//  "callback_name" (optional) should be filled in with the name of the
//     function in the DLL of the exported function to which messages
//     should be sent or NULL if there is none. If NULL, messages are
//     sent to the dialog returned in "hDialog". You will use an
//     indirect callback of this kind when your extension does not
//     create a dialog within the enclosing parent window.
//
//  When forminit is called, the DLL should register any window
//  classes it needs then create the dialog within the MDI parent
//  window and size it to the correct size. On return WinPMail will
//  resize the parent window to enclose the dialog correctly. The
//  DLL should NOT make the dialog visible - WinPMail will do that
//  as required.


WORD FAR PASCAL _export FORMINIT (WORD version, int variant, HWND hParent,
   char *data, HWND *hDialog, FORM_CALLBACK *callback)
   {
   //  First, check to see if the version of the form manager is
   //  one we can work with. This check is pretty arbitrary - you
   //  should probably assume that you may not work with any version
   //  where the major version number is higher than the original
   //  version you targeted.

   if ((version & 0xFF00) > 0x100) return 0;

   *hDialog = NULL;
   return 1;
   }


BOOL FAR PASCAL LibMain (HINSTANCE hInst, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
   {
   //  This particular encryptor has no user interface as such
   //  so we don't have to register any window classes or anything.

   if (! hLibInstance) hLibInstance = hInst;

   return (TRUE);             // Initialization went OK
   }

