//
//  ENCRYPT.C
//  Runtime Loadable Encryptor Extension for Pegasus Mail for Windows.
//  Copyright (c) 1995, David Harris, All Rights Reserved.
//
//  Encryptor module: this module implements the actual Encryptor
//  Interface Routines called by WinPMail at runtime. For more
//  information on the actual form and function of each call, consult
//  the file CRYPTIF.TXT in the FORMS subdirectory of your WINPMAIL
//  installation directory.
//
//  The author grants explicit permission for this source code to be
//  used or modified as required, subject only to the conditions that
//  the copyright notices above are preserved and that by using this
//  code you agree that the code is provided without warranty of any
//  kind, either explicit or implied, and you use it at your own
//  risk.
//
//  *** WARNING!! The encryption method this module uses barely even
//  *** warrants the title "encryptor"; it is a very simple algorithm
//  *** that should be quite easy to break for anyone wishing to invest
//  *** some time in standard cryptanalytical techniques.
//  ***
//  *** UNDER NO CIRCUMSTANCES SHOULD YOU REGARD THIS AS A WORKING
//  *** ENCRYPTOR OFFERING ANY KIND OF SECURITY. IT IS INTENDED PURELY
//  *** AS TUTORIAL CODE SHOWING IMPLEMENTATIONAL DETAIL.
//
//  This sample implementation does not support digital signatures or
//  public keys and thus does not implement the following calls:
//
//     int FAR PASCAL SIGN_FILE (char *sourcefile, char *destfile,
//        char *recipient, char *key, int encrypt_as_well);
//     int FAR PASCAL VERIFY_SIGNATURE (char *sourcefile);
//     int FAR PASCAL (*KEY_MANAGEMENT) (char *sourcefile);

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <io.h>

#pragma warn -par       //  Not worried about unused parameters


int FAR PASCAL _export ENCRYPT_FILE (char *sourcefile,
   char *destfile, char *recipient, char *key, int textfile)
   {
   FILE *infil, *outfil;
   int c, i, result;
   char *s;

   if ((infil = fopen (sourcefile, "rb")) == NULL) return 0;
   if ((outfil = fopen (destfile, "wb")) == NULL)
      {
      fclose (infil);
      return 0;
      }

   s = key;
   i = 0;
   result = 1;
   fputc ((char) 127, outfil);
   fputc ('\n', outfil);
   while ((c = fgetc (infil)) != EOF)
      {
      c ^= ((*s) + i);
      ++ s;
      if (*s == '\0')
         {
         s = key;
         ++ i;
         if (i >= 20) i = 0;
         }

      if ((c < ' ') || (c > 127)) result = 2;
      fputc (c, outfil);
      }
   fputc ((char) 127, outfil);
   fputc ('\n', outfil);
   fclose (infil);
   fclose (outfil);
   return result;
   }


int FAR PASCAL _export DECRYPT_FILE (char *sourcefile, char *destfile, char *key)
   {
   FILE *infil, *outfil;
   int c, i, result, working, trigger;
   char *s;

   if ((infil = fopen (sourcefile, "rb")) == NULL) return 0;
   if ((outfil = fopen (destfile, "wb")) == NULL)
      {
      fclose (infil);
      return 0;
      }

   s = key;
   i = working = 0;
   trigger = 0;
   result = 1;
   while ((c = fgetc (infil)) != EOF)
      {
      if (trigger == 1)
         {
         trigger = 0;
         if (c == '\n')
            {
            working ^= 1;
            continue;
            }
         else
            {
            ungetc (c, infil);
            c = 127;
            }
         }
      else if (c == 127)
         {
         trigger = 1;
         continue;
         }

      if (working)
         {
         c ^= ((*s) + i);
         ++ s;
         if (*s == '\0')
            {
            s = key;
            ++ i;
            if (i >= 20) i = 0;
            }
         }

      if ((c < ' ') || (c > 127)) result = 2;
      fputc (c, outfil);
      }

   fclose (infil);
   fclose (outfil);
   return result;
   }


int FAR PASCAL _export DESTROY_FILE (char *sourcefile)
   {
   FILE *fil;
   long len;

   if ((fil = fopen (sourcefile, "r+b")) == NULL) return 0;
   len = filelength (fileno (fil));
   while (len)
      {
      fputc ('\0', fil);
      -- len;
      }
   fclose (fil);
   remove (sourcefile);
   return 1;
   }

