/*********************************************************************/
/* REXXMSG.SCR   GammaTech IRC Sample REXX Message Exit Script       */
/*********************************************************************/
/*                                                                   */
/* This is a sample REXX script for use with GammaTech IRC. It       */
/* provides the following functions.                                 */
/*                                                                   */
/* 1) Automatically rejoin a channel if we are kicked off.           */
/* 2) Autogreet when joining a channel or when others join.          */
/* 3) Automatically begin a log file when we join a channel.         */
/*                                                                   */
/* Warning: Do not change this script. Copy it to another name       */
/* and modify the copy for backup purposes.                          */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* Entry arguments:                                                  */
/*                                                                   */
/* Arg 1 - Window handle                                             */
/* Arg 2 - Current Nickname                                          */
/* Arg 3 - The message text from IRC                                 */
/*                                                                   */
/* The third input argument is the full message from the IRC server. */
/* It may be helpful to refer to RFC 1459 to interpret the various   */
/* IRC messages. A copy of RFC 1459 is located in the GTIRC          */
/* directory.                                                        */
/*                                                                   */
/* The incoming message may be suppressed or ignored. To suppress    */
/* the message, return a null ("") string. To allow the message to   */
/* be processed normally, return a non-null string.                  */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* There are external REXX functions you may use in this REXX        */
/* procedure which are described below.                              */
/*                                                                   */
/* IrcRexxDisplay(text,win)  This function displays "text" in the    */
/* window. It does not send the text over IRC. The "text" parameter  */
/* is a null terminated string containing the text to display.       */
/*                                                                   */
/* The "win" parameter describes the window in which to display the  */
/* text. Use a null string to cause the text to be displayed in the  */
/* control window. To display the text in the window where the       */
/* message would normally be displayed, use the first argument       */
/* passed to this procedure.                                         */
/*                                                                   */
/* IrcRexxCommand(text,win)  This function sends "text" over IRC.    */
/* The "text" is a null terminated string containing the text to     */
/* be sent. The text may be text to the channel or a IRC command.    */
/*                                                                   */
/* The "win" parameter describes the window in which to display the  */
/* output of the text or command. Use a null string to cause the     */
/* output to be displayed in the control window. To display the      */
/* output in the window where the  message would normally be         */
/* displayed, use the first argument passed to this procedure.       */
/*                                                                   */
/* IrcRexxSend(text)  This function sends the "text" as a raw        */
/* string directly to the server. A carriage return and line feed    */
/* is appended to the text before transmission.                      */
/*                                                                   */
/* IrcRexxWildCard(wildcard,string)  This function checks string     */
/* for a match against wildcard. If a match is found MATCH is        */
/* returned. If no match is found NOMATCH is returned.               */
/*                                                                   */
/*********************************************************************/
Parse Upper Arg Win Us Prefix Cmd Chan Nick Rest

Pool = 'OS2ENVIRONMENT'

/*********************************************************************/
/* We see if this is a kick message for us. If so we format and      */
/* display a message in the window and rejoin the channel.           */
/*                                                                   */
/* We send the join command directly to the server because if we     */
/* send it as a normal command using IrcRexxCommand() it will be     */
/* ignored because the kick has not been processed and it thinks     */
/* we are still on the channel.                                      */
/*                                                                   */
/* We return a null string to suppress the kick message so that the  */
/* window for the channel will not be closed.                        */
/*                                                                   */
/*********************************************************************/

if (Cmd = 'KICK' & Nick = Us) then do
   By = substr(Prefix,2)
   Posex = pos('!',By)
   By = substr(By,1,posex - 1)

   Posex = pos(':',Rest)
   Reason = substr(Rest,2)

   Disp = "*** Kicked by" By "(" || Reason || ")"
   IrcRexxDisplay(Disp,Win)

   OutStr = "JOIN" Chan
   IrcRexxSend(OutStr)
   Return ""
End

/*********************************************************************/
/* AutoGreets are lame. But if you really want to autogreet folks    */
/* you can enable this script by setting the following variable:     */
/*                                                                   */
/* /rexxvar autogreet :#channel                                      */
/*                                                                   */
/*********************************************************************/

if (Cmd = 'JOIN' & Chan = VALUE('AUTOGREET',,Pool)) then do
   Parse Arg . Us Prefix Rest

   NewNick = substr(Prefix,2)
   Posex = pos('!',NewNick)
   NewNick = substr(NewNick,1,Posex - 1)

   If (NewNick <> Us) then do
      OutStr = "Hey" NewNick "!!!"
      IrcRexxCommand(OutStr,Win)
   End

   Else do
      OutStr = "Hi all"
      IrcRexxCommand(OutStr,Win)
   End
End

/*********************************************************************/
/* Begin a log file when we join a channel. This feature is disabled */
/* by default. To enable it set the following variable:              */
/*                                                                   */
/* /rexxvar autolog on                                               */
/*                                                                   */
/*********************************************************************/

if (Cmd = 'JOIN' & VALUE('AUTOLOG',,Pool) = 'ON') then do
   OutStr = "/LOG ON"
   IrcRexxCommand(OutStr,Win)
End

/*********************************************************************/
/* We don't care about this message so return a non-null string so   */
/* that it will be processed normally.                               */
/*********************************************************************/

Return "OK"

