/* Sample REXX Script for Multi-Net BBS                              */
/* This script will allow you to log on to IBM NSC BBS once you      */
/* change the strings stored in the varibles NAME and PASS. Enter    */
/* the mail.cmd name for the script name of the IBM NSC BBS phone    */
/* number.                                                           */

Signal ON SYNTAX NAME SYNTAX_ERROR

Parse arg port portname screen_handle dde_output dde_input semaphore
Parse source . . fn .
/*These are the values that Pmcomm passes on the command line to and */
/* external program. These values can then be used in different REXX */
/* functions along with the rxpmcomm.dll functions. Following is the */
/* description of each value:                                        */
/*      port = The handle of the open com port in Pmcomm             */
/*      portname = The name of the opened com port ie.. COM1         */
/*      screen_handle = Anything written to the handle will be       */
/*                      printed on the Pmcomm screen.                */

/* Setup variables                                                   */
name = 'first;last'               /* name  first;last                */
pass = 'password'                 /* password                        */
cr   = '0D'x
crlf = '0A0D'x
dcds = 1                          /* 0=no DCD support  1=DCD support */

/* This function registers the init_dll function with REXX. The      */
/* init_dll function will register the rest of the functions in      */
/* the rxpmcomm.dll.                                                 */
Call RxFuncAdd "init_dll","RxPmcomm","init_dll"

/* Required before any other rxpmcomm.dll functions are called.      */
Call init_dll
Call Clear

/* This will be printed on the REXX session screen                   */
Say 'Script started -' date() time()
Call Put_s 'Executing' fn '...'||crlf,screen_handle

/* This sets the read timeout for 20 seconds. This is used in the    */
/* wait_for, wait_fore, and the Get_ch functions.                    */
Call Read_timeout '20000',port

If dcds then Call Connected

Say 'Waiting for first name ...'
Do Forever
   Call Wait_fore 'Name','Password','continue?','execute ?','[N]o, [C]',port,screen_handle

/* This call will echo all characters to the Pmcomm screen that come */
/* from the open com port. When one of the strings are matched the   */
/* function will return the index of the matched string in the       */
/* variable result. For example if it receives the string password   */
/* then result will be equal to 2. If the functions waits longer     */
/* then the read timeout value then result will be equal to 0.       */

   match = result
   Select
     When match=1 then
       Do
         Call Put_s name||cr,port
         Say 'Waiting for password ...'
       End
     When match=2 then Call Put_s pass||cr,port
     When match=3 then Call Put_s cr,port
     When match=4 then Leave
     When match=5 then Call Put_s 'N',port
   Otherwise nop
   End
End
/* This will capture New mail from conference 1. The choices are Y for*/
/* your, N for new, and A for all. If you want to capture mail in more */
/* then one conference, then list the following function for each      */
/* conference. If you want to capture all the new mail in all conferences*/
/* use this: Parse value read_mail("N" "A") with rc                    */

Parse value read_mail("N" 1) with rc
If rc = 0 then Call file_transfer(zmodem download)

Say 'Script ended   -' date() time()
Exit


/* Clear Screen Routine                                              */
Clear: procedure expose screen_handle

Call put_s "1b5b324a"x,screen_handle
Return


/* A Procedure to see if the modem supports DCD and if see if we     */
/* have a connection, if not then DROP the DTR and then RAISE the    */
/* DTR again ...                                                     */
Connected: procedure expose port crlf screen_handle

Call DCD port
If result \= 1 then
   Do
     Call Beep 40,900
     Call Put_s 'No Data Carrier Detect ...'||crlf,screen_handle
     Call Drop_DTR port
     Call Raise_DTR port
     Say 'Script ended   -' date() time()
     Exit
   End
Return

/* Standard handler for SIGNAL on ERROR, will help in the debuging   */
syntax_error:
fp = filespec("path",fn)
fd = filespec("drive",fn)
errormsg='REXX error' rc 'in line' sigl':' errortext(rc)
errorfile = fd||fp||"SCRIPT.ERR"
rc = lineout(errorfile,date() time() fn '-' errormsg)
rc = lineout(errorfile,date() time() fn '-' sourceline(sigl))
Exit


/* Standard file transfer routine for all protocols that PMCOMM has  */
File_Transfer: procedure expose cr crlf dde_output dde_input semaphore port screen_handle
Parse arg protocol  direction

Call Read_timeout '5000',port
Call Put_s "d m"||crlf,port
Call Wait_fore "to quit?",port,screen_handle
Call Put_s "b"||crlf,port
Select
    When protocol = "XMODEM" & direction = "DOWNLOAD"  then
         do
         Call wait_fore "[Return] to abort",port,screen_handle
         If result = 1 then Call put_s "X" || crlf,port
            Call wait_fore "[Return]?",port,screen_handle
            Call put_s "Y" || crlf,port
            Call xmodem_receive file_name,dde_output,dde_input
         end
    When protocol = "XMODEM-1K" & direction = "DOWNLOAD"  then
         do
         Call wait_fore "[Return] to abort",port,screen_handle
         If result = 1 then Call put_s "C" || crlf,port
            Call wait_fore "[Return]?",port,screen_handle
            Call put_s "Y" || crlf,port
            Call xmodem_1k_receive file_name,dde_output,dde_input
         end
    When protocol = "YMODEM" & direction = "DOWNLOAD"  then
         do
         Call wait_fore "[Return] to abort",port,screen_handle
         If result = 1 then Call put_s "Y" || crlf,port
            Call wait_fore "[Return]?",port,screen_handle
            Call put_s "Y" || crlf,port
            Call ymodem_receive dde_output,dde_input
         end
    When protocol = "YMODEMG" & direction = "DOWNLOAD"  then
         do
         Call wait_fore "[Return] to abort",port,screen_handle
         If result = 1 then Call put_s "G" || crlf,port
            Call wait_fore "[Return]?",port,screen_handle
            Call put_s "Y" || crlf,port
            Call ymodemg_receive dde_output,dde_input
         end
    When protocol = "ZMODEM" & direction = "DOWNLOAD"  then
         do
           Call wait_fore "[Return] to abort",port,screen_handle
           If result = 1 then Call put_s "Z" || crlf,port
              Call wait_fore "[Return]?",port,screen_handle
              Call put_s "Y" || crlf,port
              Call zmodem_receive dde_output,dde_input
         end
    Otherwise nop
    End
Call Read_timeout '20000',port
return


/* Capture the mail ( All, New, Your ) for given conference(s) for   */
/* download and offline reading.                                     */
Read_Mail: procedure expose cr crlf dde_output dde_input port screen_handle
Parse arg type conference

Call Read_timeout '30000',port
Do i=1 by 1 to words(conference)
   Call Put_s "CA"||crlf,port
   Call Wait_fore "to quit?",port,screen_handle
   If result = 0 then return 99
   Call Put_s type crlf,port
   Call Wait_fore "to quit?",port,screen_handle
   If result = 0 then return 99
   Call Put_s word(conference,i)||crlf,port
   Call Wait_fore "? ",port,screen_handle
   If result = 0 then return 99
   return 0
End
