/* $Id$
 *
 * Send mail reply packet using SMTP directly
 */
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "socket.h"
#include "souper.h"

extern char *hostName;
extern char *mailGateway;

/* Close SMTP connection and socket */

void
smtpClose (int socket)
{
    SockPuts(socket, "QUIT");
    close(socket);
}

/* Get a response from the SMTP server and test it
*/
static int
getSmtpReply (int socket, char *response)
{
    char buf[BUFSIZ];

    do {
	SockGets(socket, buf, BUFSIZ);
    } while (buf[3] == '-');		/* wait until not a continuation */

    if (strncmp(buf, response, 3) != 0) {
	fprintf(stderr, "Expecting SMTP %s reply, got %s\n", response, buf);
    }
    return (buf[0] == *response);	/* only first digit really matters */
}

/* Open socket and intialize connection to SMTP server. */

#ifdef DEBUG
int
smtpConnect (void)
{
    return 1;
}
#else
int
smtpConnect (void)
{
    struct servent *sp;
    int	socket;

    if ((sp = getservbyname("smtp", "tcp")) == NULL) {
	fprintf(stderr, "smtp/tcp: Unknown service.\n");
	return -1;
    }

    if ((socket = Socket(mailGateway, ntohs(sp->s_port))) < 0) {
	fprintf(stderr, "Cannot connect to %s mail server.\n", mailGateway);
	return -1;
    }

    if (!getSmtpReply(socket, "220")) {
	printf("Disconnecting from %s\n", mailGateway);
	smtpClose(socket);
	return -1;
    }

    SockPrintf(socket, "HELO %s\r\n", hostName);
    if (!getSmtpReply(socket, "250")) {
	printf("Disconnecting from %s\n", mailGateway);
	smtpClose(socket);
	return -1;
    }
    return socket;
}
#endif
    
/* Send RCPT command.
*/
static void
sendSmtpRcpt (int socket, char *buf)
{
    printf("%s: Mailing to %s\n", progname, buf);
    SockPrintf(socket, "RCPT TO:<%s>\r\n", buf);
    getSmtpReply(socket, "250");
}

/* Extract the mail address.
 */
static void
putAddress (int socket, char *address)
{
    char buf[BUFSIZ], ch, *put;
    const char *get;
    char gotAddress;

    gotAddress = 0;
    put = buf;
    if ((get = strchr(address, '<')) != 0) {
	char ch = *++get;
	while (ch != '>' && ch != '\0') {
	    *put++ = ch;
	    ch = *++get;
	}
	gotAddress = 1;
    } else {
	get = address;
	ch = *get++;

	/* Skip leading whitespace. */
	while (ch != '\0' && isspace(ch))
	    ch = *get++;

	while (ch != '\0') {
	    if (isspace(ch)) {
		ch = *get++;

	    } else if (ch == '(') {
		/* Skip comment. */
		int nest = 1;
		while (nest > 0 && ch != '\0') {
		    ch = *get++;

		    if (ch == '(')
			++nest;
		    else if (ch == ')')
			--nest;
		}

		if (ch == ')') {
		    ch = *get++;
		}

	    } else if (ch == '"') {
		/* Copy quoted string. */
		do {
		    *put++ = ch;
		    ch = *get++;
		} while (ch != '"' && ch != '\0');

		if (ch == '"') {
		    *put++ = ch;
		    ch = *get++;
		}

	    } else {
		/* Copy address. */
		while (ch != '\0' && ch != '(' && !isspace(ch)) {
		    *put++ = ch;
		    ch = *get++;
		}
		gotAddress = 1;
	    }
	}
    }

    if (gotAddress) {
	*put = '\0';
	sendSmtpRcpt(socket, buf);
    }
}

/* Search for ',' separating addresses.
*/
static char *
findAddressSep (char *src)
{
    char ch, matchCh;

    ch = *src; 
    while (ch != '\0' && ch != ',') {
        if (ch == '"') {
            matchCh = '"';
        } else if (ch == '(') {
            matchCh = ')';
        } else if (ch == '<') {
            matchCh = '>';
        } else {
            matchCh = '\0';
        }

        if (matchCh) {
            do {
                ch = *(++src);
            } while (ch != '\0' && ch != matchCh);

            if (ch == '\0')
                break;
        }
        ch = *(++src);
    }

    return src;
}

/* Send an RCPT command for each address in the address list.
*/
static void
putAddresses (int socket, char *addresses)
{
    char *srcEnd, *startAddr, *endAddr, saveCh;
    
    srcEnd = strchr(addresses, '\0');
    startAddr = addresses;

    while (startAddr < srcEnd) {
	endAddr = findAddressSep(startAddr);
	saveCh = *endAddr;
	*endAddr = '\0';
	putAddress(socket, startAddr);
	*endAddr = saveCh;
	startAddr = endAddr + 1;
    }
}

/* Send message to SMTP server. */

void
smtpMail (int socket, FILE *fd, size_t bytes)
{
    char buf[BUFSIZ], *addrs, ch;
    char *from, *resentTo, *s;
    char more;
    long offset;
    size_t count;

    /* Look for From:  and send MAIL command to SMTP server. */
    from = getHeader(fd, "From");
    printf("%s: Mailing from %s\n", progname, from);
    SockPrintf(socket, "MAIL FROM:<%s>\r\n", from);
    free(from);
    if (!getSmtpReply(socket, "250")) {
	return;
    }

    offset = ftell(fd);
    if ((resentTo = getHeader(fd, "Resent-To")) != NULL) {
	/* Send to address on Resent-To header. */
	putAddresses(socket, resentTo);
	free(resentTo);
    } else {
	/* Send to addresses on To, Cc and Bcc headers. */
	more = fgets(buf, sizeof(buf), fd) != 0;
	while (more) {
	    if (buf[0] == '\n')
		break;

	    if (isHeader(buf, "To", 2) || isHeader(buf, "Cc", 2)
	     || isHeader(buf, "Bcc", 3))
	    {
		addrs = buf;
		while (*addrs != '\0' && !isspace(*addrs)) {
		    ++addrs;
		}
		putAddresses(socket, addrs);

		/* Read next line and check if it is a continuation line. */
		while ((more = fgets(buf, sizeof(buf), fd) != 0) != 0) {
		    ch = buf[0];
		    if (ch == '\n' || (ch != ' ' && ch != '\t'))
			break;
		    putAddresses(socket, buf);
		}

		continue;
	    }
	
	    more = fgets(buf, sizeof(buf), fd) != 0;
	}
    }

    /* Send the DATA command and the mail message line by line. */
    SockPuts(socket, "DATA");
    if (!getSmtpReply(socket, "354")) {
	return;
    }

    fseek(fd, offset, SEEK_SET);
    count = bytes;
    while (fgets(buf, sizeof(buf), fd) && count > 0) {
	count -= strlen(buf);
	if ((s = strchr(buf, '\n')) != NULL)
	    *s = '\0';
	if (buf[0] == '.') {
	    SockWrite(socket, buf, 1);	/* write an extra . */
	}
	SockPrintf(socket, "%s\r\n", buf);
    }
    fseek(fd, offset+bytes, SEEK_SET);

    SockPuts(socket, ".");
    getSmtpReply(socket, "250");
}
