/*****************************************************************************
  DLGCBAR.CPP

  Purpose:   
  	Implementation of CTheApp.

  Functions:
  	CTheApp::CTheApp()          -- constructor
  	CTheApp::~CTheApp()         -- destructor
  	CTheApp::FirstInstance()    -- locate first instance of app
  	CTheApp::InitInstance()     -- initialize app-instance
  	CTheApp::OnHelpAbout()		-- display About box

  Development Team:           
  	Mary Kirtland
  Ported to 32-bit by:
    Mike Hedley	
  Written by Microsoft Product Support Services, Premier ISV Support
  Copyright (c) 1996 Microsoft Corporation. All rights reserved.
\****************************************************************************/
                              
#include "stdafx.h"
#include "resource.h"
#include "dlgcbar.h" 
#include "aboutdlg.h"
#include "wndlist.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
        
/////////////////////////////////////////////////////////////////////////////
// CTheApp 

CTheApp NEAR theApp;  

BEGIN_MESSAGE_MAP(CTheApp, CWinApp)
	//{{AFX_MSG_MAP(CTheApp)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTheApp Constructors/Destructors

CTheApp::CTheApp()
{
}

CTheApp::~CTheApp()
{
}   
  
/////////////////////////////////////////////////////////////////////////////
// CTheApp::FirstInstance
//		FirstInstance checks for an existing instance of the application. 
//		If one is found, it is activated.
//
//  	This function uses a technique similar to that described in KB 
//  	article Q109175	to locate the previous instance of the application.  
//  	However, instead of searching for a matching class name, it searches 
//  	for a matching caption.  This allows us to use the normal dialog
//  	class for our main window.  It assumes that the AFX_IDS_APP_TITLE 
//  	string resource matches the caption specified in the dialog template.

BOOL CTheApp::FirstInstance()
{                                       
	CString strCaption;
	strCaption.LoadString(AFX_IDS_APP_TITLE);

	CWnd* pwndFirst = CWnd::FindWindow((LPCSTR)(DWORD)WC_DIALOG, 
									   strCaption);
	if (pwndFirst)
	{
		// another instance is already running - activate it
		CWnd* pwndPopup = pwndFirst->GetLastActivePopup();								   
		pwndFirst->SetForegroundWindow();
		if (pwndFirst->IsIconic())
			pwndFirst->ShowWindow(SW_SHOWNORMAL);
		if (pwndFirst != pwndPopup)
			pwndPopup->SetForegroundWindow(); 
		return FALSE;			
	}
	else
	{   
		// this is the first instance  
		return TRUE;
	}
}	

/////////////////////////////////////////////////////////////////////////////
// CTheApp::InitInstance
//		InitInstance performs per-instance initialization of the DLGCBAR 
//		application.  If an instance of the application is already running,
//		it activates that instance.  Otherwise, it creates the modeless 
//		dialog which serves as the application's interface.

BOOL CTheApp::InitInstance()
{
	if (!FirstInstance())
		return FALSE;
	
	// Create main window
	TRY
	{           
		CWndListDlg* pMainWnd = new CWndListDlg;
		m_pMainWnd = pMainWnd;
		return pMainWnd->Create();
	}
	CATCH_ALL(e)
	{
		TRACE0("Failed to create main dialog\n");
		return FALSE;
	}
	END_CATCH_ALL    
	
}
       
/////////////////////////////////////////////////////////////////////////////
// CTheApp::OnHelpAbout
//		OnHelpAbout displays the application's about box.

void CTheApp::OnHelpAbout() 
{
	CAboutDlg dlg(m_pMainWnd);
	dlg.DoModal();
}
