/*****************************************************************************
  MODELESS.CPP

  Purpose:  
  	Implements CModelessDialog, a reusable class for creating modeless
  	dialogs.

  Functions:
  	CModelessDialog::CModelessDialog()		-- constructor
  	CModelessDialog::~CModelessDialog()		-- destructor
  	CModelessDialog::OnCancel()				-- WM_COMMAND IDCANCEL handler
  	CModelessDialog::OnOK()					-- WM_COMMAND IDOK handler
  	CModelessDialog::PostNcDestroy()		-- called after WM_NCDESTROY

  Development Team:
  	Mary Kirtland
  Ported to 32-bit by:
    Mike Hedley	
  Written by Microsoft Product Support Services, Premier ISV Support
  Copyright (c) 1996 Microsoft Corporation. All rights reserved.
\****************************************************************************/

#include "stdafx.h"
#include "modeless.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog 

IMPLEMENT_DYNAMIC(CModelessDialog, CDialog)

BEGIN_MESSAGE_MAP(CModelessDialog, CDialog)
	//{{AFX_MSG_MAP(CModelessDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog Construction/Destruction

CModelessDialog::CModelessDialog() 
{
}
        
CModelessDialog::~CModelessDialog()
{
}
  
void CModelessDialog::PostNcDestroy()
{
	delete this;
}

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog::OnCancel
//		Modeless dialogs must not call EndDialog(), as CDialog::OnCancel()
//		does.  All we need to do is destroy the window.

void CModelessDialog::OnCancel() 
{
	DestroyWindow();
}

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog::OnOK
//		Modeless dialogs must not call EndDialog(), as CDialog::OnOK() does
//		We retrieve data from the controls using DDX, then destroy the 
//		window.

void CModelessDialog::OnOK() 
{
	if (!UpdateData(TRUE)) 
	{
		TRACE0("UpdateData failed -- modeless dialog terminate\n");
		return;
	}
	DestroyWindow();
}




