// DyncoSet.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDyncol32Set recordset
#include "ColData.h"
#include "Columns.h"
#include "Tables.h"

class CDyncol32Set : public CRecordset
{
public:
	CDyncol32Set(CDatabase* pDatabase = NULL);
	~CDyncol32Set();
	DECLARE_DYNAMIC(CDyncol32Set)

public:
	virtual BOOL Open( UINT nOpenType = AFX_DB_USE_DEFAULT_TYPE, LPCSTR lpszSql = NULL, DWORD dwOptions = none );
	CPtrList	m_pList;
	CColumns*	m_pColumns;
	CTables*	m_pTables;

	// put surrounding brackets around table and column names
	CString& bracketWrap(CString& strName) {
		CString temp = _T("[");
		temp += strName + _T("]");
		strName = temp;
		return strName;
	}

// Field/Param Data
	//{{AFX_FIELD(CDyncol32Set, CRecordset)
	CString	m_CourseID;
	CString	m_CourseTitle;
	int		m_Hours;
	//}}AFX_FIELD


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDyncol32Set)
	public:
	virtual CString GetDefaultConnect();    // Default connection string
	virtual CString GetDefaultSQL();    // Default SQL for Recordset
	virtual void DoFieldExchange(CFieldExchange* pFX);  // RFX support
	//}}AFX_VIRTUAL

// Implementation
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};
