// TblsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dyncol32.h"
#include "TblsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTablesDialog dialog


CTablesDialog::CTablesDialog(CWnd* pParent /*=NULL*/, CDatabase *pDb)
	: CDialog(CTablesDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTablesDialog)
	m_bSystemTables = FALSE;
	m_strTableNameSelected = _T("");
	m_bTables = TRUE;
	m_bViews = FALSE;
	//}}AFX_DATA_INIT
	m_prs = new CTables(pDb);
}

CTablesDialog::~CTablesDialog()
{
	delete m_prs;
}

void CTablesDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTablesDialog)
	DDX_Control(pDX, IDC_LIST1, m_TableList);
	DDX_Check(pDX, IDC_SYSTEMTABLES, m_bSystemTables);
	DDX_LBString(pDX, IDC_LIST1, m_strTableNameSelected);
	DDX_Check(pDX, IDC_TABLES, m_bTables);
	DDX_Check(pDX, IDC_VIEWS, m_bViews);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTablesDialog, CDialog)
	//{{AFX_MSG_MAP(CTablesDialog)
	ON_BN_CLICKED(IDC_SYSTEMTABLES, OnTableTypes)
	ON_LBN_DBLCLK(IDC_LIST1, OnSelenctTable)
	ON_BN_CLICKED(IDC_TABLES, OnTableTypes)
	ON_BN_CLICKED(IDC_VIEWS, OnTableTypes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTablesDialog message handlers

BOOL CTablesDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// filter just tables, aliases and synonyms to view by default
	m_prs->m_strTableTypeParam = _T("'TABLE', 'ALIAS', 'SYNONYM'");
	m_prs->Open(CRecordset::forwardOnly, NULL, CRecordset::readOnly);
	PopulateListBox();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTablesDialog::OnTableTypes() 
{
	// toggle display of system tables, tables, and views
	m_prs->m_strTableTypeParam = _T("ALIAS', 'SYNONYM'");

	UpdateData(TRUE);
	if (m_bSystemTables)
		m_prs->m_strTableTypeParam += _T(", 'SYSTEM TABLE'");
	if (m_bTables)
		m_prs->m_strTableTypeParam += _T(", 'TABLE'");
	if (m_bViews)
		m_prs->m_strTableTypeParam += _T(", 'VIEW'");
	
	m_prs->Close();
	m_prs->Open(CRecordset::forwardOnly, NULL, CRecordset::readOnly);
	PopulateListBox();
}

// refresh listbox from tables recordset
void CTablesDialog::PopulateListBox()
{
	m_TableList.ResetContent();

	while (!m_prs->IsEOF()) {
		m_TableList.AddString(m_prs->m_strTableName);
		m_prs->MoveNext();
	}
}

// handle double-click in the listbox
void CTablesDialog::OnSelenctTable() 
{
	PostMessage(WM_COMMAND, IDOK);
}

