{********************************************}
{*                                          *}
{*    LED25.PAS generated from LED25.VBX    *}
{*                                          *}
{********************************************}

unit Led25;

interface

uses SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTLED}
{^- Remove space to enable default init data -- See documentation. }

type

  { TLED }

  TLED = class(TVBXControl)
  protected
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 1 read GetIntProp;
    property AVersion: Single index 13 read GetSingleProp write SetSingleProp;
    property Redraw: Boolean index 44 read GetBoolProp write SetBoolProp;
    property ZLoad: TVBInteger index 46 read GetIntProp write SetIntProp;
  published
    property BackColor: TColor index 3 read GetColorProp write SetColorProp;
    property Enabled;
    property Visible;
    property TabOrder;
    property TabStop;
    property About: TVBString index 14 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property DecayRate: TVBInteger index 15 read GetIntProp write SetIntProp;
    property MaxDecay: Boolean index 16 read GetBoolProp write SetBoolProp;
    property BevelWidth: TVBInteger index 17 read GetIntProp write SetIntProp;
    property BevelInner: TVBEnum index 18 read GetEnumProp write SetEnumProp;
    property BevelOuter: TVBEnum index 19 read GetEnumProp write SetEnumProp;
    property BorderWidth: TVBInteger index 20 read GetIntProp write
      SetIntProp;
    property Value: TVBLongint index 21 read GetLongProp write SetProp;
    property LEDColor: TVBEnum index 22 read GetEnumProp write SetEnumProp
      stored False;
    property LEDIndex: TVBInteger index 23 read GetIntProp write SetIntProp;
    property LEDStatus: TVBEnum index 24 read GetEnumProp write SetEnumProp
      stored False;
    property Mode: TVBEnum index 25 read GetEnumProp write SetEnumProp;
    property NumLEDs: TVBInteger index 26 read GetIntProp write SetIntProp;
    property LEDWidth: TVBInteger index 27 read GetIntProp write SetIntProp;
    property LEDHeight: TVBInteger index 28 read GetIntProp write SetIntProp;
    property LEDSep: TVBInteger index 29 read GetIntProp write SetIntProp;
    property LEDStyle: TVBEnum index 30 read GetEnumProp write SetEnumProp;
    property BorderHorizontal: TVBInteger index 31 read GetIntProp write
      SetIntProp;
    property BorderVertical: TVBInteger index 32 read GetIntProp write
      SetIntProp;
    property Orientation: TVBEnum index 33 read GetEnumProp write SetEnumProp;
    property Direction: TVBEnum index 34 read GetEnumProp write SetEnumProp;
    property OnPictureRed: TVBPic index 35 read GetPictureProp write
      SetPictureProp stored False;
    property OnPictureYellow: TVBPic index 36 read GetPictureProp write
      SetPictureProp stored False;
    property OnPictureGreen: TVBPic index 37 read GetPictureProp write
      SetPictureProp stored False;
    property OffPictureRed: TVBPic index 38 read GetPictureProp write
      SetPictureProp stored False;
    property OffPictureYellow: TVBPic index 39 read GetPictureProp write
      SetPictureProp stored False;
    property OffPictureGreen: TVBPic index 40 read GetPictureProp write
      SetPictureProp stored False;
    property AutoSize: TVBEnum index 41 read GetEnumProp write SetEnumProp;
    property MouseControl: Boolean index 42 read GetBoolProp write
      SetBoolProp;
    property BackgroundPicture: TVBPic index 43 read GetPictureProp write
      SetPictureProp stored False;
    property AutoRedraw: Boolean index 45 read GetBoolProp write SetBoolProp;
    property OnClick;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

{ Default form data for TLED }

{$IFDEF InitTLED}

const
  TLEDInitLen = 293;

procedure TLEDInitData; near; assembler;
asm
	DB	$00,$03,$4C,$45,$44,$01,$00,$00,$03,$C0,$C0,$C0,$00,$04,$08,$FF
	DB	$FF,$09,$FF,$FF,$0A,$00,$00,$0B,$00,$00,$0C,$00,$0D,$00,$00,$20
	DB	$40,$0F,$00,$00,$10,$00,$00,$11,$02,$00,$12,$01,$13,$02,$14,$02
	DB	$00,$15,$00,$00,$00,$00,$17,$00,$00,$19,$01,$1A,$01,$00,$1B,$14
	DB	$00,$1C,$14,$00,$1D,$02,$00,$1E,$00,$1F,$05,$00,$20,$05,$00,$21
	DB	$00,$22,$00,$29,$00,$2A,$00,$00,$2D,$FF,$FF,$2E,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$FF
end;

{$ENDIF}

{ TLED }

constructor TLED.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('LED25.VBX');
  FVBXClass := StrNew('LED');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents];
  TabStop := True;
  FVBXFlags := [vfLoadMessage];
  {$IFDEF InitTLED}
  FHForm := VBXCreateFormFile(TLEDInitLen, @TLEDInitData);
  {$ENDIF}
end;

procedure TLED.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: begin end; { VCL Handles OnGotFocus }
    2: begin end; { VCL Handles OnLostFocus }
    3: DispatchMouseEvent(OnMouseDown, Message);
    4: DispatchMouseMoveEvent(OnMouseMove, Message);
    5: DispatchMouseEvent(OnMouseUp, Message);
  end;
end;

procedure TLED.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  HandleProperty('AVersion', Filer, 13);
  HandleBinaryProperty('OnPictureRed_Data', Filer, 35);
  HandleBinaryProperty('OnPictureYellow_Data', Filer, 36);
  HandleBinaryProperty('OnPictureGreen_Data', Filer, 37);
  HandleBinaryProperty('OffPictureRed_Data', Filer, 38);
  HandleBinaryProperty('OffPictureYellow_Data', Filer, 39);
  HandleBinaryProperty('OffPictureGreen_Data', Filer, 40);
  HandleBinaryProperty('BackgroundPicture_Data', Filer, 43);
  HandleBinaryProperty('ZLoad', Filer, 46);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    TLED]);
end;

end.
