Eval {
    pre = "mdat^menu^demo";
    [pre]^[100] = "InvMenu";
    [pre]^[101] = "PhoneList";
    [pre]^[102] = "DemoTest";
    [pre]^[103] = "SysUtils";
}
Define Demo() {
    /* 
        note, parm^demo^func will be set at this point if this prog was
        not exited correctly, or, we are cycling on a signal, in which 
        case parm^demo^func will hold the current function we are performing.
        A way to initialize parm^demo^func is to use the before macro 
        command line switch to run a macro to clear it first time through.
    */
    isDos = SysType() == "DOS";
    while (1) {
        if (!parm^demo^func^[TaskNum()]) {
            scr = SdCreate("Demo", -2, -2, isDos ? 14 : 10, 40, 
                           "Nadir Demonstration");
            SdPrompt(scr, 1, 2, "Please select an application");
            SdButton(scr,,1, 3, 7, 26, "Invoicing Program", "i", 100);
            SdButton(scr,,1, isDos ? 5 : 4, 7, 26,"Phone List", "p", 101);
            SdButton(scr,,1, isDos ? 7 : 5, 7, 26,"Demos and Tests","t", 102);
            SdButton(scr,,1, isDos ? 9 : 6, 7, 26,"System Utilities","s", 103);
            SdButton(scr, "can",  1, isDos ? 12 : 8, 15, 10, "Close", "c", 3);

            cmd = SdEdit(scr);
            SdDestroy(scr);

            switch (cmd) {
            case 2:             // cancel
            case 3:             // close
                parm^demo^func^[TaskNum()] = "";
                return;
            default:
                parm^demo^func^[TaskNum()] = mdat^menu^demo^[cmd];
            }
        }
        [parm^demo^func^[TaskNum()]](); // perform the selected (or current) function
        parm^demo^func^[TaskNum()] = "";
    }
}
Define MenuSel(title, prompt, pre) {
/*
    implements a menu of choices using a select box
    title is title of screen
    prompt is a prompt written on row 1
    pre - prefix of menu items
    menu items are of the form
    [pre][funcDes]    = func
    eg mdat^menu^dtst^["Run Xtree"]   = "RunXtree";
*/
    while (1) {
        scr = SdCreate(, -2, -2, 13, 40, title);
        SdPrompt(scr, 1, 2, prompt);
        SdSelect(scr, "sel",  1, 3, 5, 30, 7, &funcDes, pre, 100);
        SdButton(scr, "can",  1, 11, 15, 10, "Cancel", "", 2);
        cmd = SdEdit(scr);
        SdUpdate(scr);
        SdDestroy(scr);
        switch (cmd) {
        case 2:             // cancel
        case 3:             // close
            return cmd;
        }
        [[pre][funcDes]]();
    }
}
Eval {
    pre = "mdat^menu^dtst";
    [pre]^["Multi Line Edits"]  = "TestMultiEd";
    [pre]^["Process Intrinsic"] = "TestProcess";
    [pre]^["Run Xtree"]         = "RunXtree";
    [pre]^["Screen Dialogues"]  = "TestWinput";
}
Define DemoTest() {
    MenuSel("Demo and Tests",
            "Please select a program",
            "mdat^menu^dtst^");
}
Eval {
    pre = "mdat^menu^sute";
    [pre]^["Load Symbol Data"]              = "LoadSymbols";
    [pre]^["Unload Symbol Data"]            = "UnloadSymbols";
    [pre]^["System Parameters"]             = "SysParm";
    [pre]^["Windows Dialogue Parameters"]   = "SysSdParm";
    [pre]^["DOS Screen Attributes"]         = "DosScreenAttr";
    [pre]^["Printer Parameters"]            = "PrinterSetup";
    [pre]^["Table Maintenance"]             = "MtceSelect";
    [pre]^["DOS Shell"]     = "System";  // note, can be an Intrinsic Func
}
Define SysUtils() {
    MenuSel("System Utilities",
            "Please select a utility",
            "mdat^menu^sute^");
}

