/*
    Usage:  n -eDetab <input >output

    Replace tabs with spaces in the input file.

    This function will change the whitespace between tokens, not
    the contents of strings.  
    
    Arguments:

    tab - number of spaces that a tab is expanded to.  Defaults to 4.
          Maximum number of 8.

    comm - If true, comments are not scanned, but are still output.
           If false, all tokens in comments are read, and the tabs
           expanded.  Note that problems can occur if there are
           unterminated strings in comments.
*/
Define Detab(tab, comm)
{
    if (!tab)
        tab = 4;
    do {
        if (errMsg = TokenNext(comm))
            MsgWait("Detab", errMsg . " at word " . TokenValue());
        if (StrPos(term = TokenTerm(), "\t") >= 0) {
            for (i = 0; i < StrLen(term); i += 1) {
                if ((ch = StrSubs(term, i, 1)) == "\t")
                    Print(StrSubs("        ", , tab - OutputColumn() % tab));
                else 
                    Print (ch);
            }
        }
        else
            Print(term);            /* no tabs in whitespace */
        Print(TokenValue());        /* now print the token */
    } while (TokenType() != "EOT");
}

