If(0)

    PRINTER PARAMETERS IN PARM FILE

    code is the code for the printer

    prt^[code]^name     = printer name of filename that report is written to
    prt^[code]^copies   = number of copies
    prt^[code]^append   = whether file is appended (default to overwrite)
    prt^[code]^browse   = if set, user can browse file before printing

    page^[code]^height          = length of page in lines
    page^[code]^width           = width of page in character positions
    page^[code]^margin^top      = top margin, in lines
    page^[code]^margin^bottom   = bottom margin, in lines
    page^[code]^margin^left     = left margin, in char positions
    page^[code]^margin^right    = right margin, in char positions

Endif
If(0)
    Following Eval will initialize the contents of the parm file
    with some default values
Endif
Eval {
    parm^prt^def^name   = "";
    parm^prt^def^copies = 1;
    parm^prt^def^append = "";
    parm^prt^def^browse = "b";
    parm^page^def^height = 66;
    parm^page^def^width  = 132;
    parm^page^def^margin^top    = 3;
    parm^page^def^margin^bottom = 3;
    parm^page^def^margin^left   = 0;
    parm^page^def^margin^right  = 0;
}
Define PrinterSetup(code, desc)
{
    title = "Printer Setup";
    if (desc)
        title = StrCat(title, " - ", desc);
    if (!(prt = code))
        prt = "def";

    scr = SdCreate(, -1, -1, 16, 72, title);
    SdPrompt(scr, 1, 2, "Printer Name  :", "p");
    SdString(scr, "",   1,  1, 18, 40, &parm^prt^[prt]^name);
    SdPrompt(scr, 3, 2, "No of copies  :", "c");
    SdInt   (scr, "",   1,  3, 18, 3, &parm^prt^[prt]^copies);
    SdCheck (scr, "", 1, 3, 28, 26, &parm^prt^[prt]^append, "Append when outputting", "a");
    SdCheck (scr, "", 1, 4, 28, 26, &parm^prt^[prt]^browse, "Browse before printing", "b");

    SdPrompt(scr, 6, 2, "Page  Height  :", "h");
    SdInt   (scr, "",   1,  6, 18, 3, &parm^page^[prt]^height);
    SdPrompt(scr, 6,28, "Width  :");
    SdInt   (scr, "",   1,  6, 37, 3, &parm^page^[prt]^width);

    SdPrompt(scr, 8, 2, "Margins");
    SdPrompt(scr, 8,11, "Top  :", "t");
    SdInt   (scr, "",   1,  8, 18, 3, &parm^page^[prt]^margin^top);
    SdPrompt(scr, 8,28, "Bottom :");
    SdInt   (scr, "",   1,  8, 37, 3, &parm^page^[prt]^margin^bottom);

    SdPrompt(scr, 9,11, "Left :", "l");
    SdInt   (scr, "",   1,  9, 18, 3, &parm^page^[prt]^margin^left);
    SdPrompt(scr, 9,28, "Right  :");
    SdInt   (scr, "",   1,  9, 37, 3, &parm^page^[prt]^margin^right);

    SdPrompt(scr,11, 2, "Start Seq Lit :", "s");
    SdString(scr, "",   1, 11, 18, 50, &parm^prt^[prt]^start, 80, "Literal");
    SdPrompt(scr,12, 2, "End Seq Lit   :", "e");
    SdString(scr, "",   1, 12, 18, 50, &parm^prt^[prt]^end, 80, "Literal");

    SdButton(scr, "", 1,    14, 41, 10, "OK",     "", 1);
    SdButton(scr, "", 1,    14, 55, 10, "Cancel", "", 2);

    if (SdEdit(scr) == 1)
        SdUpdate(scr);

    SdDestroy(scr);
}
