Option Explicit
Const RAS_MaxEntryName = 20
Const RAS_MaxDeviceName = 32
Const RAS_MaxDeviceType = 16
Const RAS_MaxParamKey = 32
Const RAS_MaxParamValue = 128
Const RAS_MaxPhoneNumber = 128
Const RAS_MaxCallbackNumber = 48
Const UNLEN = 21
Const PWLEN = 14
Const DNLEN = 15

    Const WN_Success = &H0
    Const WN_Not_Supported = &H1
    Const WN_Net_Error = &H2
    Const WN_Bad_Pointer = &H4
    Const WN_Bad_NetName = &H32
    Const WN_Bad_Password = &H6
    Const WN_Bad_Localname = &H33
    Const WN_Access_Denied = &H7
    Const Wn_Out_Of_Memory = &HB
    Const WN_Already_Connected = &H34

Type RASDIALPARAMS
    dwSize As Long      ' 256 (calculates to 255)
    szEntryName As String * 21      ' [ RAS_MaxEntryName + 1 ];
    szPhoneNumber As String * 129   ' [ RAS_MaxPhoneNumber + 1 ];
    szCallbackNumber As String * 49 ' [ RAS_MaxCallbackNumber + 1 ];
    szUserName As String * 21       ' [ UNLEN + 1 ];
    szPassword As String * 15       ' [ PWLEN + 1 ];
    szDomain As String * 16         ' [ DNLEN + 1 ];
    szFiller As String * 1
End Type
Type RASCONNStatus
    dwSize As Long          ' 60
    RASCONNSTATE As Integer
    dwError As Long
    szDeviceType    As String * 17
    szDeviceName    As String * 33
End Type

Type RASENTRYNAME
   dwSize As Long       ' 26
   szEntryName As String * 21
   szFiller As String * 1
End Type
Type RASCONN
    dwSize As Long      ' 30
    hrasconn As Long    ' handle to connection
    szEntryName As String * 21
End Type

'  FUNCTION PROTOTYPES

Declare Function RASDIAL& Lib "RASAPI16.DLL" (reserved As Any, lpszPhonebookPath As Any, lprasdialparams As RASDIALPARAMS, reserved2 As Any, ByVal hwndNotifier As Integer, hrasconn As Long)
   'LPTSTR reserved;           /* reserved; must be set to NULL*/
   'LPTSTR lpszPhonebookPath;  /* full pathname to Phone Book file*/
   'LPRASDIALPARAMS lpRasDialParams;   /* points to calling parameters*/
   'LPVOID reserved2;        /* reserved; must be set to NULL*/
   'HWND hwndNotifier;       /* notification message for RasDial events*/
   'LPHRASCONN lphRasConn;   /* points to variable to receive connection handle*/
Declare Function RasGetErrorString& Lib "RASAPI16.DLL" (ByVal uErrorCode%, ByVal lpszErrorString$, ByVal cBufSize&)
   'UINT uErrorCode;        /* error code to get string for */
  ' LPSTR lpszErrorString;  /* buffer to hold error string */
   'DWORD cBufSize;         /* sizeof buffer */
Declare Function RasEnumEntries& Lib "RASAPI16.DLL" (reserved As Any, lpszPhonebookPath As Any, lprasentryname As RASENTRYNAME, lpcb As Long, lpcEntries As Long)
   'LPTSTR reserved;          /* reserved; must be NULL */
   'LPTSTR lpszPhonebookPath; /* full path to Phone Book file */
   'LPRASENTRYNAME lprasentryname;  /* buffer to receive Phone Book entries */
   'LPDWORD lpcb;             /* size in bytes of buffer */
   'LPDWORD lpcEntries;       /* number of entries written to buffer */
Declare Function RasEnumConnections& Lib "RASAPI16.DLL" (lprasconn As RASCONN, lpcb&, lpcConnections&)

Declare Function RasGetConnectStatus& Lib "RASAPI16.DLL" (ByVal hrasconn&, lprasconnstatus As RASCONNStatus)
Declare Function RasHangUp& Lib "RASAPI16.DLL" (ByVal hrasconn As Long)
Declare Function WNetAddConnection% Lib "user" (ByVal lpszNetPath As Any, ByVal lpszPassword As Any, ByVal lpszLocalName As Any)
Declare Function WNetCancelConnection% Lib "user" (ByVal lpszLocalName As Any, ByVal force As Integer)
Declare Function RegisterWindowMessage% Lib "user" (ByVal lpszMessage As String)

Global Sylphrasconn As Long
Global SyMsgId As Integer

Function SyDialRas (PhoneEntry As String, Username As String, Password As String, Domain As String, ErrMsg As String) As Integer
    Dim lprasdialparams As RASDIALPARAMS
    Dim hwndNotifier As Integer
    Dim Result As Integer
    Dim size As Long
    '
    Load Ras
    Ras.Show 0
    DoEvents
    Ras.ConnectTo = PhoneEntry
    lprasdialparams.dwSize = Len(lprasdialparams)
    lprasdialparams.szEntryName = PhoneEntry + Chr$(0)
    lprasdialparams.szPhoneNumber = Chr$(0)
    lprasdialparams.szCallbackNumber = Chr$(0)
    lprasdialparams.szUserName = Username + Chr$(0)
    lprasdialparams.szPassword = Password + Chr$(0)
    lprasdialparams.szDomain = Domain + Chr$(0)
    '
    hwndNotifier = Ras.hWnd
    
    Ras!MsgBlaster1.hWndTarget = Ras.hWnd
    Ras!MsgBlaster1.MsgList(0) = SyMsgId
    Sylphrasconn = 0
    Result = RASDIAL&(ByVal 0&, ByVal 0&, lprasdialparams, ByVal 0&, hwndNotifier, Sylphrasconn)
    If Result <> 0 Then
        SyDialRas = False
        ErrMsg = SyGetRasErrorString(Result)
        'Unload Ras
        Exit Function
    End If
    Do While True
        If Ras.ErrCD <> "" Then
            ErrMsg = SyGetRasErrorString(Val(Ras.ErrCD))
            SyDialRas = False
            'Unload Ras
            Exit Function
        End If
        DoEvents
        DoEvents
        If Ras.Connect <> "" Then Exit Do
    Loop
    SyDialRas = True
    'Unload Ras
End Function

Function SyGetRasErrorString (Errcode As Integer) As String
    Dim buffer As String * 256
    Dim Result As Long
    Result = RasGetErrorString(Errcode, buffer, Len(buffer))
    If Result = 0 Then
        SyGetRasErrorString = Left$(buffer, Len(buffer) - 1)
    Else
        SyGetRasErrorString = "User Error"
    End If

End Function

Function SyNetConnect (ByVal Servertext As String, ByVal PasswordText As String, ByVal DriveLetter As String, ErrMsg As String) As Integer
     Dim Retval As Integer
     Servertext = UCase$(Servertext) + Chr$(0) ' Network resource name
     PasswordText = PasswordText + Chr$(0) ' Password for the resource
     DriveLetter = DriveLetter + Chr$(0)
     Retval = WNetAddConnection(Servertext, PasswordText, DriveLetter)
     SyNetConnect = False
     Select Case Retval
         Case WN_Success:
            ErrMsg = "Drive connected."
            SyNetConnect = True
         Case WN_Not_Supported:
            ErrMsg = "Function is not supported."
         Case Wn_Out_Of_Memory:
            ErrMsg = "Out of Memory."
         Case WN_Net_Error:
            ErrMsg = "An error occurred on the network."
         Case WN_Bad_Pointer:
            ErrMsg = "The Pointer was Invalid."
         Case WN_Bad_NetName:
            ErrMsg = "Invalid Network Resource Name."
         Case WN_Bad_Password:
            ErrMsg = "The Password was Invalid."
         Case WN_Bad_Localname:
            ErrMsg = "The local device name was invalid."
         Case WN_Access_Denied:
            ErrMsg = "A security violation occurred."
         Case WN_Already_Connected:
            ErrMsg = "The local device was connected to a remote resource."
         Case Else:
            ErrMsg = "Unrecognized Error " + Str$(Retval) + "."
      End Select

End Function

Function SyNetDisConnect (ByVal DriveLetter As String) As Integer
    Dim Retval As Integer
    Retval = WNetCancelConnection%(DriveLetter$, 1)
    If Retval = 0 Then
        SyNetDisConnect = True
    Else
        SyNetDisConnect = False
    End If
End Function

Sub SyRasHangup ()
    Dim x As Long
    If Sylphrasconn <> 0 Then
        x = RasHangUp(Sylphrasconn)
        Sylphrasconn = 0
    End If
    On Error Resume Next
    Unload Ras
End Sub

