{********************************************}
{*                                          *}
{* SLIDER25.PAS generated from SLIDER25.VBX *}
{*                                          *}
{********************************************}

unit Slider25;

interface

uses SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTSlider}
{^- Remove space to enable default init data -- See documentation. }

type
  TSliderChangeEvent = procedure (Sender: TObject) of object;

  { TSlider }

  TSlider = class(TVBXControl)
  protected
    FOnChange: TSliderChangeEvent;
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 0 read GetIntProp;
    property FontName: TVBString index 13 read GetStringProp write
      SetStringProp;
    property FontBold: Boolean index 14 read GetBoolProp write SetBoolProp;
    property FontItalic: Boolean index 15 read GetBoolProp write SetBoolProp;
    property FontStrikethru: Boolean index 16 read GetBoolProp write
      SetBoolProp;
    property FontUnderline: Boolean index 17 read GetBoolProp write
      SetBoolProp;
    property FontSize: Single index 18 read GetSingleProp write SetSingleProp;
    property AVersion: Single index 19 read GetSingleProp write SetSingleProp;
    property Redraw: Boolean index 73 read GetBoolProp write SetBoolProp;
    property RedrawStatic: Boolean index 74 read GetBoolProp write
      SetBoolProp;
    property ZLoad: TVBInteger index 80 read GetIntProp write SetIntProp;
  published
    property Enabled;
    property Visible;
    property MousePointer: TVBEnum index 8 read GetEnumProp write SetEnumProp
      default 0;
    property TabOrder;
    property TabStop;
    property About: TVBString index 20 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property BevelWidth: TVBInteger index 21 read GetIntProp write SetIntProp;
    property BevelInner: TVBEnum index 22 read GetEnumProp write SetEnumProp;
    property BevelOuter: TVBEnum index 23 read GetEnumProp write SetEnumProp;
    property BorderWidth: TVBInteger index 24 read GetIntProp write
      SetIntProp;
    property Value: Single index 25 read GetSingleProp write SetSingleProp;
    property Max: Single index 26 read GetSingleProp write SetSingleProp;
    property Min: Single index 27 read GetSingleProp write SetSingleProp;
    property BackColor: TColor index 28 read GetColorProp write SetColorProp;
    property BackPicture: TVBPic index 29 read GetPictureProp write
      SetPictureProp stored False;
    property OnColor: TColor index 30 read GetColorProp write SetColorProp;
    property OnPicture: TVBPic index 31 read GetPictureProp write
      SetPictureProp stored False;
    property OffColor: TColor index 32 read GetColorProp write SetColorProp;
    property OffPicture: TVBPic index 33 read GetPictureProp write
      SetPictureProp stored False;
    property BarBorder: Single index 34 read GetSingleProp write
      SetSingleProp;
    property BarInner: Single index 35 read GetSingleProp write SetSingleProp;
    property BarOuter: Single index 36 read GetSingleProp write SetSingleProp;
    property KnobColor: TColor index 37 read GetColorProp write SetColorProp;
    property KnobPicture: TVBPic index 38 read GetPictureProp write
      SetPictureProp stored False;
    property KnobStyle: TVBEnum index 39 read GetEnumProp write SetEnumProp;
    property KnobXScale: Single index 40 read GetSingleProp write
      SetSingleProp;
    property KnobYScale: Single index 41 read GetSingleProp write
      SetSingleProp;
    property KnobOffset: Single index 42 read GetSingleProp write
      SetSingleProp;
    property Orientation: TVBEnum index 43 read GetEnumProp write SetEnumProp;
    property Direction: TVBEnum index 44 read GetEnumProp write SetEnumProp;
    property MouseControl: Boolean index 45 read GetBoolProp write
      SetBoolProp;
    property Tics: TVBInteger index 46 read GetIntProp write SetIntProp;
    property TicID: TVBInteger index 47 read GetIntProp write SetIntProp;
    property TicStart: Single index 48 read GetSingleProp write SetSingleProp
      stored False;
    property TicStop: Single index 49 read GetSingleProp write SetSingleProp
      stored False;
    property TicInner: Single index 50 read GetSingleProp write SetSingleProp
      stored False;
    property TicOuter: Single index 51 read GetSingleProp write SetSingleProp
      stored False;
    property TicLabelPosition: Single index 52 read GetSingleProp write
      SetSingleProp stored False;
    property TicLabelOn: Boolean index 53 read GetBoolProp write SetBoolProp
      stored False;
    property TicDelta: Single index 54 read GetSingleProp write SetSingleProp
      stored False;
    property TicColor: TColor index 55 read GetColorProp write SetColorProp
      stored False;
    property TicFontID: TVBInteger index 56 read GetIntProp write SetIntProp
      stored False;
    property Captions: TVBInteger index 57 read GetIntProp write SetIntProp;
    property CaptionID: TVBInteger index 58 read GetIntProp write SetIntProp;
    property Caption: TVBString index 59 read GetStringProp write
      SetStringProp stored False;
    property CaptionX: Single index 60 read GetSingleProp write SetSingleProp
      stored False;
    property CaptionY: Single index 61 read GetSingleProp write SetSingleProp
      stored False;
    property CaptionColor: TColor index 62 read GetColorProp write
      SetColorProp stored False;
    property CaptionFontID: TVBInteger index 63 read GetIntProp write
      SetIntProp stored False;
    property Digital: Boolean index 64 read GetBoolProp write SetBoolProp;
    property DigitalX: Single index 65 read GetSingleProp write SetSingleProp;
    property DigitalY: Single index 66 read GetSingleProp write SetSingleProp;
    property DigitalDecimals: TVBInteger index 67 read GetIntProp write
      SetIntProp;
    property DigitalColor: TColor index 68 read GetColorProp write
      SetColorProp;
    property DigitalFontID: TVBInteger index 69 read GetIntProp write
      SetIntProp;
    property ShapeStyle: TVBEnum index 70 read GetEnumProp write SetEnumProp;
    property Shape: TVBString index 71 read GetStringProp write SetStringProp;
    property AutoRedraw: Boolean index 72 read GetBoolProp write SetBoolProp;
    property FontID: TVBInteger index 75 read GetIntProp write SetIntProp;
    property Fonts: TVBInteger index 76 read GetIntProp write SetIntProp
      stored False;
    property Snap: TVBEnum index 77 read GetEnumProp write SetEnumProp;
    property SnapIncrement: Single index 78 read GetSingleProp write
      SetSingleProp;
    property FontDialog_: TVBString index 79 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property OnClick;
    property OnDragDrop;
    property OnEndDrag;
    property OnDragOver;
    property OnEnter;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnChange: TSliderChangeEvent read FOnChange write FOnChange;
  end;

procedure Register;

implementation

{ Default form data for TSlider }

{$IFDEF InitTSlider}

const
  TSliderInitLen = 228;

procedure TSliderInitData; near; assembler;
asm
	DB	$00,$00,$00,$02,$06,$FF,$FF,$07,$FF,$FF,$08,$00,$09,$00,$00,$0A
	DB	$00,$00,$0B,$00,$0C,$06,$53,$6C,$69,$64,$65,$72,$13,$62,$10,$20
	DB	$40,$15,$02,$00,$16,$01,$17,$02,$18,$02,$00,$19,$00,$00,$48,$42
	DB	$1A,$00,$00,$C8,$42,$1B,$00,$00,$00,$00,$1C,$C0,$C0,$C0,$00,$1E
	DB	$00,$FF,$00,$00,$20,$FF,$00,$00,$00,$22,$CD,$CC,$CC,$3D,$23,$9A
	DB	$99,$99,$3E,$24,$33,$33,$33,$3F,$25,$00,$00,$00,$00,$27,$00,$28
	DB	$00,$00,$00,$00,$29,$00,$00,$00,$00,$2A,$00,$00,$00,$00,$2B,$01
	DB	$2C,$01,$2D,$FF,$FF,$2E,$00,$00,$2F,$00,$00,$39,$00,$00,$3A,$00
	DB	$00,$40,$00,$00,$41,$00,$00,$00,$00,$42,$00,$00,$00,$00,$43,$00
	DB	$00,$44,$00,$00,$00,$00,$45,$00,$00,$46,$00,$47,$00,$48,$FF,$FF
	DB	$4B,$00,$00,$4D,$00,$4E,$00,$00,$00,$00,$50,$00,$00,$00,$00,$01
	DB	$00,$10,$00,$07,$00,$00,$00,$00,$00,$BC,$02,$00,$00,$00,$00,$01
	DB	$02,$02,$22,$53,$79,$73,$74,$65,$6D,$00,$3B,$56,$E2,$8F,$3B,$1C
	DB	$00,$00,$00,$17,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01
	DB	$00,$20,$00,$FF
end;

{$ENDIF}

{ TSlider }

constructor TSlider.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('SLIDER25.VBX');
  FVBXClass := StrNew('SLIDER');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents];
  TabStop := True;
  FVBXFlags := [vfLoadMessage];
  {$IFDEF InitTSlider}
  FHForm := VBXCreateFormFile(TSliderInitLen, @TSliderInitData);
  {$ENDIF}
end;

procedure TSlider.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: begin end; { VCL Handles OnDragDrop }
    2: begin end; { VCL Handles OnDragOver }
    3: begin end; { VCL Handles OnGotFocus }
    4: DispatchKeyEvent(OnKeyDown, Message);
    5: DispatchKeyPressedEvent(OnKeyPress, Message);
    6: DispatchKeyEvent(OnKeyUp, Message);
    7: begin end; { VCL Handles OnLostFocus }
    8: DispatchMouseEvent(OnMouseDown, Message);
    9: DispatchMouseMoveEvent(OnMouseMove, Message);
    10: DispatchMouseEvent(OnMouseUp, Message);
    11: DispatchCustomEvent(FOnChange, Message, 11);
  end;
end;

procedure TSlider.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  HandleProperty('AVersion', Filer, 19);
  HandleBinaryProperty('BackPicture_Data', Filer, 29);
  HandleBinaryProperty('OnPicture_Data', Filer, 31);
  HandleBinaryProperty('OffPicture_Data', Filer, 33);
  HandleBinaryProperty('KnobPicture_Data', Filer, 38);
  HandleBinaryProperty('ZLoad', Filer, 80);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    TSlider]);
end;

end.
