#ifndef   ANSISCRN__H
#define   ANSISCRN__H

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *       ANSISCRN.H
 *
 *       #include implementation of ANSI screen control codes
 *            Contributed to the public domain 12-26-91 by
 *              Matthew J. Glass.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include   <stdio.h>

#define   ESC                  27
#define   ANSI_cup(a,b)        printf("%c[%d;%dH",ESC,a,b)
#define   ANSI_up(a)           printf("%c[%dA",ESC,a)
#define   ANSI_down(a)         printf("%c[%dB",ESC,a)
#define   ANSI_right(a)        printf("%c[%dC",ESC,a)
#define   ANSI_left(a)         printf("%c[%dD",ESC,a)
#define   ANSI_locate(a,b)     printf("%c[%d;%df",ESC,a,b)
#define   ANSI_savecurs()      printf("%c[s",ESC)
#define   ANSI_restcurs()      printf("%c[u",ESC)
#define   ANSI_cls()           printf("%c[2J",ESC)
#define   ANSI_cleol()         printf("%c[K",ESC)
#define   ANSI_margins(a,b)    printf("%c[%d;%dr",ESC,a,b)

#define   NORMAL         0     /* attributes for ANSI_attrib() */
#define   BOLD           1
#define   USCORE         2
#define   BLINK          3
#define   REVERSE        4
#define   INVIS          5

#define   BLACK          0     /* colors for ANSI_bg_color() and */
#define   RED            1     /* ANSI_fg_color.                 */
#define   GREEN          2
#define   YELLOW         3
#define   BLUE           4
#define   MAGENTA        5
#define   CYAN           6
#define   WHITE          7
#define   B_BLACK        8     /* bright colors for ANSI_fg_color() */
#define   B_RED          9
#define   B_GREEN        10
#define   B_YELLOW       11
#define   B_BLUE         12
#define   B_MAGENTA      13
#define   B_CYAN         14
#define   B_WHITE        15

extern char *_atrb_plt_[];

extern char *_fg_plt_[];

extern char *_bg_plt_[];

#define   ANSI_attrib(a)     printf("%c[%sm",ESC, _atrb_plt_[a])
#define   ANSI_fg_color(a)   printf("%c[%sm",ESC, _fg_plt_[a] )
#define   ANSI_bg_color(a)   printf("%c[%sm",ESC, _bg_plt_[a] )

#endif /* ANSISCRN__H */
