/*
**  NLCNVRT.C - A utility to convert newlines in text files
**
**  public domain by Bob Stout
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "errors.h"
#include "sniptype.h"

FILE *infile;
FILE *outfile;

void usage(void);
void toDOS(void);
void toUnix(void);
void fromKB(void);
void Cout(int ch, FILE *outfile);
void Sout(char *str, FILE *outfile);

main(int argc, char *argv[])
{
      char outname[L_tmpnam] = "";

      if (argc < 3)
            usage();
      if (NULL == strchr("-/", argv[1][0]))
            usage();

      infile = cant(argv[2], "rb");

      if (3 == argc || NULL == (outfile = fopen(argv[3], "wb")))
      {
            tmpnam(outname);
            outfile = cant(outname, "wb");
      }

      switch (argv[1][1])
      {
      case 'd':
      case 'D':
            toDOS();
            break;

      case 'u':
      case 'U':
            toUnix();
            break;

      case 'k':
      case 'K':
            fromKB();
            break;

      default:
            usage();
      }
      fclose(infile);
      fclose(outfile);
      if (*outname)
      {
            if (Success_ != remove(argv[2]))
            {
                  remove(outname);
                  ErrExit("Can't remove %s", argv[2]);
            }
            rename(outname, argv[2]);
      }
      return EXIT_SUCCESS;
}

void usage(void)
{
      puts("Usage: NLCNVRT -[d | u | k] infile [outfile]");
      puts("Switches: -d  Convert to DOS - converts LF to CRLF");
      puts("        : -u  Convert to Unix - converts CRLF to LF");
      puts("        : -k  Convert to DOS from KB - converts CR to CRLF");
      exit(EXIT_FAILURE);
}

void toDOS(void)
{
      int ch, lastch = 0;

      while (EOF != (ch = fgetc(infile)))
      {
            if ('\n' == ch && '\r' != lastch)
                  fputc('\r', outfile);
            fputc(lastch = ch, outfile);
      }
      if ('\n' != lastch)
            fputs("\r\n", outfile);
}

void toUnix(void)
{
      int ch, lastch = 0;

      while (EOF != (ch = fgetc(infile)) && '\x1a' != ch)
      {
            if ('\r' != ch)
                  fputc(lastch = ch, outfile);
      }
      if ('\n' != lastch)
            fputc('\n', outfile);
}

void fromKB(void)
{
      int ch, lastch = 0;

      while (EOF != (ch = fgetc(infile)))
      {
            if ('\r' == ch)
                  fputc('\n', outfile);
            fputc(lastch = ch, outfile);
      }
      if ('\r' != lastch)
            fputs("\r\n", outfile);
}

void Cout(int ch, FILE *outfile)
{
      if (EOF == fputc(ch, outfile))
            exit(EXIT_FAILURE);
}

void Sout(char *str, FILE *outfile)
{
      if (EOF == fputs(str, outfile))
            exit(EXIT_FAILURE);
}
